/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype.truetype;

import java.awt.FontFormatException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.IntBuffer;

abstract class GlyphLocator {
    protected ByteBuffer glyfTable;

    GlyphLocator() {
    }

    public static GlyphLocator forTable(int format, ByteBuffer loca, ByteBuffer glyf) throws FontFormatException {
        switch (format) {
            case 0: {
                return new TwoByte(loca, glyf);
            }
            case 1: {
                return new FourByte(loca, glyf);
            }
        }
        throw new FontFormatException("unsupported loca format");
    }

    public abstract ByteBuffer getGlyphData(int var1);

    private static final class FourByte
    extends GlyphLocator {
        final IntBuffer indexToLoc;

        FourByte(ByteBuffer loca, ByteBuffer glyf) {
            this.glyfTable = glyf;
            this.indexToLoc = loca.asIntBuffer();
        }

        public ByteBuffer getGlyphData(int glyph) {
            int limit;
            int offset = this.indexToLoc.get(glyph);
            if (offset >= (limit = this.indexToLoc.get(glyph + 1))) {
                return null;
            }
            this.glyfTable.limit(limit).position(offset);
            return this.glyfTable;
        }
    }

    private static final class TwoByte
    extends GlyphLocator {
        final CharBuffer indexToLoc;

        TwoByte(ByteBuffer loca, ByteBuffer glyf) {
            this.glyfTable = glyf;
            this.indexToLoc = loca.asCharBuffer();
        }

        public ByteBuffer getGlyphData(int glyph) {
            int limit;
            int offset = this.indexToLoc.get(glyph) << 1;
            if (offset >= (limit = this.indexToLoc.get(glyph + 1) << 1)) {
                return null;
            }
            this.glyfTable.limit(limit).position(offset);
            return this.glyfTable;
        }
    }
}

