/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.jdwp.processor;

import gnu.classpath.jdwp.VMMethod;
import gnu.classpath.jdwp.exception.JdwpException;
import gnu.classpath.jdwp.exception.JdwpInternalErrorException;
import gnu.classpath.jdwp.exception.NotImplementedException;
import gnu.classpath.jdwp.id.ReferenceTypeId;
import gnu.classpath.jdwp.processor.CommandSet;
import gnu.classpath.jdwp.util.LineTable;
import gnu.classpath.jdwp.util.VariableTable;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;

public class MethodCommandSet
extends CommandSet {
    public boolean runCommand(ByteBuffer bb, DataOutputStream os, byte command) throws JdwpException {
        try {
            switch (command) {
                case 1: {
                    this.executeLineTable(bb, os);
                    break;
                }
                case 2: {
                    this.executeVariableTable(bb, os);
                    break;
                }
                case 3: {
                    this.executeByteCodes(bb, os);
                    break;
                }
                case 4: {
                    this.executeIsObsolete(bb, os);
                    break;
                }
                case 5: {
                    this.executeVariableTableWithGeneric(bb, os);
                    break;
                }
                default: {
                    throw new NotImplementedException("Command " + command + " not found in Method Command Set.");
                }
            }
        }
        catch (IOException ex) {
            throw new JdwpInternalErrorException(ex);
        }
        return false;
    }

    private void executeLineTable(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        VMMethod method = VMMethod.readId(clazz, bb);
        LineTable lt = method.getLineTable();
        lt.write(os);
    }

    private void executeVariableTable(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        ReferenceTypeId refId = this.idMan.readReferenceTypeId(bb);
        Class clazz = refId.getType();
        VMMethod method = VMMethod.readId(clazz, bb);
        VariableTable vt = method.getVariableTable();
        vt.write(os);
    }

    private void executeByteCodes(ByteBuffer bb, DataOutputStream os) throws JdwpException, IOException {
        String msg = "getting bytecodes is unsupported";
        throw new NotImplementedException(msg);
    }

    private void executeIsObsolete(ByteBuffer bb, DataOutputStream os) throws IOException {
        os.writeBoolean(false);
    }

    private void executeVariableTableWithGeneric(ByteBuffer bb, DataOutputStream os) throws JdwpException {
        throw new NotImplementedException("Command VariableTableWithGeneric not implemented.");
    }
}

