# This file was automatically generated by bifcl from /usr/obj/ports/bro-2.5/bro-2.5/src/analyzer/protocol/dns/events.bif (plugin mode).

## Generated for all DNS messages.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## is_orig:  True if the message was sent by the originator of the connection.
##
## msg: The parsed DNS message header.
##
## len: The length of the message's raw representation (i.e., the DNS payload).
##
## .. bro:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply dns_TSIG_addl dns_TXT_reply dns_WKS_reply dns_end
##    dns_full_request dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid  dns_query_reply dns_rejected
##    dns_request non_dns_request  dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
export {
global dns_message: event(c: connection , is_orig: bool , msg: dns_msg , len: count );


## Generated for DNS requests. For requests with multiple queries, this event
## is raised once for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## query: The queried name.
##
## qtype: The queried resource record type.
##
## qclass: The queried resource record class.
##
## .. bro:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply dns_TSIG_addl dns_TXT_reply dns_WKS_reply dns_end
##    dns_full_request dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected non_dns_request dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_request: event(c: connection , msg: dns_msg , query: string , qtype: count , qclass: count );


## Generated for DNS replies that reject a query. This event is raised if a DNS
## reply indicates failure because it does not pass on any
## answers to a query. Note that all of the event's parameters are parsed out of
## the reply; there's no stateful correlation with the query.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## query: The queried name.
##
## qtype: The queried resource record type.
##
## qclass: The queried resource record class.
##
## .. bro:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply dns_TSIG_addl dns_TXT_reply dns_WKS_reply dns_end
##    dns_full_request dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_request non_dns_request dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_rejected: event(c: connection , msg: dns_msg , query: string , qtype: count , qclass: count );


## Generated for each entry in the Question section of a DNS reply.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## query: The queried name.
##
## qtype: The queried resource record type.
##
## qclass: The queried resource record class.
##
## .. bro:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply dns_TSIG_addl dns_TXT_reply dns_WKS_reply dns_end
##    dns_full_request dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_rejected
##    dns_request non_dns_request dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_query_reply: event(c: connection , msg: dns_msg , query: string , qtype: count , qclass: count );


## Generated for DNS replies of type *A*. For replies with multiple answers, an
## individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## a: The address returned by the reply.
##
## .. bro:see:: dns_AAAA_reply dns_A6_reply dns_CNAME_reply dns_EDNS_addl dns_HINFO_reply
##    dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply
##    dns_TSIG_addl dns_TXT_reply dns_WKS_reply dns_end dns_full_request
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request non_dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_A_reply: event(c: connection , msg: dns_msg , ans: dns_answer , a: addr );


## Generated for DNS replies of type *AAAA*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## a: The address returned by the reply.
##
## .. bro:see::  dns_A_reply dns_A6_reply dns_CNAME_reply dns_EDNS_addl dns_HINFO_reply dns_MX_reply
##    dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply dns_TSIG_addl
##    dns_TXT_reply dns_WKS_reply dns_end dns_full_request dns_mapping_altered
##    dns_mapping_lost_name dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid dns_message dns_query_reply dns_rejected dns_request
##    non_dns_request dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_AAAA_reply: event(c: connection , msg: dns_msg , ans: dns_answer , a: addr );


## Generated for DNS replies of type *A6*. For replies with multiple answers, an
## individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## a: The address returned by the reply.
##
## .. bro:see::  dns_A_reply dns_AAAA_reply dns_CNAME_reply dns_EDNS_addl dns_HINFO_reply dns_MX_reply
##    dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply dns_TSIG_addl
##    dns_TXT_reply dns_WKS_reply dns_end dns_full_request dns_mapping_altered
##    dns_mapping_lost_name dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid dns_message dns_query_reply dns_rejected dns_request
##    non_dns_request dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_A6_reply: event(c: connection , msg: dns_msg , ans: dns_answer , a: addr );


## Generated for DNS replies of type *NS*. For replies with multiple answers, an
## individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## name: The name returned by the reply.
##
## .. bro:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply  dns_PTR_reply dns_SOA_reply dns_SRV_reply
##    dns_TSIG_addl dns_TXT_reply dns_WKS_reply dns_end dns_full_request
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request non_dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_NS_reply: event(c: connection , msg: dns_msg , ans: dns_answer , name: string );


## Generated for DNS replies of type *CNAME*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## name: The name returned by the reply.
##
## .. bro:see:: dns_AAAA_reply dns_A_reply  dns_EDNS_addl dns_HINFO_reply dns_MX_reply
##    dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply dns_TSIG_addl
##    dns_TXT_reply dns_WKS_reply dns_end dns_full_request dns_mapping_altered
##    dns_mapping_lost_name dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid dns_message dns_query_reply dns_rejected dns_request
##    non_dns_request dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_CNAME_reply: event(c: connection , msg: dns_msg , ans: dns_answer , name: string );


## Generated for DNS replies of type *PTR*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## name: The name returned by the reply.
##
## .. bro:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply  dns_SOA_reply dns_SRV_reply
##    dns_TSIG_addl dns_TXT_reply dns_WKS_reply dns_end dns_full_request
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request non_dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_PTR_reply: event(c: connection , msg: dns_msg , ans: dns_answer , name: string );


## Generated for DNS replies of type *CNAME*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## soa: The parsed SOA value.
##
## .. bro:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SRV_reply
##    dns_TSIG_addl dns_TXT_reply dns_WKS_reply dns_end dns_full_request
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request non_dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_SOA_reply: event(c: connection , msg: dns_msg , ans: dns_answer , soa: dns_soa );


## Generated for DNS replies of type *WKS*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## .. bro:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply dns_TSIG_addl dns_TXT_reply  dns_end dns_full_request
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request non_dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_WKS_reply: event(c: connection , msg: dns_msg , ans: dns_answer );


## Generated for DNS replies of type *HINFO*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## .. bro:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl dns_MX_reply
##    dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply dns_TSIG_addl
##    dns_TXT_reply dns_WKS_reply dns_end dns_full_request dns_mapping_altered
##    dns_mapping_lost_name dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid dns_message dns_query_reply dns_rejected dns_request
##    non_dns_request dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_HINFO_reply: event(c: connection , msg: dns_msg , ans: dns_answer );


## Generated for DNS replies of type *MX*. For replies with multiple answers, an
## individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## name: The name returned by the reply.
##
## preference: The preference for *name* specified by the reply.
##
## .. bro:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply  dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply
##    dns_TSIG_addl dns_TXT_reply dns_WKS_reply dns_end dns_full_request
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request non_dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_MX_reply: event(c: connection , msg: dns_msg , ans: dns_answer , name: string , preference: count );


## Generated for DNS replies of type *TXT*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## strs: The textual information returned by the reply.
##
## .. bro:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply dns_TSIG_addl  dns_WKS_reply dns_end dns_full_request
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request non_dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_TXT_reply: event(c: connection , msg: dns_msg , ans: dns_answer , strs: string_vec );


## Generated for DNS replies of type *CAA* (Certification Authority Authorization).
## For replies with multiple answers, an individual event of the corresponding type
## is raised for each.
## See `RFC 6844 <https://tools.ietf.org/html/rfc6844>`__ for more details.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## flags: The flags byte of the CAA reply.
##
## tag: The property identifier of the CAA reply.
##
## value: The property value of the CAA reply.
global dns_CAA_reply: event(c: connection , msg: dns_msg , ans: dns_answer , flags: count , tag: string , value: string );


## Generated for DNS replies of type *SRV*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## target: Target of the SRV response -- the canonical hostname of the
##         machine providing the service, ending in a dot.
##
## priority: Priority of the SRV response -- the priority of the target
##           host, lower value means more preferred.
##
## weight: Weight of the SRV response -- a relative weight for records
##         with the same priority, higher value means more preferred.
##
## p: Port of the SRV response -- the TCP or UDP port on which the
##    service is to be found.
##
## .. bro:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_TSIG_addl dns_TXT_reply dns_WKS_reply dns_end dns_full_request
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request non_dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_SRV_reply: event(c: connection , msg: dns_msg , ans: dns_answer , target: string , priority: count , weight: count , p: count );


## Generated on DNS reply resource records when the type of record is not one
## that Bro knows how to parse and generate another more specific event.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The type-independent part of the parsed answer record.
##
## .. bro:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_TSIG_addl dns_TXT_reply dns_WKS_reply dns_SRV_reply dns_end
global dns_unknown_reply: event(c: connection , msg: dns_msg , ans: dns_answer );


## Generated for DNS replies of type *EDNS*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The parsed EDNS reply.
##
## .. bro:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_HINFO_reply dns_MX_reply
##    dns_NS_reply dns_PTR_reply dns_SOA_reply dns_SRV_reply dns_TSIG_addl
##    dns_TXT_reply dns_WKS_reply dns_end dns_full_request dns_mapping_altered
##    dns_mapping_lost_name dns_mapping_new_name dns_mapping_unverified
##    dns_mapping_valid dns_message dns_query_reply dns_rejected dns_request
##    non_dns_request dns_max_queries dns_session_timeout dns_skip_addl
##    dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_EDNS_addl: event(c: connection , msg: dns_msg , ans: dns_edns_additional );


## Generated for DNS replies of type *TSIG*. For replies with multiple answers,
## an individual event of the corresponding type is raised for each.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## ans: The parsed TSIG reply.
##
## .. bro:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply  dns_TXT_reply dns_WKS_reply dns_end dns_full_request
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request non_dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_TSIG_addl: event(c: connection , msg: dns_msg , ans: dns_tsig_additional );


## Generated at the end of processing a DNS packet. This event is the last
## ``dns_*`` event that will be raised for a DNS query/reply and signals that
## all resource records have been passed on.
##
## See `Wikipedia <http://en.wikipedia.org/wiki/Domain_Name_System>`__ for more
## information about the DNS protocol. Bro analyzes both UDP and TCP DNS
## sessions.
##
## c: The connection, which may be UDP or TCP depending on the type of the
##    transport-layer session being analyzed.
##
## msg: The parsed DNS message header.
##
## .. bro:see:: dns_AAAA_reply dns_A_reply dns_CNAME_reply dns_EDNS_addl
##    dns_HINFO_reply dns_MX_reply dns_NS_reply dns_PTR_reply dns_SOA_reply
##    dns_SRV_reply dns_TSIG_addl dns_TXT_reply dns_WKS_reply dns_full_request
##    dns_mapping_altered dns_mapping_lost_name dns_mapping_new_name
##    dns_mapping_unverified dns_mapping_valid dns_message dns_query_reply
##    dns_rejected dns_request non_dns_request dns_max_queries dns_session_timeout
##    dns_skip_addl dns_skip_all_addl dns_skip_all_auth dns_skip_auth
global dns_end: event(c: connection , msg: dns_msg );


## Deprecated. Will be removed.
##
## .. todo:: Unclear what this event is for; it's never raised. We should just
##    remove it.
global dns_full_request: event();


## msg: The raw DNS payload.
##
## .. note:: This event is deprecated and superseded by Bro's dynamic protocol
##    detection framework.
global non_dns_request: event(c: connection , msg: string );

} # end of export section
module GLOBAL;
