'\"
'\" Copyright (c) 2004-2014 Stuart Cassoff
'\"
'\" See the file "LICENSE" for information on usage and redistribution
'\" of this file, and for a DISCLAIMER OF ALL WARRANTIES.
'\"
.TH netinfo n 0.6 Tcl netinfo
.SH NAME
netinfo \- Protocol, service, network, host and ether info
.SH SYNOPSIS
\fBpackage require Tcl\fR
.sp
\fBpackage require netinfo 0.6\fR
.br
\fBnamespace import ::netinfo::*\fR
.sp
\fBnetinfoDatabases\fR
.sp
\fBprotocolDataFilename\fR ?\fIfileName\fR?
.br
\fBserviceDataFilename\fR  ?\fIfileName\fR?
.br
\fBnetworkDataFilename\fR  ?\fIfileName\fR?
.br
\fBhostDataFilename\fR     ?\fIfileName\fR?
.br
\fBetherDataFilename\fR    ?\fIfileName\fR?
.sp
\fBloadProtocolData\fR
.br
\fBloadServiceData\fR
.br
\fBloadNetworkData\fR
.br
\fBloadHostData\fR
.br
\fBloadEtherData\fR
.sp
\fBprotocolFields\fR
.br
\fBserviceFields\fR
.br
\fBnetworkFields\fR
.br
\fBhostFields\fR
.br
\fBetherFields\fR
.sp
\fBprotocol\fR \fIfield\fR \fIvalue\fR ?\fIfield value ...\fR?
.br
\fBservice\fR  \fIfield\fR \fIvalue\fR ?\fIfield value ...\fR?
.br
\fBnetwork\fR  \fIfield\fR \fIvalue\fR ?\fIfield value ...\fR?
.br
\fBhost\fR     \fIfield\fR \fIvalue\fR ?\fIfield value ...\fR?
.br
\fBether\fR    \fIfield\fR \fIvalue\fR ?\fIfield value ...\fR?
.sp
\fBprotocolData\fR \fIprotocolInfo\fR \fIfield\fR ?\fIfield ...\fR?
.br
\fBserviceData\fR  \fIserviceInfo\fR  \fIfield\fR ?\fIfield ...\fR?
.br
\fBnetworkData\fR  \fInetworkInfo\fR  \fIfield\fR ?\fIfield ...\fR?
.br
\fBhostData\fR     \fIhostInfo\fR     \fIfield\fR ?\fIfield ...\fR?
.br
\fBetherData\fR    \fIetherInfo\fR    \fIfield\fR ?\fIfield ...\fR?
.SH DESCRIPTION
.PP
The \fBnetinfo\fR Tcl extension provides access to
system \fBprotocol\fR, \fBservice\fR, \fBnetwork\fR, \fBhost\fR and \fBether\fR information
which is retrieved from system databases and made available for querying.
.sp
This functionality is somewhat analogous to that provided by some of the
functions referenced in the \fI<netdb.h>\fR C include file usually found on
unix-like operating systems (gethostbyname, getservbyport, etc).
Unlike those functions, \fBnetinfo\fR does not go beyond referencing the
data stored in the system databases; \fBnetinfo\fR does not access the databases per query,
rather it loads the data and parses it into an internal ready-for-querying format.
If any changes are made to the databases after loading then the affected databases
would need to be reloaded if the changes are to be available to \fBnetinfo\fR queries.
.sp
Normal usage involves optionally specifying any database files if the defaults
do not match your reality, calling as many of the "load" commands as are necessary
(depending on what data you need to access; \fBnetinfo\fR does not load anything
at startup) and using the querying and extraction commands to retrieve info.
.sp
In this man page, the word \fIdbname\fR can replaced by one of:
\fBprotocol\fR, \fBservice\fR, \fBnetwork\fR, \fBhost\fR or \fBether\fR.
For example, seeing a description of a command named \fBdbnameFields\fR
does not mean that a command "\fBdbnameFields\fR" exists but rather that the commands
\fBprotocolFields\fR, \fBserviceFields\fR, \fBnetworkFields\fR, \fBhostFields\fR and \fBetherFields\fR exist.
.SH COMMANDS
.TP
\fBnetinfoDatabases\fR
Returns the list of system databases that \fBnetinfo\fR can query:
{\fBprotocol\fR \fBservice\fR \fBnetwork\fR \fBhost\fR \fBether\fR}.
.TP
\fBdbnameDataFilename\fR ?\fIfileName\fR?
Where \fIdbname\fR can be one of: \fBprotocol\fR, \fBservice\fR, \fBnetwork\fR \fBhost\fR or \fBether\fR.
These commands permit the setting and retrieval of the file names
used to import the system databases. When called without a \fIfileName\fR
argument they return the current file name.
When called with a \fIfileName\fR argument they set the file name to
\fIfileName\fR and return the old file name.
.sp
The defaults are:
.sp
.nf
protocol: /etc/protocols
service:  /etc/services
network:  /etc/networks
host:     /etc/hosts
ether:    /etc/ethers
.fi
.TP
\fBloadDbnameData\fR
Where \fIDbname\fR can be one of: \fBProtocol\fR, \fBService\fR, \fBNetwork\fR, \fBHost\fR or \fBEther\fR.
These commands import data from the system databases.
No files are loaded when the \fBnetinfo\fR extension is loaded.
One of these must be called (at least once) to import the system data
after (optionally) setting the file name. It is necessary to
load only the data for which querying is desired, i.e. they
don't all have to be loaded.
.TP
\fBdbnameFields\fR
Where \fIdbname\fR can be one of: \fBprotocol\fR, \fBservice\fR, \fBnetwork\fR, \fBhost\fR or \fBether\fR.
These commands return a list of field names for their respective
databases. The order of the fields is the same order in which
data is returned from the querying commands. The fields correspond
to the fields in their respective files, with the exception of \fBhost\fR
which has an additional \fI-domain\fR field which can be
either \fBinet\fR or \fBinet6\fR. The \fI-protocol\fR field for \fBservice\fR
data is usually \fBtcp\fR or \fBudp\fR.
.sp
The fields are:
.sp
.nf
protocol: -name -aliases -comment -number
service:  -name -aliases -comment -port -protocol
network:  -name -aliases -comment -number
host:     -name -aliases -comment -address -domain
ether:    -name -address -comment
.fi
.TP
\fBdbname\fR \fIfield\fR \fIvalue\fR ?\fIfield value ...\fR?
Where \fIdbname\fR can be one of: \fBprotocol\fR, \fBservice\fR, \fBnetwork\fR, \fBhost\fR or \fBether\fR.
These commands query their respective databases and return lists
containing matched data, if any.
The \fIfield\fR parameter must be one of the available fields for
the particular data set as returned by one of the \fBdbnameFields\fR commands.
The \fIvalue\fR parameter is matched against the indicated field using the
rules of [string match]. Additional \fIfield\fR \fIvalue\fR pairs
may be given for a more precise query. If any of the \fIvalue\fR
parameters contain any glob chars ('*', '?' or something enclosed in '[]')
then the return value will be a list of lists, each element of the outer
list being one result of the matched query. If no glob chars are present
in the \fIvalue\fR parameter then only the first match is returned as a single list.
If no matches are found then an empty list '{}' is returned.
For \fBhost\fR queries without a supplied \fI-domain\fR argument,
\fBinet\fR domains will match first. For \fBservice\fR queries
without a supplied \fI-protocol\fR argument, \fBtcp\fR protocols will match first.
.TP
\fBdbnameData\fR \fIdbnameInfo\fR \fIfield\fR ?\fIfield ...\fR?
Where \fIdbname\fR can be one of: \fBprotocol\fR, \fBservice\fR, \fBnetwork\fR, \fBhost\fR or \fBether\fR.
These commands extract data from query results.
The \fBdbname\fR parameter is a single database "row" (a list) as returned by one of
the querying commands.
The \fIfield\fR parameter must be one of the available fields for
the particular data set as returned by one of the \fBdbnameFields\fR commands.
If only a single \fIfield\fR parameter is provided then the result will be
the value of the specified field. If more than one \fIfield\fR parameters are provided
then the result will be a list containing the values of the specified
fields in the same order as the specified \fIfield\fR parameters.

.SH EXAMPLES
.nf
# Results noted with #=>

package require netinfo
namespace import ::netinfo::*

loadServiceData; loadNetworkData; loadHostData; loadEtherData

protocolData [protocol -number 123] -comment
#=> Performance Transparency Protocol
protocolData [protocol -number 123] -comment -name
#=> {Performance Transparency Protocol} ptp

service -port 9
#=> discard 9 {sink null} {} tcp
service -port 9 -protocol udp
#=> discard 9 {sink null} {} udp
service -port 9 -protocol *
#=> {discard 9 {sink null} {} tcp} {discard 9 {sink null} {} udp}
serviceData [lindex [service -port 9 -protocol *] 1] -protocol -port
#=> udp 9

network -number 127
#=> loopback loop {} 127
networkData [network -number 224] -name
#=> BASE-ADDRESS.MCAST.NET

hostData [host -aliases localhost] -address
#=> 127.0.0.1
hostData [host -aliases localhost -domain inet6] -address
#=> ::1

etherData [ether -name toaster] -address
#=> 00:01:6a:e3:df:0a

# List all services:
service -name *
.fi
.SH CAVEATS
Network database files are expected to be RFC? POSIX? compliant (if such things exist);
the lines/fields are simply parsed with no checks for correctness of data (ie: IP addresses);
such validation is beyond the scope of this extension.
No error checking is done in regards to field names or file names or anything else.
This 'crashing as error reporting' strategy is motivated by:
laziness, a desire for keeping things quick and simple and the fact this
is an all-around simple little extension that I didn't feel like bogging
down with all that extra stuff.
Besides, you're supposed to know what you're doing. :)
.SH KEYWORDS
protocol service network host ether
