%% Generated by the Erlang ASN.1 PER-compiler version, utilizing bit-syntax:2.0.4
%% Purpose: encoder and decoder to the types in mod megaco_per_media_gateway_control_prev3b

-module('megaco_per_media_gateway_control_prev3b').
-compile(nowarn_unused_vars).
-include("megaco_per_media_gateway_control_prev3b.hrl").
-asn1_info([{vsn,'2.0.4'},
            {module,'megaco_per_media_gateway_control_prev3b'},
            {options,[warnings,per,errors,
 {cwd,"/net/isildur/ldisk/daily_build/r16b03-1_prebuild_opu_o.2014-01-23_17/otp_src_R16B03-1/lib/megaco/src/binary"},
 {outdir,"/net/isildur/ldisk/daily_build/r16b03-1_prebuild_opu_o.2014-01-23_17/otp_src_R16B03-1/lib/megaco/src/binary"},
 noobj,
 {i,"."},
 {i,"/net/isildur/ldisk/daily_build/r16b03-1_prebuild_opu_o.2014-01-23_17/otp_src_R16B03-1/lib/megaco/src/binary"}]}]).

-export([encoding_rule/0,bit_string_format/0]).
-export([
'enc_Value'/1,
'enc_TimeNotation'/1,
'enc_H221NonStandard'/1,
'enc_NonStandardIdentifier'/1,
'enc_NonStandardData'/1,
'enc_StatisticsParameter'/1,
'enc_StatisticsDescriptor'/1,
'enc_PackagesItem'/1,
'enc_PackagesDescriptor'/1,
'enc_ServiceChangeProfile'/1,
'enc_ServiceChangeMethod'/1,
'enc_ServiceChangeResParm'/1,
'enc_ServiceChangeAddress'/1,
'enc_ServiceChangeParm'/1,
'enc_DigitMapValue'/1,
'enc_DigitMapName'/1,
'enc_DigitMapDescriptor'/1,
'enc_ModemType'/1,
'enc_ModemDescriptor'/1,
'enc_RequestID'/1,
'enc_SigParameter'/1,
'enc_NotifyCompletion'/1,
'enc_SignalName'/1,
'enc_SignalDirection'/1,
'enc_SignalType'/1,
'enc_Signal'/1,
'enc_SeqSigList'/1,
'enc_SignalRequest'/1,
'enc_SignalsDescriptor'/1,
'enc_EventSpec'/1,
'enc_EventBufferDescriptor'/1,
'enc_SecondRequestedActions'/1,
'enc_SecondRequestedEvent'/1,
'enc_SecondEventsDescriptor'/1,
'enc_EventDM'/1,
'enc_RequestedActions'/1,
'enc_RequestedEvent'/1,
'enc_EventsDescriptor'/1,
'enc_StreamID'/1,
'enc_MuxType'/1,
'enc_MuxDescriptor'/1,
'enc_ServiceState'/1,
'enc_EventBufferControl'/1,
'enc_TerminationStateDescriptor'/1,
'enc_PropertyGroup'/1,
'enc_LocalRemoteDescriptor'/1,
'enc_Relation'/1,
'enc_PkgdName'/1,
'enc_Name'/1,
'enc_PropertyParm'/1,
'enc_StreamMode'/1,
'enc_LocalControlDescriptor'/1,
'enc_StreamParms'/1,
'enc_StreamDescriptor'/1,
'enc_MediaDescriptor'/1,
'enc_TerminationIDList'/1,
'enc_TerminationID'/1,
'enc_WildcardField'/1,
'enc_ServiceChangeResult'/1,
'enc_ServiceChangeReply'/1,
'enc_ServiceChangeRequest'/1,
'enc_EventParameter'/1,
'enc_EventName'/1,
'enc_ObservedEvent'/1,
'enc_ObservedEventsDescriptor'/1,
'enc_NotifyReply'/1,
'enc_NotifyRequest'/1,
'enc_IndAudPackagesDescriptor'/1,
'enc_IndAudStatisticsDescriptor'/1,
'enc_IndAudDigitMapDescriptor'/1,
'enc_IndAudSignal'/1,
'enc_IndAudSeqSigList'/1,
'enc_IndAudSignalsDescriptor'/1,
'enc_IndAudEventBufferDescriptor'/1,
'enc_IndAudEventsDescriptor'/1,
'enc_IndAudTerminationStateDescriptor'/1,
'enc_IndAudPropertyGroup'/1,
'enc_IndAudLocalRemoteDescriptor'/1,
'enc_IndAudPropertyParm'/1,
'enc_IndAudLocalControlDescriptor'/1,
'enc_IndAudStreamParms'/1,
'enc_IndAudStreamDescriptor'/1,
'enc_IndAudMediaDescriptor'/1,
'enc_IndAuditParameter'/1,
'enc_AuditDescriptor'/1,
'enc_AuditReturnParameter'/1,
'enc_TerminationAudit'/1,
'enc_AuditResult'/1,
'enc_AuditReply'/1,
'enc_AuditRequest'/1,
'enc_SubtractRequest'/1,
'enc_AmmsReply'/1,
'enc_AmmDescriptor'/1,
'enc_AmmRequest'/1,
'enc_TopologyRequest'/1,
'enc_CommandReply'/1,
'enc_Command'/1,
'enc_CommandRequest'/1,
'enc_ContextAttrAuditRequest'/1,
'enc_ContextRequest'/1,
'enc_ActionReply'/1,
'enc_ActionRequest'/1,
'enc_ContextID'/1,
'enc_ErrorText'/1,
'enc_ErrorCode'/1,
'enc_ErrorDescriptor'/1,
'enc_TransactionAck'/1,
'enc_TransactionResponseAck'/1,
'enc_SegmentNumber'/1,
'enc_TransactionReply'/1,
'enc_TransactionPending'/1,
'enc_TransactionRequest'/1,
'enc_TransactionId'/1,
'enc_Transaction'/1,
'enc_PathName'/1,
'enc_IP6Address'/1,
'enc_IP4Address'/1,
'enc_DomainName'/1,
'enc_MId'/1,
'enc_Message'/1,
'enc_AuthData'/1,
'enc_SequenceNum'/1,
'enc_SecurityParmIndex'/1,
'enc_AuthenticationHeader'/1,
'enc_MegacoMessage'/1
]).

-export([
'dec_Value'/1,
'dec_TimeNotation'/1,
'dec_H221NonStandard'/1,
'dec_NonStandardIdentifier'/1,
'dec_NonStandardData'/1,
'dec_StatisticsParameter'/1,
'dec_StatisticsDescriptor'/1,
'dec_PackagesItem'/1,
'dec_PackagesDescriptor'/1,
'dec_ServiceChangeProfile'/1,
'dec_ServiceChangeMethod'/1,
'dec_ServiceChangeResParm'/1,
'dec_ServiceChangeAddress'/1,
'dec_ServiceChangeParm'/1,
'dec_DigitMapValue'/1,
'dec_DigitMapName'/1,
'dec_DigitMapDescriptor'/1,
'dec_ModemType'/1,
'dec_ModemDescriptor'/1,
'dec_RequestID'/1,
'dec_SigParameter'/1,
'dec_NotifyCompletion'/1,
'dec_SignalName'/1,
'dec_SignalDirection'/1,
'dec_SignalType'/1,
'dec_Signal'/1,
'dec_SeqSigList'/1,
'dec_SignalRequest'/1,
'dec_SignalsDescriptor'/1,
'dec_EventSpec'/1,
'dec_EventBufferDescriptor'/1,
'dec_SecondRequestedActions'/1,
'dec_SecondRequestedEvent'/1,
'dec_SecondEventsDescriptor'/1,
'dec_EventDM'/1,
'dec_RequestedActions'/1,
'dec_RequestedEvent'/1,
'dec_EventsDescriptor'/1,
'dec_StreamID'/1,
'dec_MuxType'/1,
'dec_MuxDescriptor'/1,
'dec_ServiceState'/1,
'dec_EventBufferControl'/1,
'dec_TerminationStateDescriptor'/1,
'dec_PropertyGroup'/1,
'dec_LocalRemoteDescriptor'/1,
'dec_Relation'/1,
'dec_PkgdName'/1,
'dec_Name'/1,
'dec_PropertyParm'/1,
'dec_StreamMode'/1,
'dec_LocalControlDescriptor'/1,
'dec_StreamParms'/1,
'dec_StreamDescriptor'/1,
'dec_MediaDescriptor'/1,
'dec_TerminationIDList'/1,
'dec_TerminationID'/1,
'dec_WildcardField'/1,
'dec_ServiceChangeResult'/1,
'dec_ServiceChangeReply'/1,
'dec_ServiceChangeRequest'/1,
'dec_EventParameter'/1,
'dec_EventName'/1,
'dec_ObservedEvent'/1,
'dec_ObservedEventsDescriptor'/1,
'dec_NotifyReply'/1,
'dec_NotifyRequest'/1,
'dec_IndAudPackagesDescriptor'/1,
'dec_IndAudStatisticsDescriptor'/1,
'dec_IndAudDigitMapDescriptor'/1,
'dec_IndAudSignal'/1,
'dec_IndAudSeqSigList'/1,
'dec_IndAudSignalsDescriptor'/1,
'dec_IndAudEventBufferDescriptor'/1,
'dec_IndAudEventsDescriptor'/1,
'dec_IndAudTerminationStateDescriptor'/1,
'dec_IndAudPropertyGroup'/1,
'dec_IndAudLocalRemoteDescriptor'/1,
'dec_IndAudPropertyParm'/1,
'dec_IndAudLocalControlDescriptor'/1,
'dec_IndAudStreamParms'/1,
'dec_IndAudStreamDescriptor'/1,
'dec_IndAudMediaDescriptor'/1,
'dec_IndAuditParameter'/1,
'dec_AuditDescriptor'/1,
'dec_AuditReturnParameter'/1,
'dec_TerminationAudit'/1,
'dec_AuditResult'/1,
'dec_AuditReply'/1,
'dec_AuditRequest'/1,
'dec_SubtractRequest'/1,
'dec_AmmsReply'/1,
'dec_AmmDescriptor'/1,
'dec_AmmRequest'/1,
'dec_TopologyRequest'/1,
'dec_CommandReply'/1,
'dec_Command'/1,
'dec_CommandRequest'/1,
'dec_ContextAttrAuditRequest'/1,
'dec_ContextRequest'/1,
'dec_ActionReply'/1,
'dec_ActionRequest'/1,
'dec_ContextID'/1,
'dec_ErrorText'/1,
'dec_ErrorCode'/1,
'dec_ErrorDescriptor'/1,
'dec_TransactionAck'/1,
'dec_TransactionResponseAck'/1,
'dec_SegmentNumber'/1,
'dec_TransactionReply'/1,
'dec_TransactionPending'/1,
'dec_TransactionRequest'/1,
'dec_TransactionId'/1,
'dec_Transaction'/1,
'dec_PathName'/1,
'dec_IP6Address'/1,
'dec_IP4Address'/1,
'dec_DomainName'/1,
'dec_MId'/1,
'dec_Message'/1,
'dec_AuthData'/1,
'dec_SequenceNum'/1,
'dec_SecurityParmIndex'/1,
'dec_AuthenticationHeader'/1,
'dec_MegacoMessage'/1
]).

-export([info/0]).


-export([encode/2,decode/2]).

encoding_rule() -> per.

bit_string_format() -> bitstring.

encode(Type, Data) ->
try complete(encode_disp(Type, Data)) of
  Bytes ->
    {ok,Bytes}
  catch
    Class:Exception when Class =:= error; Class =:= exit ->
      case Exception of
        {error,Reason}=Error ->
          Error;
        Reason ->
         {error,{asn1,Reason}}
      end
end.

decode(Type,Data) ->
try decode_disp(Type, Data) of
  {Result,Rest} ->
    {ok,Result}
  catch
    Class:Exception when Class =:= error; Class =:= exit ->
      case Exception of
        {error,Reason}=Error ->
          Error;
        Reason ->
         {error,{asn1,Reason}}
      end
end.

encode_disp('Value',Data) -> 'enc_Value'(Data);
encode_disp('TimeNotation',Data) -> 'enc_TimeNotation'(Data);
encode_disp('H221NonStandard',Data) -> 'enc_H221NonStandard'(Data);
encode_disp('NonStandardIdentifier',Data) -> 'enc_NonStandardIdentifier'(Data);
encode_disp('NonStandardData',Data) -> 'enc_NonStandardData'(Data);
encode_disp('StatisticsParameter',Data) -> 'enc_StatisticsParameter'(Data);
encode_disp('StatisticsDescriptor',Data) -> 'enc_StatisticsDescriptor'(Data);
encode_disp('PackagesItem',Data) -> 'enc_PackagesItem'(Data);
encode_disp('PackagesDescriptor',Data) -> 'enc_PackagesDescriptor'(Data);
encode_disp('ServiceChangeProfile',Data) -> 'enc_ServiceChangeProfile'(Data);
encode_disp('ServiceChangeMethod',Data) -> 'enc_ServiceChangeMethod'(Data);
encode_disp('ServiceChangeResParm',Data) -> 'enc_ServiceChangeResParm'(Data);
encode_disp('ServiceChangeAddress',Data) -> 'enc_ServiceChangeAddress'(Data);
encode_disp('ServiceChangeParm',Data) -> 'enc_ServiceChangeParm'(Data);
encode_disp('DigitMapValue',Data) -> 'enc_DigitMapValue'(Data);
encode_disp('DigitMapName',Data) -> 'enc_DigitMapName'(Data);
encode_disp('DigitMapDescriptor',Data) -> 'enc_DigitMapDescriptor'(Data);
encode_disp('ModemType',Data) -> 'enc_ModemType'(Data);
encode_disp('ModemDescriptor',Data) -> 'enc_ModemDescriptor'(Data);
encode_disp('RequestID',Data) -> 'enc_RequestID'(Data);
encode_disp('SigParameter',Data) -> 'enc_SigParameter'(Data);
encode_disp('NotifyCompletion',Data) -> 'enc_NotifyCompletion'(Data);
encode_disp('SignalName',Data) -> 'enc_SignalName'(Data);
encode_disp('SignalDirection',Data) -> 'enc_SignalDirection'(Data);
encode_disp('SignalType',Data) -> 'enc_SignalType'(Data);
encode_disp('Signal',Data) -> 'enc_Signal'(Data);
encode_disp('SeqSigList',Data) -> 'enc_SeqSigList'(Data);
encode_disp('SignalRequest',Data) -> 'enc_SignalRequest'(Data);
encode_disp('SignalsDescriptor',Data) -> 'enc_SignalsDescriptor'(Data);
encode_disp('EventSpec',Data) -> 'enc_EventSpec'(Data);
encode_disp('EventBufferDescriptor',Data) -> 'enc_EventBufferDescriptor'(Data);
encode_disp('SecondRequestedActions',Data) -> 'enc_SecondRequestedActions'(Data);
encode_disp('SecondRequestedEvent',Data) -> 'enc_SecondRequestedEvent'(Data);
encode_disp('SecondEventsDescriptor',Data) -> 'enc_SecondEventsDescriptor'(Data);
encode_disp('EventDM',Data) -> 'enc_EventDM'(Data);
encode_disp('RequestedActions',Data) -> 'enc_RequestedActions'(Data);
encode_disp('RequestedEvent',Data) -> 'enc_RequestedEvent'(Data);
encode_disp('EventsDescriptor',Data) -> 'enc_EventsDescriptor'(Data);
encode_disp('StreamID',Data) -> 'enc_StreamID'(Data);
encode_disp('MuxType',Data) -> 'enc_MuxType'(Data);
encode_disp('MuxDescriptor',Data) -> 'enc_MuxDescriptor'(Data);
encode_disp('ServiceState',Data) -> 'enc_ServiceState'(Data);
encode_disp('EventBufferControl',Data) -> 'enc_EventBufferControl'(Data);
encode_disp('TerminationStateDescriptor',Data) -> 'enc_TerminationStateDescriptor'(Data);
encode_disp('PropertyGroup',Data) -> 'enc_PropertyGroup'(Data);
encode_disp('LocalRemoteDescriptor',Data) -> 'enc_LocalRemoteDescriptor'(Data);
encode_disp('Relation',Data) -> 'enc_Relation'(Data);
encode_disp('PkgdName',Data) -> 'enc_PkgdName'(Data);
encode_disp('Name',Data) -> 'enc_Name'(Data);
encode_disp('PropertyParm',Data) -> 'enc_PropertyParm'(Data);
encode_disp('StreamMode',Data) -> 'enc_StreamMode'(Data);
encode_disp('LocalControlDescriptor',Data) -> 'enc_LocalControlDescriptor'(Data);
encode_disp('StreamParms',Data) -> 'enc_StreamParms'(Data);
encode_disp('StreamDescriptor',Data) -> 'enc_StreamDescriptor'(Data);
encode_disp('MediaDescriptor',Data) -> 'enc_MediaDescriptor'(Data);
encode_disp('TerminationIDList',Data) -> 'enc_TerminationIDList'(Data);
encode_disp('TerminationID',Data) -> 'enc_TerminationID'(Data);
encode_disp('WildcardField',Data) -> 'enc_WildcardField'(Data);
encode_disp('ServiceChangeResult',Data) -> 'enc_ServiceChangeResult'(Data);
encode_disp('ServiceChangeReply',Data) -> 'enc_ServiceChangeReply'(Data);
encode_disp('ServiceChangeRequest',Data) -> 'enc_ServiceChangeRequest'(Data);
encode_disp('EventParameter',Data) -> 'enc_EventParameter'(Data);
encode_disp('EventName',Data) -> 'enc_EventName'(Data);
encode_disp('ObservedEvent',Data) -> 'enc_ObservedEvent'(Data);
encode_disp('ObservedEventsDescriptor',Data) -> 'enc_ObservedEventsDescriptor'(Data);
encode_disp('NotifyReply',Data) -> 'enc_NotifyReply'(Data);
encode_disp('NotifyRequest',Data) -> 'enc_NotifyRequest'(Data);
encode_disp('IndAudPackagesDescriptor',Data) -> 'enc_IndAudPackagesDescriptor'(Data);
encode_disp('IndAudStatisticsDescriptor',Data) -> 'enc_IndAudStatisticsDescriptor'(Data);
encode_disp('IndAudDigitMapDescriptor',Data) -> 'enc_IndAudDigitMapDescriptor'(Data);
encode_disp('IndAudSignal',Data) -> 'enc_IndAudSignal'(Data);
encode_disp('IndAudSeqSigList',Data) -> 'enc_IndAudSeqSigList'(Data);
encode_disp('IndAudSignalsDescriptor',Data) -> 'enc_IndAudSignalsDescriptor'(Data);
encode_disp('IndAudEventBufferDescriptor',Data) -> 'enc_IndAudEventBufferDescriptor'(Data);
encode_disp('IndAudEventsDescriptor',Data) -> 'enc_IndAudEventsDescriptor'(Data);
encode_disp('IndAudTerminationStateDescriptor',Data) -> 'enc_IndAudTerminationStateDescriptor'(Data);
encode_disp('IndAudPropertyGroup',Data) -> 'enc_IndAudPropertyGroup'(Data);
encode_disp('IndAudLocalRemoteDescriptor',Data) -> 'enc_IndAudLocalRemoteDescriptor'(Data);
encode_disp('IndAudPropertyParm',Data) -> 'enc_IndAudPropertyParm'(Data);
encode_disp('IndAudLocalControlDescriptor',Data) -> 'enc_IndAudLocalControlDescriptor'(Data);
encode_disp('IndAudStreamParms',Data) -> 'enc_IndAudStreamParms'(Data);
encode_disp('IndAudStreamDescriptor',Data) -> 'enc_IndAudStreamDescriptor'(Data);
encode_disp('IndAudMediaDescriptor',Data) -> 'enc_IndAudMediaDescriptor'(Data);
encode_disp('IndAuditParameter',Data) -> 'enc_IndAuditParameter'(Data);
encode_disp('AuditDescriptor',Data) -> 'enc_AuditDescriptor'(Data);
encode_disp('AuditReturnParameter',Data) -> 'enc_AuditReturnParameter'(Data);
encode_disp('TerminationAudit',Data) -> 'enc_TerminationAudit'(Data);
encode_disp('AuditResult',Data) -> 'enc_AuditResult'(Data);
encode_disp('AuditReply',Data) -> 'enc_AuditReply'(Data);
encode_disp('AuditRequest',Data) -> 'enc_AuditRequest'(Data);
encode_disp('SubtractRequest',Data) -> 'enc_SubtractRequest'(Data);
encode_disp('AmmsReply',Data) -> 'enc_AmmsReply'(Data);
encode_disp('AmmDescriptor',Data) -> 'enc_AmmDescriptor'(Data);
encode_disp('AmmRequest',Data) -> 'enc_AmmRequest'(Data);
encode_disp('TopologyRequest',Data) -> 'enc_TopologyRequest'(Data);
encode_disp('CommandReply',Data) -> 'enc_CommandReply'(Data);
encode_disp('Command',Data) -> 'enc_Command'(Data);
encode_disp('CommandRequest',Data) -> 'enc_CommandRequest'(Data);
encode_disp('ContextAttrAuditRequest',Data) -> 'enc_ContextAttrAuditRequest'(Data);
encode_disp('ContextRequest',Data) -> 'enc_ContextRequest'(Data);
encode_disp('ActionReply',Data) -> 'enc_ActionReply'(Data);
encode_disp('ActionRequest',Data) -> 'enc_ActionRequest'(Data);
encode_disp('ContextID',Data) -> 'enc_ContextID'(Data);
encode_disp('ErrorText',Data) -> 'enc_ErrorText'(Data);
encode_disp('ErrorCode',Data) -> 'enc_ErrorCode'(Data);
encode_disp('ErrorDescriptor',Data) -> 'enc_ErrorDescriptor'(Data);
encode_disp('TransactionAck',Data) -> 'enc_TransactionAck'(Data);
encode_disp('TransactionResponseAck',Data) -> 'enc_TransactionResponseAck'(Data);
encode_disp('SegmentNumber',Data) -> 'enc_SegmentNumber'(Data);
encode_disp('TransactionReply',Data) -> 'enc_TransactionReply'(Data);
encode_disp('TransactionPending',Data) -> 'enc_TransactionPending'(Data);
encode_disp('TransactionRequest',Data) -> 'enc_TransactionRequest'(Data);
encode_disp('TransactionId',Data) -> 'enc_TransactionId'(Data);
encode_disp('Transaction',Data) -> 'enc_Transaction'(Data);
encode_disp('PathName',Data) -> 'enc_PathName'(Data);
encode_disp('IP6Address',Data) -> 'enc_IP6Address'(Data);
encode_disp('IP4Address',Data) -> 'enc_IP4Address'(Data);
encode_disp('DomainName',Data) -> 'enc_DomainName'(Data);
encode_disp('MId',Data) -> 'enc_MId'(Data);
encode_disp('Message',Data) -> 'enc_Message'(Data);
encode_disp('AuthData',Data) -> 'enc_AuthData'(Data);
encode_disp('SequenceNum',Data) -> 'enc_SequenceNum'(Data);
encode_disp('SecurityParmIndex',Data) -> 'enc_SecurityParmIndex'(Data);
encode_disp('AuthenticationHeader',Data) -> 'enc_AuthenticationHeader'(Data);
encode_disp('MegacoMessage',Data) -> 'enc_MegacoMessage'(Data);
encode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).


decode_disp('Value',Data) -> 'dec_Value'(Data);
decode_disp('TimeNotation',Data) -> 'dec_TimeNotation'(Data);
decode_disp('H221NonStandard',Data) -> 'dec_H221NonStandard'(Data);
decode_disp('NonStandardIdentifier',Data) -> 'dec_NonStandardIdentifier'(Data);
decode_disp('NonStandardData',Data) -> 'dec_NonStandardData'(Data);
decode_disp('StatisticsParameter',Data) -> 'dec_StatisticsParameter'(Data);
decode_disp('StatisticsDescriptor',Data) -> 'dec_StatisticsDescriptor'(Data);
decode_disp('PackagesItem',Data) -> 'dec_PackagesItem'(Data);
decode_disp('PackagesDescriptor',Data) -> 'dec_PackagesDescriptor'(Data);
decode_disp('ServiceChangeProfile',Data) -> 'dec_ServiceChangeProfile'(Data);
decode_disp('ServiceChangeMethod',Data) -> 'dec_ServiceChangeMethod'(Data);
decode_disp('ServiceChangeResParm',Data) -> 'dec_ServiceChangeResParm'(Data);
decode_disp('ServiceChangeAddress',Data) -> 'dec_ServiceChangeAddress'(Data);
decode_disp('ServiceChangeParm',Data) -> 'dec_ServiceChangeParm'(Data);
decode_disp('DigitMapValue',Data) -> 'dec_DigitMapValue'(Data);
decode_disp('DigitMapName',Data) -> 'dec_DigitMapName'(Data);
decode_disp('DigitMapDescriptor',Data) -> 'dec_DigitMapDescriptor'(Data);
decode_disp('ModemType',Data) -> 'dec_ModemType'(Data);
decode_disp('ModemDescriptor',Data) -> 'dec_ModemDescriptor'(Data);
decode_disp('RequestID',Data) -> 'dec_RequestID'(Data);
decode_disp('SigParameter',Data) -> 'dec_SigParameter'(Data);
decode_disp('NotifyCompletion',Data) -> 'dec_NotifyCompletion'(Data);
decode_disp('SignalName',Data) -> 'dec_SignalName'(Data);
decode_disp('SignalDirection',Data) -> 'dec_SignalDirection'(Data);
decode_disp('SignalType',Data) -> 'dec_SignalType'(Data);
decode_disp('Signal',Data) -> 'dec_Signal'(Data);
decode_disp('SeqSigList',Data) -> 'dec_SeqSigList'(Data);
decode_disp('SignalRequest',Data) -> 'dec_SignalRequest'(Data);
decode_disp('SignalsDescriptor',Data) -> 'dec_SignalsDescriptor'(Data);
decode_disp('EventSpec',Data) -> 'dec_EventSpec'(Data);
decode_disp('EventBufferDescriptor',Data) -> 'dec_EventBufferDescriptor'(Data);
decode_disp('SecondRequestedActions',Data) -> 'dec_SecondRequestedActions'(Data);
decode_disp('SecondRequestedEvent',Data) -> 'dec_SecondRequestedEvent'(Data);
decode_disp('SecondEventsDescriptor',Data) -> 'dec_SecondEventsDescriptor'(Data);
decode_disp('EventDM',Data) -> 'dec_EventDM'(Data);
decode_disp('RequestedActions',Data) -> 'dec_RequestedActions'(Data);
decode_disp('RequestedEvent',Data) -> 'dec_RequestedEvent'(Data);
decode_disp('EventsDescriptor',Data) -> 'dec_EventsDescriptor'(Data);
decode_disp('StreamID',Data) -> 'dec_StreamID'(Data);
decode_disp('MuxType',Data) -> 'dec_MuxType'(Data);
decode_disp('MuxDescriptor',Data) -> 'dec_MuxDescriptor'(Data);
decode_disp('ServiceState',Data) -> 'dec_ServiceState'(Data);
decode_disp('EventBufferControl',Data) -> 'dec_EventBufferControl'(Data);
decode_disp('TerminationStateDescriptor',Data) -> 'dec_TerminationStateDescriptor'(Data);
decode_disp('PropertyGroup',Data) -> 'dec_PropertyGroup'(Data);
decode_disp('LocalRemoteDescriptor',Data) -> 'dec_LocalRemoteDescriptor'(Data);
decode_disp('Relation',Data) -> 'dec_Relation'(Data);
decode_disp('PkgdName',Data) -> 'dec_PkgdName'(Data);
decode_disp('Name',Data) -> 'dec_Name'(Data);
decode_disp('PropertyParm',Data) -> 'dec_PropertyParm'(Data);
decode_disp('StreamMode',Data) -> 'dec_StreamMode'(Data);
decode_disp('LocalControlDescriptor',Data) -> 'dec_LocalControlDescriptor'(Data);
decode_disp('StreamParms',Data) -> 'dec_StreamParms'(Data);
decode_disp('StreamDescriptor',Data) -> 'dec_StreamDescriptor'(Data);
decode_disp('MediaDescriptor',Data) -> 'dec_MediaDescriptor'(Data);
decode_disp('TerminationIDList',Data) -> 'dec_TerminationIDList'(Data);
decode_disp('TerminationID',Data) -> 'dec_TerminationID'(Data);
decode_disp('WildcardField',Data) -> 'dec_WildcardField'(Data);
decode_disp('ServiceChangeResult',Data) -> 'dec_ServiceChangeResult'(Data);
decode_disp('ServiceChangeReply',Data) -> 'dec_ServiceChangeReply'(Data);
decode_disp('ServiceChangeRequest',Data) -> 'dec_ServiceChangeRequest'(Data);
decode_disp('EventParameter',Data) -> 'dec_EventParameter'(Data);
decode_disp('EventName',Data) -> 'dec_EventName'(Data);
decode_disp('ObservedEvent',Data) -> 'dec_ObservedEvent'(Data);
decode_disp('ObservedEventsDescriptor',Data) -> 'dec_ObservedEventsDescriptor'(Data);
decode_disp('NotifyReply',Data) -> 'dec_NotifyReply'(Data);
decode_disp('NotifyRequest',Data) -> 'dec_NotifyRequest'(Data);
decode_disp('IndAudPackagesDescriptor',Data) -> 'dec_IndAudPackagesDescriptor'(Data);
decode_disp('IndAudStatisticsDescriptor',Data) -> 'dec_IndAudStatisticsDescriptor'(Data);
decode_disp('IndAudDigitMapDescriptor',Data) -> 'dec_IndAudDigitMapDescriptor'(Data);
decode_disp('IndAudSignal',Data) -> 'dec_IndAudSignal'(Data);
decode_disp('IndAudSeqSigList',Data) -> 'dec_IndAudSeqSigList'(Data);
decode_disp('IndAudSignalsDescriptor',Data) -> 'dec_IndAudSignalsDescriptor'(Data);
decode_disp('IndAudEventBufferDescriptor',Data) -> 'dec_IndAudEventBufferDescriptor'(Data);
decode_disp('IndAudEventsDescriptor',Data) -> 'dec_IndAudEventsDescriptor'(Data);
decode_disp('IndAudTerminationStateDescriptor',Data) -> 'dec_IndAudTerminationStateDescriptor'(Data);
decode_disp('IndAudPropertyGroup',Data) -> 'dec_IndAudPropertyGroup'(Data);
decode_disp('IndAudLocalRemoteDescriptor',Data) -> 'dec_IndAudLocalRemoteDescriptor'(Data);
decode_disp('IndAudPropertyParm',Data) -> 'dec_IndAudPropertyParm'(Data);
decode_disp('IndAudLocalControlDescriptor',Data) -> 'dec_IndAudLocalControlDescriptor'(Data);
decode_disp('IndAudStreamParms',Data) -> 'dec_IndAudStreamParms'(Data);
decode_disp('IndAudStreamDescriptor',Data) -> 'dec_IndAudStreamDescriptor'(Data);
decode_disp('IndAudMediaDescriptor',Data) -> 'dec_IndAudMediaDescriptor'(Data);
decode_disp('IndAuditParameter',Data) -> 'dec_IndAuditParameter'(Data);
decode_disp('AuditDescriptor',Data) -> 'dec_AuditDescriptor'(Data);
decode_disp('AuditReturnParameter',Data) -> 'dec_AuditReturnParameter'(Data);
decode_disp('TerminationAudit',Data) -> 'dec_TerminationAudit'(Data);
decode_disp('AuditResult',Data) -> 'dec_AuditResult'(Data);
decode_disp('AuditReply',Data) -> 'dec_AuditReply'(Data);
decode_disp('AuditRequest',Data) -> 'dec_AuditRequest'(Data);
decode_disp('SubtractRequest',Data) -> 'dec_SubtractRequest'(Data);
decode_disp('AmmsReply',Data) -> 'dec_AmmsReply'(Data);
decode_disp('AmmDescriptor',Data) -> 'dec_AmmDescriptor'(Data);
decode_disp('AmmRequest',Data) -> 'dec_AmmRequest'(Data);
decode_disp('TopologyRequest',Data) -> 'dec_TopologyRequest'(Data);
decode_disp('CommandReply',Data) -> 'dec_CommandReply'(Data);
decode_disp('Command',Data) -> 'dec_Command'(Data);
decode_disp('CommandRequest',Data) -> 'dec_CommandRequest'(Data);
decode_disp('ContextAttrAuditRequest',Data) -> 'dec_ContextAttrAuditRequest'(Data);
decode_disp('ContextRequest',Data) -> 'dec_ContextRequest'(Data);
decode_disp('ActionReply',Data) -> 'dec_ActionReply'(Data);
decode_disp('ActionRequest',Data) -> 'dec_ActionRequest'(Data);
decode_disp('ContextID',Data) -> 'dec_ContextID'(Data);
decode_disp('ErrorText',Data) -> 'dec_ErrorText'(Data);
decode_disp('ErrorCode',Data) -> 'dec_ErrorCode'(Data);
decode_disp('ErrorDescriptor',Data) -> 'dec_ErrorDescriptor'(Data);
decode_disp('TransactionAck',Data) -> 'dec_TransactionAck'(Data);
decode_disp('TransactionResponseAck',Data) -> 'dec_TransactionResponseAck'(Data);
decode_disp('SegmentNumber',Data) -> 'dec_SegmentNumber'(Data);
decode_disp('TransactionReply',Data) -> 'dec_TransactionReply'(Data);
decode_disp('TransactionPending',Data) -> 'dec_TransactionPending'(Data);
decode_disp('TransactionRequest',Data) -> 'dec_TransactionRequest'(Data);
decode_disp('TransactionId',Data) -> 'dec_TransactionId'(Data);
decode_disp('Transaction',Data) -> 'dec_Transaction'(Data);
decode_disp('PathName',Data) -> 'dec_PathName'(Data);
decode_disp('IP6Address',Data) -> 'dec_IP6Address'(Data);
decode_disp('IP4Address',Data) -> 'dec_IP4Address'(Data);
decode_disp('DomainName',Data) -> 'dec_DomainName'(Data);
decode_disp('MId',Data) -> 'dec_MId'(Data);
decode_disp('Message',Data) -> 'dec_Message'(Data);
decode_disp('AuthData',Data) -> 'dec_AuthData'(Data);
decode_disp('SequenceNum',Data) -> 'dec_SequenceNum'(Data);
decode_disp('SecurityParmIndex',Data) -> 'dec_SecurityParmIndex'(Data);
decode_disp('AuthenticationHeader',Data) -> 'dec_AuthenticationHeader'(Data);
decode_disp('MegacoMessage',Data) -> 'dec_MegacoMessage'(Data);
decode_disp(Type,_Data) -> exit({error,{asn1,{undefined_type,Type}}}).




info() ->
   case ?MODULE:module_info(attributes) of
     Attributes when is_list(Attributes) ->
       case lists:keyfind(asn1_info, 1, Attributes) of
         {_,Info} when is_list(Info) ->
           Info;
         _ ->
           []
       end;
     _ ->
       []
   end.
'enc_Value'(Val) ->
Enc2@len = length(Val),
[if Enc2@len < 128 ->
[align,
Enc2@len];
Enc2@len < 16384 ->
[align|<<2:2,Enc2@len:14>>]
end|[begin
Enc1@bin = iolist_to_binary(Comp),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len < 128 ->
[Enc1@len|Enc1@bin];
Enc1@len < 16384 ->
[<<2:2,Enc1@len:14>>|Enc1@bin];
true ->
encode_fragmented(Enc1@bin, 8)
end
end || Comp <- Val]].



dec_Value(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components1(V1@V0, V1@Buf1, []).

'enc_TimeNotation'(Val) ->
[align,
begin
Enc1@input = element(2, Val),
Enc2@bin = list_to_binary(Enc1@input),
Enc2@len = byte_size(Enc2@bin),
if Enc2@len =:= 8 ->
Enc2@bin
end
end|begin
Enc3@input = element(3, Val),
Enc4@bin = list_to_binary(Enc3@input),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len =:= 8 ->
Enc4@bin
end
end].


dec_TimeNotation(Bytes) ->

%% attribute number 1 with type IA5String
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:8/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv4 = binary_to_list(V1@V0),
{V1@Conv4,V1@Buf1}
end,

%% attribute number 2 with type IA5String
{Term2,Bytes2} = begin
<<V2@V0:8/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv2 = binary_to_list(V2@V0),
{V2@Conv2,V2@Buf1}
end,
{{'TimeNotation',Term1,Term2},Bytes2}.

'enc_H221NonStandard'(Val) ->
[begin
Enc2@input = element(2, Val),
if Enc2@input bsr 8 =:= 0 ->
[<<0:1>>,
align,
Enc2@input];
true ->
exit({error,{asn1,{illegal_value,Enc2@input}}})
end
end,
begin
Enc4@input = element(3, Val),
if Enc4@input bsr 8 =:= 0 ->
Enc4@input;
true ->
exit({error,{asn1,{illegal_value,Enc4@input}}})
end
end,
begin
Enc6@input = element(4, Val),
if Enc6@input bsr 8 =:= 0 ->
Enc6@input;
true ->
exit({error,{asn1,{illegal_value,Enc6@input}}})
end
end|begin
Enc8@input = element(5, Val),
if Enc8@input bsr 16 =:= 0 ->
<<Enc8@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc8@input}}})
end
end].


dec_H221NonStandard(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type INTEGER
{Term1,Bytes2} = begin
V2@Pad2 = bit_size(Bytes1) band 7,
<<_:V2@Pad2,V2@V0:1/unsigned-unit:8,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 2 with type INTEGER
{Term2,Bytes3} = begin
<<V3@V0:1/unsigned-unit:8,V3@Buf1/bitstring>> = Bytes2,
{V3@V0,V3@Buf1}
end,

%% attribute number 3 with type INTEGER
{Term3,Bytes4} = begin
<<V4@V0:1/unsigned-unit:8,V4@Buf1/bitstring>> = Bytes3,
{V4@V0,V4@Buf1}
end,

%% attribute number 4 with type INTEGER
{Term4,Bytes5} = begin
<<V5@V0:2/unsigned-unit:8,V5@Buf1/bitstring>> = Bytes4,
{V5@V0,V5@Buf1}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V6@V0,V6@Buf1} = case Bytes5 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:7,0:1,V6@V7:7,V6@Buf8/bitstring>> when V6@V7 =/= 0 ->
{V6@V7,V6@Buf8};
<<_:7,1:1,0:1,V6@V8:14,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V10:V6@V0/bitstring-unit:1,V6@Buf11/bitstring>> = V6@Buf1,
{V6@V10,V6@Buf11}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
{{'H221NonStandard',Term1,Term2,Term3,Term4},Bytes7}.

'enc_NonStandardIdentifier'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= object ->
begin
Enc2@bin = encode_oid(ChoiceVal),
Enc2@len = byte_size(Enc2@bin),
if Enc2@len < 128 ->
[<<0:1,0:2>>,
align,
Enc2@len|Enc2@bin];
Enc2@len < 16384 ->
[<<0:1,0:2>>,
align,
<<2:2,Enc2@len:14>>|Enc2@bin];
true ->
[<<0:1,0:2>>,
align|encode_fragmented(Enc2@bin, 8)]
end
end;
ChoiceTag =:= h221NonStandard ->
[<<0:1,1:2>>|enc_H221NonStandard(ChoiceVal)];
ChoiceTag =:= experimental ->
begin
Enc5@bin = list_to_binary(ChoiceVal),
Enc5@len = byte_size(Enc5@bin),
if Enc5@len =:= 8 ->
[<<0:1,2:2>>,
align|Enc5@bin]
end
end
end.


dec_NonStandardIdentifier(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@Buf6/bitstring>> ->
{V2@V5,V2@Buf6};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@Buf7/bitstring>> ->
{V2@V6,V2@Buf7}
end,
<<V2@V8:V2@V0/binary-unit:8,V2@Buf9/bitstring>> = V2@Buf1,
V2@Conv10 = binary_to_list(V2@V8),
{V2@V11,V2@Buf12}  = {decode_oid(V2@Conv10),V2@Buf9},
{V2@V11,V2@Buf12}
end
end,
{{object,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_H221NonStandard(Bytes2)
end,
{{h221NonStandard,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:8/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv4 = binary_to_list(V3@V0),
{V3@Conv4,V3@Buf1}
end
end,
{{experimental,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10}
end,
<<V1@V11:V1@V3/unit:8,V1@Buf12/bitstring>> = V1@Buf4,
{V1@V11,V1@Buf12}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
'enc_NonStandardData'(Val) ->
[begin
Enc1@input = element(2, Val),
enc_NonStandardIdentifier(Enc1@input)
end,
align|begin
Enc2@input = element(3, Val),
Enc3@bin = iolist_to_binary(Enc2@input),
Enc3@len = byte_size(Enc3@bin),
if Enc3@len < 128 ->
[Enc3@len|Enc3@bin];
Enc3@len < 16384 ->
[<<2:2,Enc3@len:14>>|Enc3@bin];
true ->
encode_fragmented(Enc3@bin, 8)
end
end].


dec_NonStandardData(Bytes) ->

%% attribute number 1 with type NonStandardIdentifier
{Term1,Bytes1} = dec_NonStandardIdentifier(Bytes),

%% attribute number 2 with type OCTET STRING
{Term2,Bytes2} = begin
V1@Pad3 = bit_size(Bytes1) band 7,
{V1@V0,V1@Buf1} = case Bytes1 of
<<_:V1@Pad3,0:1,V1@V5:7,V1@V7:V1@V5/binary-unit:8,V1@Buf8/bitstring>> ->
{V1@V7,V1@Buf8};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@V8:V1@V6/binary-unit:8,V1@Buf9/bitstring>> ->
{V1@V8,V1@Buf9};
<<_:V1@Pad3,1:1,1:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V8,V1@Buf9}  = decode_fragmented(V1@V6, V1@Buf7, 8),
{V1@V8,V1@Buf9}
end,
V1@Conv10 = binary_to_list(V1@V0),
{V1@Conv10,V1@Buf1}
end,
{{'NonStandardData',Term1,Term2},Bytes2}.

'enc_StatisticsParameter'(Val) ->
[begin
Enc1@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
align,
begin
Enc2@input = element(2, Val),
Enc3@bin = iolist_to_binary(Enc2@input),
Enc3@len = byte_size(Enc3@bin),
if Enc3@len =:= 4 ->
Enc3@bin
end
end|begin
Enc4@input = element(3, Val),
if Enc4@input =:= asn1_NOVALUE ->
[];
true ->
enc_Value(Enc4@input)
end
end].


dec_StatisticsParameter(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes2} = begin
V2@Pad2 = bit_size(Bytes1) band 7,
<<_:V2@Pad2,V2@V0:4/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv4 = binary_to_list(V2@V0),
{V2@Conv4,V2@Buf1}
end,

%% attribute number 2 with type Value
{Term2,Bytes3} = case Opt band 1 of
1 ->
dec_Value(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,
{{'StatisticsParameter',Term1,Term2},Bytes3}.

'enc_StatisticsDescriptor'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_StatisticsParameter(Comp) || Comp <- Val]].



dec_StatisticsDescriptor(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components2(V1@V0, V1@Buf1, []).

'enc_PackagesItem'(Val) ->
[begin
Enc2@input = element(2, Val),
Enc3@bin = iolist_to_binary(Enc2@input),
Enc3@len = byte_size(Enc3@bin),
if Enc3@len =:= 2 ->
[<<0:1>>|Enc3@bin]
end
end|begin
Enc4@input = element(3, Val),
if 0 =< Enc4@input, Enc4@input < 100 ->
<<Enc4@input:7>>;
true ->
exit({error,{asn1,{illegal_value,Enc4@input}}})
end
end].


dec_PackagesItem(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes2} = begin
<<V2@V0:2/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv2 = binary_to_list(V2@V0),
{V2@Conv2,V2@Buf1}
end,

%% attribute number 2 with type INTEGER
{Term2,Bytes3} = begin
<<V3@V0:7/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
{V3@V0,V3@Buf1}
end,

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V4@V0,V4@Buf1} = case Bytes3 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V11:V4@V0/bitstring-unit:1,V4@Buf12/bitstring>> = V4@Buf1,
{V4@V11,V4@Buf12}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
{{'PackagesItem',Term1,Term2},Bytes5}.

'enc_PackagesDescriptor'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_PackagesItem(Comp) || Comp <- Val]].



dec_PackagesDescriptor(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components3(V1@V0, V1@Buf1, []).

'enc_ServiceChangeProfile'(Val) ->
Enc1@input = element(2, Val),
Enc2@bin = list_to_binary(Enc1@input),
Enc2@len = byte_size(Enc2@bin),
Enc2@len@sub = Enc2@len - 1,
if 0 =< Enc2@len@sub, Enc2@len@sub < 67 ->
[<<Enc2@len@sub:7>>,
align|Enc2@bin]
end.


dec_ServiceChangeProfile(Bytes) ->

%% attribute number 1 with type IA5String
{Term1,Bytes1} = begin
<<V1@V0:7/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Add2 = V1@V0 + 1,
V1@Pad5 = bit_size(V1@Buf1) band 7,
<<_:V1@Pad5,V1@V3:V1@Add2/binary-unit:8,V1@Buf4/bitstring>> = V1@Buf1,
V1@Conv7 = binary_to_list(V1@V3),
{V1@Conv7,V1@Buf4}
end,
{{'ServiceChangeProfile',Term1},Bytes1}.

'enc_ServiceChangeMethod'(Val) ->
if Val =:= failover ->
<<0:1,0:3>>;
Val =:= forced ->
<<0:1,1:3>>;
Val =:= graceful ->
<<0:1,2:3>>;
Val =:= restart ->
<<0:1,3:3>>;
Val =:= disconnected ->
<<0:1,4:3>>;
Val =:= handOff ->
<<0:1,5:3>>;
true ->
exit({error,{asn1,{illegal_value,Val}}})
end.


dec_ServiceChangeMethod(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:3/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> failover;
1 -> forced;
2 -> graceful;
3 -> restart;
4 -> disconnected;
5 -> handOff;
_ -> exit({error,{asn1,{decode_enumerated,{V1@V3,[failover,forced,graceful,restart,disconnected,handOff]}}}})
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13}
end,
<<V1@V14:V1@V6/unit:8,V1@Buf15/bitstring>> = V1@Buf7,
{V1@V14,V1@Buf15}
end,
V1@Int16 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int16,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

'enc_ServiceChangeResParm'(Val) ->
[begin
Enc1@input = element(2, Val),
Enc2@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@input = element(4, Val),
Enc4@input = element(5, Val),
if Enc3@input =:= asn1_NOVALUE ->
if Enc4@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc4@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc5@input = element(6, Val),
if Enc5@input =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
begin
Enc7@input = element(2, Val),
if Enc7@input =:= asn1_NOVALUE ->
[];
true ->
enc_MId(Enc7@input)
end
end,
begin
Enc9@input = element(3, Val),
if Enc9@input =:= asn1_NOVALUE ->
[];
true ->
enc_ServiceChangeAddress(Enc9@input)
end
end,
begin
Enc11@input = element(4, Val),
if Enc11@input =:= asn1_NOVALUE ->
[];
0 =< Enc11@input, Enc11@input < 100 ->
<<Enc11@input:7>>;
true ->
exit({error,{asn1,{illegal_value,Enc11@input}}})
end
end,
begin
Enc14@input = element(5, Val),
if Enc14@input =:= asn1_NOVALUE ->
[];
true ->
enc_ServiceChangeProfile(Enc14@input)
end
end|begin
Enc16@input = element(6, Val),
if Enc16@input =:= asn1_NOVALUE ->
[];
true ->
enc_TimeNotation(Enc16@input)
end
end].


dec_ServiceChangeResParm(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:5,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type MId
{Term1,Bytes3} = case (Opt bsr 4) band 1 of
1 ->
dec_MId(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 2 with type ServiceChangeAddress
{Term2,Bytes4} = case (Opt bsr 3) band 1 of
1 ->
dec_ServiceChangeAddress(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type INTEGER
{Term3,Bytes5} = case (Opt bsr 2) band 1 of
1 ->
begin
<<V3@V0:7/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes4,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute number 4 with type ServiceChangeProfile
{Term4,Bytes6} = case (Opt bsr 1) band 1 of
1 ->
dec_ServiceChangeProfile(Bytes5);
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% attribute number 5 with type TimeNotation
{Term5,Bytes7} = case Opt band 1 of
1 ->
dec_TimeNotation(Bytes6);
0 ->
{asn1_NOVALUE,Bytes6}
end,

%% Extensions
{Extensions,Bytes8} = case Ext of
0 -> {<<>>,Bytes7};
1 ->
{V4@V0,V4@Buf1} = case Bytes7 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V11:V4@V0/bitstring-unit:1,V4@Buf12/bitstring>> = V4@Buf1,
{V4@V11,V4@Buf12}
end,
Bytes9= skipextensions(Bytes8, 1, Extensions),
{{'ServiceChangeResParm',Term1,Term2,Term3,Term4,Term5},Bytes9}.

'enc_ServiceChangeAddress'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= portNumber ->
if ChoiceVal bsr 16 =:= 0 ->
[<<0:1,0:3>>,
align|<<ChoiceVal:16>>];
true ->
exit({error,{asn1,{illegal_value,ChoiceVal}}})
end;
ChoiceTag =:= ip4Address ->
[<<0:1,1:3>>|enc_IP4Address(ChoiceVal)];
ChoiceTag =:= ip6Address ->
[<<0:1,2:3>>|enc_IP6Address(ChoiceVal)];
ChoiceTag =:= domainName ->
[<<0:1,3:3>>|enc_DomainName(ChoiceVal)];
ChoiceTag =:= deviceName ->
begin
Enc7@bin = list_to_binary(ChoiceVal),
Enc7@len = byte_size(Enc7@bin),
Enc7@len@sub = Enc7@len - 1,
if Enc7@len@sub bsr 6 =:= 0 ->
[<<0:1,4:3,Enc7@len@sub:6>>,
align|Enc7@bin]
end
end;
ChoiceTag =:= mtpAddress ->
begin
Enc9@bin = iolist_to_binary(ChoiceVal),
Enc9@len = byte_size(Enc9@bin),
Enc9@len@sub = Enc9@len - 2,
if 0 =< Enc9@len@sub, Enc9@len@sub < 3 ->
[<<0:1,5:3,Enc9@len@sub:2>>,
align|Enc9@bin]
end
end
end.


dec_ServiceChangeAddress(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:3/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
begin
V2@Pad2 = bit_size(Bytes2) band 7,
<<_:V2@Pad2,V2@V0:2/unsigned-unit:8,V2@Buf1/bitstring>> = Bytes2,
{V2@V0,V2@Buf1}
end
end,
{{portNumber,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_IP4Address(Bytes2)
end,
{{ip4Address,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_IP6Address(Bytes2)
end,
{{ip6Address,Val},NewBytes};
3 ->
{Val,NewBytes} = begin
dec_DomainName(Bytes2)
end,
{{domainName,Val},NewBytes};
4 ->
{Val,NewBytes} = begin
begin
<<V3@V0:6/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
V3@Add2 = V3@V0 + 1,
V3@Pad5 = bit_size(V3@Buf1) band 7,
<<_:V3@Pad5,V3@V3:V3@Add2/binary-unit:8,V3@Buf4/bitstring>> = V3@Buf1,
V3@Conv7 = binary_to_list(V3@V3),
{V3@Conv7,V3@Buf4}
end
end,
{{deviceName,Val},NewBytes};
5 ->
{Val,NewBytes} = begin
begin
<<V4@V0:2/unsigned-unit:1,V4@Buf1/bitstring>> = Bytes2,
V4@Add2 = V4@V0 + 2,
V4@Pad5 = bit_size(V4@Buf1) band 7,
<<_:V4@Pad5,V4@V3:V4@Add2/binary-unit:8,V4@Buf4/bitstring>> = V4@Buf1,
V4@Conv7 = binary_to_list(V4@V3),
{V4@Conv7,V4@Buf4}
end
end,
{{mtpAddress,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10}
end,
<<V1@V11:V1@V3/unit:8,V1@Buf12/bitstring>> = V1@Buf4,
{V1@V11,V1@Buf12}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
'enc_ServiceChangeParm'(Val) ->
Enc8@bitmap = extension_bitmap(Val, 11, 13),
Extensions = if Enc8@bitmap =:= 0 ->
[];
true ->
<<1:7,Enc8@bitmap:2>>
end,
[begin
Enc1@input = element(3, Val),
if Extensions =:= [] ->
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc1@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc2@input = element(4, Val),
Enc3@input = element(5, Val),
if Enc2@input =:= asn1_NOVALUE ->
if Enc3@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc3@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc4@input = element(7, Val),
Enc5@input = element(8, Val),
if Enc4@input =:= asn1_NOVALUE ->
if Enc5@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc5@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc6@input = element(9, Val),
Enc7@input = element(10, Val),
if Enc6@input =:= asn1_NOVALUE ->
if Enc7@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc7@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc10@input = element(2, Val),
if Enc10@input =:= failover ->
<<0:1,0:3>>;
Enc10@input =:= forced ->
<<0:1,1:3>>;
Enc10@input =:= graceful ->
<<0:1,2:3>>;
Enc10@input =:= restart ->
<<0:1,3:3>>;
Enc10@input =:= disconnected ->
<<0:1,4:3>>;
Enc10@input =:= handOff ->
<<0:1,5:3>>;
true ->
exit({error,{asn1,{illegal_value,Enc10@input}}})
end
end,
begin
Enc12@input = element(3, Val),
if Enc12@input =:= asn1_NOVALUE ->
[];
true ->
enc_ServiceChangeAddress(Enc12@input)
end
end,
begin
Enc14@input = element(4, Val),
if Enc14@input =:= asn1_NOVALUE ->
[];
0 =< Enc14@input, Enc14@input < 100 ->
<<Enc14@input:7>>;
true ->
exit({error,{asn1,{illegal_value,Enc14@input}}})
end
end,
begin
Enc17@input = element(5, Val),
if Enc17@input =:= asn1_NOVALUE ->
[];
true ->
enc_ServiceChangeProfile(Enc17@input)
end
end,
begin
Enc19@input = element(6, Val),
enc_Value(Enc19@input)
end,
begin
Enc20@input = element(7, Val),
if Enc20@input =:= asn1_NOVALUE ->
[];
Enc20@input bsr 32 =:= 0 ->
begin
Enc20@input@bin = binary:encode_unsigned(Enc20@input),
Enc20@input@bin_size0 = byte_size(Enc20@input@bin),
Enc20@input@bin_size = Enc20@input@bin_size0 - 1,
[<<Enc20@input@bin_size:2>>,
align|Enc20@input@bin]
end;
true ->
exit({error,{asn1,{illegal_value,Enc20@input}}})
end
end,
begin
Enc23@input = element(8, Val),
if Enc23@input =:= asn1_NOVALUE ->
[];
true ->
enc_MId(Enc23@input)
end
end,
begin
Enc25@input = element(9, Val),
if Enc25@input =:= asn1_NOVALUE ->
[];
true ->
enc_TimeNotation(Enc25@input)
end
end,
begin
Enc27@input = element(10, Val),
if Enc27@input =:= asn1_NOVALUE ->
[];
true ->
enc_NonStandardData(Enc27@input)
end
end,
Extensions,
begin
Enc29@input = element(11, Val),
if Enc29@input =:= asn1_NOVALUE ->
[];
true ->
begin
Enc30@output = enc_AuditDescriptor(Enc29@input),
Enc31@bin = complete(Enc30@output),
Enc31@len = byte_size(Enc31@bin),
if Enc31@len < 128 ->
[align,
Enc31@len|Enc31@bin];
Enc31@len < 16384 ->
[align,
<<2:2,Enc31@len:14>>|Enc31@bin];
true ->
[align|encode_fragmented(Enc31@bin, 8)]
end
end
end
end|begin
Enc33@input = element(12, Val),
if Enc33@input =:= asn1_NOVALUE ->
[];
true ->
[align,
1,
0]
end
end].


dec_ServiceChangeParm(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:7,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type ENUMERATED
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:3/unsigned-unit:1,V3@Buf4/bitstring>> ->
V3@Int5 = case V3@V3 of
0 -> failover;
1 -> forced;
2 -> graceful;
3 -> restart;
4 -> disconnected;
5 -> handOff;
_ -> exit({error,{asn1,{decode_enumerated,{V3@V3,[failover,forced,graceful,restart,disconnected,handOff]}}}})
end,
{V3@Int5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<0:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V6,V3@Buf7};
<<1:1,V3@Buf5/bitstring>> ->
V3@Pad9 = bit_size(V3@Buf5) band 7,
{V3@V6,V3@Buf7} = case V3@Buf5 of
<<_:V3@Pad9,0:1,V3@V11:7,V3@Buf12/bitstring>> when V3@V11 =/= 0 ->
{V3@V11,V3@Buf12};
<<_:V3@Pad9,1:1,0:1,V3@V12:14,V3@Buf13/bitstring>> when V3@V12 =/= 0 ->
{V3@V12,V3@Buf13}
end,
<<V3@V14:V3@V6/unit:8,V3@Buf15/bitstring>> = V3@Buf7,
{V3@V14,V3@Buf15}
end,
V3@Int16 = case V3@V3 of
_ -> {asn1_enum,V3@V3}
end,
{V3@Int16,V3@Buf4}
end,
{V3@V0,V3@Buf1}
end,

%% attribute number 2 with type ServiceChangeAddress
{Term2,Bytes4} = case (Opt bsr 6) band 1 of
1 ->
dec_ServiceChangeAddress(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type INTEGER
{Term3,Bytes5} = case (Opt bsr 5) band 1 of
1 ->
begin
<<V4@V0:7/unsigned-unit:1,V4@Buf1/bitstring>> = Bytes4,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute number 4 with type ServiceChangeProfile
{Term4,Bytes6} = case (Opt bsr 4) band 1 of
1 ->
dec_ServiceChangeProfile(Bytes5);
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% attribute number 5 with type Value
{Term5,Bytes7} = dec_Value(Bytes6),

%% attribute number 6 with type INTEGER
{Term6,Bytes8} = case (Opt bsr 3) band 1 of
1 ->
begin
<<V5@V0:2/unsigned-unit:1,V5@Buf1/bitstring>> = Bytes7,
V5@Add2 = V5@V0 + 1,
V5@Pad5 = bit_size(V5@Buf1) band 7,
<<_:V5@Pad5,V5@V3:V5@Add2/unsigned-unit:8,V5@Buf4/bitstring>> = V5@Buf1,
{V5@V3,V5@Buf4}
end;
0 ->
{asn1_NOVALUE,Bytes7}
end,

%% attribute number 7 with type MId
{Term7,Bytes9} = case (Opt bsr 2) band 1 of
1 ->
dec_MId(Bytes8);
0 ->
{asn1_NOVALUE,Bytes8}
end,

%% attribute number 8 with type TimeNotation
{Term8,Bytes10} = case (Opt bsr 1) band 1 of
1 ->
dec_TimeNotation(Bytes9);
0 ->
{asn1_NOVALUE,Bytes9}
end,

%% attribute number 9 with type NonStandardData
{Term9,Bytes11} = case Opt band 1 of
1 ->
dec_NonStandardData(Bytes10);
0 ->
{asn1_NOVALUE,Bytes10}
end,

%% Extensions
{Extensions,Bytes12} = case Ext of
0 -> {<<>>,Bytes11};
1 ->
{V6@V0,V6@Buf1} = case Bytes11 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
{V6@V9,V6@Buf10}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V11:V6@V0/bitstring-unit:1,V6@Buf12/bitstring>> = V6@Buf1,
{V6@V11,V6@Buf12}
end,

%% attribute number 10 with type AuditDescriptor
{Term10,Bytes13} = case Extensions of
  <<_:0,1:1,_/bitstring>> ->
begin
V7@Pad3 = bit_size(Bytes12) band 7,
{V7@V0,V7@Buf1} = case Bytes12 of
<<_:V7@Pad3,0:1,V7@V5:7,V7@V7:V7@V5/binary-unit:8,V7@Buf8/bitstring>> ->
{V7@V7,V7@Buf8};
<<_:V7@Pad3,1:1,0:1,V7@V6:14,V7@V8:V7@V6/binary-unit:8,V7@Buf9/bitstring>> ->
{V7@V8,V7@Buf9};
<<_:V7@Pad3,1:1,1:1,V7@V6:6,V7@Buf7/bitstring>> ->
{V7@V8,V7@Buf9}  = decode_fragmented(V7@V6, V7@Buf7, 8),
{V7@V8,V7@Buf9}
end,
{TmpValx10,_} = dec_AuditDescriptor(V7@V0),
{TmpValx10,V7@Buf1}
end;
_  ->
{asn1_NOVALUE,Bytes12}
end,

%% attribute number 11 with type NULL
{Term11,Bytes14} = case Extensions of
  <<_:1,1:1,_/bitstring>> ->
begin
V8@Pad3 = bit_size(Bytes13) band 7,
{V8@V0,V8@Buf1} = case Bytes13 of
<<_:V8@Pad3,0:1,V8@V5:7,V8@V7:V8@V5/binary-unit:8,V8@Buf8/bitstring>> ->
{V8@V7,V8@Buf8};
<<_:V8@Pad3,1:1,0:1,V8@V6:14,V8@V8:V8@V6/binary-unit:8,V8@Buf9/bitstring>> ->
{V8@V8,V8@Buf9};
<<_:V8@Pad3,1:1,1:1,V8@V6:6,V8@Buf7/bitstring>> ->
{V8@V8,V8@Buf9}  = decode_fragmented(V8@V6, V8@Buf7, 8),
{V8@V8,V8@Buf9}
end,
{TmpValx11,_} = begin
ignore,
{'NULL',V8@V0}
end,
{TmpValx11,V8@Buf1}
end;
_  ->
{asn1_NOVALUE,Bytes13}
end,
Bytes15= skipextensions(Bytes14, 3, Extensions),
{{'ServiceChangeParm',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9,Term10,Term11},Bytes15}.

'enc_DigitMapValue'(Val) ->
Enc4@bitmap = extension_bitmap(Val, 6, 7),
Extensions = if Enc4@bitmap =:= 0 ->
[];
true ->
<<0:7,1:1>>
end,
[begin
Enc1@input = element(2, Val),
if Extensions =:= [] ->
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc1@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc2@input = element(3, Val),
Enc3@input = element(4, Val),
if Enc2@input =:= asn1_NOVALUE ->
if Enc3@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc3@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc6@input = element(2, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
0 =< Enc6@input, Enc6@input < 100 ->
<<Enc6@input:7>>;
true ->
exit({error,{asn1,{illegal_value,Enc6@input}}})
end
end,
begin
Enc9@input = element(3, Val),
if Enc9@input =:= asn1_NOVALUE ->
[];
0 =< Enc9@input, Enc9@input < 100 ->
<<Enc9@input:7>>;
true ->
exit({error,{asn1,{illegal_value,Enc9@input}}})
end
end,
begin
Enc12@input = element(4, Val),
if Enc12@input =:= asn1_NOVALUE ->
[];
0 =< Enc12@input, Enc12@input < 100 ->
<<Enc12@input:7>>;
true ->
exit({error,{asn1,{illegal_value,Enc12@input}}})
end
end,
align,
begin
Enc15@input = element(5, Val),
Enc16@bin = list_to_binary(Enc15@input),
Enc16@len = byte_size(Enc16@bin),
if Enc16@len < 128 ->
[Enc16@len|Enc16@bin];
Enc16@len < 16384 ->
[<<2:2,Enc16@len:14>>|Enc16@bin];
true ->
encode_fragmented(Enc16@bin, 8)
end
end,
Extensions|begin
Enc17@input = element(6, Val),
if Enc17@input =:= asn1_NOVALUE ->
[];
0 =< Enc17@input, Enc17@input < 100 ->
[align|<<1:8,Enc17@input:7,0:1>>];
true ->
exit({error,{asn1,{illegal_value,Enc17@input}}})
end
end].


dec_DigitMapValue(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:3,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type INTEGER
{Term1,Bytes3} = case (Opt bsr 2) band 1 of
1 ->
begin
<<V3@V0:7/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 2 with type INTEGER
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
<<V4@V0:7/unsigned-unit:1,V4@Buf1/bitstring>> = Bytes3,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type INTEGER
{Term3,Bytes5} = case Opt band 1 of
1 ->
begin
<<V5@V0:7/unsigned-unit:1,V5@Buf1/bitstring>> = Bytes4,
{V5@V0,V5@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute number 4 with type IA5String
{Term4,Bytes6} = begin
V6@Pad3 = bit_size(Bytes5) band 7,
{V6@V0,V6@Buf1} = case Bytes5 of
<<_:V6@Pad3,0:1,V6@V5:7,V6@V7:V6@V5/binary-unit:8,V6@Buf8/bitstring>> ->
{V6@V7,V6@Buf8};
<<_:V6@Pad3,1:1,0:1,V6@V6:14,V6@V8:V6@V6/binary-unit:8,V6@Buf9/bitstring>> ->
{V6@V8,V6@Buf9};
<<_:V6@Pad3,1:1,1:1,V6@V6:6,V6@Buf7/bitstring>> ->
{V6@V8,V6@Buf9}  = decode_fragmented(V6@V6, V6@Buf7, 8),
{V6@V8,V6@Buf9}
end,
V6@Conv10 = binary_to_list(V6@V0),
{V6@Conv10,V6@Buf1}
end,

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V7@V0,V7@Buf1} = case Bytes6 of
<<0:1,V7@V3:6,V7@Buf4/bitstring>> ->
V7@Add5 = V7@V3 + 1,
{V7@Add5,V7@Buf4};
<<1:1,V7@Buf2/bitstring>> ->
{V7@V3,V7@Buf4} = case V7@Buf2 of
<<_:7,0:1,V7@V7:7,V7@Buf8/bitstring>> when V7@V7 =/= 0 ->
{V7@V7,V7@Buf8};
<<_:7,1:1,0:1,V7@V8:14,V7@Buf9/bitstring>> when V7@V8 =/= 0 ->
{V7@V8,V7@Buf9}
end,
{V7@V3,V7@Buf4}
end,
<<V7@V10:V7@V0/bitstring-unit:1,V7@Buf11/bitstring>> = V7@Buf1,
{V7@V10,V7@Buf11}
end,

%% attribute number 5 with type INTEGER
{Term5,Bytes8} = case Extensions of
  <<_:0,1:1,_/bitstring>> ->
begin
V8@Pad3 = bit_size(Bytes7) band 7,
{V8@V0,V8@Buf1} = case Bytes7 of
<<_:V8@Pad3,0:1,V8@V5:7,V8@V7:V8@V5/binary-unit:8,V8@Buf8/bitstring>> ->
{V8@V7,V8@Buf8};
<<_:V8@Pad3,1:1,0:1,V8@V6:14,V8@V8:V8@V6/binary-unit:8,V8@Buf9/bitstring>> ->
{V8@V8,V8@Buf9};
<<_:V8@Pad3,1:1,1:1,V8@V6:6,V8@Buf7/bitstring>> ->
{V8@V8,V8@Buf9}  = decode_fragmented(V8@V6, V8@Buf7, 8),
{V8@V8,V8@Buf9}
end,
{TmpValx5,_} = begin
<<V9@V0:7/unsigned-unit:1,V9@Buf1/bitstring>> = V8@V0,
{V9@V0,V9@Buf1}
end,
{TmpValx5,V8@Buf1}
end;
_  ->
{asn1_NOVALUE,Bytes7}
end,
Bytes9= skipextensions(Bytes8, 2, Extensions),
{{'DigitMapValue',Term1,Term2,Term3,Term4,Term5},Bytes9}.

'enc_DigitMapName'(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 2 ->
Enc1@bin
end.


dec_DigitMapName(Bytes) ->
begin
<<V1@V0:2/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv2 = binary_to_list(V1@V0),
{V1@Conv2,V1@Buf1}
end.

'enc_DigitMapDescriptor'(Val) ->
[begin
Enc1@input = element(2, Val),
Enc2@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc3@input = element(2, Val),
if Enc3@input =:= asn1_NOVALUE ->
[];
true ->
begin
Enc4@bin = iolist_to_binary(Enc3@input),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len =:= 2 ->
Enc4@bin
end
end
end
end|begin
Enc6@input = element(3, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
true ->
enc_DigitMapValue(Enc6@input)
end
end].


dec_DigitMapDescriptor(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:2,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes2} = case (Opt bsr 1) band 1 of
1 ->
begin
<<V2@V0:2/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv2 = binary_to_list(V2@V0),
{V2@Conv2,V2@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes1}
end,

%% attribute number 2 with type DigitMapValue
{Term2,Bytes3} = case Opt band 1 of
1 ->
dec_DigitMapValue(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,
{{'DigitMapDescriptor',Term1,Term2},Bytes3}.

'enc_ModemType'(Val) ->
if Val =:= v18 ->
<<0:1,0:4>>;
Val =:= v22 ->
<<0:1,1:4>>;
Val =:= v22bis ->
<<0:1,2:4>>;
Val =:= v32 ->
<<0:1,3:4>>;
Val =:= v32bis ->
<<0:1,4:4>>;
Val =:= v34 ->
<<0:1,5:4>>;
Val =:= v90 ->
<<0:1,6:4>>;
Val =:= v91 ->
<<0:1,7:4>>;
Val =:= synchISDN ->
<<0:1,8:4>>;
true ->
exit({error,{asn1,{illegal_value,Val}}})
end.


dec_ModemType(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:4/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> v18;
1 -> v22;
2 -> v22bis;
3 -> v32;
4 -> v32bis;
5 -> v34;
6 -> v90;
7 -> v91;
8 -> synchISDN;
_ -> exit({error,{asn1,{decode_enumerated,{V1@V3,[v18,v22,v22bis,v32,v32bis,v34,v90,v91,synchISDN]}}}})
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13}
end,
<<V1@V14:V1@V6/unit:8,V1@Buf15/bitstring>> = V1@Buf7,
{V1@V14,V1@Buf15}
end,
V1@Int16 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int16,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

'enc_ModemDescriptor'(Val) ->
[begin
Enc1@input = element(4, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
begin
Enc2@input = element(2, Val),
enc_ModemDescriptor_mtl(Enc2@input)
end,
begin
Enc3@input = element(3, Val),
enc_ModemDescriptor_mpl(Enc3@input)
end|begin
Enc4@input = element(4, Val),
if Enc4@input =:= asn1_NOVALUE ->
[];
true ->
enc_NonStandardData(Enc4@input)
end
end].
'enc_ModemDescriptor_mtl'(Val) ->
Enc2@len = length(Val),
[if Enc2@len < 128 ->
[align,
Enc2@len];
Enc2@len < 16384 ->
[align|<<2:2,Enc2@len:14>>]
end|[if Comp =:= v18 ->
<<0:1,0:4>>;
Comp =:= v22 ->
<<0:1,1:4>>;
Comp =:= v22bis ->
<<0:1,2:4>>;
Comp =:= v32 ->
<<0:1,3:4>>;
Comp =:= v32bis ->
<<0:1,4:4>>;
Comp =:= v34 ->
<<0:1,5:4>>;
Comp =:= v90 ->
<<0:1,6:4>>;
Comp =:= v91 ->
<<0:1,7:4>>;
Comp =:= synchISDN ->
<<0:1,8:4>>;
true ->
exit({error,{asn1,{illegal_value,Comp}}})
end || Comp <- Val]].


dec_ModemDescriptor_mtl(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components4(V1@V0, V1@Buf1, []).

'enc_ModemDescriptor_mpl'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_PropertyParm(Comp) || Comp <- Val]].


dec_ModemDescriptor_mpl(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components5(V1@V0, V1@Buf1, []).



dec_ModemDescriptor(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type SEQUENCE OF
{Term1,Bytes2} = 'dec_ModemDescriptor_mtl'(Bytes1),

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes3} = 'dec_ModemDescriptor_mpl'(Bytes2),

%% attribute number 3 with type NonStandardData
{Term3,Bytes4} = case Opt band 1 of
1 ->
dec_NonStandardData(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,
{{'ModemDescriptor',Term1,Term2,Term3},Bytes4}.

'enc_RequestID'(Val) ->
if Val bsr 32 =:= 0 ->
begin
Val@bin = binary:encode_unsigned(Val),
Val@bin_size0 = byte_size(Val@bin),
Val@bin_size = Val@bin_size0 - 1,
[<<Val@bin_size:2>>,
align|Val@bin]
end;
true ->
exit({error,{asn1,{illegal_value,Val}}})
end.


dec_RequestID(Bytes) ->
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Add2 = V1@V0 + 1,
V1@Pad5 = bit_size(V1@Buf1) band 7,
<<_:V1@Pad5,V1@V3:V1@Add2/unsigned-unit:8,V1@Buf4/bitstring>> = V1@Buf1,
{V1@V3,V1@Buf4}
end.

'enc_SigParameter'(Val) ->
[begin
Enc1@input = element(4, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
Enc3@input = element(2, Val),
Enc4@bin = iolist_to_binary(Enc3@input),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len =:= 2 ->
Enc4@bin
end
end,
begin
Enc5@input = element(3, Val),
enc_Value(Enc5@input)
end|begin
Enc6@input = element(4, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
true ->
enc_SigParameter_extraInfo(Enc6@input)
end
end].
'enc_SigParameter_extraInfo'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= relation ->
if ChoiceVal =:= greaterThan ->
<<0:2,0:1,0:2>>;
ChoiceVal =:= smallerThan ->
<<0:2,0:1,1:2>>;
ChoiceVal =:= unequalTo ->
<<0:2,0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_value,ChoiceVal}}})
end;
ChoiceTag =:= range ->
if ChoiceVal =:= false ->
<<1:2,0:1>>;
ChoiceVal =:= true ->
<<1:2,1:1>>
end;
ChoiceTag =:= sublist ->
if ChoiceVal =:= false ->
<<2:2,0:1>>;
ChoiceVal =:= true ->
<<2:2,1:1>>
end
end.

dec_SigParameter_extraInfo(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
begin
{V2@V0,V2@Buf1} = case Bytes1 of
<<0:1,V2@V3:2/unsigned-unit:1,V2@Buf4/bitstring>> ->
V2@Int5 = case V2@V3 of
0 -> greaterThan;
1 -> smallerThan;
2 -> unequalTo;
_ -> exit({error,{asn1,{decode_enumerated,{V2@V3,[greaterThan,smallerThan,unequalTo]}}}})
end,
{V2@Int5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<0:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V6,V2@Buf7};
<<1:1,V2@Buf5/bitstring>> ->
V2@Pad9 = bit_size(V2@Buf5) band 7,
{V2@V6,V2@Buf7} = case V2@Buf5 of
<<_:V2@Pad9,0:1,V2@V11:7,V2@Buf12/bitstring>> when V2@V11 =/= 0 ->
{V2@V11,V2@Buf12};
<<_:V2@Pad9,1:1,0:1,V2@V12:14,V2@Buf13/bitstring>> when V2@V12 =/= 0 ->
{V2@V12,V2@Buf13}
end,
<<V2@V14:V2@V6/unit:8,V2@Buf15/bitstring>> = V2@Buf7,
{V2@V14,V2@Buf15}
end,
V2@Int16 = case V2@V3 of
_ -> {asn1_enum,V2@V3}
end,
{V2@Int16,V2@Buf4}
end,
{V2@V0,V2@Buf1}
end
end,
{{relation,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
begin
<<V3@V0:1,V3@Buf1/bitstring>> = Bytes1,
V3@Int2 = case V3@V0 of
0 -> false;
1 -> true
end,
{V3@Int2,V3@Buf1}
end
end,
{{range,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
begin
<<V4@V0:1,V4@Buf1/bitstring>> = Bytes1,
V4@Int2 = case V4@V0 of
0 -> false;
1 -> true
end,
{V4@Int2,V4@Buf1}
end
end,
{{sublist,Val},NewBytes}
end.


dec_SigParameter(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = begin
<<V3@V0:2/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv2 = binary_to_list(V3@V0),
{V3@Conv2,V3@Buf1}
end,

%% attribute number 2 with type Value
{Term2,Bytes4} = dec_Value(Bytes3),

%% attribute number 3 with type CHOICE
{Term3,Bytes5} = case Opt band 1 of
1 ->
'dec_SigParameter_extraInfo'(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V4@V0,V4@Buf1} = case Bytes5 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V11:V4@V0/bitstring-unit:1,V4@Buf12/bitstring>> = V4@Buf1,
{V4@V11,V4@Buf12}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
{{'SigParameter',Term1,Term2,Term3},Bytes7}.

'enc_NotifyCompletion'(Val) ->
Enc1@bs = try bit_string_name2pos_6(Val) of
Enc1@positions ->
bitstring_from_positions(Enc1@positions)
catch throw:invalid ->
to_named_bitstring(Val)
end,
Enc1@bits = bit_size(Enc1@bs),
if Enc1@bits < 128 ->
[align,
Enc1@bits|Enc1@bs];
Enc1@bits < 16384 ->
[align,
<<2:2,Enc1@bits:14>>|Enc1@bs];
true ->
[align|encode_fragmented(Enc1@bs, 1)]
end.


dec_NotifyCompletion(Bytes) ->
begin
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@V7:V1@V5/binary-unit:1,V1@Buf8/bitstring>> ->
{V1@V7,V1@Buf8};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@V8:V1@V6/binary-unit:1,V1@Buf9/bitstring>> ->
{V1@V8,V1@Buf9};
<<_:V1@Pad3,1:1,1:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V8,V1@Buf9}  = decode_fragmented(V1@V6, V1@Buf7, 1),
{V1@V8,V1@Buf9}
end,
{V1@V10,V1@Buf11}  = {decode_named_bit_string(V1@V0, [{onTimeOut,0},{onInterruptByEvent,1},{onInterruptByNewSignalDescr,2},{otherReason,3}]),V1@Buf1},
{V1@V10,V1@Buf11}
end.

'enc_SignalName'(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 4 ->
[align|Enc1@bin]
end.


dec_SignalName(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:4/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv4 = binary_to_list(V1@V0),
{V1@Conv4,V1@Buf1}
end.

'enc_SignalDirection'(Val) ->
if Val =:= internal ->
<<0:1,0:2>>;
Val =:= external ->
<<0:1,1:2>>;
Val =:= both ->
<<0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_value,Val}}})
end.


dec_SignalDirection(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:2/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> internal;
1 -> external;
2 -> both;
_ -> exit({error,{asn1,{decode_enumerated,{V1@V3,[internal,external,both]}}}})
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13}
end,
<<V1@V14:V1@V6/unit:8,V1@Buf15/bitstring>> = V1@Buf7,
{V1@V14,V1@Buf15}
end,
V1@Int16 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int16,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

'enc_SignalType'(Val) ->
if Val =:= brief ->
<<0:1,0:2>>;
Val =:= onOff ->
<<0:1,1:2>>;
Val =:= timeOut ->
<<0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_value,Val}}})
end.


dec_SignalType(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:2/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> brief;
1 -> onOff;
2 -> timeOut;
_ -> exit({error,{asn1,{decode_enumerated,{V1@V3,[brief,onOff,timeOut]}}}})
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13}
end,
<<V1@V14:V1@V6/unit:8,V1@Buf15/bitstring>> = V1@Buf7,
{V1@V14,V1@Buf15}
end,
V1@Int16 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int16,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

'enc_Signal'(Val) ->
Enc6@bitmap = extension_bitmap(Val, 9, 11),
Extensions = if Enc6@bitmap =:= 0 ->
[];
true ->
<<1:7,Enc6@bitmap:2>>
end,
[begin
Enc1@input = element(3, Val),
if Extensions =:= [] ->
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc1@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc2@input = element(4, Val),
Enc3@input = element(5, Val),
if Enc2@input =:= asn1_NOVALUE ->
if Enc3@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc3@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc4@input = element(6, Val),
Enc5@input = element(7, Val),
if Enc4@input =:= asn1_NOVALUE ->
if Enc5@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc5@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
align,
begin
Enc8@input = element(2, Val),
Enc9@bin = iolist_to_binary(Enc8@input),
Enc9@len = byte_size(Enc9@bin),
if Enc9@len =:= 4 ->
Enc9@bin
end
end,
begin
Enc10@input = element(3, Val),
if Enc10@input =:= asn1_NOVALUE ->
[];
Enc10@input bsr 16 =:= 0 ->
<<Enc10@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc10@input}}})
end
end,
begin
Enc13@input = element(4, Val),
if Enc13@input =:= asn1_NOVALUE ->
[];
Enc13@input =:= brief ->
<<0:1,0:2>>;
Enc13@input =:= onOff ->
<<0:1,1:2>>;
Enc13@input =:= timeOut ->
<<0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_value,Enc13@input}}})
end
end,
begin
Enc16@input = element(5, Val),
if Enc16@input =:= asn1_NOVALUE ->
[];
Enc16@input bsr 16 =:= 0 ->
[align|<<Enc16@input:16>>];
true ->
exit({error,{asn1,{illegal_value,Enc16@input}}})
end
end,
begin
Enc19@input = element(6, Val),
if Enc19@input =:= asn1_NOVALUE ->
[];
true ->
begin
Enc20@bs = try bit_string_name2pos_6(Enc19@input) of
Enc20@positions ->
bitstring_from_positions(Enc20@positions)
catch throw:invalid ->
to_named_bitstring(Enc19@input)
end,
Enc20@bits = bit_size(Enc20@bs),
if Enc20@bits < 128 ->
[align,
Enc20@bits|Enc20@bs];
Enc20@bits < 16384 ->
[align,
<<2:2,Enc20@bits:14>>|Enc20@bs];
true ->
[align|encode_fragmented(Enc20@bs, 1)]
end
end
end
end,
begin
Enc22@input = element(7, Val),
if Enc22@input =:= asn1_NOVALUE ->
[];
Enc22@input =:= false ->
<<0:1>>;
Enc22@input =:= true ->
<<1:1>>
end
end,
begin
Enc25@input = element(8, Val),
enc_Signal_sigParList(Enc25@input)
end,
Extensions,
begin
Enc26@input = element(9, Val),
if Enc26@input =:= asn1_NOVALUE ->
[];
Enc26@input =:= internal ->
[align|<<1:8,0:1,0:2,0:5>>];
Enc26@input =:= external ->
[align|<<1:8,0:1,1:2,0:5>>];
Enc26@input =:= both ->
[align|<<1:8,0:1,2:2,0:5>>];
true ->
exit({error,{asn1,{illegal_value,Enc26@input}}})
end
end|begin
Enc29@input = element(10, Val),
if Enc29@input =:= asn1_NOVALUE ->
[];
true ->
begin
Enc31@output = if Enc29@input bsr 32 =:= 0 ->
begin
Enc29@input@bin = binary:encode_unsigned(Enc29@input),
Enc29@input@bin_size0 = byte_size(Enc29@input@bin),
Enc29@input@bin_size = Enc29@input@bin_size0 - 1,
[<<Enc29@input@bin_size:2,0:6>>|Enc29@input@bin]
end;
true ->
exit({error,{asn1,{illegal_value,Enc29@input}}})
end,
Enc32@bin = complete(Enc31@output),
Enc32@len = byte_size(Enc32@bin),
if Enc32@len < 128 ->
[align,
Enc32@len|Enc32@bin];
Enc32@len < 16384 ->
[align,
<<2:2,Enc32@len:14>>|Enc32@bin];
true ->
[align|encode_fragmented(Enc32@bin, 8)]
end
end
end
end].
'enc_Signal_sigParList'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_SigParameter(Comp) || Comp <- Val]].


dec_Signal_sigParList(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components7(V1@V0, V1@Buf1, []).



dec_Signal(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:5,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:4/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv4 = binary_to_list(V3@V0),
{V3@Conv4,V3@Buf1}
end,

%% attribute number 2 with type INTEGER
{Term2,Bytes4} = case (Opt bsr 4) band 1 of
1 ->
begin
V4@Pad2 = bit_size(Bytes3) band 7,
<<_:V4@Pad2,V4@V0:2/unsigned-unit:8,V4@Buf1/bitstring>> = Bytes3,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type ENUMERATED
{Term3,Bytes5} = case (Opt bsr 3) band 1 of
1 ->
begin
{V5@V0,V5@Buf1} = case Bytes4 of
<<0:1,V5@V3:2/unsigned-unit:1,V5@Buf4/bitstring>> ->
V5@Int5 = case V5@V3 of
0 -> brief;
1 -> onOff;
2 -> timeOut;
_ -> exit({error,{asn1,{decode_enumerated,{V5@V3,[brief,onOff,timeOut]}}}})
end,
{V5@Int5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<0:1,V5@V6:6,V5@Buf7/bitstring>> ->
{V5@V6,V5@Buf7};
<<1:1,V5@Buf5/bitstring>> ->
V5@Pad9 = bit_size(V5@Buf5) band 7,
{V5@V6,V5@Buf7} = case V5@Buf5 of
<<_:V5@Pad9,0:1,V5@V11:7,V5@Buf12/bitstring>> when V5@V11 =/= 0 ->
{V5@V11,V5@Buf12};
<<_:V5@Pad9,1:1,0:1,V5@V12:14,V5@Buf13/bitstring>> when V5@V12 =/= 0 ->
{V5@V12,V5@Buf13}
end,
<<V5@V14:V5@V6/unit:8,V5@Buf15/bitstring>> = V5@Buf7,
{V5@V14,V5@Buf15}
end,
V5@Int16 = case V5@V3 of
_ -> {asn1_enum,V5@V3}
end,
{V5@Int16,V5@Buf4}
end,
{V5@V0,V5@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute number 4 with type INTEGER
{Term4,Bytes6} = case (Opt bsr 2) band 1 of
1 ->
begin
V6@Pad2 = bit_size(Bytes5) band 7,
<<_:V6@Pad2,V6@V0:2/unsigned-unit:8,V6@Buf1/bitstring>> = Bytes5,
{V6@V0,V6@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% attribute number 5 with type BIT STRING
{Term5,Bytes7} = case (Opt bsr 1) band 1 of
1 ->
begin
V7@Pad3 = bit_size(Bytes6) band 7,
{V7@V0,V7@Buf1} = case Bytes6 of
<<_:V7@Pad3,0:1,V7@V5:7,V7@V7:V7@V5/binary-unit:1,V7@Buf8/bitstring>> ->
{V7@V7,V7@Buf8};
<<_:V7@Pad3,1:1,0:1,V7@V6:14,V7@V8:V7@V6/binary-unit:1,V7@Buf9/bitstring>> ->
{V7@V8,V7@Buf9};
<<_:V7@Pad3,1:1,1:1,V7@V6:6,V7@Buf7/bitstring>> ->
{V7@V8,V7@Buf9}  = decode_fragmented(V7@V6, V7@Buf7, 1),
{V7@V8,V7@Buf9}
end,
{V7@V10,V7@Buf11}  = {decode_named_bit_string(V7@V0, [{onTimeOut,0},{onInterruptByEvent,1},{onInterruptByNewSignalDescr,2},{otherReason,3}]),V7@Buf1},
{V7@V10,V7@Buf11}
end;
0 ->
{asn1_NOVALUE,Bytes6}
end,

%% attribute number 6 with type BOOLEAN
{Term6,Bytes8} = case Opt band 1 of
1 ->
begin
<<V8@V0:1,V8@Buf1/bitstring>> = Bytes7,
V8@Int2 = case V8@V0 of
0 -> false;
1 -> true
end,
{V8@Int2,V8@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes7}
end,

%% attribute number 7 with type SEQUENCE OF
{Term7,Bytes9} = 'dec_Signal_sigParList'(Bytes8),

%% Extensions
{Extensions,Bytes10} = case Ext of
0 -> {<<>>,Bytes9};
1 ->
{V9@V0,V9@Buf1} = case Bytes9 of
<<0:1,V9@V3:6,V9@Buf4/bitstring>> ->
V9@Add5 = V9@V3 + 1,
{V9@Add5,V9@Buf4};
<<1:1,V9@Buf2/bitstring>> ->
V9@Pad6 = bit_size(V9@Buf2) band 7,
{V9@V3,V9@Buf4} = case V9@Buf2 of
<<_:V9@Pad6,0:1,V9@V8:7,V9@Buf9/bitstring>> when V9@V8 =/= 0 ->
{V9@V8,V9@Buf9};
<<_:V9@Pad6,1:1,0:1,V9@V9:14,V9@Buf10/bitstring>> when V9@V9 =/= 0 ->
{V9@V9,V9@Buf10}
end,
{V9@V3,V9@Buf4}
end,
<<V9@V11:V9@V0/bitstring-unit:1,V9@Buf12/bitstring>> = V9@Buf1,
{V9@V11,V9@Buf12}
end,

%% attribute number 8 with type ENUMERATED
{Term8,Bytes11} = case Extensions of
  <<_:0,1:1,_/bitstring>> ->
begin
V10@Pad3 = bit_size(Bytes10) band 7,
{V10@V0,V10@Buf1} = case Bytes10 of
<<_:V10@Pad3,0:1,V10@V5:7,V10@V7:V10@V5/binary-unit:8,V10@Buf8/bitstring>> ->
{V10@V7,V10@Buf8};
<<_:V10@Pad3,1:1,0:1,V10@V6:14,V10@V8:V10@V6/binary-unit:8,V10@Buf9/bitstring>> ->
{V10@V8,V10@Buf9};
<<_:V10@Pad3,1:1,1:1,V10@V6:6,V10@Buf7/bitstring>> ->
{V10@V8,V10@Buf9}  = decode_fragmented(V10@V6, V10@Buf7, 8),
{V10@V8,V10@Buf9}
end,
{TmpValx8,_} = begin
{V11@V0,V11@Buf1} = case V10@V0 of
<<0:1,V11@V3:2/unsigned-unit:1,V11@Buf4/bitstring>> ->
V11@Int5 = case V11@V3 of
0 -> internal;
1 -> external;
2 -> both;
_ -> exit({error,{asn1,{decode_enumerated,{V11@V3,[internal,external,both]}}}})
end,
{V11@Int5,V11@Buf4};
<<1:1,V11@Buf2/bitstring>> ->
{V11@V3,V11@Buf4} = case V11@Buf2 of
<<0:1,V11@V6:6,V11@Buf7/bitstring>> ->
{V11@V6,V11@Buf7};
<<1:1,V11@Buf5/bitstring>> ->
V11@Pad9 = bit_size(V11@Buf5) band 7,
{V11@V6,V11@Buf7} = case V11@Buf5 of
<<_:V11@Pad9,0:1,V11@V11:7,V11@Buf12/bitstring>> when V11@V11 =/= 0 ->
{V11@V11,V11@Buf12};
<<_:V11@Pad9,1:1,0:1,V11@V12:14,V11@Buf13/bitstring>> when V11@V12 =/= 0 ->
{V11@V12,V11@Buf13}
end,
<<V11@V14:V11@V6/unit:8,V11@Buf15/bitstring>> = V11@Buf7,
{V11@V14,V11@Buf15}
end,
V11@Int16 = case V11@V3 of
_ -> {asn1_enum,V11@V3}
end,
{V11@Int16,V11@Buf4}
end,
{V11@V0,V11@Buf1}
end,
{TmpValx8,V10@Buf1}
end;
_  ->
{asn1_NOVALUE,Bytes10}
end,

%% attribute number 9 with type INTEGER
{Term9,Bytes12} = case Extensions of
  <<_:1,1:1,_/bitstring>> ->
begin
V12@Pad3 = bit_size(Bytes11) band 7,
{V12@V0,V12@Buf1} = case Bytes11 of
<<_:V12@Pad3,0:1,V12@V5:7,V12@V7:V12@V5/binary-unit:8,V12@Buf8/bitstring>> ->
{V12@V7,V12@Buf8};
<<_:V12@Pad3,1:1,0:1,V12@V6:14,V12@V8:V12@V6/binary-unit:8,V12@Buf9/bitstring>> ->
{V12@V8,V12@Buf9};
<<_:V12@Pad3,1:1,1:1,V12@V6:6,V12@Buf7/bitstring>> ->
{V12@V8,V12@Buf9}  = decode_fragmented(V12@V6, V12@Buf7, 8),
{V12@V8,V12@Buf9}
end,
{TmpValx9,_} = begin
<<V13@V0:2/unsigned-unit:1,V13@Buf1/bitstring>> = V12@V0,
V13@Add2 = V13@V0 + 1,
V13@Pad5 = bit_size(V13@Buf1) band 7,
<<_:V13@Pad5,V13@V3:V13@Add2/unsigned-unit:8,V13@Buf4/bitstring>> = V13@Buf1,
{V13@V3,V13@Buf4}
end,
{TmpValx9,V12@Buf1}
end;
_  ->
{asn1_NOVALUE,Bytes11}
end,
Bytes13= skipextensions(Bytes12, 3, Extensions),
{{'Signal',Term1,Term2,Term3,Term4,Term5,Term6,Term7,Term8,Term9},Bytes13}.

'enc_SeqSigList'(Val) ->
[align,
begin
Enc1@input = element(2, Val),
if Enc1@input bsr 16 =:= 0 ->
<<Enc1@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc1@input}}})
end
end|begin
Enc3@input = element(3, Val),
enc_SeqSigList_signalList(Enc3@input)
end].
'enc_SeqSigList_signalList'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_Signal(Comp) || Comp <- Val]].


dec_SeqSigList_signalList(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components8(V1@V0, V1@Buf1, []).



dec_SeqSigList(Bytes) ->

%% attribute number 1 with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes2} = 'dec_SeqSigList_signalList'(Bytes1),
{{'SeqSigList',Term1,Term2},Bytes2}.

'enc_SignalRequest'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= signal ->
[<<0:1,0:1>>|enc_Signal(ChoiceVal)];
ChoiceTag =:= seqSigList ->
[<<0:1,1:1>>|enc_SeqSigList(ChoiceVal)]
end.


dec_SignalRequest(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:1/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_Signal(Bytes2)
end,
{{signal,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_SeqSigList(Bytes2)
end,
{{seqSigList,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10}
end,
<<V1@V11:V1@V3/unit:8,V1@Buf12/bitstring>> = V1@Buf4,
{V1@V11,V1@Buf12}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
'enc_SignalsDescriptor'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_SignalRequest(Comp) || Comp <- Val]].



dec_SignalsDescriptor(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components9(V1@V0, V1@Buf1, []).

'enc_EventSpec'(Val) ->
[begin
Enc1@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
align,
begin
Enc3@input = element(2, Val),
Enc4@bin = iolist_to_binary(Enc3@input),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len =:= 4 ->
Enc4@bin
end
end,
begin
Enc5@input = element(3, Val),
if Enc5@input =:= asn1_NOVALUE ->
[];
Enc5@input bsr 16 =:= 0 ->
<<Enc5@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc5@input}}})
end
end|begin
Enc8@input = element(4, Val),
enc_EventSpec_eventParList(Enc8@input)
end].
'enc_EventSpec_eventParList'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_EventParameter(Comp) || Comp <- Val]].


dec_EventSpec_eventParList(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components10(V1@V0, V1@Buf1, []).



dec_EventSpec(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:4/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv4 = binary_to_list(V3@V0),
{V3@Conv4,V3@Buf1}
end,

%% attribute number 2 with type INTEGER
{Term2,Bytes4} = case Opt band 1 of
1 ->
begin
V4@Pad2 = bit_size(Bytes3) band 7,
<<_:V4@Pad2,V4@V0:2/unsigned-unit:8,V4@Buf1/bitstring>> = Bytes3,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type SEQUENCE OF
{Term3,Bytes5} = 'dec_EventSpec_eventParList'(Bytes4),

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V5@V0,V5@Buf1} = case Bytes5 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V11:V5@V0/bitstring-unit:1,V5@Buf12/bitstring>> = V5@Buf1,
{V5@V11,V5@Buf12}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
{{'EventSpec',Term1,Term2,Term3},Bytes7}.

'enc_EventBufferDescriptor'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_EventSpec(Comp) || Comp <- Val]].



dec_EventBufferDescriptor(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components11(V1@V0, V1@Buf1, []).

'enc_SecondRequestedActions'(Val) ->
[begin
Enc1@input = element(2, Val),
Enc2@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@input = element(4, Val),
Enc5@input = element(2, Val),
if Enc3@input =:= asn1_NOVALUE ->
if Enc5@input =:= asn1_NOVALUE ->
<<0:1>>;
Enc5@input =:= false ->
<<0:1,0:1>>;
Enc5@input =:= true ->
<<0:1,1:1>>
end;
true ->
if Enc5@input =:= asn1_NOVALUE ->
<<1:1>>;
Enc5@input =:= false ->
<<1:1,0:1>>;
Enc5@input =:= true ->
<<1:1,1:1>>
end
end
end,
begin
Enc8@input = element(3, Val),
if Enc8@input =:= asn1_NOVALUE ->
[];
true ->
enc_EventDM(Enc8@input)
end
end|begin
Enc10@input = element(4, Val),
if Enc10@input =:= asn1_NOVALUE ->
[];
true ->
enc_SignalsDescriptor(Enc10@input)
end
end].


dec_SecondRequestedActions(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:3,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type BOOLEAN
{Term1,Bytes3} = case (Opt bsr 2) band 1 of
1 ->
begin
<<V3@V0:1,V3@Buf1/bitstring>> = Bytes2,
V3@Int2 = case V3@V0 of
0 -> false;
1 -> true
end,
{V3@Int2,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 2 with type EventDM
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
dec_EventDM(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type SignalsDescriptor
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_SignalsDescriptor(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V4@V0,V4@Buf1} = case Bytes5 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V11:V4@V0/bitstring-unit:1,V4@Buf12/bitstring>> = V4@Buf1,
{V4@V11,V4@Buf12}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
{{'SecondRequestedActions',Term1,Term2,Term3},Bytes7}.

'enc_SecondRequestedEvent'(Val) ->
[begin
Enc1@input = element(3, Val),
Enc2@input = element(4, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
align,
begin
Enc4@input = element(2, Val),
Enc5@bin = iolist_to_binary(Enc4@input),
Enc5@len = byte_size(Enc5@bin),
if Enc5@len =:= 4 ->
Enc5@bin
end
end,
begin
Enc6@input = element(3, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
Enc6@input bsr 16 =:= 0 ->
<<Enc6@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc6@input}}})
end
end,
begin
Enc9@input = element(4, Val),
if Enc9@input =:= asn1_NOVALUE ->
[];
true ->
enc_SecondRequestedActions(Enc9@input)
end
end|begin
Enc11@input = element(5, Val),
enc_SecondRequestedEvent_evParList(Enc11@input)
end].
'enc_SecondRequestedEvent_evParList'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_EventParameter(Comp) || Comp <- Val]].


dec_SecondRequestedEvent_evParList(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components12(V1@V0, V1@Buf1, []).



dec_SecondRequestedEvent(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:4/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv4 = binary_to_list(V3@V0),
{V3@Conv4,V3@Buf1}
end,

%% attribute number 2 with type INTEGER
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
V4@Pad2 = bit_size(Bytes3) band 7,
<<_:V4@Pad2,V4@V0:2/unsigned-unit:8,V4@Buf1/bitstring>> = Bytes3,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type SecondRequestedActions
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_SecondRequestedActions(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute number 4 with type SEQUENCE OF
{Term4,Bytes6} = 'dec_SecondRequestedEvent_evParList'(Bytes5),

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V5@V0,V5@Buf1} = case Bytes6 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V11:V5@V0/bitstring-unit:1,V5@Buf12/bitstring>> = V5@Buf1,
{V5@V11,V5@Buf12}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
{{'SecondRequestedEvent',Term1,Term2,Term3,Term4},Bytes8}.

'enc_SecondEventsDescriptor'(Val) ->
[begin
Enc1@input = element(2, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
Enc3@input = element(2, Val),
if Enc3@input =:= asn1_NOVALUE ->
[];
Enc3@input bsr 32 =:= 0 ->
begin
Enc3@input@bin = binary:encode_unsigned(Enc3@input),
Enc3@input@bin_size0 = byte_size(Enc3@input@bin),
Enc3@input@bin_size = Enc3@input@bin_size0 - 1,
[<<Enc3@input@bin_size:2>>,
align|Enc3@input@bin]
end;
true ->
exit({error,{asn1,{illegal_value,Enc3@input}}})
end
end|begin
Enc6@input = element(3, Val),
enc_SecondEventsDescriptor_eventList(Enc6@input)
end].
'enc_SecondEventsDescriptor_eventList'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_SecondRequestedEvent(Comp) || Comp <- Val]].


dec_SecondEventsDescriptor_eventList(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components13(V1@V0, V1@Buf1, []).



dec_SecondEventsDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type INTEGER
{Term1,Bytes3} = case Opt band 1 of
1 ->
begin
<<V3@V0:2/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
V3@Add2 = V3@V0 + 1,
V3@Pad5 = bit_size(V3@Buf1) band 7,
<<_:V3@Pad5,V3@V3:V3@Add2/unsigned-unit:8,V3@Buf4/bitstring>> = V3@Buf1,
{V3@V3,V3@Buf4}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes4} = 'dec_SecondEventsDescriptor_eventList'(Bytes3),

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V4@V0,V4@Buf1} = case Bytes4 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V11:V4@V0/bitstring-unit:1,V4@Buf12/bitstring>> = V4@Buf1,
{V4@V11,V4@Buf12}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
{{'SecondEventsDescriptor',Term1,Term2},Bytes6}.

'enc_EventDM'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= digitMapName ->
begin
Enc2@bin = iolist_to_binary(ChoiceVal),
Enc2@len = byte_size(Enc2@bin),
if Enc2@len =:= 2 ->
[<<0:1>>|Enc2@bin]
end
end;
ChoiceTag =:= digitMapValue ->
[<<1:1>>|enc_DigitMapValue(ChoiceVal)]
end.


dec_EventDM(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:1/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
begin
<<V2@V0:2/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv2 = binary_to_list(V2@V0),
{V2@Conv2,V2@Buf1}
end
end,
{{digitMapName,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_DigitMapValue(Bytes1)
end,
{{digitMapValue,Val},NewBytes}
end.
'enc_RequestedActions'(Val) ->
[begin
Enc1@input = element(2, Val),
Enc2@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@input = element(4, Val),
Enc4@input = element(5, Val),
if Enc3@input =:= asn1_NOVALUE ->
if Enc4@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc4@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc6@input = element(2, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
Enc6@input =:= false ->
<<0:1>>;
Enc6@input =:= true ->
<<1:1>>
end
end,
begin
Enc9@input = element(3, Val),
if Enc9@input =:= asn1_NOVALUE ->
[];
true ->
enc_EventDM(Enc9@input)
end
end,
begin
Enc11@input = element(4, Val),
if Enc11@input =:= asn1_NOVALUE ->
[];
true ->
enc_SecondEventsDescriptor(Enc11@input)
end
end|begin
Enc13@input = element(5, Val),
if Enc13@input =:= asn1_NOVALUE ->
[];
true ->
enc_SignalsDescriptor(Enc13@input)
end
end].


dec_RequestedActions(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:4,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type BOOLEAN
{Term1,Bytes3} = case (Opt bsr 3) band 1 of
1 ->
begin
<<V3@V0:1,V3@Buf1/bitstring>> = Bytes2,
V3@Int2 = case V3@V0 of
0 -> false;
1 -> true
end,
{V3@Int2,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 2 with type EventDM
{Term2,Bytes4} = case (Opt bsr 2) band 1 of
1 ->
dec_EventDM(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type SecondEventsDescriptor
{Term3,Bytes5} = case (Opt bsr 1) band 1 of
1 ->
dec_SecondEventsDescriptor(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute number 4 with type SignalsDescriptor
{Term4,Bytes6} = case Opt band 1 of
1 ->
dec_SignalsDescriptor(Bytes5);
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V4@V0,V4@Buf1} = case Bytes6 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V11:V4@V0/bitstring-unit:1,V4@Buf12/bitstring>> = V4@Buf1,
{V4@V11,V4@Buf12}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
{{'RequestedActions',Term1,Term2,Term3,Term4},Bytes8}.

'enc_RequestedEvent'(Val) ->
[begin
Enc1@input = element(3, Val),
Enc2@input = element(4, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
align,
begin
Enc4@input = element(2, Val),
Enc5@bin = iolist_to_binary(Enc4@input),
Enc5@len = byte_size(Enc5@bin),
if Enc5@len =:= 4 ->
Enc5@bin
end
end,
begin
Enc6@input = element(3, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
Enc6@input bsr 16 =:= 0 ->
<<Enc6@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc6@input}}})
end
end,
begin
Enc9@input = element(4, Val),
if Enc9@input =:= asn1_NOVALUE ->
[];
true ->
enc_RequestedActions(Enc9@input)
end
end|begin
Enc11@input = element(5, Val),
enc_RequestedEvent_evParList(Enc11@input)
end].
'enc_RequestedEvent_evParList'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_EventParameter(Comp) || Comp <- Val]].


dec_RequestedEvent_evParList(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components14(V1@V0, V1@Buf1, []).



dec_RequestedEvent(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:4/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv4 = binary_to_list(V3@V0),
{V3@Conv4,V3@Buf1}
end,

%% attribute number 2 with type INTEGER
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
V4@Pad2 = bit_size(Bytes3) band 7,
<<_:V4@Pad2,V4@V0:2/unsigned-unit:8,V4@Buf1/bitstring>> = Bytes3,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type RequestedActions
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_RequestedActions(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute number 4 with type SEQUENCE OF
{Term4,Bytes6} = 'dec_RequestedEvent_evParList'(Bytes5),

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V5@V0,V5@Buf1} = case Bytes6 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V11:V5@V0/bitstring-unit:1,V5@Buf12/bitstring>> = V5@Buf1,
{V5@V11,V5@Buf12}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
{{'RequestedEvent',Term1,Term2,Term3,Term4},Bytes8}.

'enc_EventsDescriptor'(Val) ->
[begin
Enc1@input = element(2, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
Enc3@input = element(2, Val),
if Enc3@input =:= asn1_NOVALUE ->
[];
Enc3@input bsr 32 =:= 0 ->
begin
Enc3@input@bin = binary:encode_unsigned(Enc3@input),
Enc3@input@bin_size0 = byte_size(Enc3@input@bin),
Enc3@input@bin_size = Enc3@input@bin_size0 - 1,
[<<Enc3@input@bin_size:2>>,
align|Enc3@input@bin]
end;
true ->
exit({error,{asn1,{illegal_value,Enc3@input}}})
end
end|begin
Enc6@input = element(3, Val),
enc_EventsDescriptor_eventList(Enc6@input)
end].
'enc_EventsDescriptor_eventList'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_RequestedEvent(Comp) || Comp <- Val]].


dec_EventsDescriptor_eventList(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components15(V1@V0, V1@Buf1, []).



dec_EventsDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type INTEGER
{Term1,Bytes3} = case Opt band 1 of
1 ->
begin
<<V3@V0:2/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
V3@Add2 = V3@V0 + 1,
V3@Pad5 = bit_size(V3@Buf1) band 7,
<<_:V3@Pad5,V3@V3:V3@Add2/unsigned-unit:8,V3@Buf4/bitstring>> = V3@Buf1,
{V3@V3,V3@Buf4}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes4} = 'dec_EventsDescriptor_eventList'(Bytes3),

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V4@V0,V4@Buf1} = case Bytes4 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V11:V4@V0/bitstring-unit:1,V4@Buf12/bitstring>> = V4@Buf1,
{V4@V11,V4@Buf12}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
{{'EventsDescriptor',Term1,Term2},Bytes6}.

'enc_StreamID'(Val) ->
if Val bsr 16 =:= 0 ->
[align|<<Val:16>>];
true ->
exit({error,{asn1,{illegal_value,Val}}})
end.


dec_StreamID(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end.

'enc_MuxType'(Val) ->
if Val =:= h221 ->
<<0:1,0:2>>;
Val =:= h223 ->
<<0:1,1:2>>;
Val =:= h226 ->
<<0:1,2:2>>;
Val =:= v76 ->
<<0:1,3:2>>;
Val =:= nx64k ->
<<1:1,0:7>>;
true ->
exit({error,{asn1,{illegal_value,Val}}})
end.


dec_MuxType(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:2/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> h221;
1 -> h223;
2 -> h226;
3 -> v76
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13}
end,
<<V1@V14:V1@V6/unit:8,V1@Buf15/bitstring>> = V1@Buf7,
{V1@V14,V1@Buf15}
end,
V1@Int16 = case V1@V3 of
0 -> nx64k;
_ -> {asn1_enum,V1@V3}
end,
{V1@Int16,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

'enc_MuxDescriptor'(Val) ->
[begin
Enc1@input = element(4, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
Enc3@input = element(2, Val),
if Enc3@input =:= h221 ->
<<0:1,0:2>>;
Enc3@input =:= h223 ->
<<0:1,1:2>>;
Enc3@input =:= h226 ->
<<0:1,2:2>>;
Enc3@input =:= v76 ->
<<0:1,3:2>>;
Enc3@input =:= nx64k ->
<<1:1,0:7>>;
true ->
exit({error,{asn1,{illegal_value,Enc3@input}}})
end
end,
begin
Enc5@input = element(3, Val),
enc_MuxDescriptor_termList(Enc5@input)
end|begin
Enc6@input = element(4, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
true ->
enc_NonStandardData(Enc6@input)
end
end].
'enc_MuxDescriptor_termList'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_TerminationID(Comp) || Comp <- Val]].


dec_MuxDescriptor_termList(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components16(V1@V0, V1@Buf1, []).



dec_MuxDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type ENUMERATED
{Term1,Bytes3} = begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:2/unsigned-unit:1,V3@Buf4/bitstring>> ->
V3@Int5 = case V3@V3 of
0 -> h221;
1 -> h223;
2 -> h226;
3 -> v76
end,
{V3@Int5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<0:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V6,V3@Buf7};
<<1:1,V3@Buf5/bitstring>> ->
V3@Pad9 = bit_size(V3@Buf5) band 7,
{V3@V6,V3@Buf7} = case V3@Buf5 of
<<_:V3@Pad9,0:1,V3@V11:7,V3@Buf12/bitstring>> when V3@V11 =/= 0 ->
{V3@V11,V3@Buf12};
<<_:V3@Pad9,1:1,0:1,V3@V12:14,V3@Buf13/bitstring>> when V3@V12 =/= 0 ->
{V3@V12,V3@Buf13}
end,
<<V3@V14:V3@V6/unit:8,V3@Buf15/bitstring>> = V3@Buf7,
{V3@V14,V3@Buf15}
end,
V3@Int16 = case V3@V3 of
0 -> nx64k;
_ -> {asn1_enum,V3@V3}
end,
{V3@Int16,V3@Buf4}
end,
{V3@V0,V3@Buf1}
end,

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes4} = 'dec_MuxDescriptor_termList'(Bytes3),

%% attribute number 3 with type NonStandardData
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_NonStandardData(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V4@V0,V4@Buf1} = case Bytes5 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V11:V4@V0/bitstring-unit:1,V4@Buf12/bitstring>> = V4@Buf1,
{V4@V11,V4@Buf12}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
{{'MuxDescriptor',Term1,Term2,Term3},Bytes7}.

'enc_ServiceState'(Val) ->
if Val =:= test ->
<<0:1,0:2>>;
Val =:= outOfSvc ->
<<0:1,1:2>>;
Val =:= inSvc ->
<<0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_value,Val}}})
end.


dec_ServiceState(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:2/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> test;
1 -> outOfSvc;
2 -> inSvc;
_ -> exit({error,{asn1,{decode_enumerated,{V1@V3,[test,outOfSvc,inSvc]}}}})
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13}
end,
<<V1@V14:V1@V6/unit:8,V1@Buf15/bitstring>> = V1@Buf7,
{V1@V14,V1@Buf15}
end,
V1@Int16 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int16,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

'enc_EventBufferControl'(Val) ->
if Val =:= off ->
<<0:1,0:1>>;
Val =:= lockStep ->
<<0:1,1:1>>;
true ->
exit({error,{asn1,{illegal_value,Val}}})
end.


dec_EventBufferControl(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:1/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> off;
1 -> lockStep
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13}
end,
<<V1@V14:V1@V6/unit:8,V1@Buf15/bitstring>> = V1@Buf7,
{V1@V14,V1@Buf15}
end,
V1@Int16 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int16,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

'enc_TerminationStateDescriptor'(Val) ->
[begin
Enc1@input = element(3, Val),
Enc2@input = element(4, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc4@input = element(2, Val),
enc_TerminationStateDescriptor_propertyParms(Enc4@input)
end,
begin
Enc5@input = element(3, Val),
if Enc5@input =:= asn1_NOVALUE ->
[];
Enc5@input =:= off ->
<<0:1,0:1>>;
Enc5@input =:= lockStep ->
<<0:1,1:1>>;
true ->
exit({error,{asn1,{illegal_value,Enc5@input}}})
end
end|begin
Enc8@input = element(4, Val),
if Enc8@input =:= asn1_NOVALUE ->
[];
Enc8@input =:= test ->
<<0:1,0:2>>;
Enc8@input =:= outOfSvc ->
<<0:1,1:2>>;
Enc8@input =:= inSvc ->
<<0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_value,Enc8@input}}})
end
end].
'enc_TerminationStateDescriptor_propertyParms'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_PropertyParm(Comp) || Comp <- Val]].


dec_TerminationStateDescriptor_propertyParms(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components17(V1@V0, V1@Buf1, []).



dec_TerminationStateDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type SEQUENCE OF
{Term1,Bytes3} = 'dec_TerminationStateDescriptor_propertyParms'(Bytes2),

%% attribute number 2 with type ENUMERATED
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
{V3@V0,V3@Buf1} = case Bytes3 of
<<0:1,V3@V3:1/unsigned-unit:1,V3@Buf4/bitstring>> ->
V3@Int5 = case V3@V3 of
0 -> off;
1 -> lockStep
end,
{V3@Int5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<0:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V6,V3@Buf7};
<<1:1,V3@Buf5/bitstring>> ->
V3@Pad9 = bit_size(V3@Buf5) band 7,
{V3@V6,V3@Buf7} = case V3@Buf5 of
<<_:V3@Pad9,0:1,V3@V11:7,V3@Buf12/bitstring>> when V3@V11 =/= 0 ->
{V3@V11,V3@Buf12};
<<_:V3@Pad9,1:1,0:1,V3@V12:14,V3@Buf13/bitstring>> when V3@V12 =/= 0 ->
{V3@V12,V3@Buf13}
end,
<<V3@V14:V3@V6/unit:8,V3@Buf15/bitstring>> = V3@Buf7,
{V3@V14,V3@Buf15}
end,
V3@Int16 = case V3@V3 of
_ -> {asn1_enum,V3@V3}
end,
{V3@Int16,V3@Buf4}
end,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type ENUMERATED
{Term3,Bytes5} = case Opt band 1 of
1 ->
begin
{V4@V0,V4@Buf1} = case Bytes4 of
<<0:1,V4@V3:2/unsigned-unit:1,V4@Buf4/bitstring>> ->
V4@Int5 = case V4@V3 of
0 -> test;
1 -> outOfSvc;
2 -> inSvc;
_ -> exit({error,{asn1,{decode_enumerated,{V4@V3,[test,outOfSvc,inSvc]}}}})
end,
{V4@Int5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<0:1,V4@V6:6,V4@Buf7/bitstring>> ->
{V4@V6,V4@Buf7};
<<1:1,V4@Buf5/bitstring>> ->
V4@Pad9 = bit_size(V4@Buf5) band 7,
{V4@V6,V4@Buf7} = case V4@Buf5 of
<<_:V4@Pad9,0:1,V4@V11:7,V4@Buf12/bitstring>> when V4@V11 =/= 0 ->
{V4@V11,V4@Buf12};
<<_:V4@Pad9,1:1,0:1,V4@V12:14,V4@Buf13/bitstring>> when V4@V12 =/= 0 ->
{V4@V12,V4@Buf13}
end,
<<V4@V14:V4@V6/unit:8,V4@Buf15/bitstring>> = V4@Buf7,
{V4@V14,V4@Buf15}
end,
V4@Int16 = case V4@V3 of
_ -> {asn1_enum,V4@V3}
end,
{V4@Int16,V4@Buf4}
end,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V5@V0,V5@Buf1} = case Bytes5 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V11:V5@V0/bitstring-unit:1,V5@Buf12/bitstring>> = V5@Buf1,
{V5@V11,V5@Buf12}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
{{'TerminationStateDescriptor',Term1,Term2,Term3},Bytes7}.

'enc_PropertyGroup'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_PropertyParm(Comp) || Comp <- Val]].



dec_PropertyGroup(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components18(V1@V0, V1@Buf1, []).

'enc_LocalRemoteDescriptor'(Val) ->
[<<0:1>>|begin
Enc2@input = element(2, Val),
enc_LocalRemoteDescriptor_propGrps(Enc2@input)
end].
'enc_LocalRemoteDescriptor_propGrps'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_PropertyGroup(Comp) || Comp <- Val]].


dec_LocalRemoteDescriptor_propGrps(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components19(V1@V0, V1@Buf1, []).



dec_LocalRemoteDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type SEQUENCE OF
{Term1,Bytes2} = 'dec_LocalRemoteDescriptor_propGrps'(Bytes1),

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V2@V0,V2@Buf1} = case Bytes2 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V11:V2@V0/bitstring-unit:1,V2@Buf12/bitstring>> = V2@Buf1,
{V2@V11,V2@Buf12}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
{{'LocalRemoteDescriptor',Term1},Bytes4}.

'enc_Relation'(Val) ->
if Val =:= greaterThan ->
<<0:1,0:2>>;
Val =:= smallerThan ->
<<0:1,1:2>>;
Val =:= unequalTo ->
<<0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_value,Val}}})
end.


dec_Relation(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:2/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> greaterThan;
1 -> smallerThan;
2 -> unequalTo;
_ -> exit({error,{asn1,{decode_enumerated,{V1@V3,[greaterThan,smallerThan,unequalTo]}}}})
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13}
end,
<<V1@V14:V1@V6/unit:8,V1@Buf15/bitstring>> = V1@Buf7,
{V1@V14,V1@Buf15}
end,
V1@Int16 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int16,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

'enc_PkgdName'(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 4 ->
[align|Enc1@bin]
end.


dec_PkgdName(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:4/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv4 = binary_to_list(V1@V0),
{V1@Conv4,V1@Buf1}
end.

'enc_Name'(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 2 ->
Enc1@bin
end.


dec_Name(Bytes) ->
begin
<<V1@V0:2/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv2 = binary_to_list(V1@V0),
{V1@Conv2,V1@Buf1}
end.

'enc_PropertyParm'(Val) ->
[begin
Enc1@input = element(4, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
align,
begin
Enc3@input = element(2, Val),
Enc4@bin = iolist_to_binary(Enc3@input),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len =:= 4 ->
Enc4@bin
end
end,
begin
Enc5@input = element(3, Val),
enc_PropertyParm_value(Enc5@input)
end|begin
Enc6@input = element(4, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
true ->
enc_PropertyParm_extraInfo(Enc6@input)
end
end].
'enc_PropertyParm_value'(Val) ->
Enc2@len = length(Val),
[if Enc2@len < 128 ->
[align,
Enc2@len];
Enc2@len < 16384 ->
[align|<<2:2,Enc2@len:14>>]
end|[begin
Enc1@bin = iolist_to_binary(Comp),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len < 128 ->
[Enc1@len|Enc1@bin];
Enc1@len < 16384 ->
[<<2:2,Enc1@len:14>>|Enc1@bin];
true ->
encode_fragmented(Enc1@bin, 8)
end
end || Comp <- Val]].


dec_PropertyParm_value(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components20(V1@V0, V1@Buf1, []).

'enc_PropertyParm_extraInfo'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= relation ->
if ChoiceVal =:= greaterThan ->
<<0:2,0:1,0:2>>;
ChoiceVal =:= smallerThan ->
<<0:2,0:1,1:2>>;
ChoiceVal =:= unequalTo ->
<<0:2,0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_value,ChoiceVal}}})
end;
ChoiceTag =:= range ->
if ChoiceVal =:= false ->
<<1:2,0:1>>;
ChoiceVal =:= true ->
<<1:2,1:1>>
end;
ChoiceTag =:= sublist ->
if ChoiceVal =:= false ->
<<2:2,0:1>>;
ChoiceVal =:= true ->
<<2:2,1:1>>
end
end.

dec_PropertyParm_extraInfo(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
begin
{V2@V0,V2@Buf1} = case Bytes1 of
<<0:1,V2@V3:2/unsigned-unit:1,V2@Buf4/bitstring>> ->
V2@Int5 = case V2@V3 of
0 -> greaterThan;
1 -> smallerThan;
2 -> unequalTo;
_ -> exit({error,{asn1,{decode_enumerated,{V2@V3,[greaterThan,smallerThan,unequalTo]}}}})
end,
{V2@Int5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<0:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V6,V2@Buf7};
<<1:1,V2@Buf5/bitstring>> ->
V2@Pad9 = bit_size(V2@Buf5) band 7,
{V2@V6,V2@Buf7} = case V2@Buf5 of
<<_:V2@Pad9,0:1,V2@V11:7,V2@Buf12/bitstring>> when V2@V11 =/= 0 ->
{V2@V11,V2@Buf12};
<<_:V2@Pad9,1:1,0:1,V2@V12:14,V2@Buf13/bitstring>> when V2@V12 =/= 0 ->
{V2@V12,V2@Buf13}
end,
<<V2@V14:V2@V6/unit:8,V2@Buf15/bitstring>> = V2@Buf7,
{V2@V14,V2@Buf15}
end,
V2@Int16 = case V2@V3 of
_ -> {asn1_enum,V2@V3}
end,
{V2@Int16,V2@Buf4}
end,
{V2@V0,V2@Buf1}
end
end,
{{relation,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
begin
<<V3@V0:1,V3@Buf1/bitstring>> = Bytes1,
V3@Int2 = case V3@V0 of
0 -> false;
1 -> true
end,
{V3@Int2,V3@Buf1}
end
end,
{{range,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
begin
<<V4@V0:1,V4@Buf1/bitstring>> = Bytes1,
V4@Int2 = case V4@V0 of
0 -> false;
1 -> true
end,
{V4@Int2,V4@Buf1}
end
end,
{{sublist,Val},NewBytes}
end.


dec_PropertyParm(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:4/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv4 = binary_to_list(V3@V0),
{V3@Conv4,V3@Buf1}
end,

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes4} = 'dec_PropertyParm_value'(Bytes3),

%% attribute number 3 with type CHOICE
{Term3,Bytes5} = case Opt band 1 of
1 ->
'dec_PropertyParm_extraInfo'(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V4@V0,V4@Buf1} = case Bytes5 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V11:V4@V0/bitstring-unit:1,V4@Buf12/bitstring>> = V4@Buf1,
{V4@V11,V4@Buf12}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
{{'PropertyParm',Term1,Term2,Term3},Bytes7}.

'enc_StreamMode'(Val) ->
if Val =:= sendOnly ->
<<0:1,0:3>>;
Val =:= recvOnly ->
<<0:1,1:3>>;
Val =:= sendRecv ->
<<0:1,2:3>>;
Val =:= inactive ->
<<0:1,3:3>>;
Val =:= loopBack ->
<<0:1,4:3>>;
true ->
exit({error,{asn1,{illegal_value,Val}}})
end.


dec_StreamMode(Bytes) ->
begin
{V1@V0,V1@Buf1} = case Bytes of
<<0:1,V1@V3:3/unsigned-unit:1,V1@Buf4/bitstring>> ->
V1@Int5 = case V1@V3 of
0 -> sendOnly;
1 -> recvOnly;
2 -> sendRecv;
3 -> inactive;
4 -> loopBack;
_ -> exit({error,{asn1,{decode_enumerated,{V1@V3,[sendOnly,recvOnly,sendRecv,inactive,loopBack]}}}})
end,
{V1@Int5,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<0:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7};
<<1:1,V1@Buf5/bitstring>> ->
V1@Pad9 = bit_size(V1@Buf5) band 7,
{V1@V6,V1@Buf7} = case V1@Buf5 of
<<_:V1@Pad9,0:1,V1@V11:7,V1@Buf12/bitstring>> when V1@V11 =/= 0 ->
{V1@V11,V1@Buf12};
<<_:V1@Pad9,1:1,0:1,V1@V12:14,V1@Buf13/bitstring>> when V1@V12 =/= 0 ->
{V1@V12,V1@Buf13}
end,
<<V1@V14:V1@V6/unit:8,V1@Buf15/bitstring>> = V1@Buf7,
{V1@V14,V1@Buf15}
end,
V1@Int16 = case V1@V3 of
_ -> {asn1_enum,V1@V3}
end,
{V1@Int16,V1@Buf4}
end,
{V1@V0,V1@Buf1}
end.

'enc_LocalControlDescriptor'(Val) ->
[begin
Enc1@input = element(2, Val),
Enc2@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@input = element(4, Val),
if Enc3@input =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
begin
Enc5@input = element(2, Val),
if Enc5@input =:= asn1_NOVALUE ->
[];
Enc5@input =:= sendOnly ->
<<0:1,0:3>>;
Enc5@input =:= recvOnly ->
<<0:1,1:3>>;
Enc5@input =:= sendRecv ->
<<0:1,2:3>>;
Enc5@input =:= inactive ->
<<0:1,3:3>>;
Enc5@input =:= loopBack ->
<<0:1,4:3>>;
true ->
exit({error,{asn1,{illegal_value,Enc5@input}}})
end
end,
begin
Enc8@input = element(3, Val),
if Enc8@input =:= asn1_NOVALUE ->
[];
Enc8@input =:= false ->
<<0:1>>;
Enc8@input =:= true ->
<<1:1>>
end
end,
begin
Enc11@input = element(4, Val),
if Enc11@input =:= asn1_NOVALUE ->
[];
Enc11@input =:= false ->
<<0:1>>;
Enc11@input =:= true ->
<<1:1>>
end
end|begin
Enc14@input = element(5, Val),
enc_LocalControlDescriptor_propertyParms(Enc14@input)
end].
'enc_LocalControlDescriptor_propertyParms'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_PropertyParm(Comp) || Comp <- Val]].


dec_LocalControlDescriptor_propertyParms(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components21(V1@V0, V1@Buf1, []).



dec_LocalControlDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:3,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type ENUMERATED
{Term1,Bytes3} = case (Opt bsr 2) band 1 of
1 ->
begin
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:3/unsigned-unit:1,V3@Buf4/bitstring>> ->
V3@Int5 = case V3@V3 of
0 -> sendOnly;
1 -> recvOnly;
2 -> sendRecv;
3 -> inactive;
4 -> loopBack;
_ -> exit({error,{asn1,{decode_enumerated,{V3@V3,[sendOnly,recvOnly,sendRecv,inactive,loopBack]}}}})
end,
{V3@Int5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<0:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V6,V3@Buf7};
<<1:1,V3@Buf5/bitstring>> ->
V3@Pad9 = bit_size(V3@Buf5) band 7,
{V3@V6,V3@Buf7} = case V3@Buf5 of
<<_:V3@Pad9,0:1,V3@V11:7,V3@Buf12/bitstring>> when V3@V11 =/= 0 ->
{V3@V11,V3@Buf12};
<<_:V3@Pad9,1:1,0:1,V3@V12:14,V3@Buf13/bitstring>> when V3@V12 =/= 0 ->
{V3@V12,V3@Buf13}
end,
<<V3@V14:V3@V6/unit:8,V3@Buf15/bitstring>> = V3@Buf7,
{V3@V14,V3@Buf15}
end,
V3@Int16 = case V3@V3 of
_ -> {asn1_enum,V3@V3}
end,
{V3@Int16,V3@Buf4}
end,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 2 with type BOOLEAN
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
<<V4@V0:1,V4@Buf1/bitstring>> = Bytes3,
V4@Int2 = case V4@V0 of
0 -> false;
1 -> true
end,
{V4@Int2,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type BOOLEAN
{Term3,Bytes5} = case Opt band 1 of
1 ->
begin
<<V5@V0:1,V5@Buf1/bitstring>> = Bytes4,
V5@Int2 = case V5@V0 of
0 -> false;
1 -> true
end,
{V5@Int2,V5@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute number 4 with type SEQUENCE OF
{Term4,Bytes6} = 'dec_LocalControlDescriptor_propertyParms'(Bytes5),

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V6@V0,V6@Buf1} = case Bytes6 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
{V6@V9,V6@Buf10}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V11:V6@V0/bitstring-unit:1,V6@Buf12/bitstring>> = V6@Buf1,
{V6@V11,V6@Buf12}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
{{'LocalControlDescriptor',Term1,Term2,Term3,Term4},Bytes8}.

'enc_StreamParms'(Val) ->
Enc4@bitmap = extension_bitmap(Val, 5, 6),
Extensions = if Enc4@bitmap =:= 0 ->
[];
true ->
<<0:7,1:1>>
end,
[begin
Enc1@input = element(2, Val),
if Extensions =:= [] ->
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc1@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc2@input = element(3, Val),
Enc3@input = element(4, Val),
if Enc2@input =:= asn1_NOVALUE ->
if Enc3@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc3@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc6@input = element(2, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
true ->
enc_LocalControlDescriptor(Enc6@input)
end
end,
begin
Enc8@input = element(3, Val),
if Enc8@input =:= asn1_NOVALUE ->
[];
true ->
enc_LocalRemoteDescriptor(Enc8@input)
end
end,
begin
Enc10@input = element(4, Val),
if Enc10@input =:= asn1_NOVALUE ->
[];
true ->
enc_LocalRemoteDescriptor(Enc10@input)
end
end,
Extensions|begin
Enc12@input = element(5, Val),
if Enc12@input =:= asn1_NOVALUE ->
[];
true ->
begin
Enc13@output = enc_StatisticsDescriptor(Enc12@input),
Enc14@bin = complete(Enc13@output),
Enc14@len = byte_size(Enc14@bin),
if Enc14@len < 128 ->
[align,
Enc14@len|Enc14@bin];
Enc14@len < 16384 ->
[align,
<<2:2,Enc14@len:14>>|Enc14@bin];
true ->
[align|encode_fragmented(Enc14@bin, 8)]
end
end
end
end].


dec_StreamParms(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:3,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type LocalControlDescriptor
{Term1,Bytes3} = case (Opt bsr 2) band 1 of
1 ->
dec_LocalControlDescriptor(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 2 with type LocalRemoteDescriptor
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
dec_LocalRemoteDescriptor(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type LocalRemoteDescriptor
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_LocalRemoteDescriptor(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V3@V0,V3@Buf1} = case Bytes5 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V11:V3@V0/bitstring-unit:1,V3@Buf12/bitstring>> = V3@Buf1,
{V3@V11,V3@Buf12}
end,

%% attribute number 4 with type StatisticsDescriptor
{Term4,Bytes7} = case Extensions of
  <<_:0,1:1,_/bitstring>> ->
begin
V4@Pad3 = bit_size(Bytes6) band 7,
{V4@V0,V4@Buf1} = case Bytes6 of
<<_:V4@Pad3,0:1,V4@V5:7,V4@V7:V4@V5/binary-unit:8,V4@Buf8/bitstring>> ->
{V4@V7,V4@Buf8};
<<_:V4@Pad3,1:1,0:1,V4@V6:14,V4@V8:V4@V6/binary-unit:8,V4@Buf9/bitstring>> ->
{V4@V8,V4@Buf9};
<<_:V4@Pad3,1:1,1:1,V4@V6:6,V4@Buf7/bitstring>> ->
{V4@V8,V4@Buf9}  = decode_fragmented(V4@V6, V4@Buf7, 8),
{V4@V8,V4@Buf9}
end,
{TmpValx4,_} = dec_StatisticsDescriptor(V4@V0),
{TmpValx4,V4@Buf1}
end;
_  ->
{asn1_NOVALUE,Bytes6}
end,
Bytes8= skipextensions(Bytes7, 2, Extensions),
{{'StreamParms',Term1,Term2,Term3,Term4},Bytes8}.

'enc_StreamDescriptor'(Val) ->
[align,
begin
Enc1@input = element(2, Val),
if Enc1@input bsr 16 =:= 0 ->
<<Enc1@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc1@input}}})
end
end|begin
Enc3@input = element(3, Val),
enc_StreamParms(Enc3@input)
end].


dec_StreamDescriptor(Bytes) ->

%% attribute number 1 with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 2 with type StreamParms
{Term2,Bytes2} = dec_StreamParms(Bytes1),
{{'StreamDescriptor',Term1,Term2},Bytes2}.

'enc_MediaDescriptor'(Val) ->
[begin
Enc1@input = element(2, Val),
Enc2@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc4@input = element(2, Val),
if Enc4@input =:= asn1_NOVALUE ->
[];
true ->
enc_TerminationStateDescriptor(Enc4@input)
end
end|begin
Enc6@input = element(3, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
true ->
enc_MediaDescriptor_streams(Enc6@input)
end
end].
'enc_MediaDescriptor_streams'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= oneStream ->
[<<0:1>>|enc_StreamParms(ChoiceVal)];
ChoiceTag =:= multiStream ->
[<<1:1>>|enc_MediaDescriptor_streams_multiStream(ChoiceVal)]
end.
'enc_MediaDescriptor_streams_multiStream'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_StreamDescriptor(Comp) || Comp <- Val]].


dec_MediaDescriptor_streams_multiStream(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components22(V1@V0, V1@Buf1, []).


dec_MediaDescriptor_streams(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:1/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_StreamParms(Bytes1)
end,
{{oneStream,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
'dec_MediaDescriptor_streams_multiStream'(Bytes1)
end,
{{multiStream,Val},NewBytes}
end.


dec_MediaDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type TerminationStateDescriptor
{Term1,Bytes3} = case (Opt bsr 1) band 1 of
1 ->
dec_TerminationStateDescriptor(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 2 with type CHOICE
{Term2,Bytes4} = case Opt band 1 of
1 ->
'dec_MediaDescriptor_streams'(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V3@V0,V3@Buf1} = case Bytes4 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V11:V3@V0/bitstring-unit:1,V3@Buf12/bitstring>> = V3@Buf1,
{V3@V11,V3@Buf12}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
{{'MediaDescriptor',Term1,Term2},Bytes6}.

'enc_TerminationIDList'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_TerminationID(Comp) || Comp <- Val]].



dec_TerminationIDList(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components23(V1@V0, V1@Buf1, []).

'enc_TerminationID'(Val) ->
[<<0:1>>,
begin
Enc2@input = element(2, Val),
enc_TerminationID_wildcard(Enc2@input)
end|begin
Enc3@input = element(3, Val),
Enc4@bin = iolist_to_binary(Enc3@input),
Enc4@len = byte_size(Enc4@bin),
Enc4@len@sub = Enc4@len - 1,
if Enc4@len@sub bsr 3 =:= 0 ->
[<<Enc4@len@sub:3>>,
align|Enc4@bin]
end
end].
'enc_TerminationID_wildcard'(Val) ->
Enc2@len = length(Val),
[if Enc2@len < 128 ->
[align,
Enc2@len];
Enc2@len < 16384 ->
[align|<<2:2,Enc2@len:14>>]
end|begin
_ = [if length(Comp) =:= 1 ->
[];
byte_size(Comp) =:= 1 ->
[]
end || Comp <- Val],
iolist_to_binary(Val)
end].


dec_TerminationID_wildcard(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components24(V1@V0, V1@Buf1, []).



dec_TerminationID(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type SEQUENCE OF
{Term1,Bytes2} = 'dec_TerminationID_wildcard'(Bytes1),

%% attribute number 2 with type OCTET STRING
{Term2,Bytes3} = begin
<<V2@V0:3/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes2,
V2@Add2 = V2@V0 + 1,
V2@Pad5 = bit_size(V2@Buf1) band 7,
<<_:V2@Pad5,V2@V3:V2@Add2/binary-unit:8,V2@Buf4/bitstring>> = V2@Buf1,
V2@Conv7 = binary_to_list(V2@V3),
{V2@Conv7,V2@Buf4}
end,

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V3@V0,V3@Buf1} = case Bytes3 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:7,0:1,V3@V7:7,V3@Buf8/bitstring>> when V3@V7 =/= 0 ->
{V3@V7,V3@Buf8};
<<_:7,1:1,0:1,V3@V8:14,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V10:V3@V0/bitstring-unit:1,V3@Buf11/bitstring>> = V3@Buf1,
{V3@V10,V3@Buf11}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
{{'TerminationID',Term1,Term2},Bytes5}.

'enc_WildcardField'(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 1 ->
Enc1@bin
end.


dec_WildcardField(Bytes) ->
begin
<<V1@V0:1/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv2 = binary_to_list(V1@V0),
{V1@Conv2,V1@Buf1}
end.

'enc_ServiceChangeResult'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= errorDescriptor ->
[<<0:1>>|enc_ErrorDescriptor(ChoiceVal)];
ChoiceTag =:= serviceChangeResParms ->
[<<1:1>>|enc_ServiceChangeResParm(ChoiceVal)]
end.


dec_ServiceChangeResult(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:1/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_ErrorDescriptor(Bytes1)
end,
{{errorDescriptor,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_ServiceChangeResParm(Bytes1)
end,
{{serviceChangeResParms,Val},NewBytes}
end.
'enc_ServiceChangeReply'(Val) ->
[<<0:1>>,
begin
Enc2@input = element(2, Val),
enc_TerminationIDList(Enc2@input)
end|begin
Enc3@input = element(3, Val),
enc_ServiceChangeResult(Enc3@input)
end].


dec_ServiceChangeReply(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type TerminationIDList
{Term1,Bytes2} = dec_TerminationIDList(Bytes1),

%% attribute number 2 with type ServiceChangeResult
{Term2,Bytes3} = dec_ServiceChangeResult(Bytes2),

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V2@V0,V2@Buf1} = case Bytes3 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V11:V2@V0/bitstring-unit:1,V2@Buf12/bitstring>> = V2@Buf1,
{V2@V11,V2@Buf12}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
{{'ServiceChangeReply',Term1,Term2},Bytes5}.

'enc_ServiceChangeRequest'(Val) ->
[<<0:1>>,
begin
Enc2@input = element(2, Val),
enc_TerminationIDList(Enc2@input)
end|begin
Enc3@input = element(3, Val),
enc_ServiceChangeParm(Enc3@input)
end].


dec_ServiceChangeRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type TerminationIDList
{Term1,Bytes2} = dec_TerminationIDList(Bytes1),

%% attribute number 2 with type ServiceChangeParm
{Term2,Bytes3} = dec_ServiceChangeParm(Bytes2),

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V2@V0,V2@Buf1} = case Bytes3 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V11:V2@V0/bitstring-unit:1,V2@Buf12/bitstring>> = V2@Buf1,
{V2@V11,V2@Buf12}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
{{'ServiceChangeRequest',Term1,Term2},Bytes5}.

'enc_EventParameter'(Val) ->
[begin
Enc1@input = element(4, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
Enc3@input = element(2, Val),
Enc4@bin = iolist_to_binary(Enc3@input),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len =:= 2 ->
Enc4@bin
end
end,
begin
Enc5@input = element(3, Val),
enc_Value(Enc5@input)
end|begin
Enc6@input = element(4, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
true ->
enc_EventParameter_extraInfo(Enc6@input)
end
end].
'enc_EventParameter_extraInfo'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= relation ->
if ChoiceVal =:= greaterThan ->
<<0:2,0:1,0:2>>;
ChoiceVal =:= smallerThan ->
<<0:2,0:1,1:2>>;
ChoiceVal =:= unequalTo ->
<<0:2,0:1,2:2>>;
true ->
exit({error,{asn1,{illegal_value,ChoiceVal}}})
end;
ChoiceTag =:= range ->
if ChoiceVal =:= false ->
<<1:2,0:1>>;
ChoiceVal =:= true ->
<<1:2,1:1>>
end;
ChoiceTag =:= sublist ->
if ChoiceVal =:= false ->
<<2:2,0:1>>;
ChoiceVal =:= true ->
<<2:2,1:1>>
end
end.

dec_EventParameter_extraInfo(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
begin
{V2@V0,V2@Buf1} = case Bytes1 of
<<0:1,V2@V3:2/unsigned-unit:1,V2@Buf4/bitstring>> ->
V2@Int5 = case V2@V3 of
0 -> greaterThan;
1 -> smallerThan;
2 -> unequalTo;
_ -> exit({error,{asn1,{decode_enumerated,{V2@V3,[greaterThan,smallerThan,unequalTo]}}}})
end,
{V2@Int5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<0:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V6,V2@Buf7};
<<1:1,V2@Buf5/bitstring>> ->
V2@Pad9 = bit_size(V2@Buf5) band 7,
{V2@V6,V2@Buf7} = case V2@Buf5 of
<<_:V2@Pad9,0:1,V2@V11:7,V2@Buf12/bitstring>> when V2@V11 =/= 0 ->
{V2@V11,V2@Buf12};
<<_:V2@Pad9,1:1,0:1,V2@V12:14,V2@Buf13/bitstring>> when V2@V12 =/= 0 ->
{V2@V12,V2@Buf13}
end,
<<V2@V14:V2@V6/unit:8,V2@Buf15/bitstring>> = V2@Buf7,
{V2@V14,V2@Buf15}
end,
V2@Int16 = case V2@V3 of
_ -> {asn1_enum,V2@V3}
end,
{V2@Int16,V2@Buf4}
end,
{V2@V0,V2@Buf1}
end
end,
{{relation,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
begin
<<V3@V0:1,V3@Buf1/bitstring>> = Bytes1,
V3@Int2 = case V3@V0 of
0 -> false;
1 -> true
end,
{V3@Int2,V3@Buf1}
end
end,
{{range,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
begin
<<V4@V0:1,V4@Buf1/bitstring>> = Bytes1,
V4@Int2 = case V4@V0 of
0 -> false;
1 -> true
end,
{V4@Int2,V4@Buf1}
end
end,
{{sublist,Val},NewBytes}
end.


dec_EventParameter(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = begin
<<V3@V0:2/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv2 = binary_to_list(V3@V0),
{V3@Conv2,V3@Buf1}
end,

%% attribute number 2 with type Value
{Term2,Bytes4} = dec_Value(Bytes3),

%% attribute number 3 with type CHOICE
{Term3,Bytes5} = case Opt band 1 of
1 ->
'dec_EventParameter_extraInfo'(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V4@V0,V4@Buf1} = case Bytes5 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V11:V4@V0/bitstring-unit:1,V4@Buf12/bitstring>> = V4@Buf1,
{V4@V11,V4@Buf12}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
{{'EventParameter',Term1,Term2,Term3},Bytes7}.

'enc_EventName'(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 4 ->
[align|Enc1@bin]
end.


dec_EventName(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:4/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv4 = binary_to_list(V1@V0),
{V1@Conv4,V1@Buf1}
end.

'enc_ObservedEvent'(Val) ->
[begin
Enc1@input = element(3, Val),
Enc2@input = element(5, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
align,
begin
Enc4@input = element(2, Val),
Enc5@bin = iolist_to_binary(Enc4@input),
Enc5@len = byte_size(Enc5@bin),
if Enc5@len =:= 4 ->
Enc5@bin
end
end,
begin
Enc6@input = element(3, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
Enc6@input bsr 16 =:= 0 ->
<<Enc6@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc6@input}}})
end
end,
begin
Enc9@input = element(4, Val),
enc_ObservedEvent_eventParList(Enc9@input)
end|begin
Enc10@input = element(5, Val),
if Enc10@input =:= asn1_NOVALUE ->
[];
true ->
enc_TimeNotation(Enc10@input)
end
end].
'enc_ObservedEvent_eventParList'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_EventParameter(Comp) || Comp <- Val]].


dec_ObservedEvent_eventParList(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components25(V1@V0, V1@Buf1, []).



dec_ObservedEvent(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:4/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv4 = binary_to_list(V3@V0),
{V3@Conv4,V3@Buf1}
end,

%% attribute number 2 with type INTEGER
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
V4@Pad2 = bit_size(Bytes3) band 7,
<<_:V4@Pad2,V4@V0:2/unsigned-unit:8,V4@Buf1/bitstring>> = Bytes3,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type SEQUENCE OF
{Term3,Bytes5} = 'dec_ObservedEvent_eventParList'(Bytes4),

%% attribute number 4 with type TimeNotation
{Term4,Bytes6} = case Opt band 1 of
1 ->
dec_TimeNotation(Bytes5);
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V5@V0,V5@Buf1} = case Bytes6 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V11:V5@V0/bitstring-unit:1,V5@Buf12/bitstring>> = V5@Buf1,
{V5@V11,V5@Buf12}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
{{'ObservedEvent',Term1,Term2,Term3,Term4},Bytes8}.

'enc_ObservedEventsDescriptor'(Val) ->
[begin
Enc1@input = element(2, Val),
if Enc1@input bsr 32 =:= 0 ->
begin
Enc1@input@bin = binary:encode_unsigned(Enc1@input),
Enc1@input@bin_size0 = byte_size(Enc1@input@bin),
Enc1@input@bin_size = Enc1@input@bin_size0 - 1,
[<<Enc1@input@bin_size:2>>,
align|Enc1@input@bin]
end;
true ->
exit({error,{asn1,{illegal_value,Enc1@input}}})
end
end|begin
Enc3@input = element(3, Val),
enc_ObservedEventsDescriptor_observedEventLst(Enc3@input)
end].
'enc_ObservedEventsDescriptor_observedEventLst'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_ObservedEvent(Comp) || Comp <- Val]].


dec_ObservedEventsDescriptor_observedEventLst(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components26(V1@V0, V1@Buf1, []).



dec_ObservedEventsDescriptor(Bytes) ->

%% attribute number 1 with type INTEGER
{Term1,Bytes1} = begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Add2 = V1@V0 + 1,
V1@Pad5 = bit_size(V1@Buf1) band 7,
<<_:V1@Pad5,V1@V3:V1@Add2/unsigned-unit:8,V1@Buf4/bitstring>> = V1@Buf1,
{V1@V3,V1@Buf4}
end,

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes2} = 'dec_ObservedEventsDescriptor_observedEventLst'(Bytes1),
{{'ObservedEventsDescriptor',Term1,Term2},Bytes2}.

'enc_NotifyReply'(Val) ->
[begin
Enc1@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
Enc3@input = element(2, Val),
enc_TerminationIDList(Enc3@input)
end|begin
Enc4@input = element(3, Val),
if Enc4@input =:= asn1_NOVALUE ->
[];
true ->
enc_ErrorDescriptor(Enc4@input)
end
end].


dec_NotifyReply(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type TerminationIDList
{Term1,Bytes3} = dec_TerminationIDList(Bytes2),

%% attribute number 2 with type ErrorDescriptor
{Term2,Bytes4} = case Opt band 1 of
1 ->
dec_ErrorDescriptor(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V3@V0,V3@Buf1} = case Bytes4 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V11:V3@V0/bitstring-unit:1,V3@Buf12/bitstring>> = V3@Buf1,
{V3@V11,V3@Buf12}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
{{'NotifyReply',Term1,Term2},Bytes6}.

'enc_NotifyRequest'(Val) ->
[begin
Enc1@input = element(4, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
Enc3@input = element(2, Val),
enc_TerminationIDList(Enc3@input)
end,
begin
Enc4@input = element(3, Val),
enc_ObservedEventsDescriptor(Enc4@input)
end|begin
Enc5@input = element(4, Val),
if Enc5@input =:= asn1_NOVALUE ->
[];
true ->
enc_ErrorDescriptor(Enc5@input)
end
end].


dec_NotifyRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type TerminationIDList
{Term1,Bytes3} = dec_TerminationIDList(Bytes2),

%% attribute number 2 with type ObservedEventsDescriptor
{Term2,Bytes4} = dec_ObservedEventsDescriptor(Bytes3),

%% attribute number 3 with type ErrorDescriptor
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_ErrorDescriptor(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V3@V0,V3@Buf1} = case Bytes5 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V11:V3@V0/bitstring-unit:1,V3@Buf12/bitstring>> = V3@Buf1,
{V3@V11,V3@Buf12}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
{{'NotifyRequest',Term1,Term2,Term3},Bytes7}.

'enc_IndAudPackagesDescriptor'(Val) ->
[begin
Enc2@input = element(2, Val),
Enc3@bin = iolist_to_binary(Enc2@input),
Enc3@len = byte_size(Enc3@bin),
if Enc3@len =:= 2 ->
[<<0:1>>|Enc3@bin]
end
end|begin
Enc4@input = element(3, Val),
if 0 =< Enc4@input, Enc4@input < 100 ->
<<Enc4@input:7>>;
true ->
exit({error,{asn1,{illegal_value,Enc4@input}}})
end
end].


dec_IndAudPackagesDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes2} = begin
<<V2@V0:2/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv2 = binary_to_list(V2@V0),
{V2@Conv2,V2@Buf1}
end,

%% attribute number 2 with type INTEGER
{Term2,Bytes3} = begin
<<V3@V0:7/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
{V3@V0,V3@Buf1}
end,

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V4@V0,V4@Buf1} = case Bytes3 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V11:V4@V0/bitstring-unit:1,V4@Buf12/bitstring>> = V4@Buf1,
{V4@V11,V4@Buf12}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
{{'IndAudPackagesDescriptor',Term1,Term2},Bytes5}.

'enc_IndAudStatisticsDescriptor'(Val) ->
[align|begin
Enc1@input = element(2, Val),
Enc2@bin = iolist_to_binary(Enc1@input),
Enc2@len = byte_size(Enc2@bin),
if Enc2@len =:= 4 ->
Enc2@bin
end
end].


dec_IndAudStatisticsDescriptor(Bytes) ->

%% attribute number 1 with type OCTET STRING
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:4/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv4 = binary_to_list(V1@V0),
{V1@Conv4,V1@Buf1}
end,
{{'IndAudStatisticsDescriptor',Term1},Bytes1}.

'enc_IndAudDigitMapDescriptor'(Val) ->
[begin
Enc1@input = element(2, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end|begin
Enc2@input = element(2, Val),
if Enc2@input =:= asn1_NOVALUE ->
[];
true ->
begin
Enc3@bin = iolist_to_binary(Enc2@input),
Enc3@len = byte_size(Enc3@bin),
if Enc3@len =:= 2 ->
Enc3@bin
end
end
end
end].


dec_IndAudDigitMapDescriptor(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes2} = case Opt band 1 of
1 ->
begin
<<V2@V0:2/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv2 = binary_to_list(V2@V0),
{V2@Conv2,V2@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes1}
end,
{{'IndAudDigitMapDescriptor',Term1},Bytes2}.

'enc_IndAudSignal'(Val) ->
[begin
Enc1@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
align,
begin
Enc3@input = element(2, Val),
Enc4@bin = iolist_to_binary(Enc3@input),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len =:= 4 ->
Enc4@bin
end
end|begin
Enc5@input = element(3, Val),
if Enc5@input =:= asn1_NOVALUE ->
[];
Enc5@input bsr 16 =:= 0 ->
<<Enc5@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc5@input}}})
end
end].


dec_IndAudSignal(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:4/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv4 = binary_to_list(V3@V0),
{V3@Conv4,V3@Buf1}
end,

%% attribute number 2 with type INTEGER
{Term2,Bytes4} = case Opt band 1 of
1 ->
begin
V4@Pad2 = bit_size(Bytes3) band 7,
<<_:V4@Pad2,V4@V0:2/unsigned-unit:8,V4@Buf1/bitstring>> = Bytes3,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V5@V0,V5@Buf1} = case Bytes4 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V11:V5@V0/bitstring-unit:1,V5@Buf12/bitstring>> = V5@Buf1,
{V5@V11,V5@Buf12}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
{{'IndAudSignal',Term1,Term2},Bytes6}.

'enc_IndAudSeqSigList'(Val) ->
[begin
Enc1@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
align,
begin
Enc2@input = element(2, Val),
if Enc2@input bsr 16 =:= 0 ->
<<Enc2@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc2@input}}})
end
end|begin
Enc4@input = element(3, Val),
if Enc4@input =:= asn1_NOVALUE ->
[];
true ->
enc_IndAudSignal(Enc4@input)
end
end].


dec_IndAudSeqSigList(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type INTEGER
{Term1,Bytes2} = begin
V2@Pad2 = bit_size(Bytes1) band 7,
<<_:V2@Pad2,V2@V0:2/unsigned-unit:8,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 2 with type IndAudSignal
{Term2,Bytes3} = case Opt band 1 of
1 ->
dec_IndAudSignal(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,
{{'IndAudSeqSigList',Term1,Term2},Bytes3}.

'enc_IndAudSignalsDescriptor'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= signal ->
[<<0:1,0:1>>|enc_IndAudSignal(ChoiceVal)];
ChoiceTag =:= seqSigList ->
[<<0:1,1:1>>|enc_IndAudSeqSigList(ChoiceVal)]
end.


dec_IndAudSignalsDescriptor(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:1/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_IndAudSignal(Bytes2)
end,
{{signal,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_IndAudSeqSigList(Bytes2)
end,
{{seqSigList,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10}
end,
<<V1@V11:V1@V3/unit:8,V1@Buf12/bitstring>> = V1@Buf4,
{V1@V11,V1@Buf12}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
'enc_IndAudEventBufferDescriptor'(Val) ->
[begin
Enc1@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
align,
begin
Enc3@input = element(2, Val),
Enc4@bin = iolist_to_binary(Enc3@input),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len =:= 4 ->
Enc4@bin
end
end|begin
Enc5@input = element(3, Val),
if Enc5@input =:= asn1_NOVALUE ->
[];
Enc5@input bsr 16 =:= 0 ->
<<Enc5@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc5@input}}})
end
end].


dec_IndAudEventBufferDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes3} = begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:4/binary-unit:8,V3@Buf1/bitstring>> = Bytes2,
V3@Conv4 = binary_to_list(V3@V0),
{V3@Conv4,V3@Buf1}
end,

%% attribute number 2 with type INTEGER
{Term2,Bytes4} = case Opt band 1 of
1 ->
begin
V4@Pad2 = bit_size(Bytes3) band 7,
<<_:V4@Pad2,V4@V0:2/unsigned-unit:8,V4@Buf1/bitstring>> = Bytes3,
{V4@V0,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V5@V0,V5@Buf1} = case Bytes4 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V11:V5@V0/bitstring-unit:1,V5@Buf12/bitstring>> = V5@Buf1,
{V5@V11,V5@Buf12}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
{{'IndAudEventBufferDescriptor',Term1,Term2},Bytes6}.

'enc_IndAudEventsDescriptor'(Val) ->
[begin
Enc1@input = element(2, Val),
Enc2@input = element(4, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc4@input = element(2, Val),
if Enc4@input =:= asn1_NOVALUE ->
[];
Enc4@input bsr 32 =:= 0 ->
begin
Enc4@input@bin = binary:encode_unsigned(Enc4@input),
Enc4@input@bin_size0 = byte_size(Enc4@input@bin),
Enc4@input@bin_size = Enc4@input@bin_size0 - 1,
[<<Enc4@input@bin_size:2>>,
align|Enc4@input@bin]
end;
true ->
exit({error,{asn1,{illegal_value,Enc4@input}}})
end
end,
align,
begin
Enc7@input = element(3, Val),
Enc8@bin = iolist_to_binary(Enc7@input),
Enc8@len = byte_size(Enc8@bin),
if Enc8@len =:= 4 ->
Enc8@bin
end
end|begin
Enc9@input = element(4, Val),
if Enc9@input =:= asn1_NOVALUE ->
[];
Enc9@input bsr 16 =:= 0 ->
<<Enc9@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc9@input}}})
end
end].


dec_IndAudEventsDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type INTEGER
{Term1,Bytes3} = case (Opt bsr 1) band 1 of
1 ->
begin
<<V3@V0:2/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
V3@Add2 = V3@V0 + 1,
V3@Pad5 = bit_size(V3@Buf1) band 7,
<<_:V3@Pad5,V3@V3:V3@Add2/unsigned-unit:8,V3@Buf4/bitstring>> = V3@Buf1,
{V3@V3,V3@Buf4}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 2 with type OCTET STRING
{Term2,Bytes4} = begin
V4@Pad2 = bit_size(Bytes3) band 7,
<<_:V4@Pad2,V4@V0:4/binary-unit:8,V4@Buf1/bitstring>> = Bytes3,
V4@Conv4 = binary_to_list(V4@V0),
{V4@Conv4,V4@Buf1}
end,

%% attribute number 3 with type INTEGER
{Term3,Bytes5} = case Opt band 1 of
1 ->
begin
V5@Pad2 = bit_size(Bytes4) band 7,
<<_:V5@Pad2,V5@V0:2/unsigned-unit:8,V5@Buf1/bitstring>> = Bytes4,
{V5@V0,V5@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V6@V0,V6@Buf1} = case Bytes5 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
{V6@V9,V6@Buf10}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V11:V6@V0/bitstring-unit:1,V6@Buf12/bitstring>> = V6@Buf1,
{V6@V11,V6@Buf12}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
{{'IndAudEventsDescriptor',Term1,Term2,Term3},Bytes7}.

'enc_IndAudTerminationStateDescriptor'(Val) ->
[begin
Enc1@input = element(3, Val),
Enc2@input = element(4, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc4@input = element(2, Val),
enc_IndAudTerminationStateDescriptor_propertyParms(Enc4@input)
end,
begin
Enc5@input = element(3, Val),
if Enc5@input =:= asn1_NOVALUE ->
[];
true ->
[]
end
end|begin
Enc7@input = element(4, Val),
if Enc7@input =:= asn1_NOVALUE ->
[];
true ->
[]
end
end].
'enc_IndAudTerminationStateDescriptor_propertyParms'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_IndAudPropertyParm(Comp) || Comp <- Val]].


dec_IndAudTerminationStateDescriptor_propertyParms(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components27(V1@V0, V1@Buf1, []).



dec_IndAudTerminationStateDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type SEQUENCE OF
{Term1,Bytes3} = 'dec_IndAudTerminationStateDescriptor_propertyParms'(Bytes2),

%% attribute number 2 with type NULL
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
ignore,
{'NULL',Bytes3}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type NULL
{Term3,Bytes5} = case Opt band 1 of
1 ->
begin
ignore,
{'NULL',Bytes4}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V5@V0,V5@Buf1} = case Bytes5 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V11:V5@V0/bitstring-unit:1,V5@Buf12/bitstring>> = V5@Buf1,
{V5@V11,V5@Buf12}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
{{'IndAudTerminationStateDescriptor',Term1,Term2,Term3},Bytes7}.

'enc_IndAudPropertyGroup'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_IndAudPropertyParm(Comp) || Comp <- Val]].



dec_IndAudPropertyGroup(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components28(V1@V0, V1@Buf1, []).

'enc_IndAudLocalRemoteDescriptor'(Val) ->
[begin
Enc1@input = element(2, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
Enc3@input = element(2, Val),
if Enc3@input =:= asn1_NOVALUE ->
[];
Enc3@input bsr 16 =:= 0 ->
[align|<<Enc3@input:16>>];
true ->
exit({error,{asn1,{illegal_value,Enc3@input}}})
end
end|begin
Enc6@input = element(3, Val),
enc_IndAudPropertyGroup(Enc6@input)
end].


dec_IndAudLocalRemoteDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type INTEGER
{Term1,Bytes3} = case Opt band 1 of
1 ->
begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:2/unsigned-unit:8,V3@Buf1/bitstring>> = Bytes2,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 2 with type IndAudPropertyGroup
{Term2,Bytes4} = dec_IndAudPropertyGroup(Bytes3),

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V4@V0,V4@Buf1} = case Bytes4 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V11:V4@V0/bitstring-unit:1,V4@Buf12/bitstring>> = V4@Buf1,
{V4@V11,V4@Buf12}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
{{'IndAudLocalRemoteDescriptor',Term1,Term2},Bytes6}.

'enc_IndAudPropertyParm'(Val) ->
Enc2@input = element(2, Val),
Enc3@bin = iolist_to_binary(Enc2@input),
Enc3@len = byte_size(Enc3@bin),
if Enc3@len =:= 4 ->
[<<0:1>>,
align|Enc3@bin]
end.


dec_IndAudPropertyParm(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes2} = begin
V2@Pad2 = bit_size(Bytes1) band 7,
<<_:V2@Pad2,V2@V0:4/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv4 = binary_to_list(V2@V0),
{V2@Conv4,V2@Buf1}
end,

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:7,0:1,V3@V7:7,V3@Buf8/bitstring>> when V3@V7 =/= 0 ->
{V3@V7,V3@Buf8};
<<_:7,1:1,0:1,V3@V8:14,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V10:V3@V0/bitstring-unit:1,V3@Buf11/bitstring>> = V3@Buf1,
{V3@V10,V3@Buf11}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
{{'IndAudPropertyParm',Term1},Bytes4}.

'enc_IndAudLocalControlDescriptor'(Val) ->
[begin
Enc1@input = element(2, Val),
Enc2@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc3@input = element(4, Val),
Enc4@input = element(5, Val),
if Enc3@input =:= asn1_NOVALUE ->
if Enc4@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc4@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc6@input = element(2, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
true ->
[]
end
end,
begin
Enc8@input = element(3, Val),
if Enc8@input =:= asn1_NOVALUE ->
[];
true ->
[]
end
end,
begin
Enc10@input = element(4, Val),
if Enc10@input =:= asn1_NOVALUE ->
[];
true ->
[]
end
end|begin
Enc12@input = element(5, Val),
if Enc12@input =:= asn1_NOVALUE ->
[];
true ->
enc_IndAudLocalControlDescriptor_propertyParms(Enc12@input)
end
end].
'enc_IndAudLocalControlDescriptor_propertyParms'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_IndAudPropertyParm(Comp) || Comp <- Val]].


dec_IndAudLocalControlDescriptor_propertyParms(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components29(V1@V0, V1@Buf1, []).



dec_IndAudLocalControlDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:4,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type NULL
{Term1,Bytes3} = case (Opt bsr 3) band 1 of
1 ->
begin
ignore,
{'NULL',Bytes2}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 2 with type NULL
{Term2,Bytes4} = case (Opt bsr 2) band 1 of
1 ->
begin
ignore,
{'NULL',Bytes3}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type NULL
{Term3,Bytes5} = case (Opt bsr 1) band 1 of
1 ->
begin
ignore,
{'NULL',Bytes4}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% attribute number 4 with type SEQUENCE OF
{Term4,Bytes6} = case Opt band 1 of
1 ->
'dec_IndAudLocalControlDescriptor_propertyParms'(Bytes5);
0 ->
{asn1_NOVALUE,Bytes5}
end,

%% Extensions
{Extensions,Bytes7} = case Ext of
0 -> {<<>>,Bytes6};
1 ->
{V6@V0,V6@Buf1} = case Bytes6 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
{V6@V9,V6@Buf10}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V11:V6@V0/bitstring-unit:1,V6@Buf12/bitstring>> = V6@Buf1,
{V6@V11,V6@Buf12}
end,
Bytes8= skipextensions(Bytes7, 1, Extensions),
{{'IndAudLocalControlDescriptor',Term1,Term2,Term3,Term4},Bytes8}.

'enc_IndAudStreamParms'(Val) ->
Enc4@bitmap = extension_bitmap(Val, 5, 6),
Extensions = if Enc4@bitmap =:= 0 ->
[];
true ->
<<0:7,1:1>>
end,
[begin
Enc1@input = element(2, Val),
if Extensions =:= [] ->
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc1@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc2@input = element(3, Val),
Enc3@input = element(4, Val),
if Enc2@input =:= asn1_NOVALUE ->
if Enc3@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc3@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc6@input = element(2, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
true ->
enc_IndAudLocalControlDescriptor(Enc6@input)
end
end,
begin
Enc8@input = element(3, Val),
if Enc8@input =:= asn1_NOVALUE ->
[];
true ->
enc_IndAudLocalRemoteDescriptor(Enc8@input)
end
end,
begin
Enc10@input = element(4, Val),
if Enc10@input =:= asn1_NOVALUE ->
[];
true ->
enc_IndAudLocalRemoteDescriptor(Enc10@input)
end
end,
Extensions|begin
Enc12@input = element(5, Val),
if Enc12@input =:= asn1_NOVALUE ->
[];
true ->
begin
Enc13@output = enc_IndAudStatisticsDescriptor(Enc12@input),
Enc14@bin = complete(Enc13@output),
Enc14@len = byte_size(Enc14@bin),
if Enc14@len < 128 ->
[align,
Enc14@len|Enc14@bin];
Enc14@len < 16384 ->
[align,
<<2:2,Enc14@len:14>>|Enc14@bin];
true ->
[align|encode_fragmented(Enc14@bin, 8)]
end
end
end
end].


dec_IndAudStreamParms(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:3,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type IndAudLocalControlDescriptor
{Term1,Bytes3} = case (Opt bsr 2) band 1 of
1 ->
dec_IndAudLocalControlDescriptor(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 2 with type IndAudLocalRemoteDescriptor
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
dec_IndAudLocalRemoteDescriptor(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type IndAudLocalRemoteDescriptor
{Term3,Bytes5} = case Opt band 1 of
1 ->
dec_IndAudLocalRemoteDescriptor(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V3@V0,V3@Buf1} = case Bytes5 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V11:V3@V0/bitstring-unit:1,V3@Buf12/bitstring>> = V3@Buf1,
{V3@V11,V3@Buf12}
end,

%% attribute number 4 with type IndAudStatisticsDescriptor
{Term4,Bytes7} = case Extensions of
  <<_:0,1:1,_/bitstring>> ->
begin
V4@Pad3 = bit_size(Bytes6) band 7,
{V4@V0,V4@Buf1} = case Bytes6 of
<<_:V4@Pad3,0:1,V4@V5:7,V4@V7:V4@V5/binary-unit:8,V4@Buf8/bitstring>> ->
{V4@V7,V4@Buf8};
<<_:V4@Pad3,1:1,0:1,V4@V6:14,V4@V8:V4@V6/binary-unit:8,V4@Buf9/bitstring>> ->
{V4@V8,V4@Buf9};
<<_:V4@Pad3,1:1,1:1,V4@V6:6,V4@Buf7/bitstring>> ->
{V4@V8,V4@Buf9}  = decode_fragmented(V4@V6, V4@Buf7, 8),
{V4@V8,V4@Buf9}
end,
{TmpValx4,_} = dec_IndAudStatisticsDescriptor(V4@V0),
{TmpValx4,V4@Buf1}
end;
_  ->
{asn1_NOVALUE,Bytes6}
end,
Bytes8= skipextensions(Bytes7, 2, Extensions),
{{'IndAudStreamParms',Term1,Term2,Term3,Term4},Bytes8}.

'enc_IndAudStreamDescriptor'(Val) ->
[align,
begin
Enc1@input = element(2, Val),
if Enc1@input bsr 16 =:= 0 ->
<<Enc1@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc1@input}}})
end
end|begin
Enc3@input = element(3, Val),
enc_IndAudStreamParms(Enc3@input)
end].


dec_IndAudStreamDescriptor(Bytes) ->

%% attribute number 1 with type INTEGER
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 2 with type IndAudStreamParms
{Term2,Bytes2} = dec_IndAudStreamParms(Bytes1),
{{'IndAudStreamDescriptor',Term1,Term2},Bytes2}.

'enc_IndAudMediaDescriptor'(Val) ->
[begin
Enc1@input = element(2, Val),
Enc2@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc4@input = element(2, Val),
if Enc4@input =:= asn1_NOVALUE ->
[];
true ->
enc_IndAudTerminationStateDescriptor(Enc4@input)
end
end|begin
Enc6@input = element(3, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
true ->
enc_IndAudMediaDescriptor_streams(Enc6@input)
end
end].
'enc_IndAudMediaDescriptor_streams'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= oneStream ->
[<<0:1>>|enc_IndAudStreamParms(ChoiceVal)];
ChoiceTag =:= multiStream ->
[<<1:1>>|enc_IndAudMediaDescriptor_streams_multiStream(ChoiceVal)]
end.
'enc_IndAudMediaDescriptor_streams_multiStream'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_IndAudStreamDescriptor(Comp) || Comp <- Val]].


dec_IndAudMediaDescriptor_streams_multiStream(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components30(V1@V0, V1@Buf1, []).


dec_IndAudMediaDescriptor_streams(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:1/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_IndAudStreamParms(Bytes1)
end,
{{oneStream,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
'dec_IndAudMediaDescriptor_streams_multiStream'(Bytes1)
end,
{{multiStream,Val},NewBytes}
end.


dec_IndAudMediaDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type IndAudTerminationStateDescriptor
{Term1,Bytes3} = case (Opt bsr 1) band 1 of
1 ->
dec_IndAudTerminationStateDescriptor(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 2 with type CHOICE
{Term2,Bytes4} = case Opt band 1 of
1 ->
'dec_IndAudMediaDescriptor_streams'(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V3@V0,V3@Buf1} = case Bytes4 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V11:V3@V0/bitstring-unit:1,V3@Buf12/bitstring>> = V3@Buf1,
{V3@V11,V3@Buf12}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
{{'IndAudMediaDescriptor',Term1,Term2},Bytes6}.

'enc_IndAuditParameter'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= indAudMediaDescriptor ->
[<<0:1,0:3>>|enc_IndAudMediaDescriptor(ChoiceVal)];
ChoiceTag =:= indAudEventsDescriptor ->
[<<0:1,1:3>>|enc_IndAudEventsDescriptor(ChoiceVal)];
ChoiceTag =:= indAudEventBufferDescriptor ->
[<<0:1,2:3>>|enc_IndAudEventBufferDescriptor(ChoiceVal)];
ChoiceTag =:= indAudSignalsDescriptor ->
[<<0:1,3:3>>|enc_IndAudSignalsDescriptor(ChoiceVal)];
ChoiceTag =:= indAudDigitMapDescriptor ->
[<<0:1,4:3>>|enc_IndAudDigitMapDescriptor(ChoiceVal)];
ChoiceTag =:= indAudStatisticsDescriptor ->
[<<0:1,5:3>>|enc_IndAudStatisticsDescriptor(ChoiceVal)];
ChoiceTag =:= indAudPackagesDescriptor ->
[<<0:1,6:3>>|enc_IndAudPackagesDescriptor(ChoiceVal)]
end.


dec_IndAuditParameter(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:3/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_IndAudMediaDescriptor(Bytes2)
end,
{{indAudMediaDescriptor,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_IndAudEventsDescriptor(Bytes2)
end,
{{indAudEventsDescriptor,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_IndAudEventBufferDescriptor(Bytes2)
end,
{{indAudEventBufferDescriptor,Val},NewBytes};
3 ->
{Val,NewBytes} = begin
dec_IndAudSignalsDescriptor(Bytes2)
end,
{{indAudSignalsDescriptor,Val},NewBytes};
4 ->
{Val,NewBytes} = begin
dec_IndAudDigitMapDescriptor(Bytes2)
end,
{{indAudDigitMapDescriptor,Val},NewBytes};
5 ->
{Val,NewBytes} = begin
dec_IndAudStatisticsDescriptor(Bytes2)
end,
{{indAudStatisticsDescriptor,Val},NewBytes};
6 ->
{Val,NewBytes} = begin
dec_IndAudPackagesDescriptor(Bytes2)
end,
{{indAudPackagesDescriptor,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10}
end,
<<V1@V11:V1@V3/unit:8,V1@Buf12/bitstring>> = V1@Buf4,
{V1@V11,V1@Buf12}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
'enc_AuditDescriptor'(Val) ->
Enc2@bitmap = extension_bitmap(Val, 3, 4),
Extensions = if Enc2@bitmap =:= 0 ->
[];
true ->
<<0:7,1:1>>
end,
[begin
Enc1@input = element(2, Val),
if Extensions =:= [] ->
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc1@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc4@input = element(2, Val),
if Enc4@input =:= asn1_NOVALUE ->
[];
true ->
begin
Enc5@bs = try bit_string_name2pos_31(Enc4@input) of
Enc5@positions ->
bitstring_from_positions(Enc5@positions)
catch throw:invalid ->
to_named_bitstring(Enc4@input)
end,
Enc5@bits = bit_size(Enc5@bs),
if Enc5@bits < 128 ->
[align,
Enc5@bits|Enc5@bs];
Enc5@bits < 16384 ->
[align,
<<2:2,Enc5@bits:14>>|Enc5@bs];
true ->
[align|encode_fragmented(Enc5@bs, 1)]
end
end
end
end,
Extensions|begin
Enc7@input = element(3, Val),
if Enc7@input =:= asn1_NOVALUE ->
[];
true ->
begin
Enc8@output = enc_AuditDescriptor_auditPropertyToken(Enc7@input),
Enc9@bin = complete(Enc8@output),
Enc9@len = byte_size(Enc9@bin),
if Enc9@len < 128 ->
[align,
Enc9@len|Enc9@bin];
Enc9@len < 16384 ->
[align,
<<2:2,Enc9@len:14>>|Enc9@bin];
true ->
[align|encode_fragmented(Enc9@bin, 8)]
end
end
end
end].
'enc_AuditDescriptor_auditPropertyToken'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_IndAuditParameter(Comp) || Comp <- Val]].


dec_AuditDescriptor_auditPropertyToken(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components32(V1@V0, V1@Buf1, []).



dec_AuditDescriptor(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type BIT STRING
{Term1,Bytes3} = case Opt band 1 of
1 ->
begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:1,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:1,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 1),
{V3@V8,V3@Buf9}
end,
{V3@V10,V3@Buf11}  = {decode_named_bit_string(V3@V0, [{muxToken,0},{modemToken,1},{mediaToken,2},{eventsToken,3},{signalsToken,4},{digitMapToken,5},{statsToken,6},{observedEventsToken,7},{packagesToken,8},{eventBufferToken,9}]),V3@Buf1},
{V3@V10,V3@Buf11}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V4@V0,V4@Buf1} = case Bytes3 of
<<0:1,V4@V3:6,V4@Buf4/bitstring>> ->
V4@Add5 = V4@V3 + 1,
{V4@Add5,V4@Buf4};
<<1:1,V4@Buf2/bitstring>> ->
V4@Pad6 = bit_size(V4@Buf2) band 7,
{V4@V3,V4@Buf4} = case V4@Buf2 of
<<_:V4@Pad6,0:1,V4@V8:7,V4@Buf9/bitstring>> when V4@V8 =/= 0 ->
{V4@V8,V4@Buf9};
<<_:V4@Pad6,1:1,0:1,V4@V9:14,V4@Buf10/bitstring>> when V4@V9 =/= 0 ->
{V4@V9,V4@Buf10}
end,
{V4@V3,V4@Buf4}
end,
<<V4@V11:V4@V0/bitstring-unit:1,V4@Buf12/bitstring>> = V4@Buf1,
{V4@V11,V4@Buf12}
end,

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes5} = case Extensions of
  <<_:0,1:1,_/bitstring>> ->
begin
V5@Pad3 = bit_size(Bytes4) band 7,
{V5@V0,V5@Buf1} = case Bytes4 of
<<_:V5@Pad3,0:1,V5@V5:7,V5@V7:V5@V5/binary-unit:8,V5@Buf8/bitstring>> ->
{V5@V7,V5@Buf8};
<<_:V5@Pad3,1:1,0:1,V5@V6:14,V5@V8:V5@V6/binary-unit:8,V5@Buf9/bitstring>> ->
{V5@V8,V5@Buf9};
<<_:V5@Pad3,1:1,1:1,V5@V6:6,V5@Buf7/bitstring>> ->
{V5@V8,V5@Buf9}  = decode_fragmented(V5@V6, V5@Buf7, 8),
{V5@V8,V5@Buf9}
end,
{TmpValx2,_} = 'dec_AuditDescriptor_auditPropertyToken'(V5@V0),
{TmpValx2,V5@Buf1}
end;
_  ->
{asn1_NOVALUE,Bytes4}
end,
Bytes6= skipextensions(Bytes5, 2, Extensions),
{{'AuditDescriptor',Term1,Term2},Bytes6}.

'enc_AuditReturnParameter'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= errorDescriptor ->
[<<0:1,0:4>>|enc_ErrorDescriptor(ChoiceVal)];
ChoiceTag =:= mediaDescriptor ->
[<<0:1,1:4>>|enc_MediaDescriptor(ChoiceVal)];
ChoiceTag =:= modemDescriptor ->
[<<0:1,2:4>>|enc_ModemDescriptor(ChoiceVal)];
ChoiceTag =:= muxDescriptor ->
[<<0:1,3:4>>|enc_MuxDescriptor(ChoiceVal)];
ChoiceTag =:= eventsDescriptor ->
[<<0:1,4:4>>|enc_EventsDescriptor(ChoiceVal)];
ChoiceTag =:= eventBufferDescriptor ->
[<<0:1,5:4>>|enc_EventBufferDescriptor(ChoiceVal)];
ChoiceTag =:= signalsDescriptor ->
[<<0:1,6:4>>|enc_SignalsDescriptor(ChoiceVal)];
ChoiceTag =:= digitMapDescriptor ->
[<<0:1,7:4>>|enc_DigitMapDescriptor(ChoiceVal)];
ChoiceTag =:= observedEventsDescriptor ->
[<<0:1,8:4>>|enc_ObservedEventsDescriptor(ChoiceVal)];
ChoiceTag =:= statisticsDescriptor ->
[<<0:1,9:4>>|enc_StatisticsDescriptor(ChoiceVal)];
ChoiceTag =:= packagesDescriptor ->
[<<0:1,10:4>>|enc_PackagesDescriptor(ChoiceVal)];
ChoiceTag =:= emptyDescriptors ->
[<<0:1,11:4>>|enc_AuditDescriptor(ChoiceVal)]
end.


dec_AuditReturnParameter(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:4/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_ErrorDescriptor(Bytes2)
end,
{{errorDescriptor,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_MediaDescriptor(Bytes2)
end,
{{mediaDescriptor,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_ModemDescriptor(Bytes2)
end,
{{modemDescriptor,Val},NewBytes};
3 ->
{Val,NewBytes} = begin
dec_MuxDescriptor(Bytes2)
end,
{{muxDescriptor,Val},NewBytes};
4 ->
{Val,NewBytes} = begin
dec_EventsDescriptor(Bytes2)
end,
{{eventsDescriptor,Val},NewBytes};
5 ->
{Val,NewBytes} = begin
dec_EventBufferDescriptor(Bytes2)
end,
{{eventBufferDescriptor,Val},NewBytes};
6 ->
{Val,NewBytes} = begin
dec_SignalsDescriptor(Bytes2)
end,
{{signalsDescriptor,Val},NewBytes};
7 ->
{Val,NewBytes} = begin
dec_DigitMapDescriptor(Bytes2)
end,
{{digitMapDescriptor,Val},NewBytes};
8 ->
{Val,NewBytes} = begin
dec_ObservedEventsDescriptor(Bytes2)
end,
{{observedEventsDescriptor,Val},NewBytes};
9 ->
{Val,NewBytes} = begin
dec_StatisticsDescriptor(Bytes2)
end,
{{statisticsDescriptor,Val},NewBytes};
10 ->
{Val,NewBytes} = begin
dec_PackagesDescriptor(Bytes2)
end,
{{packagesDescriptor,Val},NewBytes};
11 ->
{Val,NewBytes} = begin
dec_AuditDescriptor(Bytes2)
end,
{{emptyDescriptors,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10}
end,
<<V1@V11:V1@V3/unit:8,V1@Buf12/bitstring>> = V1@Buf4,
{V1@V11,V1@Buf12}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
'enc_TerminationAudit'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_AuditReturnParameter(Comp) || Comp <- Val]].



dec_TerminationAudit(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components33(V1@V0, V1@Buf1, []).

'enc_AuditResult'(Val) ->
[begin
Enc1@input = element(2, Val),
enc_TerminationID(Enc1@input)
end|begin
Enc2@input = element(3, Val),
enc_TerminationAudit(Enc2@input)
end].


dec_AuditResult(Bytes) ->

%% attribute number 1 with type TerminationID
{Term1,Bytes1} = dec_TerminationID(Bytes),

%% attribute number 2 with type TerminationAudit
{Term2,Bytes2} = dec_TerminationAudit(Bytes1),
{{'AuditResult',Term1,Term2},Bytes2}.

'enc_AuditReply'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= contextAuditResult ->
[<<0:1,0:2>>|enc_TerminationIDList(ChoiceVal)];
ChoiceTag =:= error ->
[<<0:1,1:2>>|enc_ErrorDescriptor(ChoiceVal)];
ChoiceTag =:= auditResult ->
[<<0:1,2:2>>|enc_AuditResult(ChoiceVal)]
end.


dec_AuditReply(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_TerminationIDList(Bytes2)
end,
{{contextAuditResult,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_ErrorDescriptor(Bytes2)
end,
{{error,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_AuditResult(Bytes2)
end,
{{auditResult,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10}
end,
<<V1@V11:V1@V3/unit:8,V1@Buf12/bitstring>> = V1@Buf4,
{V1@V11,V1@Buf12}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
'enc_AuditRequest'(Val) ->
[<<0:1>>,
begin
Enc2@input = element(2, Val),
enc_TerminationID(Enc2@input)
end|begin
Enc3@input = element(3, Val),
enc_AuditDescriptor(Enc3@input)
end].


dec_AuditRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type TerminationID
{Term1,Bytes2} = dec_TerminationID(Bytes1),

%% attribute number 2 with type AuditDescriptor
{Term2,Bytes3} = dec_AuditDescriptor(Bytes2),

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V2@V0,V2@Buf1} = case Bytes3 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V11:V2@V0/bitstring-unit:1,V2@Buf12/bitstring>> = V2@Buf1,
{V2@V11,V2@Buf12}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
{{'AuditRequest',Term1,Term2},Bytes5}.

'enc_SubtractRequest'(Val) ->
[begin
Enc1@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
Enc3@input = element(2, Val),
enc_TerminationIDList(Enc3@input)
end|begin
Enc4@input = element(3, Val),
if Enc4@input =:= asn1_NOVALUE ->
[];
true ->
enc_AuditDescriptor(Enc4@input)
end
end].


dec_SubtractRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type TerminationIDList
{Term1,Bytes3} = dec_TerminationIDList(Bytes2),

%% attribute number 2 with type AuditDescriptor
{Term2,Bytes4} = case Opt band 1 of
1 ->
dec_AuditDescriptor(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V3@V0,V3@Buf1} = case Bytes4 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V11:V3@V0/bitstring-unit:1,V3@Buf12/bitstring>> = V3@Buf1,
{V3@V11,V3@Buf12}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
{{'SubtractRequest',Term1,Term2},Bytes6}.

'enc_AmmsReply'(Val) ->
[begin
Enc1@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end
end,
begin
Enc3@input = element(2, Val),
enc_TerminationIDList(Enc3@input)
end|begin
Enc4@input = element(3, Val),
if Enc4@input =:= asn1_NOVALUE ->
[];
true ->
enc_TerminationAudit(Enc4@input)
end
end].


dec_AmmsReply(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type TerminationIDList
{Term1,Bytes3} = dec_TerminationIDList(Bytes2),

%% attribute number 2 with type TerminationAudit
{Term2,Bytes4} = case Opt band 1 of
1 ->
dec_TerminationAudit(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V3@V0,V3@Buf1} = case Bytes4 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V11:V3@V0/bitstring-unit:1,V3@Buf12/bitstring>> = V3@Buf1,
{V3@V11,V3@Buf12}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
{{'AmmsReply',Term1,Term2},Bytes6}.

'enc_AmmDescriptor'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= mediaDescriptor ->
[<<0:1,0:3>>|enc_MediaDescriptor(ChoiceVal)];
ChoiceTag =:= modemDescriptor ->
[<<0:1,1:3>>|enc_ModemDescriptor(ChoiceVal)];
ChoiceTag =:= muxDescriptor ->
[<<0:1,2:3>>|enc_MuxDescriptor(ChoiceVal)];
ChoiceTag =:= eventsDescriptor ->
[<<0:1,3:3>>|enc_EventsDescriptor(ChoiceVal)];
ChoiceTag =:= eventBufferDescriptor ->
[<<0:1,4:3>>|enc_EventBufferDescriptor(ChoiceVal)];
ChoiceTag =:= signalsDescriptor ->
[<<0:1,5:3>>|enc_SignalsDescriptor(ChoiceVal)];
ChoiceTag =:= digitMapDescriptor ->
[<<0:1,6:3>>|enc_DigitMapDescriptor(ChoiceVal)];
ChoiceTag =:= auditDescriptor ->
[<<0:1,7:3>>|enc_AuditDescriptor(ChoiceVal)];
ChoiceTag =:= statisticsDescriptor ->
begin
Enc9@output = enc_StatisticsDescriptor(ChoiceVal),
Enc10@bin = complete(Enc9@output),
Enc10@len = byte_size(Enc10@bin),
if Enc10@len < 128 ->
[<<1:1,0:7>>,
align,
Enc10@len|Enc10@bin];
Enc10@len < 16384 ->
[<<1:1,0:7>>,
align,
<<2:2,Enc10@len:14>>|Enc10@bin];
true ->
[<<1:1,0:7>>,
align|encode_fragmented(Enc10@bin, 8)]
end
end
end.


dec_AmmDescriptor(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:3/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_MediaDescriptor(Bytes2)
end,
{{mediaDescriptor,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_ModemDescriptor(Bytes2)
end,
{{modemDescriptor,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_MuxDescriptor(Bytes2)
end,
{{muxDescriptor,Val},NewBytes};
3 ->
{Val,NewBytes} = begin
dec_EventsDescriptor(Bytes2)
end,
{{eventsDescriptor,Val},NewBytes};
4 ->
{Val,NewBytes} = begin
dec_EventBufferDescriptor(Bytes2)
end,
{{eventBufferDescriptor,Val},NewBytes};
5 ->
{Val,NewBytes} = begin
dec_SignalsDescriptor(Bytes2)
end,
{{signalsDescriptor,Val},NewBytes};
6 ->
{Val,NewBytes} = begin
dec_DigitMapDescriptor(Bytes2)
end,
{{digitMapDescriptor,Val},NewBytes};
7 ->
{Val,NewBytes} = begin
dec_AuditDescriptor(Bytes2)
end,
{{auditDescriptor,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10}
end,
<<V1@V11:V1@V3/unit:8,V1@Buf12/bitstring>> = V1@Buf4,
{V1@V11,V1@Buf12}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
0 ->
{Val,NewBytes} = begin
{TmpVal,_} = dec_StatisticsDescriptor(V2@V0),
{TmpVal,V2@Buf1}
end,
{{statisticsDescriptor,Val},NewBytes};
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
'enc_AmmRequest'(Val) ->
[<<0:1>>,
begin
Enc2@input = element(2, Val),
enc_TerminationIDList(Enc2@input)
end|begin
Enc3@input = element(3, Val),
enc_AmmRequest_descriptors(Enc3@input)
end].
'enc_AmmRequest_descriptors'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_AmmDescriptor(Comp) || Comp <- Val]].


dec_AmmRequest_descriptors(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components34(V1@V0, V1@Buf1, []).



dec_AmmRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type TerminationIDList
{Term1,Bytes2} = dec_TerminationIDList(Bytes1),

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes3} = 'dec_AmmRequest_descriptors'(Bytes2),

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V2@V0,V2@Buf1} = case Bytes3 of
<<0:1,V2@V3:6,V2@Buf4/bitstring>> ->
V2@Add5 = V2@V3 + 1,
{V2@Add5,V2@Buf4};
<<1:1,V2@Buf2/bitstring>> ->
V2@Pad6 = bit_size(V2@Buf2) band 7,
{V2@V3,V2@Buf4} = case V2@Buf2 of
<<_:V2@Pad6,0:1,V2@V8:7,V2@Buf9/bitstring>> when V2@V8 =/= 0 ->
{V2@V8,V2@Buf9};
<<_:V2@Pad6,1:1,0:1,V2@V9:14,V2@Buf10/bitstring>> when V2@V9 =/= 0 ->
{V2@V9,V2@Buf10}
end,
{V2@V3,V2@Buf4}
end,
<<V2@V11:V2@V0/bitstring-unit:1,V2@Buf12/bitstring>> = V2@Buf1,
{V2@V11,V2@Buf12}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
{{'AmmRequest',Term1,Term2},Bytes5}.

'enc_TopologyRequest'(Val) ->
Enc1@bitmap = extension_bitmap(Val, 5, 6),
Extensions = if Enc1@bitmap =:= 0 ->
[];
true ->
<<0:7,1:1>>
end,
[if Extensions =:= [] ->
<<0:1>>;
true ->
<<1:1>>
end,
begin
Enc3@input = element(2, Val),
enc_TerminationID(Enc3@input)
end,
begin
Enc4@input = element(3, Val),
enc_TerminationID(Enc4@input)
end,
begin
Enc5@input = element(4, Val),
if Enc5@input =:= bothway ->
<<0:2>>;
Enc5@input =:= isolate ->
<<1:2>>;
Enc5@input =:= oneway ->
<<2:2>>;
true ->
exit({error,{asn1,{illegal_value,Enc5@input}}})
end
end,
Extensions|begin
Enc7@input = element(5, Val),
if Enc7@input =:= asn1_NOVALUE ->
[];
Enc7@input bsr 16 =:= 0 ->
[align|<<2:8,Enc7@input:16>>];
true ->
exit({error,{asn1,{illegal_value,Enc7@input}}})
end
end].


dec_TopologyRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type TerminationID
{Term1,Bytes2} = dec_TerminationID(Bytes1),

%% attribute number 2 with type TerminationID
{Term2,Bytes3} = dec_TerminationID(Bytes2),

%% attribute number 3 with type ENUMERATED
{Term3,Bytes4} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes3,
V2@Int2 = case V2@V0 of
0 -> bothway;
1 -> isolate;
2 -> oneway;
_ -> exit({error,{asn1,{decode_enumerated,{V2@V0,[bothway,isolate,oneway]}}}})
end,
{V2@Int2,V2@Buf1}
end,

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V3@V0,V3@Buf1} = case Bytes4 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V11:V3@V0/bitstring-unit:1,V3@Buf12/bitstring>> = V3@Buf1,
{V3@V11,V3@Buf12}
end,

%% attribute number 4 with type INTEGER
{Term4,Bytes6} = case Extensions of
  <<_:0,1:1,_/bitstring>> ->
begin
V4@Pad3 = bit_size(Bytes5) band 7,
{V4@V0,V4@Buf1} = case Bytes5 of
<<_:V4@Pad3,0:1,V4@V5:7,V4@V7:V4@V5/binary-unit:8,V4@Buf8/bitstring>> ->
{V4@V7,V4@Buf8};
<<_:V4@Pad3,1:1,0:1,V4@V6:14,V4@V8:V4@V6/binary-unit:8,V4@Buf9/bitstring>> ->
{V4@V8,V4@Buf9};
<<_:V4@Pad3,1:1,1:1,V4@V6:6,V4@Buf7/bitstring>> ->
{V4@V8,V4@Buf9}  = decode_fragmented(V4@V6, V4@Buf7, 8),
{V4@V8,V4@Buf9}
end,
{TmpValx4,_} = begin
V5@Pad2 = bit_size(V4@V0) band 7,
<<_:V5@Pad2,V5@V0:2/unsigned-unit:8,V5@Buf1/bitstring>> = V4@V0,
{V5@V0,V5@Buf1}
end,
{TmpValx4,V4@Buf1}
end;
_  ->
{asn1_NOVALUE,Bytes5}
end,
Bytes7= skipextensions(Bytes6, 2, Extensions),
{{'TopologyRequest',Term1,Term2,Term3,Term4},Bytes7}.

'enc_CommandReply'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= addReply ->
[<<0:1,0:3>>|enc_AmmsReply(ChoiceVal)];
ChoiceTag =:= moveReply ->
[<<0:1,1:3>>|enc_AmmsReply(ChoiceVal)];
ChoiceTag =:= modReply ->
[<<0:1,2:3>>|enc_AmmsReply(ChoiceVal)];
ChoiceTag =:= subtractReply ->
[<<0:1,3:3>>|enc_AmmsReply(ChoiceVal)];
ChoiceTag =:= auditCapReply ->
[<<0:1,4:3>>|enc_AuditReply(ChoiceVal)];
ChoiceTag =:= auditValueReply ->
[<<0:1,5:3>>|enc_AuditReply(ChoiceVal)];
ChoiceTag =:= notifyReply ->
[<<0:1,6:3>>|enc_NotifyReply(ChoiceVal)];
ChoiceTag =:= serviceChangeReply ->
[<<0:1,7:3>>|enc_ServiceChangeReply(ChoiceVal)]
end.


dec_CommandReply(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:3/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_AmmsReply(Bytes2)
end,
{{addReply,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_AmmsReply(Bytes2)
end,
{{moveReply,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_AmmsReply(Bytes2)
end,
{{modReply,Val},NewBytes};
3 ->
{Val,NewBytes} = begin
dec_AmmsReply(Bytes2)
end,
{{subtractReply,Val},NewBytes};
4 ->
{Val,NewBytes} = begin
dec_AuditReply(Bytes2)
end,
{{auditCapReply,Val},NewBytes};
5 ->
{Val,NewBytes} = begin
dec_AuditReply(Bytes2)
end,
{{auditValueReply,Val},NewBytes};
6 ->
{Val,NewBytes} = begin
dec_NotifyReply(Bytes2)
end,
{{notifyReply,Val},NewBytes};
7 ->
{Val,NewBytes} = begin
dec_ServiceChangeReply(Bytes2)
end,
{{serviceChangeReply,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10}
end,
<<V1@V11:V1@V3/unit:8,V1@Buf12/bitstring>> = V1@Buf4,
{V1@V11,V1@Buf12}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
'enc_Command'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= addReq ->
[<<0:1,0:3>>|enc_AmmRequest(ChoiceVal)];
ChoiceTag =:= moveReq ->
[<<0:1,1:3>>|enc_AmmRequest(ChoiceVal)];
ChoiceTag =:= modReq ->
[<<0:1,2:3>>|enc_AmmRequest(ChoiceVal)];
ChoiceTag =:= subtractReq ->
[<<0:1,3:3>>|enc_SubtractRequest(ChoiceVal)];
ChoiceTag =:= auditCapRequest ->
[<<0:1,4:3>>|enc_AuditRequest(ChoiceVal)];
ChoiceTag =:= auditValueRequest ->
[<<0:1,5:3>>|enc_AuditRequest(ChoiceVal)];
ChoiceTag =:= notifyReq ->
[<<0:1,6:3>>|enc_NotifyRequest(ChoiceVal)];
ChoiceTag =:= serviceChangeReq ->
[<<0:1,7:3>>|enc_ServiceChangeRequest(ChoiceVal)]
end.


dec_Command(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:3/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_AmmRequest(Bytes2)
end,
{{addReq,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_AmmRequest(Bytes2)
end,
{{moveReq,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_AmmRequest(Bytes2)
end,
{{modReq,Val},NewBytes};
3 ->
{Val,NewBytes} = begin
dec_SubtractRequest(Bytes2)
end,
{{subtractReq,Val},NewBytes};
4 ->
{Val,NewBytes} = begin
dec_AuditRequest(Bytes2)
end,
{{auditCapRequest,Val},NewBytes};
5 ->
{Val,NewBytes} = begin
dec_AuditRequest(Bytes2)
end,
{{auditValueRequest,Val},NewBytes};
6 ->
{Val,NewBytes} = begin
dec_NotifyRequest(Bytes2)
end,
{{notifyReq,Val},NewBytes};
7 ->
{Val,NewBytes} = begin
dec_ServiceChangeRequest(Bytes2)
end,
{{serviceChangeReq,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10}
end,
<<V1@V11:V1@V3/unit:8,V1@Buf12/bitstring>> = V1@Buf4,
{V1@V11,V1@Buf12}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
'enc_CommandRequest'(Val) ->
[begin
Enc1@input = element(3, Val),
Enc2@input = element(4, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1,0:1>>;
true ->
<<0:1,0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,1:1,0:1>>;
true ->
<<0:1,1:1,1:1>>
end
end
end,
begin
Enc4@input = element(2, Val),
enc_Command(Enc4@input)
end,
begin
Enc5@input = element(3, Val),
if Enc5@input =:= asn1_NOVALUE ->
[];
true ->
[]
end
end|begin
Enc7@input = element(4, Val),
if Enc7@input =:= asn1_NOVALUE ->
[];
true ->
[]
end
end].


dec_CommandRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:2,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type Command
{Term1,Bytes3} = dec_Command(Bytes2),

%% attribute number 2 with type NULL
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
ignore,
{'NULL',Bytes3}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type NULL
{Term3,Bytes5} = case Opt band 1 of
1 ->
begin
ignore,
{'NULL',Bytes4}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V5@V0,V5@Buf1} = case Bytes5 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V11:V5@V0/bitstring-unit:1,V5@Buf12/bitstring>> = V5@Buf1,
{V5@V11,V5@Buf12}
end,
Bytes7= skipextensions(Bytes6, 1, Extensions),
{{'CommandRequest',Term1,Term2,Term3},Bytes7}.

'enc_ContextAttrAuditRequest'(Val) ->
Enc4@bitmap = extension_bitmap(Val, 5, 7),
Extensions = if Enc4@bitmap =:= 0 ->
[];
true ->
<<1:7,Enc4@bitmap:2>>
end,
[begin
Enc1@input = element(2, Val),
if Extensions =:= [] ->
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc1@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc2@input = element(3, Val),
Enc3@input = element(4, Val),
if Enc2@input =:= asn1_NOVALUE ->
if Enc3@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc3@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc6@input = element(2, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
true ->
[]
end
end,
begin
Enc8@input = element(3, Val),
if Enc8@input =:= asn1_NOVALUE ->
[];
true ->
[]
end
end,
begin
Enc10@input = element(4, Val),
if Enc10@input =:= asn1_NOVALUE ->
[];
true ->
[]
end
end,
Extensions,
begin
Enc12@input = element(5, Val),
if Enc12@input =:= asn1_NOVALUE ->
[];
true ->
[align,
1,
0]
end
end|begin
Enc14@input = element(6, Val),
if Enc14@input =:= asn1_NOVALUE ->
[];
true ->
begin
Enc15@output = enc_ContextAttrAuditRequest_contextPropAud(Enc14@input),
Enc16@bin = complete(Enc15@output),
Enc16@len = byte_size(Enc16@bin),
if Enc16@len < 128 ->
[align,
Enc16@len|Enc16@bin];
Enc16@len < 16384 ->
[align,
<<2:2,Enc16@len:14>>|Enc16@bin];
true ->
[align|encode_fragmented(Enc16@bin, 8)]
end
end
end
end].
'enc_ContextAttrAuditRequest_contextPropAud'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_IndAudPropertyParm(Comp) || Comp <- Val]].


dec_ContextAttrAuditRequest_contextPropAud(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components35(V1@V0, V1@Buf1, []).



dec_ContextAttrAuditRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:3,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type NULL
{Term1,Bytes3} = case (Opt bsr 2) band 1 of
1 ->
begin
ignore,
{'NULL',Bytes2}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 2 with type NULL
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
ignore,
{'NULL',Bytes3}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type NULL
{Term3,Bytes5} = case Opt band 1 of
1 ->
begin
ignore,
{'NULL',Bytes4}
end;
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V6@V0,V6@Buf1} = case Bytes5 of
<<0:1,V6@V3:6,V6@Buf4/bitstring>> ->
V6@Add5 = V6@V3 + 1,
{V6@Add5,V6@Buf4};
<<1:1,V6@Buf2/bitstring>> ->
V6@Pad6 = bit_size(V6@Buf2) band 7,
{V6@V3,V6@Buf4} = case V6@Buf2 of
<<_:V6@Pad6,0:1,V6@V8:7,V6@Buf9/bitstring>> when V6@V8 =/= 0 ->
{V6@V8,V6@Buf9};
<<_:V6@Pad6,1:1,0:1,V6@V9:14,V6@Buf10/bitstring>> when V6@V9 =/= 0 ->
{V6@V9,V6@Buf10}
end,
{V6@V3,V6@Buf4}
end,
<<V6@V11:V6@V0/bitstring-unit:1,V6@Buf12/bitstring>> = V6@Buf1,
{V6@V11,V6@Buf12}
end,

%% attribute number 4 with type NULL
{Term4,Bytes7} = case Extensions of
  <<_:0,1:1,_/bitstring>> ->
begin
V7@Pad3 = bit_size(Bytes6) band 7,
{V7@V0,V7@Buf1} = case Bytes6 of
<<_:V7@Pad3,0:1,V7@V5:7,V7@V7:V7@V5/binary-unit:8,V7@Buf8/bitstring>> ->
{V7@V7,V7@Buf8};
<<_:V7@Pad3,1:1,0:1,V7@V6:14,V7@V8:V7@V6/binary-unit:8,V7@Buf9/bitstring>> ->
{V7@V8,V7@Buf9};
<<_:V7@Pad3,1:1,1:1,V7@V6:6,V7@Buf7/bitstring>> ->
{V7@V8,V7@Buf9}  = decode_fragmented(V7@V6, V7@Buf7, 8),
{V7@V8,V7@Buf9}
end,
{TmpValx4,_} = begin
ignore,
{'NULL',V7@V0}
end,
{TmpValx4,V7@Buf1}
end;
_  ->
{asn1_NOVALUE,Bytes6}
end,

%% attribute number 5 with type SEQUENCE OF
{Term5,Bytes8} = case Extensions of
  <<_:1,1:1,_/bitstring>> ->
begin
V9@Pad3 = bit_size(Bytes7) band 7,
{V9@V0,V9@Buf1} = case Bytes7 of
<<_:V9@Pad3,0:1,V9@V5:7,V9@V7:V9@V5/binary-unit:8,V9@Buf8/bitstring>> ->
{V9@V7,V9@Buf8};
<<_:V9@Pad3,1:1,0:1,V9@V6:14,V9@V8:V9@V6/binary-unit:8,V9@Buf9/bitstring>> ->
{V9@V8,V9@Buf9};
<<_:V9@Pad3,1:1,1:1,V9@V6:6,V9@Buf7/bitstring>> ->
{V9@V8,V9@Buf9}  = decode_fragmented(V9@V6, V9@Buf7, 8),
{V9@V8,V9@Buf9}
end,
{TmpValx5,_} = 'dec_ContextAttrAuditRequest_contextPropAud'(V9@V0),
{TmpValx5,V9@Buf1}
end;
_  ->
{asn1_NOVALUE,Bytes7}
end,
Bytes9= skipextensions(Bytes8, 3, Extensions),
{{'ContextAttrAuditRequest',Term1,Term2,Term3,Term4,Term5},Bytes9}.

'enc_ContextRequest'(Val) ->
Enc4@bitmap = extension_bitmap(Val, 5, 7),
Extensions = if Enc4@bitmap =:= 0 ->
[];
true ->
<<1:7,Enc4@bitmap:2>>
end,
[begin
Enc1@input = element(2, Val),
if Extensions =:= [] ->
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc1@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc2@input = element(3, Val),
Enc3@input = element(4, Val),
if Enc2@input =:= asn1_NOVALUE ->
if Enc3@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc3@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc6@input = element(2, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
Enc6@input bsr 4 =:= 0 ->
<<Enc6@input:4>>;
true ->
exit({error,{asn1,{illegal_value,Enc6@input}}})
end
end,
begin
Enc9@input = element(3, Val),
if Enc9@input =:= asn1_NOVALUE ->
[];
Enc9@input =:= false ->
<<0:1>>;
Enc9@input =:= true ->
<<1:1>>
end
end,
begin
Enc12@input = element(4, Val),
if Enc12@input =:= asn1_NOVALUE ->
[];
true ->
enc_ContextRequest_topologyReq(Enc12@input)
end
end,
Extensions,
begin
Enc14@input = element(5, Val),
if Enc14@input =:= asn1_NOVALUE ->
[];
Enc14@input =:= false ->
[align|<<1:8,0:1,0:7>>];
Enc14@input =:= true ->
[align|<<1:8,1:1,0:7>>]
end
end|begin
Enc17@input = element(6, Val),
if Enc17@input =:= asn1_NOVALUE ->
[];
true ->
begin
Enc18@output = enc_ContextRequest_contextProp(Enc17@input),
Enc19@bin = complete(Enc18@output),
Enc19@len = byte_size(Enc19@bin),
if Enc19@len < 128 ->
[align,
Enc19@len|Enc19@bin];
Enc19@len < 16384 ->
[align,
<<2:2,Enc19@len:14>>|Enc19@bin];
true ->
[align|encode_fragmented(Enc19@bin, 8)]
end
end
end
end].
'enc_ContextRequest_topologyReq'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_TopologyRequest(Comp) || Comp <- Val]].


dec_ContextRequest_topologyReq(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components36(V1@V0, V1@Buf1, []).

'enc_ContextRequest_contextProp'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_PropertyParm(Comp) || Comp <- Val]].


dec_ContextRequest_contextProp(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components37(V1@V0, V1@Buf1, []).



dec_ContextRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:3,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type INTEGER
{Term1,Bytes3} = case (Opt bsr 2) band 1 of
1 ->
begin
<<V3@V0:4/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 2 with type BOOLEAN
{Term2,Bytes4} = case (Opt bsr 1) band 1 of
1 ->
begin
<<V4@V0:1,V4@Buf1/bitstring>> = Bytes3,
V4@Int2 = case V4@V0 of
0 -> false;
1 -> true
end,
{V4@Int2,V4@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type SEQUENCE OF
{Term3,Bytes5} = case Opt band 1 of
1 ->
'dec_ContextRequest_topologyReq'(Bytes4);
0 ->
{asn1_NOVALUE,Bytes4}
end,

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V5@V0,V5@Buf1} = case Bytes5 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V11:V5@V0/bitstring-unit:1,V5@Buf12/bitstring>> = V5@Buf1,
{V5@V11,V5@Buf12}
end,

%% attribute number 4 with type BOOLEAN
{Term4,Bytes7} = case Extensions of
  <<_:0,1:1,_/bitstring>> ->
begin
V6@Pad3 = bit_size(Bytes6) band 7,
{V6@V0,V6@Buf1} = case Bytes6 of
<<_:V6@Pad3,0:1,V6@V5:7,V6@V7:V6@V5/binary-unit:8,V6@Buf8/bitstring>> ->
{V6@V7,V6@Buf8};
<<_:V6@Pad3,1:1,0:1,V6@V6:14,V6@V8:V6@V6/binary-unit:8,V6@Buf9/bitstring>> ->
{V6@V8,V6@Buf9};
<<_:V6@Pad3,1:1,1:1,V6@V6:6,V6@Buf7/bitstring>> ->
{V6@V8,V6@Buf9}  = decode_fragmented(V6@V6, V6@Buf7, 8),
{V6@V8,V6@Buf9}
end,
{TmpValx4,_} = begin
<<V7@V0:1,V7@Buf1/bitstring>> = V6@V0,
V7@Int2 = case V7@V0 of
0 -> false;
1 -> true
end,
{V7@Int2,V7@Buf1}
end,
{TmpValx4,V6@Buf1}
end;
_  ->
{asn1_NOVALUE,Bytes6}
end,

%% attribute number 5 with type SEQUENCE OF
{Term5,Bytes8} = case Extensions of
  <<_:1,1:1,_/bitstring>> ->
begin
V8@Pad3 = bit_size(Bytes7) band 7,
{V8@V0,V8@Buf1} = case Bytes7 of
<<_:V8@Pad3,0:1,V8@V5:7,V8@V7:V8@V5/binary-unit:8,V8@Buf8/bitstring>> ->
{V8@V7,V8@Buf8};
<<_:V8@Pad3,1:1,0:1,V8@V6:14,V8@V8:V8@V6/binary-unit:8,V8@Buf9/bitstring>> ->
{V8@V8,V8@Buf9};
<<_:V8@Pad3,1:1,1:1,V8@V6:6,V8@Buf7/bitstring>> ->
{V8@V8,V8@Buf9}  = decode_fragmented(V8@V6, V8@Buf7, 8),
{V8@V8,V8@Buf9}
end,
{TmpValx5,_} = 'dec_ContextRequest_contextProp'(V8@V0),
{TmpValx5,V8@Buf1}
end;
_  ->
{asn1_NOVALUE,Bytes7}
end,
Bytes9= skipextensions(Bytes8, 3, Extensions),
{{'ContextRequest',Term1,Term2,Term3,Term4,Term5},Bytes9}.

'enc_ActionReply'(Val) ->
[begin
Enc1@input = element(3, Val),
Enc2@input = element(4, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc3@input = element(2, Val),
if Enc3@input bsr 32 =:= 0 ->
begin
Enc3@input@bin = binary:encode_unsigned(Enc3@input),
Enc3@input@bin_size0 = byte_size(Enc3@input@bin),
Enc3@input@bin_size = Enc3@input@bin_size0 - 1,
[<<Enc3@input@bin_size:2>>,
align|Enc3@input@bin]
end;
true ->
exit({error,{asn1,{illegal_value,Enc3@input}}})
end
end,
begin
Enc5@input = element(3, Val),
if Enc5@input =:= asn1_NOVALUE ->
[];
true ->
enc_ErrorDescriptor(Enc5@input)
end
end,
begin
Enc7@input = element(4, Val),
if Enc7@input =:= asn1_NOVALUE ->
[];
true ->
enc_ContextRequest(Enc7@input)
end
end|begin
Enc9@input = element(5, Val),
enc_ActionReply_commandReply(Enc9@input)
end].
'enc_ActionReply_commandReply'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_CommandReply(Comp) || Comp <- Val]].


dec_ActionReply_commandReply(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components38(V1@V0, V1@Buf1, []).



dec_ActionReply(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:2,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type INTEGER
{Term1,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Add2 = V2@V0 + 1,
V2@Pad5 = bit_size(V2@Buf1) band 7,
<<_:V2@Pad5,V2@V3:V2@Add2/unsigned-unit:8,V2@Buf4/bitstring>> = V2@Buf1,
{V2@V3,V2@Buf4}
end,

%% attribute number 2 with type ErrorDescriptor
{Term2,Bytes3} = case (Opt bsr 1) band 1 of
1 ->
dec_ErrorDescriptor(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 3 with type ContextRequest
{Term3,Bytes4} = case Opt band 1 of
1 ->
dec_ContextRequest(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 4 with type SEQUENCE OF
{Term4,Bytes5} = 'dec_ActionReply_commandReply'(Bytes4),
{{'ActionReply',Term1,Term2,Term3,Term4},Bytes5}.

'enc_ActionRequest'(Val) ->
[begin
Enc1@input = element(3, Val),
Enc2@input = element(4, Val),
if Enc1@input =:= asn1_NOVALUE ->
if Enc2@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc2@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc3@input = element(2, Val),
if Enc3@input bsr 32 =:= 0 ->
begin
Enc3@input@bin = binary:encode_unsigned(Enc3@input),
Enc3@input@bin_size0 = byte_size(Enc3@input@bin),
Enc3@input@bin_size = Enc3@input@bin_size0 - 1,
[<<Enc3@input@bin_size:2>>,
align|Enc3@input@bin]
end;
true ->
exit({error,{asn1,{illegal_value,Enc3@input}}})
end
end,
begin
Enc5@input = element(3, Val),
if Enc5@input =:= asn1_NOVALUE ->
[];
true ->
enc_ContextRequest(Enc5@input)
end
end,
begin
Enc7@input = element(4, Val),
if Enc7@input =:= asn1_NOVALUE ->
[];
true ->
enc_ContextAttrAuditRequest(Enc7@input)
end
end|begin
Enc9@input = element(5, Val),
enc_ActionRequest_commandRequests(Enc9@input)
end].
'enc_ActionRequest_commandRequests'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_CommandRequest(Comp) || Comp <- Val]].


dec_ActionRequest_commandRequests(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components39(V1@V0, V1@Buf1, []).



dec_ActionRequest(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:2,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type INTEGER
{Term1,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Add2 = V2@V0 + 1,
V2@Pad5 = bit_size(V2@Buf1) band 7,
<<_:V2@Pad5,V2@V3:V2@Add2/unsigned-unit:8,V2@Buf4/bitstring>> = V2@Buf1,
{V2@V3,V2@Buf4}
end,

%% attribute number 2 with type ContextRequest
{Term2,Bytes3} = case (Opt bsr 1) band 1 of
1 ->
dec_ContextRequest(Bytes2);
0 ->
{asn1_NOVALUE,Bytes2}
end,

%% attribute number 3 with type ContextAttrAuditRequest
{Term3,Bytes4} = case Opt band 1 of
1 ->
dec_ContextAttrAuditRequest(Bytes3);
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 4 with type SEQUENCE OF
{Term4,Bytes5} = 'dec_ActionRequest_commandRequests'(Bytes4),
{{'ActionRequest',Term1,Term2,Term3,Term4},Bytes5}.

'enc_ContextID'(Val) ->
if Val bsr 32 =:= 0 ->
begin
Val@bin = binary:encode_unsigned(Val),
Val@bin_size0 = byte_size(Val@bin),
Val@bin_size = Val@bin_size0 - 1,
[<<Val@bin_size:2>>,
align|Val@bin]
end;
true ->
exit({error,{asn1,{illegal_value,Val}}})
end.


dec_ContextID(Bytes) ->
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Add2 = V1@V0 + 1,
V1@Pad5 = bit_size(V1@Buf1) band 7,
<<_:V1@Pad5,V1@V3:V1@Add2/unsigned-unit:8,V1@Buf4/bitstring>> = V1@Buf1,
{V1@V3,V1@Buf4}
end.

'enc_ErrorText'(Val) ->
Enc1@bin = list_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len < 128 ->
[align,
Enc1@len|Enc1@bin];
Enc1@len < 16384 ->
[align,
<<2:2,Enc1@len:14>>|Enc1@bin];
true ->
[align|encode_fragmented(Enc1@bin, 8)]
end.


dec_ErrorText(Bytes) ->
begin
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@V7:V1@V5/binary-unit:8,V1@Buf8/bitstring>> ->
{V1@V7,V1@Buf8};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@V8:V1@V6/binary-unit:8,V1@Buf9/bitstring>> ->
{V1@V8,V1@Buf9};
<<_:V1@Pad3,1:1,1:1,V1@V6:6,V1@Buf7/bitstring>> ->
{V1@V8,V1@Buf9}  = decode_fragmented(V1@V6, V1@Buf7, 8),
{V1@V8,V1@Buf9}
end,
V1@Conv10 = binary_to_list(V1@V0),
{V1@Conv10,V1@Buf1}
end.

'enc_ErrorCode'(Val) ->
if Val bsr 16 =:= 0 ->
[align|<<Val:16>>];
true ->
exit({error,{asn1,{illegal_value,Val}}})
end.


dec_ErrorCode(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end.

'enc_ErrorDescriptor'(Val) ->
[begin
Enc1@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
align,
begin
Enc2@input = element(2, Val),
if Enc2@input bsr 16 =:= 0 ->
<<Enc2@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc2@input}}})
end
end|begin
Enc4@input = element(3, Val),
if Enc4@input =:= asn1_NOVALUE ->
[];
true ->
begin
Enc5@bin = list_to_binary(Enc4@input),
Enc5@len = byte_size(Enc5@bin),
if Enc5@len < 128 ->
[Enc5@len|Enc5@bin];
Enc5@len < 16384 ->
[<<2:2,Enc5@len:14>>|Enc5@bin];
true ->
encode_fragmented(Enc5@bin, 8)
end
end
end
end].


dec_ErrorDescriptor(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type INTEGER
{Term1,Bytes2} = begin
V2@Pad2 = bit_size(Bytes1) band 7,
<<_:V2@Pad2,V2@V0:2/unsigned-unit:8,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 2 with type IA5String
{Term2,Bytes3} = case Opt band 1 of
1 ->
begin
V3@Pad3 = bit_size(Bytes2) band 7,
{V3@V0,V3@Buf1} = case Bytes2 of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
V3@Conv10 = binary_to_list(V3@V0),
{V3@Conv10,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,
{{'ErrorDescriptor',Term1,Term2},Bytes3}.

'enc_TransactionAck'(Val) ->
[begin
Enc1@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
begin
Enc2@input = element(2, Val),
if Enc2@input bsr 32 =:= 0 ->
begin
Enc2@input@bin = binary:encode_unsigned(Enc2@input),
Enc2@input@bin_size0 = byte_size(Enc2@input@bin),
Enc2@input@bin_size = Enc2@input@bin_size0 - 1,
[<<Enc2@input@bin_size:2>>,
align|Enc2@input@bin]
end;
true ->
exit({error,{asn1,{illegal_value,Enc2@input}}})
end
end|begin
Enc4@input = element(3, Val),
if Enc4@input =:= asn1_NOVALUE ->
[];
Enc4@input bsr 32 =:= 0 ->
begin
Enc4@input@bin = binary:encode_unsigned(Enc4@input),
Enc4@input@bin_size0 = byte_size(Enc4@input@bin),
Enc4@input@bin_size = Enc4@input@bin_size0 - 1,
[<<Enc4@input@bin_size:2,0:6>>|Enc4@input@bin]
end;
true ->
exit({error,{asn1,{illegal_value,Enc4@input}}})
end
end].


dec_TransactionAck(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type INTEGER
{Term1,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Add2 = V2@V0 + 1,
V2@Pad5 = bit_size(V2@Buf1) band 7,
<<_:V2@Pad5,V2@V3:V2@Add2/unsigned-unit:8,V2@Buf4/bitstring>> = V2@Buf1,
{V2@V3,V2@Buf4}
end,

%% attribute number 2 with type INTEGER
{Term2,Bytes3} = case Opt band 1 of
1 ->
begin
<<V3@V0:2/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
V3@Add2 = V3@V0 + 1,
V3@Pad5 = bit_size(V3@Buf1) band 7,
<<_:V3@Pad5,V3@V3:V3@Add2/unsigned-unit:8,V3@Buf4/bitstring>> = V3@Buf1,
{V3@V3,V3@Buf4}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,
{{'TransactionAck',Term1,Term2},Bytes3}.

'enc_TransactionResponseAck'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_TransactionAck(Comp) || Comp <- Val]].



dec_TransactionResponseAck(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components40(V1@V0, V1@Buf1, []).

'enc_SegmentNumber'(Val) ->
if Val bsr 16 =:= 0 ->
[align|<<Val:16>>];
true ->
exit({error,{asn1,{illegal_value,Val}}})
end.


dec_SegmentNumber(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:2/unsigned-unit:8,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end.

'enc_TransactionReply'(Val) ->
Enc2@bitmap = extension_bitmap(Val, 5, 7),
Extensions = if Enc2@bitmap =:= 0 ->
[];
true ->
<<1:7,Enc2@bitmap:2>>
end,
[begin
Enc1@input = element(3, Val),
if Extensions =:= [] ->
if Enc1@input =:= asn1_NOVALUE ->
<<0:1,0:1>>;
true ->
<<0:1,1:1>>
end;
true ->
if Enc1@input =:= asn1_NOVALUE ->
<<1:1,0:1>>;
true ->
<<1:1,1:1>>
end
end
end,
begin
Enc4@input = element(2, Val),
if Enc4@input bsr 32 =:= 0 ->
begin
Enc4@input@bin = binary:encode_unsigned(Enc4@input),
Enc4@input@bin_size0 = byte_size(Enc4@input@bin),
Enc4@input@bin_size = Enc4@input@bin_size0 - 1,
[<<Enc4@input@bin_size:2>>,
align|Enc4@input@bin]
end;
true ->
exit({error,{asn1,{illegal_value,Enc4@input}}})
end
end,
begin
Enc6@input = element(3, Val),
if Enc6@input =:= asn1_NOVALUE ->
[];
true ->
[]
end
end,
begin
Enc8@input = element(4, Val),
enc_TransactionReply_transactionResult(Enc8@input)
end,
Extensions,
begin
Enc9@input = element(5, Val),
if Enc9@input =:= asn1_NOVALUE ->
[];
Enc9@input bsr 16 =:= 0 ->
[align|<<2:8,Enc9@input:16>>];
true ->
exit({error,{asn1,{illegal_value,Enc9@input}}})
end
end|begin
Enc12@input = element(6, Val),
if Enc12@input =:= asn1_NOVALUE ->
[];
true ->
[align,
1,
0]
end
end].
'enc_TransactionReply_transactionResult'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= transactionError ->
[<<0:1>>|enc_ErrorDescriptor(ChoiceVal)];
ChoiceTag =:= actionReplies ->
[<<1:1>>|enc_TransactionReply_transactionResult_actionReplies(ChoiceVal)]
end.
'enc_TransactionReply_transactionResult_actionReplies'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_ActionReply(Comp) || Comp <- Val]].


dec_TransactionReply_transactionResult_actionReplies(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components41(V1@V0, V1@Buf1, []).


dec_TransactionReply_transactionResult(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:1/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_ErrorDescriptor(Bytes1)
end,
{{transactionError,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
'dec_TransactionReply_transactionResult_actionReplies'(Bytes1)
end,
{{actionReplies,Val},NewBytes}
end.


dec_TransactionReply(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
{Opt,Bytes2} = begin
<<V2@V0:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 1 with type INTEGER
{Term1,Bytes3} = begin
<<V3@V0:2/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
V3@Add2 = V3@V0 + 1,
V3@Pad5 = bit_size(V3@Buf1) band 7,
<<_:V3@Pad5,V3@V3:V3@Add2/unsigned-unit:8,V3@Buf4/bitstring>> = V3@Buf1,
{V3@V3,V3@Buf4}
end,

%% attribute number 2 with type NULL
{Term2,Bytes4} = case Opt band 1 of
1 ->
begin
ignore,
{'NULL',Bytes3}
end;
0 ->
{asn1_NOVALUE,Bytes3}
end,

%% attribute number 3 with type CHOICE
{Term3,Bytes5} = 'dec_TransactionReply_transactionResult'(Bytes4),

%% Extensions
{Extensions,Bytes6} = case Ext of
0 -> {<<>>,Bytes5};
1 ->
{V5@V0,V5@Buf1} = case Bytes5 of
<<0:1,V5@V3:6,V5@Buf4/bitstring>> ->
V5@Add5 = V5@V3 + 1,
{V5@Add5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
V5@Pad6 = bit_size(V5@Buf2) band 7,
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<_:V5@Pad6,0:1,V5@V8:7,V5@Buf9/bitstring>> when V5@V8 =/= 0 ->
{V5@V8,V5@Buf9};
<<_:V5@Pad6,1:1,0:1,V5@V9:14,V5@Buf10/bitstring>> when V5@V9 =/= 0 ->
{V5@V9,V5@Buf10}
end,
{V5@V3,V5@Buf4}
end,
<<V5@V11:V5@V0/bitstring-unit:1,V5@Buf12/bitstring>> = V5@Buf1,
{V5@V11,V5@Buf12}
end,

%% attribute number 4 with type INTEGER
{Term4,Bytes7} = case Extensions of
  <<_:0,1:1,_/bitstring>> ->
begin
V6@Pad3 = bit_size(Bytes6) band 7,
{V6@V0,V6@Buf1} = case Bytes6 of
<<_:V6@Pad3,0:1,V6@V5:7,V6@V7:V6@V5/binary-unit:8,V6@Buf8/bitstring>> ->
{V6@V7,V6@Buf8};
<<_:V6@Pad3,1:1,0:1,V6@V6:14,V6@V8:V6@V6/binary-unit:8,V6@Buf9/bitstring>> ->
{V6@V8,V6@Buf9};
<<_:V6@Pad3,1:1,1:1,V6@V6:6,V6@Buf7/bitstring>> ->
{V6@V8,V6@Buf9}  = decode_fragmented(V6@V6, V6@Buf7, 8),
{V6@V8,V6@Buf9}
end,
{TmpValx4,_} = begin
V7@Pad2 = bit_size(V6@V0) band 7,
<<_:V7@Pad2,V7@V0:2/unsigned-unit:8,V7@Buf1/bitstring>> = V6@V0,
{V7@V0,V7@Buf1}
end,
{TmpValx4,V6@Buf1}
end;
_  ->
{asn1_NOVALUE,Bytes6}
end,

%% attribute number 5 with type NULL
{Term5,Bytes8} = case Extensions of
  <<_:1,1:1,_/bitstring>> ->
begin
V8@Pad3 = bit_size(Bytes7) band 7,
{V8@V0,V8@Buf1} = case Bytes7 of
<<_:V8@Pad3,0:1,V8@V5:7,V8@V7:V8@V5/binary-unit:8,V8@Buf8/bitstring>> ->
{V8@V7,V8@Buf8};
<<_:V8@Pad3,1:1,0:1,V8@V6:14,V8@V8:V8@V6/binary-unit:8,V8@Buf9/bitstring>> ->
{V8@V8,V8@Buf9};
<<_:V8@Pad3,1:1,1:1,V8@V6:6,V8@Buf7/bitstring>> ->
{V8@V8,V8@Buf9}  = decode_fragmented(V8@V6, V8@Buf7, 8),
{V8@V8,V8@Buf9}
end,
{TmpValx5,_} = begin
ignore,
{'NULL',V8@V0}
end,
{TmpValx5,V8@Buf1}
end;
_  ->
{asn1_NOVALUE,Bytes7}
end,
Bytes9= skipextensions(Bytes8, 3, Extensions),
{{'TransactionReply',Term1,Term2,Term3,Term4,Term5},Bytes9}.

'enc_TransactionPending'(Val) ->
Enc2@input = element(2, Val),
if Enc2@input bsr 32 =:= 0 ->
[<<0:1>>|begin
Enc2@input@bin = binary:encode_unsigned(Enc2@input),
Enc2@input@bin_size0 = byte_size(Enc2@input@bin),
Enc2@input@bin_size = Enc2@input@bin_size0 - 1,
[<<Enc2@input@bin_size:2>>,
align|Enc2@input@bin]
end];
true ->
exit({error,{asn1,{illegal_value,Enc2@input}}})
end.


dec_TransactionPending(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type INTEGER
{Term1,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Add2 = V2@V0 + 1,
V2@Pad5 = bit_size(V2@Buf1) band 7,
<<_:V2@Pad5,V2@V3:V2@Add2/unsigned-unit:8,V2@Buf4/bitstring>> = V2@Buf1,
{V2@V3,V2@Buf4}
end,

%% Extensions
{Extensions,Bytes3} = case Ext of
0 -> {<<>>,Bytes2};
1 ->
{V3@V0,V3@Buf1} = case Bytes2 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:7,0:1,V3@V7:7,V3@Buf8/bitstring>> when V3@V7 =/= 0 ->
{V3@V7,V3@Buf8};
<<_:7,1:1,0:1,V3@V8:14,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V10:V3@V0/bitstring-unit:1,V3@Buf11/bitstring>> = V3@Buf1,
{V3@V10,V3@Buf11}
end,
Bytes4= skipextensions(Bytes3, 1, Extensions),
{{'TransactionPending',Term1},Bytes4}.

'enc_TransactionRequest'(Val) ->
[begin
Enc2@input = element(2, Val),
if Enc2@input bsr 32 =:= 0 ->
[<<0:1>>|begin
Enc2@input@bin = binary:encode_unsigned(Enc2@input),
Enc2@input@bin_size0 = byte_size(Enc2@input@bin),
Enc2@input@bin_size = Enc2@input@bin_size0 - 1,
[<<Enc2@input@bin_size:2>>,
align|Enc2@input@bin]
end];
true ->
exit({error,{asn1,{illegal_value,Enc2@input}}})
end
end|begin
Enc4@input = element(3, Val),
enc_TransactionRequest_actions(Enc4@input)
end].
'enc_TransactionRequest_actions'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_ActionRequest(Comp) || Comp <- Val]].


dec_TransactionRequest_actions(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components42(V1@V0, V1@Buf1, []).



dec_TransactionRequest(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type INTEGER
{Term1,Bytes2} = begin
<<V2@V0:2/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
V2@Add2 = V2@V0 + 1,
V2@Pad5 = bit_size(V2@Buf1) band 7,
<<_:V2@Pad5,V2@V3:V2@Add2/unsigned-unit:8,V2@Buf4/bitstring>> = V2@Buf1,
{V2@V3,V2@Buf4}
end,

%% attribute number 2 with type SEQUENCE OF
{Term2,Bytes3} = 'dec_TransactionRequest_actions'(Bytes2),

%% Extensions
{Extensions,Bytes4} = case Ext of
0 -> {<<>>,Bytes3};
1 ->
{V3@V0,V3@Buf1} = case Bytes3 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V11:V3@V0/bitstring-unit:1,V3@Buf12/bitstring>> = V3@Buf1,
{V3@V11,V3@Buf12}
end,
Bytes5= skipextensions(Bytes4, 1, Extensions),
{{'TransactionRequest',Term1,Term2},Bytes5}.

'enc_TransactionId'(Val) ->
if Val bsr 32 =:= 0 ->
begin
Val@bin = binary:encode_unsigned(Val),
Val@bin_size0 = byte_size(Val@bin),
Val@bin_size = Val@bin_size0 - 1,
[<<Val@bin_size:2>>,
align|Val@bin]
end;
true ->
exit({error,{asn1,{illegal_value,Val}}})
end.


dec_TransactionId(Bytes) ->
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Add2 = V1@V0 + 1,
V1@Pad5 = bit_size(V1@Buf1) band 7,
<<_:V1@Pad5,V1@V3:V1@Add2/unsigned-unit:8,V1@Buf4/bitstring>> = V1@Buf1,
{V1@V3,V1@Buf4}
end.

'enc_Transaction'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= transactionRequest ->
[<<0:1,0:2>>|enc_TransactionRequest(ChoiceVal)];
ChoiceTag =:= transactionPending ->
[<<0:1,1:2>>|enc_TransactionPending(ChoiceVal)];
ChoiceTag =:= transactionReply ->
[<<0:1,2:2>>|enc_TransactionReply(ChoiceVal)];
ChoiceTag =:= transactionResponseAck ->
[<<0:1,3:2>>|enc_TransactionResponseAck(ChoiceVal)]
end.


dec_Transaction(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:2/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_TransactionRequest(Bytes2)
end,
{{transactionRequest,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_TransactionPending(Bytes2)
end,
{{transactionPending,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_TransactionReply(Bytes2)
end,
{{transactionReply,Val},NewBytes};
3 ->
{Val,NewBytes} = begin
dec_TransactionResponseAck(Bytes2)
end,
{{transactionResponseAck,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10}
end,
<<V1@V11:V1@V3/unit:8,V1@Buf12/bitstring>> = V1@Buf4,
{V1@V11,V1@Buf12}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
'enc_PathName'(Val) ->
Enc1@bin = list_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
Enc1@len@sub = Enc1@len - 1,
if Enc1@len@sub bsr 6 =:= 0 ->
[<<Enc1@len@sub:6>>,
align|Enc1@bin]
end.


dec_PathName(Bytes) ->
begin
<<V1@V0:6/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Add2 = V1@V0 + 1,
V1@Pad5 = bit_size(V1@Buf1) band 7,
<<_:V1@Pad5,V1@V3:V1@Add2/binary-unit:8,V1@Buf4/bitstring>> = V1@Buf1,
V1@Conv7 = binary_to_list(V1@V3),
{V1@Conv7,V1@Buf4}
end.

'enc_IP6Address'(Val) ->
[begin
Enc1@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
align,
begin
Enc2@input = element(2, Val),
Enc3@bin = iolist_to_binary(Enc2@input),
Enc3@len = byte_size(Enc3@bin),
if Enc3@len =:= 16 ->
Enc3@bin
end
end|begin
Enc4@input = element(3, Val),
if Enc4@input =:= asn1_NOVALUE ->
[];
Enc4@input bsr 16 =:= 0 ->
<<Enc4@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc4@input}}})
end
end].


dec_IP6Address(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes2} = begin
V2@Pad2 = bit_size(Bytes1) band 7,
<<_:V2@Pad2,V2@V0:16/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv4 = binary_to_list(V2@V0),
{V2@Conv4,V2@Buf1}
end,

%% attribute number 2 with type INTEGER
{Term2,Bytes3} = case Opt band 1 of
1 ->
begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:2/unsigned-unit:8,V3@Buf1/bitstring>> = Bytes2,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,
{{'IP6Address',Term1,Term2},Bytes3}.

'enc_IP4Address'(Val) ->
[begin
Enc1@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
align,
begin
Enc2@input = element(2, Val),
Enc3@bin = iolist_to_binary(Enc2@input),
Enc3@len = byte_size(Enc3@bin),
if Enc3@len =:= 4 ->
Enc3@bin
end
end|begin
Enc4@input = element(3, Val),
if Enc4@input =:= asn1_NOVALUE ->
[];
Enc4@input bsr 16 =:= 0 ->
<<Enc4@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc4@input}}})
end
end].


dec_IP4Address(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type OCTET STRING
{Term1,Bytes2} = begin
V2@Pad2 = bit_size(Bytes1) band 7,
<<_:V2@Pad2,V2@V0:4/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv4 = binary_to_list(V2@V0),
{V2@Conv4,V2@Buf1}
end,

%% attribute number 2 with type INTEGER
{Term2,Bytes3} = case Opt band 1 of
1 ->
begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:2/unsigned-unit:8,V3@Buf1/bitstring>> = Bytes2,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,
{{'IP4Address',Term1,Term2},Bytes3}.

'enc_DomainName'(Val) ->
[begin
Enc1@input = element(3, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
align,
begin
Enc2@input = element(2, Val),
Enc3@bin = list_to_binary(Enc2@input),
Enc3@len = byte_size(Enc3@bin),
if Enc3@len < 128 ->
[Enc3@len|Enc3@bin];
Enc3@len < 16384 ->
[<<2:2,Enc3@len:14>>|Enc3@bin];
true ->
encode_fragmented(Enc3@bin, 8)
end
end|begin
Enc4@input = element(3, Val),
if Enc4@input =:= asn1_NOVALUE ->
[];
Enc4@input bsr 16 =:= 0 ->
<<Enc4@input:16>>;
true ->
exit({error,{asn1,{illegal_value,Enc4@input}}})
end
end].


dec_DomainName(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type IA5String
{Term1,Bytes2} = begin
V2@Pad3 = bit_size(Bytes1) band 7,
{V2@V0,V2@Buf1} = case Bytes1 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end,
V2@Conv10 = binary_to_list(V2@V0),
{V2@Conv10,V2@Buf1}
end,

%% attribute number 2 with type INTEGER
{Term2,Bytes3} = case Opt band 1 of
1 ->
begin
V3@Pad2 = bit_size(Bytes2) band 7,
<<_:V3@Pad2,V3@V0:2/unsigned-unit:8,V3@Buf1/bitstring>> = Bytes2,
{V3@V0,V3@Buf1}
end;
0 ->
{asn1_NOVALUE,Bytes2}
end,
{{'DomainName',Term1,Term2},Bytes3}.

'enc_MId'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= ip4Address ->
[<<0:1,0:3>>|enc_IP4Address(ChoiceVal)];
ChoiceTag =:= ip6Address ->
[<<0:1,1:3>>|enc_IP6Address(ChoiceVal)];
ChoiceTag =:= domainName ->
[<<0:1,2:3>>|enc_DomainName(ChoiceVal)];
ChoiceTag =:= deviceName ->
begin
Enc5@bin = list_to_binary(ChoiceVal),
Enc5@len = byte_size(Enc5@bin),
Enc5@len@sub = Enc5@len - 1,
if Enc5@len@sub bsr 6 =:= 0 ->
[<<0:1,3:3,Enc5@len@sub:6>>,
align|Enc5@bin]
end
end;
ChoiceTag =:= mtpAddress ->
begin
Enc7@bin = iolist_to_binary(ChoiceVal),
Enc7@len = byte_size(Enc7@bin),
Enc7@len@sub = Enc7@len - 2,
if 0 =< Enc7@len@sub, Enc7@len@sub < 3 ->
[<<0:1,4:3,Enc7@len@sub:2>>,
align|Enc7@bin]
end
end
end.


dec_MId(Bytes) ->
case Bytes of
<<0:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
<<V1@V0:3/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes1,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_IP4Address(Bytes2)
end,
{{ip4Address,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
dec_IP6Address(Bytes2)
end,
{{ip6Address,Val},NewBytes};
2 ->
{Val,NewBytes} = begin
dec_DomainName(Bytes2)
end,
{{domainName,Val},NewBytes};
3 ->
{Val,NewBytes} = begin
begin
<<V2@V0:6/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes2,
V2@Add2 = V2@V0 + 1,
V2@Pad5 = bit_size(V2@Buf1) band 7,
<<_:V2@Pad5,V2@V3:V2@Add2/binary-unit:8,V2@Buf4/bitstring>> = V2@Buf1,
V2@Conv7 = binary_to_list(V2@V3),
{V2@Conv7,V2@Buf4}
end
end,
{{deviceName,Val},NewBytes};
4 ->
{Val,NewBytes} = begin
begin
<<V3@V0:2/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
V3@Add2 = V3@V0 + 2,
V3@Pad5 = bit_size(V3@Buf1) band 7,
<<_:V3@Pad5,V3@V3:V3@Add2/binary-unit:8,V3@Buf4/bitstring>> = V3@Buf1,
V3@Conv7 = binary_to_list(V3@V3),
{V3@Conv7,V3@Buf4}
end
end,
{{mtpAddress,Val},NewBytes}
end;

<<1:1,Bytes1/bitstring>> ->
{Choice,Bytes2} = 
begin
{V1@V0,V1@Buf1} = case Bytes1 of
<<0:1,V1@V3:6,V1@Buf4/bitstring>> ->
{V1@V3,V1@Buf4};
<<1:1,V1@Buf2/bitstring>> ->
V1@Pad6 = bit_size(V1@Buf2) band 7,
{V1@V3,V1@Buf4} = case V1@Buf2 of
<<_:V1@Pad6,0:1,V1@V8:7,V1@Buf9/bitstring>> when V1@V8 =/= 0 ->
{V1@V8,V1@Buf9};
<<_:V1@Pad6,1:1,0:1,V1@V9:14,V1@Buf10/bitstring>> when V1@V9 =/= 0 ->
{V1@V9,V1@Buf10}
end,
<<V1@V11:V1@V3/unit:8,V1@Buf12/bitstring>> = V1@Buf4,
{V1@V11,V1@Buf12}
end,
{V1@V0,V1@Buf1}
end,
begin
V2@Pad3 = bit_size(Bytes2) band 7,
{V2@V0,V2@Buf1} = case Bytes2 of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end
end,
case Choice of
_ ->
{{asn1_ExtAlt,V2@V0},V2@Buf1}
end
end.
'enc_Message'(Val) ->
[begin
Enc2@input = element(2, Val),
if 0 =< Enc2@input, Enc2@input < 100 ->
<<0:1,Enc2@input:7>>;
true ->
exit({error,{asn1,{illegal_value,Enc2@input}}})
end
end,
begin
Enc4@input = element(3, Val),
enc_MId(Enc4@input)
end|begin
Enc5@input = element(4, Val),
enc_Message_messageBody(Enc5@input)
end].
'enc_Message_messageBody'(Val) ->
{ChoiceTag,ChoiceVal} = Val,
if ChoiceTag =:= messageError ->
[<<0:1>>|enc_ErrorDescriptor(ChoiceVal)];
ChoiceTag =:= transactions ->
[<<1:1>>|enc_Message_messageBody_transactions(ChoiceVal)]
end.
'enc_Message_messageBody_transactions'(Val) ->
Enc1@len = length(Val),
[if Enc1@len < 128 ->
[align,
Enc1@len];
Enc1@len < 16384 ->
[align|<<2:2,Enc1@len:14>>]
end|[enc_Transaction(Comp) || Comp <- Val]].


dec_Message_messageBody_transactions(Bytes) ->
%% Length with constraint no
V1@Pad3 = bit_size(Bytes) band 7,
{V1@V0,V1@Buf1} = case Bytes of
<<_:V1@Pad3,0:1,V1@V5:7,V1@Buf6/bitstring>> ->
{V1@V5,V1@Buf6};
<<_:V1@Pad3,1:1,0:1,V1@V6:14,V1@Buf7/bitstring>> ->
{V1@V6,V1@Buf7}
end,
dec_components43(V1@V0, V1@Buf1, []).


dec_Message_messageBody(Bytes) ->
{Choice,Bytes1} = 
begin
<<V1@V0:1/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,
case Choice of
0 ->
{Val,NewBytes} = begin
dec_ErrorDescriptor(Bytes1)
end,
{{messageError,Val},NewBytes};
1 ->
{Val,NewBytes} = begin
'dec_Message_messageBody_transactions'(Bytes1)
end,
{{transactions,Val},NewBytes}
end.


dec_Message(Bytes) ->
{Ext,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type INTEGER
{Term1,Bytes2} = begin
<<V2@V0:7/unsigned-unit:1,V2@Buf1/bitstring>> = Bytes1,
{V2@V0,V2@Buf1}
end,

%% attribute number 2 with type MId
{Term2,Bytes3} = dec_MId(Bytes2),

%% attribute number 3 with type CHOICE
{Term3,Bytes4} = 'dec_Message_messageBody'(Bytes3),

%% Extensions
{Extensions,Bytes5} = case Ext of
0 -> {<<>>,Bytes4};
1 ->
{V3@V0,V3@Buf1} = case Bytes4 of
<<0:1,V3@V3:6,V3@Buf4/bitstring>> ->
V3@Add5 = V3@V3 + 1,
{V3@Add5,V3@Buf4};
<<1:1,V3@Buf2/bitstring>> ->
V3@Pad6 = bit_size(V3@Buf2) band 7,
{V3@V3,V3@Buf4} = case V3@Buf2 of
<<_:V3@Pad6,0:1,V3@V8:7,V3@Buf9/bitstring>> when V3@V8 =/= 0 ->
{V3@V8,V3@Buf9};
<<_:V3@Pad6,1:1,0:1,V3@V9:14,V3@Buf10/bitstring>> when V3@V9 =/= 0 ->
{V3@V9,V3@Buf10}
end,
{V3@V3,V3@Buf4}
end,
<<V3@V11:V3@V0/bitstring-unit:1,V3@Buf12/bitstring>> = V3@Buf1,
{V3@V11,V3@Buf12}
end,
Bytes6= skipextensions(Bytes5, 1, Extensions),
{{'Message',Term1,Term2,Term3},Bytes6}.

'enc_AuthData'(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
Enc1@len@sub = Enc1@len - 12,
if 0 =< Enc1@len@sub, Enc1@len@sub < 21 ->
[<<Enc1@len@sub:5>>,
align|Enc1@bin]
end.


dec_AuthData(Bytes) ->
begin
<<V1@V0:5/unsigned-unit:1,V1@Buf1/bitstring>> = Bytes,
V1@Add2 = V1@V0 + 12,
V1@Pad5 = bit_size(V1@Buf1) band 7,
<<_:V1@Pad5,V1@V3:V1@Add2/binary-unit:8,V1@Buf4/bitstring>> = V1@Buf1,
V1@Conv7 = binary_to_list(V1@V3),
{V1@Conv7,V1@Buf4}
end.

'enc_SequenceNum'(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 4 ->
[align|Enc1@bin]
end.


dec_SequenceNum(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:4/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv4 = binary_to_list(V1@V0),
{V1@Conv4,V1@Buf1}
end.

'enc_SecurityParmIndex'(Val) ->
Enc1@bin = iolist_to_binary(Val),
Enc1@len = byte_size(Enc1@bin),
if Enc1@len =:= 4 ->
[align|Enc1@bin]
end.


dec_SecurityParmIndex(Bytes) ->
begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:4/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv4 = binary_to_list(V1@V0),
{V1@Conv4,V1@Buf1}
end.

'enc_AuthenticationHeader'(Val) ->
[align,
begin
Enc1@input = element(2, Val),
Enc2@bin = iolist_to_binary(Enc1@input),
Enc2@len = byte_size(Enc2@bin),
if Enc2@len =:= 4 ->
Enc2@bin
end
end,
begin
Enc3@input = element(3, Val),
Enc4@bin = iolist_to_binary(Enc3@input),
Enc4@len = byte_size(Enc4@bin),
if Enc4@len =:= 4 ->
Enc4@bin
end
end|begin
Enc5@input = element(4, Val),
Enc6@bin = iolist_to_binary(Enc5@input),
Enc6@len = byte_size(Enc6@bin),
Enc6@len@sub = Enc6@len - 12,
if 0 =< Enc6@len@sub, Enc6@len@sub < 21 ->
[<<Enc6@len@sub:5,0:3>>|Enc6@bin]
end
end].


dec_AuthenticationHeader(Bytes) ->

%% attribute number 1 with type OCTET STRING
{Term1,Bytes1} = begin
V1@Pad2 = bit_size(Bytes) band 7,
<<_:V1@Pad2,V1@V0:4/binary-unit:8,V1@Buf1/bitstring>> = Bytes,
V1@Conv4 = binary_to_list(V1@V0),
{V1@Conv4,V1@Buf1}
end,

%% attribute number 2 with type OCTET STRING
{Term2,Bytes2} = begin
<<V2@V0:4/binary-unit:8,V2@Buf1/bitstring>> = Bytes1,
V2@Conv2 = binary_to_list(V2@V0),
{V2@Conv2,V2@Buf1}
end,

%% attribute number 3 with type OCTET STRING
{Term3,Bytes3} = begin
<<V3@V0:5/unsigned-unit:1,V3@Buf1/bitstring>> = Bytes2,
V3@Add2 = V3@V0 + 12,
<<_:3,V3@V3:V3@Add2/binary-unit:8,V3@Buf4/bitstring>> = V3@Buf1,
V3@Conv6 = binary_to_list(V3@V3),
{V3@Conv6,V3@Buf4}
end,
{{'AuthenticationHeader',Term1,Term2,Term3},Bytes3}.

'enc_MegacoMessage'(Val) ->
[begin
Enc1@input = element(2, Val),
if Enc1@input =:= asn1_NOVALUE ->
<<0:1>>;
true ->
<<1:1>>
end
end,
begin
Enc2@input = element(2, Val),
if Enc2@input =:= asn1_NOVALUE ->
[];
true ->
enc_AuthenticationHeader(Enc2@input)
end
end|begin
Enc4@input = element(3, Val),
enc_Message(Enc4@input)
end].


dec_MegacoMessage(Bytes) ->
{Opt,Bytes1} = begin
<<V1@V0:1,V1@Buf1/bitstring>> = Bytes,
{V1@V0,V1@Buf1}
end,

%% attribute number 1 with type AuthenticationHeader
{Term1,Bytes2} = case Opt band 1 of
1 ->
dec_AuthenticationHeader(Bytes1);
0 ->
{asn1_NOVALUE,Bytes1}
end,

%% attribute number 2 with type Message
{Term2,Bytes3} = dec_Message(Bytes2),
{{'MegacoMessage',Term1,Term2},Bytes3}.


%%%
%%% Run-time functions.
%%%

bit_string_name2pos_31([muxToken|T]) ->
    [0|bit_string_name2pos_31(T)];
bit_string_name2pos_31([modemToken|T]) ->
    [1|bit_string_name2pos_31(T)];
bit_string_name2pos_31([mediaToken|T]) ->
    [2|bit_string_name2pos_31(T)];
bit_string_name2pos_31([eventsToken|T]) ->
    [3|bit_string_name2pos_31(T)];
bit_string_name2pos_31([signalsToken|T]) ->
    [4|bit_string_name2pos_31(T)];
bit_string_name2pos_31([digitMapToken|T]) ->
    [5|bit_string_name2pos_31(T)];
bit_string_name2pos_31([statsToken|T]) ->
    [6|bit_string_name2pos_31(T)];
bit_string_name2pos_31([observedEventsToken|T]) ->
    [7|bit_string_name2pos_31(T)];
bit_string_name2pos_31([packagesToken|T]) ->
    [8|bit_string_name2pos_31(T)];
bit_string_name2pos_31([eventBufferToken|T]) ->
    [9|bit_string_name2pos_31(T)];
bit_string_name2pos_31([{bit,Pos}|T]) when is_integer(Pos) ->
    [Pos|bit_string_name2pos_31(T)];
bit_string_name2pos_31([]) ->
    [];
bit_string_name2pos_31(_) ->
    throw(invalid).

bit_string_name2pos_6([onTimeOut|T]) ->
    [0|bit_string_name2pos_6(T)];
bit_string_name2pos_6([onInterruptByEvent|T]) ->
    [1|bit_string_name2pos_6(T)];
bit_string_name2pos_6([onInterruptByNewSignalDescr|T]) ->
    [2|bit_string_name2pos_6(T)];
bit_string_name2pos_6([otherReason|T]) ->
    [3|bit_string_name2pos_6(T)];
bit_string_name2pos_6([{bit,Pos}|T]) when is_integer(Pos) ->
    [Pos|bit_string_name2pos_6(T)];
bit_string_name2pos_6([]) ->
    [];
bit_string_name2pos_6(_) ->
    throw(invalid).

dec_components1(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components1(Num, Bytes, Acc) ->
{Term,Remain} = begin
V2@Pad3 = bit_size(Bytes) band 7,
{V2@V0,V2@Buf1} = case Bytes of
<<_:V2@Pad3,0:1,V2@V5:7,V2@V7:V2@V5/binary-unit:8,V2@Buf8/bitstring>> ->
{V2@V7,V2@Buf8};
<<_:V2@Pad3,1:1,0:1,V2@V6:14,V2@V8:V2@V6/binary-unit:8,V2@Buf9/bitstring>> ->
{V2@V8,V2@Buf9};
<<_:V2@Pad3,1:1,1:1,V2@V6:6,V2@Buf7/bitstring>> ->
{V2@V8,V2@Buf9}  = decode_fragmented(V2@V6, V2@Buf7, 8),
{V2@V8,V2@Buf9}
end,
V2@Conv10 = binary_to_list(V2@V0),
{V2@Conv10,V2@Buf1}
end,
dec_components1(Num-1, Remain, [Term|Acc]).

dec_components10(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components10(Num, Bytes, Acc) ->
{Term,Remain} = dec_EventParameter(Bytes),
dec_components10(Num-1, Remain, [Term|Acc]).

dec_components11(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components11(Num, Bytes, Acc) ->
{Term,Remain} = dec_EventSpec(Bytes),
dec_components11(Num-1, Remain, [Term|Acc]).

dec_components12(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components12(Num, Bytes, Acc) ->
{Term,Remain} = dec_EventParameter(Bytes),
dec_components12(Num-1, Remain, [Term|Acc]).

dec_components13(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components13(Num, Bytes, Acc) ->
{Term,Remain} = dec_SecondRequestedEvent(Bytes),
dec_components13(Num-1, Remain, [Term|Acc]).

dec_components14(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components14(Num, Bytes, Acc) ->
{Term,Remain} = dec_EventParameter(Bytes),
dec_components14(Num-1, Remain, [Term|Acc]).

dec_components15(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components15(Num, Bytes, Acc) ->
{Term,Remain} = dec_RequestedEvent(Bytes),
dec_components15(Num-1, Remain, [Term|Acc]).

dec_components16(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components16(Num, Bytes, Acc) ->
{Term,Remain} = dec_TerminationID(Bytes),
dec_components16(Num-1, Remain, [Term|Acc]).

dec_components17(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components17(Num, Bytes, Acc) ->
{Term,Remain} = dec_PropertyParm(Bytes),
dec_components17(Num-1, Remain, [Term|Acc]).

dec_components18(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components18(Num, Bytes, Acc) ->
{Term,Remain} = dec_PropertyParm(Bytes),
dec_components18(Num-1, Remain, [Term|Acc]).

dec_components19(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components19(Num, Bytes, Acc) ->
{Term,Remain} = dec_PropertyGroup(Bytes),
dec_components19(Num-1, Remain, [Term|Acc]).

dec_components2(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components2(Num, Bytes, Acc) ->
{Term,Remain} = dec_StatisticsParameter(Bytes),
dec_components2(Num-1, Remain, [Term|Acc]).

dec_components20(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components20(Num, Bytes, Acc) ->
{Term,Remain} = begin
V3@Pad3 = bit_size(Bytes) band 7,
{V3@V0,V3@Buf1} = case Bytes of
<<_:V3@Pad3,0:1,V3@V5:7,V3@V7:V3@V5/binary-unit:8,V3@Buf8/bitstring>> ->
{V3@V7,V3@Buf8};
<<_:V3@Pad3,1:1,0:1,V3@V6:14,V3@V8:V3@V6/binary-unit:8,V3@Buf9/bitstring>> ->
{V3@V8,V3@Buf9};
<<_:V3@Pad3,1:1,1:1,V3@V6:6,V3@Buf7/bitstring>> ->
{V3@V8,V3@Buf9}  = decode_fragmented(V3@V6, V3@Buf7, 8),
{V3@V8,V3@Buf9}
end,
V3@Conv10 = binary_to_list(V3@V0),
{V3@Conv10,V3@Buf1}
end,
dec_components20(Num-1, Remain, [Term|Acc]).

dec_components21(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components21(Num, Bytes, Acc) ->
{Term,Remain} = dec_PropertyParm(Bytes),
dec_components21(Num-1, Remain, [Term|Acc]).

dec_components22(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components22(Num, Bytes, Acc) ->
{Term,Remain} = dec_StreamDescriptor(Bytes),
dec_components22(Num-1, Remain, [Term|Acc]).

dec_components23(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components23(Num, Bytes, Acc) ->
{Term,Remain} = dec_TerminationID(Bytes),
dec_components23(Num-1, Remain, [Term|Acc]).

dec_components24(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components24(Num, Bytes, Acc) ->
{Term,Remain} = begin
<<V4@V0:1/binary-unit:8,V4@Buf1/bitstring>> = Bytes,
V4@Conv2 = binary_to_list(V4@V0),
{V4@Conv2,V4@Buf1}
end,
dec_components24(Num-1, Remain, [Term|Acc]).

dec_components25(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components25(Num, Bytes, Acc) ->
{Term,Remain} = dec_EventParameter(Bytes),
dec_components25(Num-1, Remain, [Term|Acc]).

dec_components26(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components26(Num, Bytes, Acc) ->
{Term,Remain} = dec_ObservedEvent(Bytes),
dec_components26(Num-1, Remain, [Term|Acc]).

dec_components27(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components27(Num, Bytes, Acc) ->
{Term,Remain} = dec_IndAudPropertyParm(Bytes),
dec_components27(Num-1, Remain, [Term|Acc]).

dec_components28(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components28(Num, Bytes, Acc) ->
{Term,Remain} = dec_IndAudPropertyParm(Bytes),
dec_components28(Num-1, Remain, [Term|Acc]).

dec_components29(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components29(Num, Bytes, Acc) ->
{Term,Remain} = dec_IndAudPropertyParm(Bytes),
dec_components29(Num-1, Remain, [Term|Acc]).

dec_components3(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components3(Num, Bytes, Acc) ->
{Term,Remain} = dec_PackagesItem(Bytes),
dec_components3(Num-1, Remain, [Term|Acc]).

dec_components30(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components30(Num, Bytes, Acc) ->
{Term,Remain} = dec_IndAudStreamDescriptor(Bytes),
dec_components30(Num-1, Remain, [Term|Acc]).

dec_components32(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components32(Num, Bytes, Acc) ->
{Term,Remain} = dec_IndAuditParameter(Bytes),
dec_components32(Num-1, Remain, [Term|Acc]).

dec_components33(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components33(Num, Bytes, Acc) ->
{Term,Remain} = dec_AuditReturnParameter(Bytes),
dec_components33(Num-1, Remain, [Term|Acc]).

dec_components34(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components34(Num, Bytes, Acc) ->
{Term,Remain} = dec_AmmDescriptor(Bytes),
dec_components34(Num-1, Remain, [Term|Acc]).

dec_components35(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components35(Num, Bytes, Acc) ->
{Term,Remain} = dec_IndAudPropertyParm(Bytes),
dec_components35(Num-1, Remain, [Term|Acc]).

dec_components36(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components36(Num, Bytes, Acc) ->
{Term,Remain} = dec_TopologyRequest(Bytes),
dec_components36(Num-1, Remain, [Term|Acc]).

dec_components37(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components37(Num, Bytes, Acc) ->
{Term,Remain} = dec_PropertyParm(Bytes),
dec_components37(Num-1, Remain, [Term|Acc]).

dec_components38(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components38(Num, Bytes, Acc) ->
{Term,Remain} = dec_CommandReply(Bytes),
dec_components38(Num-1, Remain, [Term|Acc]).

dec_components39(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components39(Num, Bytes, Acc) ->
{Term,Remain} = dec_CommandRequest(Bytes),
dec_components39(Num-1, Remain, [Term|Acc]).

dec_components4(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components4(Num, Bytes, Acc) ->
{Term,Remain} = begin
{V5@V0,V5@Buf1} = case Bytes of
<<0:1,V5@V3:4/unsigned-unit:1,V5@Buf4/bitstring>> ->
V5@Int5 = case V5@V3 of
0 -> v18;
1 -> v22;
2 -> v22bis;
3 -> v32;
4 -> v32bis;
5 -> v34;
6 -> v90;
7 -> v91;
8 -> synchISDN;
_ -> exit({error,{asn1,{decode_enumerated,{V5@V3,[v18,v22,v22bis,v32,v32bis,v34,v90,v91,synchISDN]}}}})
end,
{V5@Int5,V5@Buf4};
<<1:1,V5@Buf2/bitstring>> ->
{V5@V3,V5@Buf4} = case V5@Buf2 of
<<0:1,V5@V6:6,V5@Buf7/bitstring>> ->
{V5@V6,V5@Buf7};
<<1:1,V5@Buf5/bitstring>> ->
V5@Pad9 = bit_size(V5@Buf5) band 7,
{V5@V6,V5@Buf7} = case V5@Buf5 of
<<_:V5@Pad9,0:1,V5@V11:7,V5@Buf12/bitstring>> when V5@V11 =/= 0 ->
{V5@V11,V5@Buf12};
<<_:V5@Pad9,1:1,0:1,V5@V12:14,V5@Buf13/bitstring>> when V5@V12 =/= 0 ->
{V5@V12,V5@Buf13}
end,
<<V5@V14:V5@V6/unit:8,V5@Buf15/bitstring>> = V5@Buf7,
{V5@V14,V5@Buf15}
end,
V5@Int16 = case V5@V3 of
_ -> {asn1_enum,V5@V3}
end,
{V5@Int16,V5@Buf4}
end,
{V5@V0,V5@Buf1}
end,
dec_components4(Num-1, Remain, [Term|Acc]).

dec_components40(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components40(Num, Bytes, Acc) ->
{Term,Remain} = dec_TransactionAck(Bytes),
dec_components40(Num-1, Remain, [Term|Acc]).

dec_components41(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components41(Num, Bytes, Acc) ->
{Term,Remain} = dec_ActionReply(Bytes),
dec_components41(Num-1, Remain, [Term|Acc]).

dec_components42(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components42(Num, Bytes, Acc) ->
{Term,Remain} = dec_ActionRequest(Bytes),
dec_components42(Num-1, Remain, [Term|Acc]).

dec_components43(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components43(Num, Bytes, Acc) ->
{Term,Remain} = dec_Transaction(Bytes),
dec_components43(Num-1, Remain, [Term|Acc]).

dec_components5(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components5(Num, Bytes, Acc) ->
{Term,Remain} = dec_PropertyParm(Bytes),
dec_components5(Num-1, Remain, [Term|Acc]).

dec_components7(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components7(Num, Bytes, Acc) ->
{Term,Remain} = dec_SigParameter(Bytes),
dec_components7(Num-1, Remain, [Term|Acc]).

dec_components8(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components8(Num, Bytes, Acc) ->
{Term,Remain} = dec_Signal(Bytes),
dec_components8(Num-1, Remain, [Term|Acc]).

dec_components9(0, Bytes, Acc) ->
{lists:reverse(Acc),Bytes};
dec_components9(Num, Bytes, Acc) ->
{Term,Remain} = dec_SignalRequest(Bytes),
dec_components9(Num-1, Remain, [Term|Acc]).

align(Bin) when is_binary(Bin) ->
    Bin;
align(BitStr) when is_bitstring(BitStr) ->
    AlignBits = bit_size(BitStr) rem 8,
    <<_:AlignBits,Rest/binary>> = BitStr,
    Rest.

bitstring_from_positions([]) ->
    <<>>;
bitstring_from_positions([_|_] = L0) ->
    L1 = lists:sort(L0),
    L = diff(L1, - 1),
    << 
      <<1:(N + 0)>> ||
          N <- L
    >>.

bs_drop_trailing_zeroes(Bs) ->
    bs_drop_trailing_zeroes(Bs, bit_size(Bs)).

bs_drop_trailing_zeroes(Bs0, Sz0) when Sz0 < 8 ->
    <<Byte:Sz0>> = Bs0,
    Sz = Sz0 - ntz(Byte),
    <<Bs:Sz/bits,_/bits>> = Bs0,
    Bs;
bs_drop_trailing_zeroes(Bs0, Sz0) ->
    Sz1 = Sz0 - 8,
    <<Bs1:Sz1/bits,Byte:8>> = Bs0,
    case ntz(Byte) of
        8 ->
            bs_drop_trailing_zeroes(Bs1, Sz1);
        Ntz ->
            Sz = Sz0 - Ntz,
            <<Bs:Sz/bits,_:Ntz/bits>> = Bs0,
            Bs
    end.

complete(L0) ->
    L = complete(L0, []),
    case list_to_bitstring(L) of
        <<>> ->
            <<0>>;
        Bin ->
            Bin
    end.

complete([], Bits, []) ->
    case Bits band 7 of
        0 ->
            [];
        N ->
            [<<0:(8 - N)>>]
    end;
complete([], Bits, [H|More]) ->
    complete(H, Bits, More);
complete([align|T], Bits, More) ->
    case Bits band 7 of
        0 ->
            complete(T, More);
        1 ->
            [<<0:7>>|complete(T, More)];
        2 ->
            [<<0:6>>|complete(T, More)];
        3 ->
            [<<0:5>>|complete(T, More)];
        4 ->
            [<<0:4>>|complete(T, More)];
        5 ->
            [<<0:3>>|complete(T, More)];
        6 ->
            [<<0:2>>|complete(T, More)];
        7 ->
            [<<0:1>>|complete(T, More)]
    end;
complete([[]|T], Bits, More) ->
    complete(T, Bits, More);
complete([[_|_] = H], Bits, More) ->
    complete(H, Bits, More);
complete([[_|_] = H|T], Bits, More) ->
    complete(H, Bits, [T|More]);
complete([H|T], Bits, More) when is_integer(H); is_binary(H) ->
    [H|complete(T, Bits, More)];
complete([H|T], Bits, More) ->
    [H|complete(T, Bits + bit_size(H), More)];
complete(Bin, Bits, More) when is_binary(Bin) ->
    [Bin|complete([], Bits, More)];
complete(Bin, Bits, More) ->
    [Bin|complete([], Bits + bit_size(Bin), More)].

complete([], []) ->
    [];
complete([], [H|More]) ->
    complete(H, More);
complete([align|T], More) ->
    complete(T, More);
complete([[]|T], More) ->
    complete(T, More);
complete([[_|_] = H], More) ->
    complete(H, More);
complete([[_|_] = H|T], More) ->
    complete(H, [T|More]);
complete([H|T], More) when is_integer(H); is_binary(H) ->
    [H|complete(T, More)];
complete([H|T], More) ->
    [H|complete(T, bit_size(H), More)];
complete(Bin, More) when is_binary(Bin) ->
    [Bin|complete([], More)];
complete(Bin, More) ->
    [Bin|complete([], bit_size(Bin), More)].

dec_subidentifiers([H|T], Av, Al) when H >= 128 ->
    dec_subidentifiers(T, Av bsl 7 bor H band 127, Al);
dec_subidentifiers([H|T], Av, Al) ->
    dec_subidentifiers(T, 0, [Av bsl 7 bor H|Al]);
dec_subidentifiers([], _Av, Al) ->
    lists:reverse(Al).

decode_fragmented(SegSz0, Buf0, Unit) ->
    SegSz = SegSz0 * Unit * 16384,
    <<Res:SegSz/bitstring,Buf/bitstring>> = Buf0,
    decode_fragmented_1(Buf, Unit, Res).

decode_fragmented_1(<<0:1,N:7,Buf0/bitstring>>, Unit, Res) ->
    Sz = N * Unit,
    <<S:Sz/bitstring,Buf/bitstring>> = Buf0,
    {<<Res/bitstring,S/bitstring>>,Buf};
decode_fragmented_1(<<1:1,0:1,N:14,Buf0/bitstring>>, Unit, Res) ->
    Sz = N * Unit,
    <<S:Sz/bitstring,Buf/bitstring>> = Buf0,
    {<<Res/bitstring,S/bitstring>>,Buf};
decode_fragmented_1(<<1:1,1:1,SegSz0:6,Buf0/bitstring>>, Unit, Res0) ->
    SegSz = SegSz0 * Unit * 16384,
    <<Frag:SegSz/bitstring,Buf/bitstring>> = Buf0,
    Res = <<Res0/bitstring,Frag/bitstring>>,
    decode_fragmented_1(Buf, Unit, Res).

decode_length(Buffer) ->
    case align(Buffer) of
        <<0:1,Oct:7,Rest/binary>> ->
            {Oct,Rest};
        <<2:2,Val:14,Rest/binary>> ->
            {Val,Rest};
        <<3:2,_Val:14,_Rest/binary>> ->
            exit({error,{asn1,{decode_length,{nyi,above_16k}}}})
    end.

decode_named_bit_string(Val, NNL) ->
    Bits =
        [ 
         B ||
             <<B:1>> <= Val
        ],
    decode_named_bit_string_1(0, Bits, NNL, []).

decode_named_bit_string_1(Pos, [0|Bt], Names, Acc) ->
    decode_named_bit_string_1(Pos + 1, Bt, Names, Acc);
decode_named_bit_string_1(Pos, [1|Bt], Names, Acc) ->
    case lists:keyfind(Pos, 2, Names) of
        {Name,_} ->
            decode_named_bit_string_1(Pos + 1, Bt, Names, [Name|Acc]);
        false ->
            decode_named_bit_string_1(Pos + 1,
                                      Bt,
                                      Names,
                                      [{bit,Pos}|Acc])
    end;
decode_named_bit_string_1(_Pos, [], _Names, Acc) ->
    lists:reverse(Acc).

decode_oid(Octets) ->
    [First|Rest] = dec_subidentifiers(Octets, 0, []),
    Idlist =
        if
            First < 40 ->
                [0,First|Rest];
            First < 80 ->
                [1,First - 40|Rest];
            true ->
                [2,First - 80|Rest]
        end,
    list_to_tuple(Idlist).

diff([H|T], Prev) ->
    [H - Prev|diff(T, H)];
diff([], _) ->
    [].

e_o_e(Num) when Num < 128 ->
    Num bor 128;
e_o_e(Num) ->
    [e_o_e(Num bsr 7),Num band 127 bor 128].

e_object_element(Num) when Num < 128 ->
    [Num];
e_object_element(Num) ->
    [e_o_e(Num bsr 7),Num band 127].

e_object_elements([], Acc) ->
    lists:reverse(Acc);
e_object_elements([H|T], Acc) ->
    e_object_elements(T, [e_object_element(H)|Acc]).

e_object_identifier([E1,E2|Tail])
    when E1 >= 0, E1 < 2, E2 < 40; E1 =:= 2 ->
    Head = 40 * E1 + E2,
    e_object_elements([Head|Tail], []);
e_object_identifier([_,_|_Tail] = Oid) ->
    exit({error,{asn1,{illegal_value,Oid}}}).

encode_fragmented(Bin, Unit) ->
    encode_fragmented_1(Bin, Unit, 4).

encode_fragmented_1(Bin, Unit, N) ->
    SegSz = Unit * N * 16384,
    case Bin of
        <<B:SegSz/bitstring,T/bitstring>> ->
            [<<3:2,N:6>>,B|encode_fragmented_1(T, Unit, N)];
        _ when N > 1 ->
            encode_fragmented_1(Bin, Unit, N - 1);
        _ ->
            case bit_size(Bin) div Unit of
                Len when Len < 128 ->
                    [Len,Bin];
                Len when Len < 16384 ->
                    [<<2:2,Len:14>>,Bin]
            end
    end.

encode_oid(Val) when is_tuple(Val) ->
    encode_oid(tuple_to_list(Val));
encode_oid(Val) ->
    iolist_to_binary(e_object_identifier(Val)).

extension_bitmap(Val, Pos, Limit) ->
    extension_bitmap(Val, Pos, Limit, 0).

extension_bitmap(_Val, Pos, Limit, Acc) when Pos >= Limit ->
    Acc;
extension_bitmap(Val, Pos, Limit, Acc) ->
    Bit =
        case element(Pos, Val) of
            asn1_NOVALUE ->
                0;
            _ ->
                1
        end,
    extension_bitmap(Val, Pos + 1, Limit, Acc bsl 1 bor Bit).

int_to_bitlist(0) ->
    [];
int_to_bitlist(Int) ->
    [Int band 1|int_to_bitlist(Int bsr 1)].

ntz(Byte) ->
    T = {8,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         3,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         4,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         3,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         5,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         3,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         4,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         3,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         6,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         3,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         4,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         3,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         5,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         3,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         4,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         3,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         7,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         3,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         4,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         3,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         5,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         3,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         4,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         3,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         6,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         3,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         4,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         3,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         5,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         3,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         4,
         0,
         1,
         0,
         2,
         0,
         1,
         0,
         3,
         0,
         1,
         0,
         2,
         0,
         1,
         0},
    element(Byte + 1, T).

skipextensions(Bytes0, Nr, ExtensionBitstr)
    when is_bitstring(ExtensionBitstr) ->
    Prev = Nr - 1,
    case ExtensionBitstr of
        <<_:Prev,1:1,_/bitstring>> ->
            {Len,Bytes1} = decode_length(Bytes0),
            <<_:Len/binary,Bytes2/bitstring>> = Bytes1,
            skipextensions(Bytes2, Nr + 1, ExtensionBitstr);
        <<_:Prev,0:1,_/bitstring>> ->
            skipextensions(Bytes0, Nr + 1, ExtensionBitstr);
        _ ->
            Bytes0
    end.

to_bitstring({0,Bs}) when is_binary(Bs) ->
    Bs;
to_bitstring({Unused,Bs0}) when is_binary(Bs0) ->
    Sz = bit_size(Bs0) - Unused,
    <<Bs:Sz/bits,_/bits>> = Bs0,
    Bs;
to_bitstring(Bs) when is_bitstring(Bs) ->
    Bs;
to_bitstring(Int) when is_integer(Int), Int >= 0 ->
    L = int_to_bitlist(Int),
    << 
      <<B:1>> ||
          B <- L
    >>;
to_bitstring(L) when is_list(L) ->
    << 
      <<B:1>> ||
          B <- L
    >>.

to_named_bitstring(Val) ->
    Bs = to_bitstring(Val),
    bs_drop_trailing_zeroes(Bs).
