"""Generated message classes for ml version v1beta1.

An API to enable creating and using machine learning models.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'ml'


class GoogleApiHttpBody(_messages.Message):
  """Message that represents an arbitrary HTTP body. It should only be used
  for payload formats that can't be represented as JSON, such as raw binary or
  an HTML page.   This message can be used both in streaming and non-streaming
  API methods in the request as well as the response.  It can be used as a
  top-level request field, which is convenient if one wants to extract
  parameters from either the URL or HTTP template into the request fields and
  also want access to the raw HTTP body.  Example:      message
  GetResourceRequest {       // A unique request id.       string request_id =
  1;        // The raw HTTP body is bound to this field.
  google.api.HttpBody http_body = 2;     }      service ResourceService {
  rpc GetResource(GetResourceRequest) returns (google.api.HttpBody);       rpc
  UpdateResource(google.api.HttpBody) returns (google.protobuf.Empty);     }
  Example with streaming methods:      service CaldavService {       rpc
  GetCalendar(stream google.api.HttpBody)         returns (stream
  google.api.HttpBody);       rpc UpdateCalendar(stream google.api.HttpBody)
  returns (stream google.api.HttpBody);     }  Use of this type only changes
  how the request and response bodies are handled, all other features will
  continue to work unchanged.

  Fields:
    contentType: The HTTP Content-Type string representing the content type of
      the body.
    data: HTTP body binary data.
  """

  contentType = _messages.StringField(1)
  data = _messages.BytesField(2)


class GoogleCloudMlV1ManualScaling(_messages.Message):
  """Options for manually scaling a model.

  Fields:
    nodes: The number of nodes to allocate for this model. These nodes are
      always up, starting from the time the model is deployed, so the cost of
      operating this model will be proportional to nodes * number of hours
      since deployment.
  """

  nodes = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudMlV1OperationMetadata(_messages.Message):
  """Represents the metadata of the long-running operation.

  Enums:
    OperationTypeValueValuesEnum: The operation type.

  Fields:
    createTime: The time the operation was submitted.
    endTime: The time operation processing completed.
    isCancellationRequested: Indicates whether a request to cancel this
      operation has been made.
    modelName: Contains the name of the model associated with the operation.
    operationType: The operation type.
    startTime: The time operation processing started.
    version: Contains the version associated with the operation.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    """The operation type.

    Values:
      OPERATION_TYPE_UNSPECIFIED: Unspecified operation type.
      CREATE_VERSION: An operation to create a new version.
      DELETE_VERSION: An operation to delete an existing version.
      DELETE_MODEL: An operation to delete an existing model.
    """
    OPERATION_TYPE_UNSPECIFIED = 0
    CREATE_VERSION = 1
    DELETE_VERSION = 2
    DELETE_MODEL = 3

  createTime = _messages.StringField(1)
  endTime = _messages.StringField(2)
  isCancellationRequested = _messages.BooleanField(3)
  modelName = _messages.StringField(4)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 5)
  startTime = _messages.StringField(6)
  version = _messages.MessageField('GoogleCloudMlV1Version', 7)


class GoogleCloudMlV1Version(_messages.Message):
  """Represents a version of the model.  Each version is a trained model
  deployed in the cloud, ready to handle prediction requests. A model can have
  multiple versions. You can get information about all of the versions of a
  given model by calling [projects.models.versions.list](/ml/reference/rest/v1
  /projects.models.versions/list).

  Fields:
    createTime: Output only. The time the version was created.
    deploymentUri: Required. The Google Cloud Storage location of the trained
      model used to create the version. See the [overview of model
      deployment](/ml/docs/concepts/deployment-overview) for more informaiton.
      When passing Version to [projects.models.versions.create](/ml/reference/
      rest/v1/projects.models.versions/create) the model service uses the
      specified location as the source of the model. Once deployed, the model
      version is hosted by the prediction service, so this location is useful
      only as a historical record.
    description: Optional. The description specified for the version when it
      was created.
    isDefault: Output only. If true, this version will be used to handle
      prediction requests that do not specify a version.  You can change the
      default version by calling [projects.methods.versions.setDefault](/ml/re
      ference/rest/v1/projects.models.versions/setDefault).
    lastUseTime: Output only. The time the version was last used for
      prediction.
    manualScaling: Optional. Manually select the number of nodes to use for
      serving the model. If unset (i.e., by default), the number of nodes used
      to serve the model automatically scales with traffic. However, care
      should be taken to ramp up traffic according to the model's ability to
      scale. If your model needs to handle bursts of traffic beyond it's
      ability to scale, it is recommended you set this field appropriately.
    name: Required.The name specified for the version when it was created.
      The version name must be unique within the model it is created in.
    runtimeVersion: Optional. The Google Cloud ML runtime version to use for
      this deployment. If not set, Google Cloud ML will choose a version.
  """

  createTime = _messages.StringField(1)
  deploymentUri = _messages.StringField(2)
  description = _messages.StringField(3)
  isDefault = _messages.BooleanField(4)
  lastUseTime = _messages.StringField(5)
  manualScaling = _messages.MessageField('GoogleCloudMlV1ManualScaling', 6)
  name = _messages.StringField(7)
  runtimeVersion = _messages.StringField(8)


class GoogleCloudMlV1beta1CancelJobRequest(_messages.Message):
  """Request message for the CancelJob method."""


class GoogleCloudMlV1beta1GetConfigResponse(_messages.Message):
  """Returns service account information associated with a project.

  Fields:
    serviceAccount: The service account Cloud ML uses to access resources in
      the project.
    serviceAccountProject: The project number for `service_account`.
  """

  serviceAccount = _messages.StringField(1)
  serviceAccountProject = _messages.IntegerField(2)


class GoogleCloudMlV1beta1HyperparameterOutput(_messages.Message):
  """Represents the result of a single hyperparameter tuning trial from a
  training job. The TrainingOutput object that is returned on successful
  completion of a training job with hyperparameter tuning includes a list of
  HyperparameterOutput objects, one for each successful trial.

  Messages:
    HyperparametersValue: The hyperparameters given to this trial.

  Fields:
    allMetrics: All recorded object metrics for this trial.
    finalMetric: The final objective metric seen for this trial.
    hyperparameters: The hyperparameters given to this trial.
    trialId: The trial id for these results.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class HyperparametersValue(_messages.Message):
    """The hyperparameters given to this trial.

    Messages:
      AdditionalProperty: An additional property for a HyperparametersValue
        object.

    Fields:
      additionalProperties: Additional properties of type HyperparametersValue
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a HyperparametersValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  allMetrics = _messages.MessageField('GoogleCloudMlV1beta1HyperparameterOutputHyperparameterMetric', 1, repeated=True)
  finalMetric = _messages.MessageField('GoogleCloudMlV1beta1HyperparameterOutputHyperparameterMetric', 2)
  hyperparameters = _messages.MessageField('HyperparametersValue', 3)
  trialId = _messages.StringField(4)


class GoogleCloudMlV1beta1HyperparameterOutputHyperparameterMetric(_messages.Message):
  """An observed value of a metric.

  Fields:
    objectiveValue: The objective value at this training step.
    trainingStep: The global training step for this metric.
  """

  objectiveValue = _messages.FloatField(1)
  trainingStep = _messages.IntegerField(2)


class GoogleCloudMlV1beta1HyperparameterSpec(_messages.Message):
  """Represents a set of hyperparameters to optimize.

  Enums:
    GoalValueValuesEnum: Required. The type of goal to use for tuning.
      Available types are `MAXIMIZE` and `MINIMIZE`.  Defaults to `MAXIMIZE`.

  Fields:
    goal: Required. The type of goal to use for tuning. Available types are
      `MAXIMIZE` and `MINIMIZE`.  Defaults to `MAXIMIZE`.
    hyperparameterMetricTag: Optional. The Tensorflow summary tag name to use
      for optimizing trials. For current versions of Tensorflow, this tag name
      should exactly match what is shown in Tensorboard, including all scopes.
      For versions of Tensorflow prior to 0.12, this should be only the tag
      passed to tf.Summary. By default, "training/hptuning/metric" will be
      used.
    maxParallelTrials: Optional. The number of training trials to run
      concurrently. You can reduce the time it takes to perform hyperparameter
      tuning by adding trials in parallel. However, each trail only benefits
      from the information gained in completed trials. That means that a trial
      does not get access to the results of trials running at the same time,
      which could reduce the quality of the overall optimization.  Each trial
      will use the same scale tier and machine types.  Defaults to one.
    maxTrials: Optional. How many training trials should be attempted to
      optimize the specified hyperparameters.  Defaults to one.
    params: Required. The set of parameters to tune.
  """

  class GoalValueValuesEnum(_messages.Enum):
    """Required. The type of goal to use for tuning. Available types are
    `MAXIMIZE` and `MINIMIZE`.  Defaults to `MAXIMIZE`.

    Values:
      GOAL_TYPE_UNSPECIFIED: Goal Type will default to maximize.
      MAXIMIZE: Maximize the goal metric.
      MINIMIZE: Minimize the goal metric.
    """
    GOAL_TYPE_UNSPECIFIED = 0
    MAXIMIZE = 1
    MINIMIZE = 2

  goal = _messages.EnumField('GoalValueValuesEnum', 1)
  hyperparameterMetricTag = _messages.StringField(2)
  maxParallelTrials = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  maxTrials = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  params = _messages.MessageField('GoogleCloudMlV1beta1ParameterSpec', 5, repeated=True)


class GoogleCloudMlV1beta1Job(_messages.Message):
  """Represents a training or prediction job.

  Enums:
    StateValueValuesEnum: Output only. The detailed state of a job.

  Fields:
    createTime: Output only. When the job was created.
    endTime: Output only. When the job processing was completed.
    errorMessage: Output only. The details of a failure or a cancellation.
    jobId: Required. The user-specified id of the job.
    predictionInput: Input parameters to create a prediction job.
    predictionOutput: The current prediction job result.
    startTime: Output only. When the job processing was started.
    state: Output only. The detailed state of a job.
    trainingInput: Input parameters to create a training job.
    trainingOutput: The current training job result.
  """

  class StateValueValuesEnum(_messages.Enum):
    """Output only. The detailed state of a job.

    Values:
      STATE_UNSPECIFIED: The job state is unspecified.
      QUEUED: The job has been just created and processing has not yet begun.
      PREPARING: The service is preparing to run the job.
      RUNNING: The job is in progress.
      SUCCEEDED: The job completed successfully.
      FAILED: The job failed. `error_message` should contain the details of
        the failure.
      CANCELLING: The job is being cancelled. `error_message` should describe
        the reason for the cancellation.
      CANCELLED: The job has been cancelled. `error_message` should describe
        the reason for the cancellation.
    """
    STATE_UNSPECIFIED = 0
    QUEUED = 1
    PREPARING = 2
    RUNNING = 3
    SUCCEEDED = 4
    FAILED = 5
    CANCELLING = 6
    CANCELLED = 7

  createTime = _messages.StringField(1)
  endTime = _messages.StringField(2)
  errorMessage = _messages.StringField(3)
  jobId = _messages.StringField(4)
  predictionInput = _messages.MessageField('GoogleCloudMlV1beta1PredictionInput', 5)
  predictionOutput = _messages.MessageField('GoogleCloudMlV1beta1PredictionOutput', 6)
  startTime = _messages.StringField(7)
  state = _messages.EnumField('StateValueValuesEnum', 8)
  trainingInput = _messages.MessageField('GoogleCloudMlV1beta1TrainingInput', 9)
  trainingOutput = _messages.MessageField('GoogleCloudMlV1beta1TrainingOutput', 10)


class GoogleCloudMlV1beta1ListJobsResponse(_messages.Message):
  """Response message for the ListJobs method.

  Fields:
    jobs: The list of jobs.
    nextPageToken: Optional. Pass this token as the `page_token` field of the
      request for a subsequent call.
  """

  jobs = _messages.MessageField('GoogleCloudMlV1beta1Job', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudMlV1beta1ListModelsResponse(_messages.Message):
  """Response message for the ListModels method.

  Fields:
    models: The list of models.
    nextPageToken: Optional. Pass this token as the `page_token` field of the
      request for a subsequent call.
  """

  models = _messages.MessageField('GoogleCloudMlV1beta1Model', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudMlV1beta1ListVersionsResponse(_messages.Message):
  """Response message for the ListVersions method.

  Fields:
    nextPageToken: Optional. Pass this token as the `page_token` field of the
      request for a subsequent call.
    versions: The list of versions.
  """

  nextPageToken = _messages.StringField(1)
  versions = _messages.MessageField('GoogleCloudMlV1beta1Version', 2, repeated=True)


class GoogleCloudMlV1beta1ManualScaling(_messages.Message):
  """Options for manually scaling a model.

  Fields:
    nodes: The number of nodes to allocate for this model. These nodes are
      always up, starting from the time the model is deployed, so the cost of
      operating this model will be proportional to nodes * number of hours
      since deployment.
  """

  nodes = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class GoogleCloudMlV1beta1Model(_messages.Message):
  """Represents a machine learning solution.  A model can have multiple
  versions, each of which is a deployed, trained model ready to receive
  prediction requests. The model itself is just a container.

  Fields:
    defaultVersion: Output only. The default version of the model. This
      version will be used to handle prediction requests that do not specify a
      version.  You can change the default version by calling [projects.method
      s.versions.setDefault](/ml/reference/rest/v1beta1/projects.models.versio
      ns/setDefault).
    description: Optional. The description specified for the model when it was
      created.
    name: Required. The name specified for the model when it was created.  The
      model name must be unique within the project it is created in.
    onlinePredictionLogging: Optional. If true, enables StackDriver Logging
      for online prediction. Default is false.
    regions: Optional. The list of regions where the model is going to be
      deployed. Currently only one region per model is supported. Defaults to
      'us-central1' if nothing is set.
  """

  defaultVersion = _messages.MessageField('GoogleCloudMlV1beta1Version', 1)
  description = _messages.StringField(2)
  name = _messages.StringField(3)
  onlinePredictionLogging = _messages.BooleanField(4)
  regions = _messages.StringField(5, repeated=True)


class GoogleCloudMlV1beta1OperationMetadata(_messages.Message):
  """Represents the metadata of the long-running operation.

  Enums:
    OperationTypeValueValuesEnum: The operation type.

  Fields:
    createTime: The time the operation was submitted.
    endTime: The time operation processing completed.
    isCancellationRequested: Indicates whether a request to cancel this
      operation has been made.
    modelName: Contains the name of the model associated with the operation.
    operationType: The operation type.
    startTime: The time operation processing started.
    version: Contains the version associated with the operation.
  """

  class OperationTypeValueValuesEnum(_messages.Enum):
    """The operation type.

    Values:
      OPERATION_TYPE_UNSPECIFIED: Unspecified operation type.
      CREATE_VERSION: An operation to create a new version.
      DELETE_VERSION: An operation to delete an existing version.
      DELETE_MODEL: An operation to delete an existing model.
    """
    OPERATION_TYPE_UNSPECIFIED = 0
    CREATE_VERSION = 1
    DELETE_VERSION = 2
    DELETE_MODEL = 3

  createTime = _messages.StringField(1)
  endTime = _messages.StringField(2)
  isCancellationRequested = _messages.BooleanField(3)
  modelName = _messages.StringField(4)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 5)
  startTime = _messages.StringField(6)
  version = _messages.MessageField('GoogleCloudMlV1beta1Version', 7)


class GoogleCloudMlV1beta1ParameterSpec(_messages.Message):
  """Represents a single hyperparameter to optimize.

  Enums:
    ScaleTypeValueValuesEnum: Optional. How the parameter should be scaled to
      the hypercube. Leave unset for categorical parameters. Some kind of
      scaling is strongly recommended for real or integral parameters (e.g.,
      `UNIT_LINEAR_SCALE`).
    TypeValueValuesEnum: Required. The type of the parameter.

  Fields:
    categoricalValues: Required if type is `CATEGORICAL`. The list of possible
      categories.
    discreteValues: Required if type is `DISCRETE`. A list of feasible points.
      The list should be in strictly increasing order. For instance, this
      parameter might have possible settings of 1.5, 2.5, and 4.0. This list
      should not contain more than 1,000 values.
    maxValue: Required if typeis `DOUBLE` or `INTEGER`. This field should be
      unset if type is `CATEGORICAL`. This value should be integers if type is
      `INTEGER`.
    minValue: Required if type is `DOUBLE` or `INTEGER`. This field should be
      unset if type is `CATEGORICAL`. This value should be integers if type is
      INTEGER.
    parameterName: Required. The parameter name must be unique amongst all
      ParameterConfigs in a HyperparameterSpec message. E.g., "learning_rate".
    scaleType: Optional. How the parameter should be scaled to the hypercube.
      Leave unset for categorical parameters. Some kind of scaling is strongly
      recommended for real or integral parameters (e.g., `UNIT_LINEAR_SCALE`).
    type: Required. The type of the parameter.
  """

  class ScaleTypeValueValuesEnum(_messages.Enum):
    """Optional. How the parameter should be scaled to the hypercube. Leave
    unset for categorical parameters. Some kind of scaling is strongly
    recommended for real or integral parameters (e.g., `UNIT_LINEAR_SCALE`).

    Values:
      NONE: By default, no scaling is applied.
      UNIT_LINEAR_SCALE: Scales the feasible space to (0, 1) linearly.
      UNIT_LOG_SCALE: Scales the feasible space logarithmically to (0, 1). The
        entire feasible space must be strictly positive.
      UNIT_REVERSE_LOG_SCALE: Scales the feasible space "reverse"
        logarithmically to (0, 1). The result is that values close to the top
        of the feasible space are spread out more than points near the bottom.
        The entire feasible space must be strictly positive.
    """
    NONE = 0
    UNIT_LINEAR_SCALE = 1
    UNIT_LOG_SCALE = 2
    UNIT_REVERSE_LOG_SCALE = 3

  class TypeValueValuesEnum(_messages.Enum):
    """Required. The type of the parameter.

    Values:
      PARAMETER_TYPE_UNSPECIFIED: You must specify a valid type. Using this
        unspecified type will result in an error.
      DOUBLE: Type for real-valued parameters.
      INTEGER: Type for integral parameters.
      CATEGORICAL: The parameter is categorical, with a value chosen from the
        categories field.
      DISCRETE: The parameter is real valued, with a fixed set of feasible
        points. If `type==DISCRETE`, feasible_points must be provided, and
        {`min_value`, `max_value`} will be ignored.
    """
    PARAMETER_TYPE_UNSPECIFIED = 0
    DOUBLE = 1
    INTEGER = 2
    CATEGORICAL = 3
    DISCRETE = 4

  categoricalValues = _messages.StringField(1, repeated=True)
  discreteValues = _messages.FloatField(2, repeated=True)
  maxValue = _messages.FloatField(3)
  minValue = _messages.FloatField(4)
  parameterName = _messages.StringField(5)
  scaleType = _messages.EnumField('ScaleTypeValueValuesEnum', 6)
  type = _messages.EnumField('TypeValueValuesEnum', 7)


class GoogleCloudMlV1beta1PredictRequest(_messages.Message):
  """Request for predictions to be issued against a trained model.  The body
  of the request is a single JSON object with a single top-level field:  <dl>
  <dt>instances</dt>   <dd>A JSON array containing values representing the
  instances to use for       prediction.</dd> </dl>  The structure of each
  element of the instances list is determined by your model's input
  definition. Instances can include named inputs or can contain only unlabeled
  values.  Not all data includes named inputs. Some instances will be simple
  JSON values (boolean, number, or string). However, instances are often lists
  of simple values, or complex nested lists. Here are some examples of request
  bodies:  CSV data with each row encoded as a string value: <pre>
  {"instances": ["1.0,true,\\"x\\"", "-2.0,false,\\"y\\""]} </pre> Plain text:
  <pre> {"instances": ["the quick brown fox", "la bruja le dio"]} </pre>
  Sentences encoded as lists of words (vectors of strings): <pre> {
  "instances": [     ["the","quick","brown"],     ["la","bruja","le"],     ...
  ] } </pre> Floating point scalar values: <pre> {"instances": [0.0, 1.1,
  2.2]} </pre> Vectors of integers: <pre> {   "instances": [     [0, 1, 2],
  [3, 4, 5],     ...   ] } </pre> Tensors (in this case, two-dimensional
  tensors): <pre> {   "instances": [     [       [0, 1, 2],       [3, 4, 5]
  ],     ...   ] } </pre> Images can be represented different ways. In this
  encoding scheme the first two dimensions represent the rows and columns of
  the image, and the third contains lists (vectors) of the R, G, and B values
  for each pixel. <pre> {   "instances": [     [       [         [138, 30,
  66],         [130, 20, 56],         ...       ],       [         [126, 38,
  61],         [122, 24, 57],         ...       ],       ...     ],     ...
  ] } </pre> JSON strings must be encoded as UTF-8. To send binary data, you
  must base64-encode the data and mark it as binary. To mark a JSON string as
  binary, replace it with a JSON object with a single attribute named `b64`:
  <pre>{"b64": "..."} </pre> For example:  Two Serialized tf.Examples (fake
  data, for illustrative purposes only): <pre> {"instances": [{"b64":
  "X5ad6u"}, {"b64": "IA9j4nx"}]} </pre> Two JPEG image byte strings (fake
  data, for illustrative purposes only): <pre> {"instances": [{"b64":
  "ASa8asdf"}, {"b64": "JLK7ljk3"}]} </pre> If your data includes named
  references, format each instance as a JSON object with the named references
  as the keys:  JSON input data to be preprocessed: <pre> {   "instances": [
  {       "a": 1.0,       "b": true,       "c": "x"     },     {       "a":
  -2.0,       "b": false,       "c": "y"     }   ] } </pre> Some models have
  an underlying TensorFlow graph that accepts multiple input tensors. In this
  case, you should use the names of JSON name/value pairs to identify the
  input tensors, as shown in the following exmaples:  For a graph with input
  tensor aliases "tag" (string) and "image" (base64-encoded string): <pre> {
  "instances": [     {       "tag": "beach",       "image": {"b64":
  "ASa8asdf"}     },     {       "tag": "car",       "image": {"b64":
  "JLK7ljk3"}     }   ] } </pre> For a graph with input tensor aliases "tag"
  (string) and "image" (3-dimensional array of 8-bit ints): <pre> {
  "instances": [     {       "tag": "beach",       "image": [         [
  [138, 30, 66],           [130, 20, 56],           ...         ],         [
  [126, 38, 61],           [122, 24, 57],           ...         ],         ...
  ]     },     {       "tag": "car",       "image": [         [
  [255, 0, 102],           [255, 0, 97],           ...         ],         [
  [254, 1, 101],           [254, 2, 93],           ...         ],         ...
  ]     },     ...   ] } </pre> If the call is successful, the response body
  will contain one prediction entry per instance in the request body. If
  prediction fails for any instance, the response body will contain no
  predictions and will contian a single error entry instead.

  Fields:
    httpBody:  Required. The prediction request body.
  """

  httpBody = _messages.MessageField('GoogleApiHttpBody', 1)


class GoogleCloudMlV1beta1PredictionInput(_messages.Message):
  """Represents input parameters for a prediction job.

  Enums:
    DataFormatValueValuesEnum: Required. The format of the input data files.

  Fields:
    dataFormat: Required. The format of the input data files.
    inputPaths: Required. The Google Cloud Storage location of the input data
      files. May contain wildcards.
    maxWorkerCount: Optional. The maximum number of workers to be used for
      parallel processing. Defaults to 10 if not specified.
    modelName: Use this field if you want to use the default version for the
      specified model. The string must use the following format:
      `"projects/<var>[YOUR_PROJECT]</var>/models/<var>[YOUR_MODEL]</var>"`
    outputPath: Required. The output Google Cloud Storage location.
    region: Required. The Google Compute Engine region to run the prediction
      job in.
    runtimeVersion: Optional. The Google Cloud ML runtime version to use for
      this batch prediction. If not set, Google Cloud ML will pick the runtime
      version used during the CreateVersion request for this model version, or
      choose the latest stable version when model version information is not
      available such as when the model is specified by uri.
    uri: Use this field if you want to specify a Google Cloud Storage path for
      the model to use.
    versionName: Use this field if you want to specify a version of the model
      to use. The string is formatted the same way as `model_version`, with
      the addition of the version information:  `"projects/<var>[YOUR_PROJECT]
      </var>/models/<var>YOUR_MODEL/versions/<var>[YOUR_VERSION]</var>"`
  """

  class DataFormatValueValuesEnum(_messages.Enum):
    """Required. The format of the input data files.

    Values:
      DATA_FORMAT_UNSPECIFIED: Unspecified format.
      TEXT: The source file is a text file with instances separated by the
        new-line character.
      TF_RECORD: The source file is a TFRecord file.
      TF_RECORD_GZIP: The source file is a GZIP-compressed TFRecord file.
    """
    DATA_FORMAT_UNSPECIFIED = 0
    TEXT = 1
    TF_RECORD = 2
    TF_RECORD_GZIP = 3

  dataFormat = _messages.EnumField('DataFormatValueValuesEnum', 1)
  inputPaths = _messages.StringField(2, repeated=True)
  maxWorkerCount = _messages.IntegerField(3)
  modelName = _messages.StringField(4)
  outputPath = _messages.StringField(5)
  region = _messages.StringField(6)
  runtimeVersion = _messages.StringField(7)
  uri = _messages.StringField(8)
  versionName = _messages.StringField(9)


class GoogleCloudMlV1beta1PredictionOutput(_messages.Message):
  """Represents results of a prediction job.

  Fields:
    errorCount: The number of data instances which resulted in errors.
    nodeHours: Node hours used by the batch prediction job.
    outputPath: The output Google Cloud Storage location provided at the job
      creation time.
    predictionCount: The number of generated predictions.
  """

  errorCount = _messages.IntegerField(1)
  nodeHours = _messages.FloatField(2)
  outputPath = _messages.StringField(3)
  predictionCount = _messages.IntegerField(4)


class GoogleCloudMlV1beta1SetDefaultVersionRequest(_messages.Message):
  """Request message for the SetDefaultVersion request."""


class GoogleCloudMlV1beta1TrainingInput(_messages.Message):
  """Represents input parameters for a training job.

  Enums:
    ScaleTierValueValuesEnum: Required. Specifies the machine types, the
      number of replicas for workers and parameter servers.

  Fields:
    args: Optional. Command line arguments to pass to the program.
    hyperparameters: Optional. The set of Hyperparameters to tune.
    jobDir: Optional. A Google Cloud Storage path in which to store training
      outputs and other data needed for training. This path is passed to your
      TensorFlow program as the 'job_dir' command-line argument. The benefit
      of specifying this field is that Cloud ML validates the path for use in
      training.
    masterType: Optional. Specifies the type of virtual machine to use for
      your training job's master worker.  The following types are supported:
      <dl>   <dt>standard</dt>   <dd>   A basic machine configuration suitable
      for training simple models with   small to moderate datasets.   </dd>
      <dt>large_model</dt>   <dd>   A machine with a lot of memory, specially
      suited for parameter servers   when your model is large (having many
      hidden layers or layers with very   large numbers of nodes).   </dd>
      <dt>complex_model_s</dt>   <dd>   A machine suitable for the master and
      workers of the cluster when your   model requires more computation than
      the standard machine can handle   satisfactorily.   </dd>
      <dt>complex_model_m</dt>   <dd>   A machine with roughly twice the
      number of cores and roughly double the   memory of <code
      suppresswarning="true">complex_model_s</code>.   </dd>
      <dt>complex_model_l</dt>   <dd>   A machine with roughly twice the
      number of cores and roughly double the   memory of <code
      suppresswarning="true">complex_model_m</code>.   </dd>
      <dt>standard_gpu</dt>   <dd>   A machine equivalent to <code
      suppresswarning="true">standard</code> that   also includes a   <a
      href="ml/docs/how-tos/using-gpus">   GPU that you can use in your
      trainer</a>.   </dd>   <dt>complex_model_m_gpu</dt>   <dd>   A machine
      equivalent to   <code suppresswarning="true">coplex_model_m</code> that
      also includes   four GPUs.   </dd> </dl>  You must set this value when
      `scaleTier` is set to `CUSTOM`.
    packageUris: Required. The Google Cloud Storage location of the packages
      with the training program and any additional dependencies.
    parameterServerCount: Optional. The number of parameter server replicas to
      use for the training job. Each replica in the cluster will be of the
      type specified in `parameter_server_type`.  This value can only be used
      when `scale_tier` is set to `CUSTOM`.If you set this value, you must
      also set `parameter_server_type`.
    parameterServerType: Optional. Specifies the type of virtual machine to
      use for your training job's parameter server.  The supported values are
      the same as those described in the entry for `master_type`.  This value
      must be present when `scaleTier` is set to `CUSTOM` and
      `parameter_server_count` is greater than zero.
    pythonModule: Required. The Python module name to run after installing the
      packages.
    region: Required. The Google Compute Engine region to run the training job
      in.
    runtimeVersion: Optional. The Google Cloud ML runtime version to use for
      training.  If not set, Google Cloud ML will choose the latest stable
      version.
    scaleTier: Required. Specifies the machine types, the number of replicas
      for workers and parameter servers.
    workerCount: Optional. The number of worker replicas to use for the
      training job. Each replica in the cluster will be of the type specified
      in `worker_type`.  This value can only be used when `scale_tier` is set
      to `CUSTOM`. If you set this value, you must also set `worker_type`.
    workerType: Optional. Specifies the type of virtual machine to use for
      your training job's worker nodes.  The supported values are the same as
      those described in the entry for `masterType`.  This value must be
      present when `scaleTier` is set to `CUSTOM` and `workerCount` is greater
      than zero.
  """

  class ScaleTierValueValuesEnum(_messages.Enum):
    """Required. Specifies the machine types, the number of replicas for
    workers and parameter servers.

    Values:
      BASIC: A single worker instance. This tier is suitable for learning how
        to use Cloud ML, and for experimenting with new models using small
        datasets.
      STANDARD_1: Many workers and a few parameter servers.
      PREMIUM_1: A large number of workers with many parameter servers.
      BASIC_GPU: A single worker instance [with a GPU](ml/docs/how-tos/using-
        gpus).
      CUSTOM: The CUSTOM tier is not a set tier, but rather enables you to use
        your own cluster specification. When you use this tier, set values to
        configure your processing cluster according to these guidelines:  *
        You _must_ set `TrainingInput.masterType` to specify the type     of
        machine to use for your master node. This is the only required
        setting.  *   You _may_ set `TrainingInput.workerCount` to specify the
        number of     workers to use. If you specify one or more workers, you
        _must_ also     set `TrainingInput.workerType` to specify the type of
        machine to use     for your worker nodes.  *   You _may_ set
        `TrainingInput.parameterServerCount` to specify the     number of
        parameter servers to use. If you specify one or more     parameter
        servers, you _must_ also set     `TrainingInput.parameterServerType`
        to specify the type of machine to     use for your parameter servers.
        Note that all of your workers must use the same machine type, which
        can be different from your parameter server type and master type. Your
        parameter servers must likewise use the same machine type, which can
        be different from your worker type and master type.
    """
    BASIC = 0
    STANDARD_1 = 1
    PREMIUM_1 = 2
    BASIC_GPU = 3
    CUSTOM = 4

  args = _messages.StringField(1, repeated=True)
  hyperparameters = _messages.MessageField('GoogleCloudMlV1beta1HyperparameterSpec', 2)
  jobDir = _messages.StringField(3)
  masterType = _messages.StringField(4)
  packageUris = _messages.StringField(5, repeated=True)
  parameterServerCount = _messages.IntegerField(6)
  parameterServerType = _messages.StringField(7)
  pythonModule = _messages.StringField(8)
  region = _messages.StringField(9)
  runtimeVersion = _messages.StringField(10)
  scaleTier = _messages.EnumField('ScaleTierValueValuesEnum', 11)
  workerCount = _messages.IntegerField(12)
  workerType = _messages.StringField(13)


class GoogleCloudMlV1beta1TrainingOutput(_messages.Message):
  """Represents results of a training job. Output only.

  Fields:
    completedTrialCount: The number of hyperparameter tuning trials that
      completed successfully. Only set for hyperparameter tuning jobs.
    consumedMLUnits: The amount of ML units consumed by the job.
    isHyperparameterTuningJob: Whether this job is a hyperparameter tuning
      job.
    trials: Results for individual Hyperparameter trials. Only set for
      hyperparameter tuning jobs.
  """

  completedTrialCount = _messages.IntegerField(1)
  consumedMLUnits = _messages.FloatField(2)
  isHyperparameterTuningJob = _messages.BooleanField(3)
  trials = _messages.MessageField('GoogleCloudMlV1beta1HyperparameterOutput', 4, repeated=True)


class GoogleCloudMlV1beta1Version(_messages.Message):
  """Represents a version of the model.  Each version is a trained model
  deployed in the cloud, ready to handle prediction requests. A model can have
  multiple versions. You can get information about all of the versions of a
  given model by calling [projects.models.versions.list](/ml/reference/rest/v1
  beta1/projects.models.versions/list).

  Fields:
    createTime: Output only. The time the version was created.
    deploymentUri: Required. The Google Cloud Storage location of the trained
      model used to create the version. See the [overview of model
      deployment](/ml/docs/concepts/deployment-overview) for more informaiton.
      When passing Version to [projects.models.versions.create](/ml/reference/
      rest/v1beta1/projects.models.versions/create) the model service uses the
      specified location as the source of the model. Once deployed, the model
      version is hosted by the prediction service, so this location is useful
      only as a historical record.
    description: Optional. The description specified for the version when it
      was created.
    isDefault: Output only. If true, this version will be used to handle
      prediction requests that do not specify a version.  You can change the
      default version by calling [projects.methods.versions.setDefault](/ml/re
      ference/rest/v1beta1/projects.models.versions/setDefault).
    lastUseTime: Output only. The time the version was last used for
      prediction.
    manualScaling: Optional. Manually select the number of nodes to use for
      serving the model. If unset (i.e., by default), the number of nodes used
      to serve the model automatically scales with traffic. However, care
      should be taken to ramp up traffic according to the model's ability to
      scale. If your model needs to handle bursts of traffic beyond it's
      ability to scale, it is recommended you set this field appropriately.
    name: Required.The name specified for the version when it was created.
      The version name must be unique within the model it is created in.
    runtimeVersion: Optional. The Google Cloud ML runtime version to use for
      this deployment. If not set, Google Cloud ML will choose a version.
  """

  createTime = _messages.StringField(1)
  deploymentUri = _messages.StringField(2)
  description = _messages.StringField(3)
  isDefault = _messages.BooleanField(4)
  lastUseTime = _messages.StringField(5)
  manualScaling = _messages.MessageField('GoogleCloudMlV1beta1ManualScaling', 6)
  name = _messages.StringField(7)
  runtimeVersion = _messages.StringField(8)


class GoogleLongrunningListOperationsResponse(_messages.Message):
  """The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  """This resource represents a long-running operation that is the result of a
  network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation.
      It typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal response of the operation in case of success.
      If the original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If true, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation.  It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata.  Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should have the format of `operations/some/unique/name`.
    response: The normal response of the operation in case of success.  If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`.  If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource.  For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name.  For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    """Service-specific metadata associated with the operation.  It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata.  Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    """The normal response of the operation in case of success.  If the
    original method returns no data on success, such as `Delete`, the response
    is `google.protobuf.Empty`.  If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource.  For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name.  For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleProtobufEmpty(_messages.Message):
  """A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance:      service Foo {
  rpc Bar(google.protobuf.Empty) returns (google.protobuf.Empty);     }  The
  JSON representation for `Empty` is empty JSON object `{}`.
  """



class GoogleRpcStatus(_messages.Message):
  """The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). The error model is designed to be:
  - Simple to use and understand for most users - Flexible enough to meet
  unexpected needs  # Overview  The `Status` message contains three pieces of
  data: error code, error message, and error details. The error code should be
  an enum value of google.rpc.Code, but it may accept additional error codes
  if needed.  The error message should be a developer-facing English message
  that helps developers *understand* and *resolve* the error. If a localized
  user-facing error message is needed, put the localized message in the error
  details or localize it in the client. The optional error details may contain
  arbitrary information about the error. There is a predefined set of error
  detail types in the package `google.rpc` which can be used for common error
  conditions.  # Language mapping  The `Status` message is the logical
  representation of the error model, but it is not necessarily the actual wire
  format. When the `Status` message is exposed in different client libraries
  and different wire protocols, it can be mapped differently. For example, it
  will likely be mapped to some exceptions in Java, but more likely mapped to
  some error codes in C.  # Other uses  The error model and the `Status`
  message can be used in a variety of environments, either with or without
  APIs, to provide a consistent developer experience across different
  environments.  Example uses of this error model include:  - Partial errors.
  If a service needs to return partial errors to the client,     it may embed
  the `Status` in the normal response to indicate the partial     errors.  -
  Workflow errors. A typical workflow has multiple steps. Each step may
  have a `Status` message for error reporting purpose.  - Batch operations. If
  a client uses batch request and batch response, the     `Status` message
  should be used directly inside batch response, one for     each error sub-
  response.  - Asynchronous operations. If an API call embeds asynchronous
  operation     results in its response, the status of those operations should
  be     represented directly using the `Status` message.  - Logging. If some
  API errors are stored in logs, the message `Status` could     be used
  directly after any stripping needed for security/privacy reasons.

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details.  There will be a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    """A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      """An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class MlProjectsGetConfigRequest(_messages.Message):
  """A MlProjectsGetConfigRequest object.

  Fields:
    name: Required. The project name.  Authorization: requires `Viewer` role
      on the specified project.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsJobsCancelRequest(_messages.Message):
  """A MlProjectsJobsCancelRequest object.

  Fields:
    googleCloudMlV1beta1CancelJobRequest: A
      GoogleCloudMlV1beta1CancelJobRequest resource to be passed as the
      request body.
    name: Required. The name of the job to cancel.  Authorization: requires
      `Editor` role on the parent project.
  """

  googleCloudMlV1beta1CancelJobRequest = _messages.MessageField('GoogleCloudMlV1beta1CancelJobRequest', 1)
  name = _messages.StringField(2, required=True)


class MlProjectsJobsCreateRequest(_messages.Message):
  """A MlProjectsJobsCreateRequest object.

  Fields:
    googleCloudMlV1beta1Job: A GoogleCloudMlV1beta1Job resource to be passed
      as the request body.
    parent: Required. The project name.  Authorization: requires `Editor` role
      on the specified project.
  """

  googleCloudMlV1beta1Job = _messages.MessageField('GoogleCloudMlV1beta1Job', 1)
  parent = _messages.StringField(2, required=True)


class MlProjectsJobsGetRequest(_messages.Message):
  """A MlProjectsJobsGetRequest object.

  Fields:
    name: Required. The name of the job to get the description of.
      Authorization: requires `Viewer` role on the parent project.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsJobsListRequest(_messages.Message):
  """A MlProjectsJobsListRequest object.

  Fields:
    filter: Optional. Specifies the subset of jobs to retrieve.
    pageSize: Optional. The number of jobs to retrieve per "page" of results.
      If there are more remaining results than this number, the response
      message will contain a valid value in the `next_page_token` field.  The
      default value is 20, and the maximum page size is 100.
    pageToken: Optional. A page token to request the next page of results.
      You get the token from the `next_page_token` field of the response from
      the previous call.
    parent: Required. The name of the project for which to list jobs.
      Authorization: requires `Viewer` role on the specified project.
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class MlProjectsModelsCreateRequest(_messages.Message):
  """A MlProjectsModelsCreateRequest object.

  Fields:
    googleCloudMlV1beta1Model: A GoogleCloudMlV1beta1Model resource to be
      passed as the request body.
    parent: Required. The project name.  Authorization: requires `Editor` role
      on the specified project.
  """

  googleCloudMlV1beta1Model = _messages.MessageField('GoogleCloudMlV1beta1Model', 1)
  parent = _messages.StringField(2, required=True)


class MlProjectsModelsDeleteRequest(_messages.Message):
  """A MlProjectsModelsDeleteRequest object.

  Fields:
    name: Required. The name of the model.  Authorization: requires `Editor`
      role on the parent project.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsModelsGetRequest(_messages.Message):
  """A MlProjectsModelsGetRequest object.

  Fields:
    name: Required. The name of the model.  Authorization: requires `Viewer`
      role on the parent project.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsModelsListRequest(_messages.Message):
  """A MlProjectsModelsListRequest object.

  Fields:
    pageSize: Optional. The number of models to retrieve per "page" of
      results. If there are more remaining results than this number, the
      response message will contain a valid value in the `next_page_token`
      field.  The default value is 20, and the maximum page size is 100.
    pageToken: Optional. A page token to request the next page of results.
      You get the token from the `next_page_token` field of the response from
      the previous call.
    parent: Required. The name of the project whose models are to be listed.
      Authorization: requires `Viewer` role on the specified project.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class MlProjectsModelsVersionsCreateRequest(_messages.Message):
  """A MlProjectsModelsVersionsCreateRequest object.

  Fields:
    googleCloudMlV1beta1Version: A GoogleCloudMlV1beta1Version resource to be
      passed as the request body.
    parent: Required. The name of the model.  Authorization: requires `Editor`
      role on the parent project.
  """

  googleCloudMlV1beta1Version = _messages.MessageField('GoogleCloudMlV1beta1Version', 1)
  parent = _messages.StringField(2, required=True)


class MlProjectsModelsVersionsDeleteRequest(_messages.Message):
  """A MlProjectsModelsVersionsDeleteRequest object.

  Fields:
    name: Required. The name of the version. You can get the names of all the
      versions of a model by calling [projects.models.versions.list](/ml/refer
      ence/rest/v1beta1/projects.models.versions/list).  Authorization:
      requires `Editor` role on the parent project.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsModelsVersionsGetRequest(_messages.Message):
  """A MlProjectsModelsVersionsGetRequest object.

  Fields:
    name: Required. The name of the version.  Authorization: requires `Viewer`
      role on the parent project.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsModelsVersionsListRequest(_messages.Message):
  """A MlProjectsModelsVersionsListRequest object.

  Fields:
    pageSize: Optional. The number of versions to retrieve per "page" of
      results. If there are more remaining results than this number, the
      response message will contain a valid value in the `next_page_token`
      field.  The default value is 20, and the maximum page size is 100.
    pageToken: Optional. A page token to request the next page of results.
      You get the token from the `next_page_token` field of the response from
      the previous call.
    parent: Required. The name of the model for which to list the version.
      Authorization: requires `Viewer` role on the parent project.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)


class MlProjectsModelsVersionsSetDefaultRequest(_messages.Message):
  """A MlProjectsModelsVersionsSetDefaultRequest object.

  Fields:
    googleCloudMlV1beta1SetDefaultVersionRequest: A
      GoogleCloudMlV1beta1SetDefaultVersionRequest resource to be passed as
      the request body.
    name: Required. The name of the version to make the default for the model.
      You can get the names of all the versions of a model by calling [project
      s.models.versions.list](/ml/reference/rest/v1beta1/projects.models.versi
      ons/list).  Authorization: requires `Editor` role on the parent project.
  """

  googleCloudMlV1beta1SetDefaultVersionRequest = _messages.MessageField('GoogleCloudMlV1beta1SetDefaultVersionRequest', 1)
  name = _messages.StringField(2, required=True)


class MlProjectsOperationsCancelRequest(_messages.Message):
  """A MlProjectsOperationsCancelRequest object.

  Fields:
    name: The name of the operation resource to be cancelled.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsOperationsDeleteRequest(_messages.Message):
  """A MlProjectsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsOperationsGetRequest(_messages.Message):
  """A MlProjectsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class MlProjectsOperationsListRequest(_messages.Message):
  """A MlProjectsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation collection.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class MlProjectsPredictRequest(_messages.Message):
  """A MlProjectsPredictRequest object.

  Fields:
    googleCloudMlV1beta1PredictRequest: A GoogleCloudMlV1beta1PredictRequest
      resource to be passed as the request body.
    name: Required. The resource name of a model or a version.  Authorization:
      requires `Viewer` role on the parent project.
  """

  googleCloudMlV1beta1PredictRequest = _messages.MessageField('GoogleCloudMlV1beta1PredictRequest', 1)
  name = _messages.StringField(2, required=True)


class StandardQueryParameters(_messages.Message):
  """Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    bearer_token: OAuth bearer token.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    pp: Pretty-print response.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    """Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    """V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default=u'json')
  bearer_token = _messages.StringField(4)
  callback = _messages.StringField(5)
  fields = _messages.StringField(6)
  key = _messages.StringField(7)
  oauth_token = _messages.StringField(8)
  pp = _messages.BooleanField(9, default=True)
  prettyPrint = _messages.BooleanField(10, default=True)
  quotaUser = _messages.StringField(11)
  trace = _messages.StringField(12)
  uploadType = _messages.StringField(13)
  upload_protocol = _messages.StringField(14)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv',
    package=u'ml')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1',
    package=u'ml')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2',
    package=u'ml')
