/*
 * Decompiled with CFR 0.152.
 */
package sax;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import org.xml.sax.helpers.XMLReaderFactory;
import sax.helpers.AttributesImpl;

public class Writer
extends DefaultHandler
implements LexicalHandler {
    protected static final String NAMESPACES_FEATURE_ID = "http://xml.org/sax/features/namespaces";
    protected static final String NAMESPACE_PREFIXES_FEATURE_ID = "http://xml.org/sax/features/namespace-prefixes";
    protected static final String VALIDATION_FEATURE_ID = "http://xml.org/sax/features/validation";
    protected static final String SCHEMA_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/schema";
    protected static final String SCHEMA_FULL_CHECKING_FEATURE_ID = "http://apache.org/xml/features/validation/schema-full-checking";
    protected static final String HONOUR_ALL_SCHEMA_LOCATIONS_ID = "http://apache.org/xml/features/honour-all-schemaLocations";
    protected static final String VALIDATE_ANNOTATIONS_ID = "http://apache.org/xml/features/validate-annotations";
    protected static final String GENERATE_SYNTHETIC_ANNOTATIONS_ID = "http://apache.org/xml/features/generate-synthetic-annotations";
    protected static final String DYNAMIC_VALIDATION_FEATURE_ID = "http://apache.org/xml/features/validation/dynamic";
    protected static final String LOAD_EXTERNAL_DTD_FEATURE_ID = "http://apache.org/xml/features/nonvalidating/load-external-dtd";
    protected static final String XINCLUDE_FEATURE_ID = "http://apache.org/xml/features/xinclude";
    protected static final String XINCLUDE_FIXUP_BASE_URIS_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-base-uris";
    protected static final String XINCLUDE_FIXUP_LANGUAGE_FEATURE_ID = "http://apache.org/xml/features/xinclude/fixup-language";
    protected static final String LEXICAL_HANDLER_PROPERTY_ID = "http://xml.org/sax/properties/lexical-handler";
    protected static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    protected static final boolean DEFAULT_NAMESPACES = true;
    protected static final boolean DEFAULT_NAMESPACE_PREFIXES = false;
    protected static final boolean DEFAULT_VALIDATION = false;
    protected static final boolean DEFAULT_LOAD_EXTERNAL_DTD = true;
    protected static final boolean DEFAULT_SCHEMA_VALIDATION = false;
    protected static final boolean DEFAULT_SCHEMA_FULL_CHECKING = false;
    protected static final boolean DEFAULT_HONOUR_ALL_SCHEMA_LOCATIONS = false;
    protected static final boolean DEFAULT_VALIDATE_ANNOTATIONS = false;
    protected static final boolean DEFAULT_GENERATE_SYNTHETIC_ANNOTATIONS = false;
    protected static final boolean DEFAULT_DYNAMIC_VALIDATION = false;
    protected static final boolean DEFAULT_XINCLUDE = false;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_BASE_URIS = true;
    protected static final boolean DEFAULT_XINCLUDE_FIXUP_LANGUAGE = true;
    protected static final boolean DEFAULT_CANONICAL = false;
    protected PrintWriter fOut;
    protected boolean fCanonical;
    protected int fElementDepth;
    protected Locator fLocator;
    protected boolean fXML11;
    protected boolean fInCDATA;

    public void setCanonical(boolean bl) {
        this.fCanonical = bl;
    }

    public void setOutput(OutputStream outputStream, String string) throws UnsupportedEncodingException {
        if (string == null) {
            string = "UTF8";
        }
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string);
        this.fOut = new PrintWriter(outputStreamWriter);
    }

    public void setOutput(java.io.Writer writer) {
        this.fOut = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
    }

    public void setDocumentLocator(Locator locator) {
        this.fLocator = locator;
    }

    public void startDocument() throws SAXException {
        this.fElementDepth = 0;
        this.fXML11 = false;
        this.fInCDATA = false;
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        if (this.fElementDepth > 0) {
            this.fOut.print("<?");
            this.fOut.print(string);
            if (string2 != null && string2.length() > 0) {
                this.fOut.print(' ');
                this.fOut.print(string2);
            }
            this.fOut.print("?>");
            this.fOut.flush();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if (this.fElementDepth == 0) {
            String string4 = "UTF-8";
            if (this.fLocator != null) {
                if (this.fLocator instanceof Locator2) {
                    Locator2 locator2 = (Locator2)this.fLocator;
                    this.fXML11 = "1.1".equals(locator2.getXMLVersion());
                    string4 = locator2.getEncoding();
                    if (string4 == null) {
                        string4 = "UTF-8";
                    }
                }
                this.fLocator = null;
            }
            if (!this.fCanonical) {
                this.fOut.print("<?xml version=\"");
                this.fOut.print(this.fXML11 ? "1.1" : "1.0");
                this.fOut.print("\" encoding=\"");
                this.fOut.print(string4);
                this.fOut.println("\"?>");
                this.fOut.flush();
            }
        }
        ++this.fElementDepth;
        this.fOut.print('<');
        this.fOut.print(string3);
        if (attributes != null) {
            attributes = this.sortAttributes(attributes);
            int n = attributes.getLength();
            int n2 = 0;
            while (n2 < n) {
                this.fOut.print(' ');
                this.fOut.print(attributes.getQName(n2));
                this.fOut.print("=\"");
                this.normalizeAndPrint(attributes.getValue(n2), true);
                this.fOut.print('\"');
                ++n2;
            }
        }
        this.fOut.print('>');
        this.fOut.flush();
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (!this.fInCDATA) {
            this.normalizeAndPrint(cArray, n, n2, false);
        } else {
            int n3 = 0;
            while (n3 < n2) {
                this.fOut.print(cArray[n + n3]);
                ++n3;
            }
        }
        this.fOut.flush();
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
        this.fOut.flush();
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        --this.fElementDepth;
        this.fOut.print("</");
        this.fOut.print(string3);
        this.fOut.print('>');
        this.fOut.flush();
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        this.printError("Warning", sAXParseException);
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        this.printError("Error", sAXParseException);
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        this.printError("Fatal Error", sAXParseException);
        throw sAXParseException;
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
    }

    public void endDTD() throws SAXException {
    }

    public void startEntity(String string) throws SAXException {
    }

    public void endEntity(String string) throws SAXException {
    }

    public void startCDATA() throws SAXException {
        if (!this.fCanonical) {
            this.fOut.print("<![CDATA[");
            this.fInCDATA = true;
        }
    }

    public void endCDATA() throws SAXException {
        if (!this.fCanonical) {
            this.fInCDATA = false;
            this.fOut.print("]]>");
        }
    }

    public void comment(char[] cArray, int n, int n2) throws SAXException {
        if (!this.fCanonical && this.fElementDepth > 0) {
            this.fOut.print("<!--");
            int n3 = 0;
            while (n3 < n2) {
                this.fOut.print(cArray[n + n3]);
                ++n3;
            }
            this.fOut.print("-->");
            this.fOut.flush();
        }
    }

    protected Attributes sortAttributes(Attributes attributes) {
        AttributesImpl attributesImpl = new AttributesImpl();
        int n = attributes != null ? attributes.getLength() : 0;
        int n2 = 0;
        while (n2 < n) {
            String string = attributes.getQName(n2);
            int n3 = attributesImpl.getLength();
            int n4 = 0;
            while (n4 < n3) {
                if (string.compareTo(attributesImpl.getQName(n4)) < 0) break;
                ++n4;
            }
            attributesImpl.insertAttributeAt(n4, string, attributes.getType(n2), attributes.getValue(n2));
            ++n2;
        }
        return attributesImpl;
    }

    protected void normalizeAndPrint(String string, boolean bl) {
        int n = string != null ? string.length() : 0;
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.normalizeAndPrint(c, bl);
            ++n2;
        }
    }

    protected void normalizeAndPrint(char[] cArray, int n, int n2, boolean bl) {
        int n3 = 0;
        while (n3 < n2) {
            this.normalizeAndPrint(cArray[n + n3], bl);
            ++n3;
        }
    }

    protected void normalizeAndPrint(char c, boolean bl) {
        switch (c) {
            case '<': {
                this.fOut.print("&lt;");
                break;
            }
            case '>': {
                this.fOut.print("&gt;");
                break;
            }
            case '&': {
                this.fOut.print("&amp;");
                break;
            }
            case '\"': {
                if (bl) {
                    this.fOut.print("&quot;");
                    break;
                }
                this.fOut.print("\"");
                break;
            }
            case '\r': {
                this.fOut.print("&#xD;");
                break;
            }
            case '\n': {
                if (this.fCanonical) {
                    this.fOut.print("&#xA;");
                    break;
                }
            }
            default: {
                if (this.fXML11 && (c >= '\u0001' && c <= '\u001f' && c != '\t' && c != '\n' || c >= '\u007f' && c <= '\u009f' || c == '\u2028') || bl && (c == '\t' || c == '\n')) {
                    this.fOut.print("&#x");
                    this.fOut.print(Integer.toHexString(c).toUpperCase());
                    this.fOut.print(";");
                    break;
                }
                this.fOut.print(c);
            }
        }
    }

    protected void printError(String string, SAXParseException sAXParseException) {
        System.err.print("[");
        System.err.print(string);
        System.err.print("] ");
        String string2 = sAXParseException.getSystemId();
        if (string2 != null) {
            int n = string2.lastIndexOf(47);
            if (n != -1) {
                string2 = string2.substring(n + 1);
            }
            System.err.print(string2);
        }
        System.err.print(':');
        System.err.print(sAXParseException.getLineNumber());
        System.err.print(':');
        System.err.print(sAXParseException.getColumnNumber());
        System.err.print(": ");
        System.err.print(sAXParseException.getMessage());
        System.err.println();
        System.err.flush();
    }

    /*
     * Unable to fully structure code
     */
    public static void main(String[] var0) {
        if (var0.length == 0) {
            Writer.printUsage();
            System.exit(1);
        }
        var1_1 = null;
        var2_2 = null;
        var3_3 = true;
        var4_4 = false;
        var5_5 = false;
        var6_6 = true;
        var7_7 = false;
        var8_8 = false;
        var9_9 = false;
        var10_10 = false;
        var11_11 = false;
        var12_12 = false;
        var13_13 = false;
        var14_14 = true;
        var15_15 = true;
        var16_16 = false;
        var17_17 = 0;
        while (var17_17 < var0.length) {
            block87: {
                var18_18 = var0[var17_17];
                if (!var18_18.startsWith("-")) ** GOTO lbl-1000
                var19_19 = var18_18.substring(1);
                if (var19_19.equals("p")) {
                    if (++var17_17 == var0.length) {
                        System.err.println("error: Missing argument to -p option.");
                    }
                    var20_37 = var0[var17_17];
                    try {
                        var2_2 = XMLReaderFactory.createXMLReader((String)var20_37);
                    }
                    catch (Exception var21_50) {
                        try {
                            var22_51 = ParserFactory.makeParser((String)var20_37);
                            var2_2 = new ParserAdapter(var22_51);
                            System.err.println("warning: Features and properties not supported on SAX1 parsers.");
                        }
                        catch (Exception var22_52) {
                            var2_2 = null;
                            System.err.println("error: Unable to instantiate parser (" + (String)var20_37 + ")");
                            var21_50.printStackTrace(System.err);
                        }
                    }
                } else if (var19_19.equalsIgnoreCase("n")) {
                    var3_3 = var19_19.equals("n");
                } else if (var19_19.equalsIgnoreCase("np")) {
                    var4_4 = var19_19.equals("np");
                } else if (var19_19.equalsIgnoreCase("v")) {
                    var5_5 = var19_19.equals("v");
                } else if (var19_19.equalsIgnoreCase("xd")) {
                    var6_6 = var19_19.equals("xd");
                } else if (var19_19.equalsIgnoreCase("s")) {
                    var7_7 = var19_19.equals("s");
                } else if (var19_19.equalsIgnoreCase("f")) {
                    var8_8 = var19_19.equals("f");
                } else if (var19_19.equalsIgnoreCase("hs")) {
                    var9_9 = var19_19.equals("hs");
                } else if (var19_19.equalsIgnoreCase("va")) {
                    var10_10 = var19_19.equals("va");
                } else if (var19_19.equalsIgnoreCase("ga")) {
                    var11_11 = var19_19.equals("ga");
                } else if (var19_19.equalsIgnoreCase("dv")) {
                    var12_12 = var19_19.equals("dv");
                } else if (var19_19.equalsIgnoreCase("xi")) {
                    var13_13 = var19_19.equals("xi");
                } else if (var19_19.equalsIgnoreCase("xb")) {
                    var14_14 = var19_19.equals("xb");
                } else if (var19_19.equalsIgnoreCase("xl")) {
                    var15_15 = var19_19.equals("xl");
                } else if (var19_19.equalsIgnoreCase("c")) {
                    var16_16 = var19_19.equals("c");
                } else if (var19_19.equals("h")) {
                    Writer.printUsage();
                } else lbl-1000:
                // 2 sources

                {
                    if (var2_2 == null) {
                        try {
                            var2_2 = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
                        }
                        catch (Exception var19_20) {
                            System.err.println("error: Unable to instantiate parser (org.apache.xerces.parsers.SAXParser)");
                            var19_20.printStackTrace(System.err);
                            break block87;
                        }
                    }
                    try {
                        var2_2.setFeature("http://xml.org/sax/features/namespaces", var3_3);
                    }
                    catch (SAXException var19_21) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespaces)");
                    }
                    try {
                        var2_2.setFeature("http://xml.org/sax/features/namespace-prefixes", var4_4);
                    }
                    catch (SAXException var19_22) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/namespace-prefixes)");
                    }
                    try {
                        var2_2.setFeature("http://xml.org/sax/features/validation", var5_5);
                    }
                    catch (SAXException var19_23) {
                        System.err.println("warning: Parser does not support feature (http://xml.org/sax/features/validation)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", var6_6);
                    }
                    catch (SAXNotRecognizedException var19_24) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/nonvalidating/load-external-dtd)");
                    }
                    catch (SAXNotSupportedException var20_38) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/nonvalidating/load-external-dtd)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/validation/schema", var7_7);
                    }
                    catch (SAXNotRecognizedException var19_25) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/schema)");
                    }
                    catch (SAXNotSupportedException var20_39) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/validation/schema-full-checking", var8_8);
                    }
                    catch (SAXNotRecognizedException var19_26) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    catch (SAXNotSupportedException var20_40) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/schema-full-checking)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/honour-all-schemaLocations", var9_9);
                    }
                    catch (SAXNotRecognizedException var19_27) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/honour-all-schemaLocations)");
                    }
                    catch (SAXNotSupportedException var20_41) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/honour-all-schemaLocations)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/validate-annotations", var10_10);
                    }
                    catch (SAXNotRecognizedException var19_28) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validate-annotations)");
                    }
                    catch (SAXNotSupportedException var20_42) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validate-annotations)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/generate-synthetic-annotations", var11_11);
                    }
                    catch (SAXNotRecognizedException var19_29) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/generate-synthetic-annotations)");
                    }
                    catch (SAXNotSupportedException var20_43) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/generate-synthetic-annotations)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/validation/dynamic", var12_12);
                    }
                    catch (SAXNotRecognizedException var19_30) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/validation/dynamic)");
                    }
                    catch (SAXNotSupportedException var20_44) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/validation/dynamic)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/xinclude", var13_13);
                    }
                    catch (SAXNotRecognizedException var19_31) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/xinclude)");
                    }
                    catch (SAXNotSupportedException var20_45) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/xinclude/fixup-base-uris", var14_14);
                    }
                    catch (SAXNotRecognizedException var19_32) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/xinclude/fixup-base-uris)");
                    }
                    catch (SAXNotSupportedException var20_46) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-base-uris)");
                    }
                    try {
                        var2_2.setFeature("http://apache.org/xml/features/xinclude/fixup-language", var15_15);
                    }
                    catch (SAXNotRecognizedException var19_33) {
                        System.err.println("warning: Parser does not recognize feature (http://apache.org/xml/features/xinclude/fixup-language)");
                    }
                    catch (SAXNotSupportedException var20_47) {
                        System.err.println("warning: Parser does not support feature (http://apache.org/xml/features/xinclude/fixup-language)");
                    }
                    if (var1_1 == null) {
                        var1_1 = new Writer();
                        try {
                            var1_1.setOutput(System.out, "UTF8");
                        }
                        catch (UnsupportedEncodingException var19_34) {
                            System.err.println("error: Unable to set output. Exiting.");
                            System.exit(1);
                        }
                    }
                    var2_2.setContentHandler(var1_1);
                    var2_2.setErrorHandler(var1_1);
                    try {
                        var2_2.setProperty("http://xml.org/sax/properties/lexical-handler", var1_1);
                    }
                    catch (SAXException var19_35) {
                        // empty catch block
                    }
                    var1_1.setCanonical(var16_16);
                    try {
                        var2_2.parse(var18_18);
                    }
                    catch (SAXParseException var19_36) {
                    }
                    catch (Exception var20_48) {
                        System.err.println("error: Parse error occurred - " + var20_48.getMessage());
                        if (var20_48 instanceof SAXException && (var21_49 = ((SAXException)var20_48).getException()) != null) {
                            var20_37 = var21_49;
                        }
                        var20_37.printStackTrace(System.err);
                    }
                }
            }
            ++var17_17;
        }
    }

    private static void printUsage() {
        System.err.println("usage: java sax.Writer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name     Select parser by name.");
        System.err.println("  -n  | -N    Turn on/off namespace processing.");
        System.err.println("  -np | -NP   Turn on/off namespace prefixes.");
        System.err.println("              NOTE: Requires use of -n.");
        System.err.println("  -v  | -V    Turn on/off validation.");
        System.err.println("  -xd | -XD   Turn on/off loading of external DTDs.");
        System.err.println("              NOTE: Always on when -v in use and not supported by all parsers.");
        System.err.println("  -s  | -S    Turn on/off Schema validation support.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -f  | -F    Turn on/off Schema full checking.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -hs | -HS   Turn on/off honouring of all schema locations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -va | -VA   Turn on/off validation of schema annotations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -ga | -GA   Turn on/off generation of synthetic schema annotations.");
        System.err.println("              NOTE: Requires use of -s and not supported by all parsers.");
        System.err.println("  -dv | -DV   Turn on/off dynamic validation.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xi | -XI   Turn on/off XInclude processing.");
        System.err.println("              NOTE: Not supported by all parsers.");
        System.err.println("  -xb | -XB   Turn on/off base URI fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -xl | -XL   Turn on/off language fixup during XInclude processing.");
        System.err.println("              NOTE: Requires use of -xi and not supported by all parsers.");
        System.err.println("  -c | -C     Turn on/off Canonical XML output.");
        System.err.println("              NOTE: This is not W3C canonical output.");
        System.err.println("  -h          This help screen.");
        System.err.println();
        System.err.println("defaults:");
        System.err.println("  Parser:     org.apache.xerces.parsers.SAXParser");
        System.err.print("  Namespaces: ");
        System.err.println("on");
        System.err.print("  Prefixes:   ");
        System.err.println("off");
        System.err.print("  Validation: ");
        System.err.println("off");
        System.err.print("  Load External DTD: ");
        System.err.println("on");
        System.err.print("  Schema:     ");
        System.err.println("off");
        System.err.print("  Schema full checking:     ");
        System.err.println("off");
        System.err.print("  Dynamic:    ");
        System.err.println("off");
        System.err.print("  Canonical:  ");
        System.err.println("off");
        System.err.print("  Honour all schema locations:       ");
        System.err.println("off");
        System.err.print("  Validate Annotations:              ");
        System.err.println("off");
        System.err.print("  Generate Synthetic Annotations:    ");
        System.err.println("off");
        System.err.print("  XInclude:   ");
        System.err.println("off");
        System.err.print("  XInclude base URI fixup:  ");
        System.err.println("on");
        System.err.print("  XInclude language fixup:  ");
        System.err.println("on");
    }
}

