/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.servlet.http.WebConnection;
import org.apache.coyote.Adapter;
import org.apache.coyote.CloseNowException;
import org.apache.coyote.ProtocolException;
import org.apache.coyote.Request;
import org.apache.coyote.Response;
import org.apache.coyote.http11.upgrade.InternalHttpUpgradeHandler;
import org.apache.coyote.http2.AbstractStream;
import org.apache.coyote.http2.ByteUtil;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.ConnectionSettingsLocal;
import org.apache.coyote.http2.ConnectionSettingsRemote;
import org.apache.coyote.http2.FrameType;
import org.apache.coyote.http2.HeaderSink;
import org.apache.coyote.http2.HpackDecoder;
import org.apache.coyote.http2.HpackEncoder;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.Http2Parser;
import org.apache.coyote.http2.Setting;
import org.apache.coyote.http2.Stream;
import org.apache.coyote.http2.StreamException;
import org.apache.coyote.http2.StreamProcessor;
import org.apache.coyote.http2.StreamRunnable;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.codec.binary.Base64;
import org.apache.tomcat.util.http.FastHttpDateFormat;
import org.apache.tomcat.util.http.MimeHeaders;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.SSLSupport;
import org.apache.tomcat.util.net.SocketEvent;
import org.apache.tomcat.util.net.SocketWrapperBase;
import org.apache.tomcat.util.res.StringManager;

public class Http2UpgradeHandler
extends AbstractStream
implements InternalHttpUpgradeHandler,
Http2Parser.Input,
Http2Parser.Output {
    private static final Log log = LogFactory.getLog(Http2UpgradeHandler.class);
    private static final StringManager sm = StringManager.getManager(Http2UpgradeHandler.class);
    private static final AtomicInteger connectionIdGenerator = new AtomicInteger(0);
    private static final Integer STREAM_ID_ZERO = 0;
    private static final int FLAG_END_OF_STREAM = 1;
    private static final int FLAG_END_OF_HEADERS = 4;
    private static final byte[] PING = new byte[]{0, 0, 8, 6, 0, 0, 0, 0, 0};
    private static final byte[] PING_ACK = new byte[]{0, 0, 8, 6, 1, 0, 0, 0, 0};
    private static final byte[] SETTINGS_ACK = new byte[]{0, 0, 0, 4, 1, 0, 0, 0, 0};
    private static final byte[] GOAWAY = new byte[]{7, 0, 0, 0, 0, 0};
    private static final String HTTP2_SETTINGS_HEADER = "HTTP2-Settings";
    private static final HeaderSink HEADER_SINK = new HeaderSink();
    private final String connectionId;
    private final Adapter adapter;
    private volatile SocketWrapperBase<?> socketWrapper;
    private volatile SSLSupport sslSupport;
    private volatile Http2Parser parser;
    private AtomicReference<ConnectionState> connectionState = new AtomicReference<ConnectionState>(ConnectionState.NEW);
    private volatile long pausedNanoTime = Long.MAX_VALUE;
    private final ConnectionSettingsRemote remoteSettings;
    private final ConnectionSettingsLocal localSettings;
    private HpackDecoder hpackDecoder;
    private HpackEncoder hpackEncoder;
    private long readTimeout = 10000L;
    private long keepAliveTimeout = -1L;
    private long writeTimeout = 10000L;
    private final Map<Integer, Stream> streams = new HashMap<Integer, Stream>();
    private final AtomicInteger activeRemoteStreamCount = new AtomicInteger(0);
    private volatile int maxRemoteStreamId = 0;
    private volatile int maxActiveRemoteStreamId = -1;
    private volatile int maxProcessedStreamId;
    private final AtomicInteger nextLocalStreamId = new AtomicInteger(2);
    private final PingManager pingManager = new PingManager();
    private volatile int newStreamsSinceLastPrune = 0;
    private final ConcurrentMap<AbstractStream, int[]> backLogStreams = new ConcurrentHashMap<AbstractStream, int[]>();
    private long backLogSize = 0L;
    private int maxConcurrentStreamExecution = 200;
    private AtomicInteger streamConcurrency = null;
    private Queue<StreamRunnable> queuedRunnable = null;
    private Set<String> allowedTrailerHeaders = Collections.emptySet();
    private int maxHeaderCount = 100;
    private int maxHeaderSize = 8192;
    private int maxTrailerCount = 100;
    private int maxTrailerSize = 8192;

    public Http2UpgradeHandler(Adapter adapter, Request coyoteRequest) {
        super(STREAM_ID_ZERO);
        this.adapter = adapter;
        this.connectionId = Integer.toString(connectionIdGenerator.getAndIncrement());
        this.remoteSettings = new ConnectionSettingsRemote(this.connectionId);
        this.localSettings = new ConnectionSettingsLocal(this.connectionId);
        if (coyoteRequest != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("upgradeHandler.upgrade", new Object[]{this.connectionId}));
            }
            Integer key = 1;
            Stream stream = new Stream(key, this, coyoteRequest);
            this.streams.put(key, stream);
            this.maxRemoteStreamId = 1;
            this.maxActiveRemoteStreamId = 1;
            this.activeRemoteStreamCount.set(1);
            this.maxProcessedStreamId = 1;
        }
    }

    public void init(WebConnection webConnection) {
        String msg;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.init", new Object[]{this.connectionId, this.connectionState.get()}));
        }
        if (!this.connectionState.compareAndSet(ConnectionState.NEW, ConnectionState.CONNECTED)) {
            return;
        }
        if ((long)this.maxConcurrentStreamExecution < this.localSettings.getMaxConcurrentStreams()) {
            this.streamConcurrency = new AtomicInteger(0);
            this.queuedRunnable = new ConcurrentLinkedQueue<StreamRunnable>();
        }
        this.parser = new Http2Parser(this.connectionId, this, this);
        Stream stream = null;
        this.socketWrapper.setReadTimeout(this.getReadTimeout());
        this.socketWrapper.setWriteTimeout(this.getWriteTimeout());
        if (webConnection != null) {
            try {
                stream = this.getStream(1, true);
                String base64Settings = stream.getCoyoteRequest().getHeader(HTTP2_SETTINGS_HEADER);
                byte[] settings = Base64.decodeBase64((String)base64Settings);
                FrameType.SETTINGS.check(0, settings.length);
                for (int i = 0; i < settings.length % 6; ++i) {
                    int id = ByteUtil.getTwoBytes(settings, i * 6);
                    long value = ByteUtil.getFourBytes(settings, i * 6 + 2);
                    this.remoteSettings.set(Setting.valueOf(id), value);
                }
            }
            catch (Http2Exception e) {
                throw new ProtocolException(sm.getString("upgradeHandler.upgrade.fail", new Object[]{this.connectionId}));
            }
        }
        try {
            byte[] settings = this.localSettings.getSettingsFrameForPending();
            this.socketWrapper.write(true, settings, 0, settings.length);
            this.socketWrapper.flush(true);
        }
        catch (IOException ioe) {
            msg = sm.getString("upgradeHandler.sendPrefaceFail", new Object[]{this.connectionId});
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
            throw new ProtocolException(msg, ioe);
        }
        try {
            this.parser.readConnectionPreface();
        }
        catch (Http2Exception e) {
            msg = sm.getString("upgradeHandler.invalidPreface", new Object[]{this.connectionId});
            if (log.isDebugEnabled()) {
                log.debug((Object)msg);
            }
            throw new ProtocolException(msg);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.prefaceReceived", new Object[]{this.connectionId}));
        }
        try {
            this.pingManager.sendPing(true);
        }
        catch (IOException ioe) {
            throw new ProtocolException(sm.getString("upgradeHandler.pingFailed"), ioe);
        }
        if (webConnection != null) {
            this.processStreamOnContainerThread(stream);
        }
    }

    private void processStreamOnContainerThread(Stream stream) {
        StreamProcessor streamProcessor = new StreamProcessor(this, stream, this.adapter, this.socketWrapper);
        streamProcessor.setSslSupport(this.sslSupport);
        this.processStreamOnContainerThread(streamProcessor, SocketEvent.OPEN_READ);
    }

    void processStreamOnContainerThread(StreamProcessor streamProcessor, SocketEvent event) {
        StreamRunnable streamRunnable = new StreamRunnable(streamProcessor, event);
        if (this.streamConcurrency == null) {
            this.socketWrapper.getEndpoint().getExecutor().execute(streamRunnable);
        } else if (this.getStreamConcurrency() < this.maxConcurrentStreamExecution) {
            this.increaseStreamConcurrency();
            this.socketWrapper.getEndpoint().getExecutor().execute(streamRunnable);
        } else {
            this.queuedRunnable.offer(streamRunnable);
        }
    }

    @Override
    public void setSocketWrapper(SocketWrapperBase<?> wrapper) {
        this.socketWrapper = wrapper;
    }

    @Override
    public void setSslSupport(SSLSupport sslSupport) {
        this.sslSupport = sslSupport;
    }

    @Override
    public AbstractEndpoint.Handler.SocketState upgradeDispatch(SocketEvent status) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.upgradeDispatch.entry", new Object[]{this.connectionId, status}));
        }
        this.init(null);
        AbstractEndpoint.Handler.SocketState result = AbstractEndpoint.Handler.SocketState.CLOSED;
        try {
            this.pingManager.sendPing(false);
            this.checkPauseState();
            switch (status) {
                case OPEN_READ: {
                    try {
                        this.socketWrapper.setReadTimeout(this.getReadTimeout());
                        while (true) {
                            try {
                                while (this.parser.readFrame(false)) {
                                }
                            }
                            catch (StreamException se) {
                                Stream stream = this.getStream(se.getStreamId(), false);
                                if (stream == null) {
                                    this.sendStreamReset(se);
                                    continue;
                                }
                                stream.close(se);
                                continue;
                            }
                            break;
                        }
                        this.socketWrapper.setReadTimeout(this.getKeepAliveTimeout());
                    }
                    catch (Http2Exception ce) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)sm.getString("upgradeHandler.connectionError"), (Throwable)ce);
                        }
                        this.closeConnection(ce);
                        break;
                    }
                    result = AbstractEndpoint.Handler.SocketState.UPGRADED;
                    break;
                }
                case OPEN_WRITE: {
                    this.processWrites();
                    result = AbstractEndpoint.Handler.SocketState.UPGRADED;
                    break;
                }
                case DISCONNECT: 
                case ERROR: 
                case TIMEOUT: 
                case STOP: {
                    this.close();
                }
            }
        }
        catch (IOException ioe) {
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("upgradeHandler.ioerror", new Object[]{this.connectionId}), (Throwable)ioe);
            }
            this.close();
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.upgradeDispatch.exit", new Object[]{this.connectionId, result}));
        }
        return result;
    }

    ConnectionSettingsRemote getRemoteSettings() {
        return this.remoteSettings;
    }

    ConnectionSettingsLocal getLocalSettings() {
        return this.localSettings;
    }

    @Override
    public void pause() {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.pause.entry", new Object[]{this.connectionId}));
        }
        if (this.connectionState.compareAndSet(ConnectionState.CONNECTED, ConnectionState.PAUSING)) {
            this.pausedNanoTime = System.nanoTime();
            try {
                this.writeGoAwayFrame(Integer.MAX_VALUE, Http2Error.NO_ERROR.getCode(), null);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void destroy() {
    }

    private void checkPauseState() throws IOException {
        if (this.connectionState.get() == ConnectionState.PAUSING && this.pausedNanoTime + this.pingManager.getRoundTripTimeNano() < System.nanoTime()) {
            this.connectionState.compareAndSet(ConnectionState.PAUSING, ConnectionState.PAUSED);
            this.writeGoAwayFrame(this.maxProcessedStreamId, Http2Error.NO_ERROR.getCode(), null);
        }
    }

    private int increaseStreamConcurrency() {
        return this.streamConcurrency.incrementAndGet();
    }

    private int decreaseStreamConcurrency() {
        return this.streamConcurrency.decrementAndGet();
    }

    private int getStreamConcurrency() {
        return this.streamConcurrency.get();
    }

    void executeQueuedStream() {
        StreamRunnable streamRunnable;
        if (this.streamConcurrency == null) {
            return;
        }
        this.decreaseStreamConcurrency();
        if (this.getStreamConcurrency() < this.maxConcurrentStreamExecution && (streamRunnable = this.queuedRunnable.poll()) != null) {
            this.increaseStreamConcurrency();
            this.socketWrapper.getEndpoint().getExecutor().execute(streamRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendStreamReset(StreamException se) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.rst.debug", new Object[]{this.connectionId, Integer.toString(se.getStreamId()), se.getError(), se.getMessage()}));
        }
        byte[] rstFrame = new byte[13];
        ByteUtil.setThreeBytes(rstFrame, 0, 4);
        rstFrame[3] = FrameType.RST.getIdByte();
        ByteUtil.set31Bits(rstFrame, 5, se.getStreamId());
        ByteUtil.setFourBytes(rstFrame, 9, se.getError().getCode());
        SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
        synchronized (socketWrapperBase) {
            this.socketWrapper.write(true, rstFrame, 0, rstFrame.length);
            this.socketWrapper.flush(true);
        }
    }

    void closeConnection(Http2Exception ce) {
        try {
            this.writeGoAwayFrame(this.maxProcessedStreamId, ce.getError().getCode(), ce.getMessage().getBytes(StandardCharsets.UTF_8));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeGoAwayFrame(int maxStreamId, long errorCode, byte[] debugMsg) throws IOException {
        byte[] fixedPayload = new byte[8];
        ByteUtil.set31Bits(fixedPayload, 0, maxStreamId);
        ByteUtil.setFourBytes(fixedPayload, 4, errorCode);
        int len = 8;
        if (debugMsg != null) {
            len += debugMsg.length;
        }
        byte[] payloadLength = new byte[3];
        ByteUtil.setThreeBytes(payloadLength, 0, len);
        SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
        synchronized (socketWrapperBase) {
            this.socketWrapper.write(true, payloadLength, 0, payloadLength.length);
            this.socketWrapper.write(true, GOAWAY, 0, GOAWAY.length);
            this.socketWrapper.write(true, fixedPayload, 0, 8);
            if (debugMsg != null) {
                this.socketWrapper.write(true, debugMsg, 0, debugMsg.length);
            }
            this.socketWrapper.flush(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeHeaders(Stream stream, Response coyoteResponse, int payloadSize) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.writeHeaders", new Object[]{this.connectionId, stream.getIdentifier()}));
        }
        if (!stream.canWrite()) {
            return;
        }
        this.prepareHeaders(coyoteResponse);
        byte[] header = new byte[9];
        ByteBuffer target = ByteBuffer.allocate(payloadSize);
        boolean first = true;
        HpackEncoder.State state = null;
        SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
        synchronized (socketWrapperBase) {
            while (state != HpackEncoder.State.COMPLETE) {
                state = this.getHpackEncoder().encode(coyoteResponse.getMimeHeaders(), target);
                target.flip();
                ByteUtil.setThreeBytes(header, 0, target.limit());
                if (first) {
                    first = false;
                    header[3] = FrameType.HEADERS.getIdByte();
                    if (stream.getOutputBuffer().hasNoBody()) {
                        header[4] = 1;
                    }
                } else {
                    header[3] = FrameType.CONTINUATION.getIdByte();
                }
                if (state == HpackEncoder.State.COMPLETE) {
                    header[4] = (byte)(header[4] + 4);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(target.limit() + " bytes"));
                }
                ByteUtil.set31Bits(header, 5, stream.getIdentifier());
                try {
                    this.socketWrapper.write(true, header, 0, header.length);
                    this.socketWrapper.write(true, target);
                    this.socketWrapper.flush(true);
                }
                catch (IOException ioe) {
                    this.handleAppInitiatedIOException(ioe);
                }
            }
        }
    }

    private void prepareHeaders(Response coyoteResponse) {
        MimeHeaders headers = coyoteResponse.getMimeHeaders();
        int statusCode = coyoteResponse.getStatus();
        headers.addValue(":status").setString(Integer.toString(statusCode));
        if (statusCode >= 200 && statusCode != 205 && statusCode != 304) {
            String contentLanguage;
            String contentType = coyoteResponse.getContentType();
            if (contentType != null) {
                headers.setValue("content-type").setString(contentType);
            }
            if ((contentLanguage = coyoteResponse.getContentLanguage()) != null) {
                headers.setValue("content-language").setString(contentLanguage);
            }
        }
        if (headers.getValue("date") == null) {
            headers.addValue("date").setString(FastHttpDateFormat.getCurrentDate());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writePushHeaders(Stream stream, int pushedStreamId, Request coyoteRequest, int payloadSize) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.writePushHeaders", new Object[]{this.connectionId, stream.getIdentifier(), Integer.toString(pushedStreamId)}));
        }
        SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
        synchronized (socketWrapperBase) {
            byte[] header = new byte[9];
            ByteBuffer target = ByteBuffer.allocate(payloadSize);
            boolean first = true;
            HpackEncoder.State state = null;
            byte[] pushedStreamIdBytes = new byte[4];
            ByteUtil.set31Bits(pushedStreamIdBytes, 0, pushedStreamId);
            target.put(pushedStreamIdBytes);
            while (state != HpackEncoder.State.COMPLETE) {
                state = this.getHpackEncoder().encode(coyoteRequest.getMimeHeaders(), target);
                target.flip();
                ByteUtil.setThreeBytes(header, 0, target.limit());
                if (first) {
                    first = false;
                    header[3] = FrameType.PUSH_PROMISE.getIdByte();
                } else {
                    header[3] = FrameType.CONTINUATION.getIdByte();
                }
                if (state == HpackEncoder.State.COMPLETE) {
                    header[4] = (byte)(header[4] + 4);
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)(target.limit() + " bytes"));
                }
                ByteUtil.set31Bits(header, 5, stream.getIdentifier());
                this.socketWrapper.write(true, header, 0, header.length);
                this.socketWrapper.write(true, target);
                this.socketWrapper.flush(true);
            }
        }
    }

    private HpackEncoder getHpackEncoder() {
        if (this.hpackEncoder == null) {
            this.hpackEncoder = new HpackEncoder();
        }
        this.hpackEncoder.setMaxTableSize(this.remoteSettings.getHeaderTableSize());
        return this.hpackEncoder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeBody(Stream stream, ByteBuffer data, int len, boolean finished) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.writeBody", new Object[]{this.connectionId, stream.getIdentifier(), Integer.toString(len)}));
        }
        boolean writeable = stream.canWrite();
        byte[] header = new byte[9];
        ByteUtil.setThreeBytes(header, 0, len);
        header[3] = FrameType.DATA.getIdByte();
        if (finished) {
            header[4] = 1;
            stream.sentEndOfStream();
            if (!stream.isActive()) {
                this.activeRemoteStreamCount.decrementAndGet();
            }
        }
        if (writeable) {
            ByteUtil.set31Bits(header, 5, stream.getIdentifier());
            SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
            synchronized (socketWrapperBase) {
                try {
                    this.socketWrapper.write(true, header, 0, header.length);
                    int orgLimit = data.limit();
                    data.limit(data.position() + len);
                    this.socketWrapper.write(true, data);
                    data.limit(orgLimit);
                    this.socketWrapper.flush(true);
                }
                catch (IOException ioe) {
                    this.handleAppInitiatedIOException(ioe);
                }
            }
        }
    }

    private void handleAppInitiatedIOException(IOException ioe) throws IOException {
        this.close();
        throw ioe;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeWindowUpdate(Stream stream, int increment, boolean applicationInitiated) throws IOException {
        if (!stream.canWrite()) {
            return;
        }
        SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
        synchronized (socketWrapperBase) {
            byte[] frame = new byte[13];
            ByteUtil.setThreeBytes(frame, 0, 4);
            frame[3] = FrameType.WINDOW_UPDATE.getIdByte();
            ByteUtil.set31Bits(frame, 9, increment);
            this.socketWrapper.write(true, frame, 0, frame.length);
            ByteUtil.set31Bits(frame, 5, stream.getIdentifier());
            try {
                this.socketWrapper.write(true, frame, 0, frame.length);
                this.socketWrapper.flush(true);
            }
            catch (IOException ioe) {
                if (applicationInitiated) {
                    this.handleAppInitiatedIOException(ioe);
                }
                throw ioe;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processWrites() throws IOException {
        SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
        synchronized (socketWrapperBase) {
            if (this.socketWrapper.flush(false)) {
                this.socketWrapper.registerWriteInterest();
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int reserveWindowSize(Stream stream, int reservation) throws IOException {
        int allocation = 0;
        Stream stream2 = stream;
        synchronized (stream2) {
            do {
                Http2UpgradeHandler http2UpgradeHandler = this;
                synchronized (http2UpgradeHandler) {
                    if (!stream.canWrite()) {
                        throw new CloseNowException(sm.getString("upgradeHandler.stream.notWritable", new Object[]{stream.getConnectionId(), stream.getIdentifier()}));
                    }
                    long windowSize = this.getWindowSize();
                    if (windowSize < 1L || this.backLogSize > 0L) {
                        int[] value = (int[])this.backLogStreams.get(stream);
                        if (value == null) {
                            value = new int[]{reservation, 0};
                            this.backLogStreams.put(stream, value);
                            this.backLogSize += (long)reservation;
                            for (AbstractStream parent = stream.getParentStream(); parent != null && this.backLogStreams.putIfAbsent(parent, new int[2]) == null; parent = parent.getParentStream()) {
                            }
                        } else if (value[1] > 0) {
                            allocation = value[1];
                            this.decrementWindowSize(allocation);
                            if (value[0] == 0) {
                                this.backLogStreams.remove(stream);
                            } else {
                                value[1] = 0;
                            }
                        }
                    } else if (windowSize < (long)reservation) {
                        allocation = (int)windowSize;
                        this.decrementWindowSize(allocation);
                    } else {
                        allocation = reservation;
                        this.decrementWindowSize(allocation);
                    }
                }
                if (allocation != 0) continue;
                try {
                    stream.wait();
                }
                catch (InterruptedException e) {
                    throw new IOException(sm.getString("upgradeHandler.windowSizeReservationInterrupted", new Object[]{this.connectionId, stream.getIdentifier(), Integer.toString(reservation)}), e);
                }
            } while (allocation == 0);
        }
        return allocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void incrementWindowSize(int increment) throws Http2Exception {
        Set<AbstractStream> streamsToNotify = null;
        Http2UpgradeHandler http2UpgradeHandler = this;
        synchronized (http2UpgradeHandler) {
            long windowSize = this.getWindowSize();
            if (windowSize < 1L && windowSize + (long)increment > 0L) {
                streamsToNotify = this.releaseBackLog((int)(windowSize + (long)increment));
            }
            super.incrementWindowSize(increment);
        }
        if (streamsToNotify != null) {
            Iterator i$ = streamsToNotify.iterator();
            while (i$.hasNext()) {
                AbstractStream stream;
                AbstractStream abstractStream = stream = (AbstractStream)i$.next();
                synchronized (abstractStream) {
                    stream.notifyAll();
                }
            }
        }
    }

    private synchronized Set<AbstractStream> releaseBackLog(int increment) {
        HashSet<AbstractStream> result = new HashSet<AbstractStream>();
        if (this.backLogSize < (long)increment) {
            result.addAll(this.backLogStreams.keySet());
            this.backLogStreams.clear();
            this.backLogSize = 0L;
        } else {
            int leftToAllocate = increment;
            while (leftToAllocate > 0) {
                leftToAllocate = this.allocate(this, leftToAllocate);
            }
            for (Map.Entry entry : this.backLogStreams.entrySet()) {
                int allocation = ((int[])entry.getValue())[1];
                if (allocation <= 0) continue;
                this.backLogSize -= (long)allocation;
                result.add((AbstractStream)entry.getKey());
            }
        }
        return result;
    }

    @Override
    protected synchronized void doNotifyAll() {
        this.notifyAll();
    }

    /*
     * WARNING - void declaration
     */
    private int allocate(AbstractStream stream, int allocation) {
        int[] value;
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.allocate.debug", new Object[]{this.getConnectionId(), stream.getIdentifier(), Integer.toString(allocation)}));
        }
        if ((value = (int[])this.backLogStreams.get(stream))[0] >= allocation) {
            value[0] = value[0] - allocation;
            value[1] = value[1] + allocation;
            return 0;
        }
        int leftToAllocate = allocation;
        value[1] = value[0];
        value[0] = 0;
        leftToAllocate -= value[1];
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.allocate.left", new Object[]{this.getConnectionId(), stream.getIdentifier(), Integer.toString(leftToAllocate)}));
        }
        HashSet<Stream> recipients = new HashSet<Stream>();
        recipients.addAll(stream.getChildStreams());
        recipients.retainAll(this.backLogStreams.keySet());
        while (leftToAllocate > 0) {
            void var8_8;
            if (recipients.size() == 0) {
                this.backLogStreams.remove(stream);
                return leftToAllocate;
            }
            int totalWeight = 0;
            for (AbstractStream abstractStream : recipients) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("upgradeHandler.allocate.recipient", new Object[]{this.getConnectionId(), stream.getIdentifier(), abstractStream.getIdentifier(), Integer.toString(abstractStream.getWeight())}));
                }
                totalWeight += abstractStream.getWeight();
            }
            Iterator iter = recipients.iterator();
            boolean bl = false;
            while (iter.hasNext()) {
                int remainder;
                AbstractStream recipient = (AbstractStream)iter.next();
                int share = leftToAllocate * recipient.getWeight() / totalWeight;
                if (share == 0) {
                    share = 1;
                }
                if ((remainder = this.allocate(recipient, share)) > 0) {
                    iter.remove();
                }
                var8_8 += share - remainder;
            }
            leftToAllocate -= var8_8;
        }
        return 0;
    }

    private Stream getStream(int streamId, boolean unknownIsError) throws ConnectionException {
        Integer key = streamId;
        Stream result = this.streams.get(key);
        if (result == null && unknownIsError) {
            throw new ConnectionException(sm.getString("upgradeHandler.stream.closed", new Object[]{key}), Http2Error.PROTOCOL_ERROR);
        }
        return result;
    }

    private Stream createRemoteStream(int streamId) throws ConnectionException {
        Integer key = streamId;
        if (streamId % 2 != 1) {
            throw new ConnectionException(sm.getString("upgradeHandler.stream.even", new Object[]{key}), Http2Error.PROTOCOL_ERROR);
        }
        if (streamId <= this.maxRemoteStreamId) {
            throw new ConnectionException(sm.getString("upgradeHandler.stream.old", new Object[]{key, this.maxRemoteStreamId}), Http2Error.PROTOCOL_ERROR);
        }
        this.pruneClosedStreams();
        Stream result = new Stream(key, this);
        this.streams.put(key, result);
        this.maxRemoteStreamId = streamId;
        return result;
    }

    private Stream createLocalStream(Request request) {
        int streamId = this.nextLocalStreamId.getAndAdd(2);
        Integer key = streamId;
        Stream result = new Stream(key, this, request);
        this.streams.put(key, result);
        this.maxRemoteStreamId = streamId;
        return result;
    }

    private void close() {
        this.connectionState.set(ConnectionState.CLOSED);
        try {
            this.socketWrapper.close();
        }
        catch (IOException ioe) {
            log.debug((Object)sm.getString("upgradeHandler.socketCloseFailed"), (Throwable)ioe);
        }
    }

    private void pruneClosedStreams() {
        int toClose;
        if (this.newStreamsSinceLastPrune < 9) {
            ++this.newStreamsSinceLastPrune;
            return;
        }
        this.newStreamsSinceLastPrune = 0;
        long max = this.localSettings.getMaxConcurrentStreams();
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.pruneStart", new Object[]{this.connectionId, Long.toString(max), Integer.toString(this.streams.size())}));
        }
        if ((max += max / 10L) > Integer.MAX_VALUE) {
            max = Integer.MAX_VALUE;
        }
        if ((toClose = this.streams.size() - (int)max) < 1) {
            return;
        }
        TreeSet<Integer> candidatesStepOne = new TreeSet<Integer>();
        TreeSet<Integer> candidatesStepTwo = new TreeSet<Integer>();
        TreeSet<Integer> candidatesStepThree = new TreeSet<Integer>();
        for (Map.Entry<Integer, Stream> entry : this.streams.entrySet()) {
            Stream stream = entry.getValue();
            if (stream.isActive()) continue;
            if (stream.isClosedFinal()) {
                candidatesStepThree.add(entry.getKey());
                continue;
            }
            if (stream.getChildStreams().size() == 0) {
                candidatesStepOne.add(entry.getKey());
                continue;
            }
            candidatesStepTwo.add(entry.getKey());
        }
        for (Integer streamIdToRemove : candidatesStepOne) {
            Stream removedStream = this.streams.remove(streamIdToRemove);
            removedStream.detachFromParent();
            --toClose;
            if (log.isDebugEnabled()) {
                log.debug((Object)sm.getString("upgradeHandler.pruned", new Object[]{this.connectionId, streamIdToRemove}));
            }
            AbstractStream parent = removedStream.getParentStream();
            while (parent instanceof Stream && !((Stream)parent).isActive() && !((Stream)parent).isClosedFinal() && parent.getChildStreams().size() == 0) {
                this.streams.remove(parent.getIdentifier());
                parent.detachFromParent();
                --toClose;
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("upgradeHandler.pruned", new Object[]{this.connectionId, streamIdToRemove}));
                }
                candidatesStepTwo.remove(parent.getIdentifier());
                parent = parent.getParentStream();
            }
        }
        for (Integer streamIdToRemove : candidatesStepTwo) {
            this.removeStreamFromPriorityTree(streamIdToRemove);
            --toClose;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)sm.getString("upgradeHandler.pruned", new Object[]{this.connectionId, streamIdToRemove}));
        }
        while (toClose > 0 && candidatesStepThree.size() > 0) {
            Integer streamIdToRemove;
            streamIdToRemove = (Integer)candidatesStepThree.pollLast();
            this.removeStreamFromPriorityTree(streamIdToRemove);
            --toClose;
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)sm.getString("upgradeHandler.prunedPriority", new Object[]{this.connectionId, streamIdToRemove}));
        }
        if (toClose > 0) {
            log.warn((Object)sm.getString("upgradeHandler.pruneIncomplete", new Object[]{this.connectionId, Integer.toString(toClose)}));
        }
    }

    private void removeStreamFromPriorityTree(Integer streamIdToRemove) {
        Stream streamToRemove = this.streams.remove(streamIdToRemove);
        Set<Stream> children = streamToRemove.getChildStreams();
        if (streamToRemove.getChildStreams().size() == 1) {
            streamToRemove.getChildStreams().iterator().next().rePrioritise(streamToRemove.getParentStream(), streamToRemove.getWeight());
        } else {
            int totalWeight = 0;
            for (Stream child : children) {
                totalWeight += child.getWeight();
            }
            for (Stream child : children) {
                streamToRemove.getChildStreams().iterator().next().rePrioritise(streamToRemove.getParentStream(), streamToRemove.getWeight() * child.getWeight() / totalWeight);
            }
        }
        streamToRemove.detachFromParent();
    }

    void push(Request request, Stream associatedStream) throws IOException {
        Stream pushStream = this.createLocalStream(request);
        this.writePushHeaders(associatedStream, pushStream.getIdentifier(), request, 1024);
        pushStream.sentPushPromise();
        this.processStreamOnContainerThread(pushStream);
    }

    @Override
    protected final String getConnectionId() {
        return this.connectionId;
    }

    @Override
    protected final int getWeight() {
        return 0;
    }

    boolean isTrailerHeaderAllowed(String headerName) {
        return this.allowedTrailerHeaders.contains(headerName);
    }

    public long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public long getKeepAliveTimeout() {
        return this.keepAliveTimeout;
    }

    public void setKeepAliveTimeout(long keepAliveTimeout) {
        this.keepAliveTimeout = keepAliveTimeout;
    }

    public long getWriteTimeout() {
        return this.writeTimeout;
    }

    public void setWriteTimeout(long writeTimeout) {
        this.writeTimeout = writeTimeout;
    }

    public void setMaxConcurrentStreams(long maxConcurrentStreams) {
        this.localSettings.set(Setting.MAX_CONCURRENT_STREAMS, maxConcurrentStreams);
    }

    public void setMaxConcurrentStreamExecution(int maxConcurrentStreamExecution) {
        this.maxConcurrentStreamExecution = maxConcurrentStreamExecution;
    }

    public void setInitialWindowSize(int initialWindowSize) {
        this.localSettings.set(Setting.INITIAL_WINDOW_SIZE, initialWindowSize);
    }

    public void setAllowedTrailerHeaders(Set<String> allowedTrailerHeaders) {
        this.allowedTrailerHeaders = allowedTrailerHeaders;
    }

    public void setMaxHeaderCount(int maxHeaderCount) {
        this.maxHeaderCount = maxHeaderCount;
    }

    public int getMaxHeaderCount() {
        return this.maxHeaderCount;
    }

    public void setMaxHeaderSize(int maxHeaderSize) {
        this.maxHeaderSize = maxHeaderSize;
    }

    public int getMaxHeaderSize() {
        return this.maxHeaderSize;
    }

    public void setMaxTrailerCount(int maxTrailerCount) {
        this.maxTrailerCount = maxTrailerCount;
    }

    public int getMaxTrailerCount() {
        return this.maxTrailerCount;
    }

    public void setMaxTrailerSize(int maxTrailerSize) {
        this.maxTrailerSize = maxTrailerSize;
    }

    public int getMaxTrailerSize() {
        return this.maxTrailerSize;
    }

    @Override
    public boolean fill(boolean block, byte[] data) throws IOException {
        return this.fill(block, data, 0, data.length);
    }

    @Override
    public boolean fill(boolean block, ByteBuffer data, int len) throws IOException {
        boolean result = this.fill(block, data.array(), data.arrayOffset() + data.position(), len);
        if (result) {
            data.position(data.position() + len);
        }
        return result;
    }

    @Override
    public boolean fill(boolean block, byte[] data, int offset, int length) throws IOException {
        int pos = offset;
        boolean nextReadBlock = block;
        int thisRead = 0;
        for (int len = length; len > 0; len -= thisRead) {
            thisRead = this.socketWrapper.read(nextReadBlock, data, pos, len);
            if (thisRead == 0) {
                if (nextReadBlock) {
                    throw new IllegalStateException();
                }
                return false;
            }
            if (thisRead == -1) {
                if (this.connectionState.get().isNewStreamAllowed()) {
                    throw new EOFException();
                }
                return false;
            }
            pos += thisRead;
            nextReadBlock = true;
        }
        return true;
    }

    @Override
    public int getMaxFrameSize() {
        return this.localSettings.getMaxFrameSize();
    }

    @Override
    public HpackDecoder getHpackDecoder() {
        if (this.hpackDecoder == null) {
            this.hpackDecoder = new HpackDecoder(this.localSettings.getHeaderTableSize());
        }
        return this.hpackDecoder;
    }

    @Override
    public ByteBuffer startRequestBodyFrame(int streamId, int payloadSize) throws Http2Exception {
        Stream stream = this.getStream(streamId, true);
        stream.checkState(FrameType.DATA);
        return stream.getInputByteBuffer();
    }

    @Override
    public void endRequestBodyFrame(int streamId) throws Http2Exception {
        Stream stream = this.getStream(streamId, true);
        stream.getInputBuffer().onDataAvailable();
    }

    @Override
    public void receivedEndOfStream(int streamId) throws ConnectionException {
        Stream stream = this.getStream(streamId, this.connectionState.get().isNewStreamAllowed());
        if (stream != null) {
            stream.receivedEndOfStream();
            if (!stream.isActive()) {
                this.activeRemoteStreamCount.decrementAndGet();
            }
        }
    }

    @Override
    public void swallowedPadding(int streamId, int paddingLength) throws ConnectionException, IOException {
        Stream stream = this.getStream(streamId, true);
        this.writeWindowUpdate(stream, paddingLength + 1, false);
    }

    @Override
    public HpackDecoder.HeaderEmitter headersStart(int streamId, boolean headersEndStream) throws Http2Exception {
        if (this.connectionState.get().isNewStreamAllowed()) {
            Stream stream = this.getStream(streamId, false);
            if (stream == null) {
                stream = this.createRemoteStream(streamId);
            }
            stream.checkState(FrameType.HEADERS);
            stream.receivedStartOfHeaders(headersEndStream);
            this.closeIdleStreams(streamId);
            if (this.localSettings.getMaxConcurrentStreams() < (long)this.activeRemoteStreamCount.incrementAndGet()) {
                this.activeRemoteStreamCount.decrementAndGet();
                throw new StreamException(sm.getString("upgradeHandler.tooManyRemoteStreams", new Object[]{Long.toString(this.localSettings.getMaxConcurrentStreams())}), Http2Error.REFUSED_STREAM, streamId);
            }
            return stream;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.noNewStreams", new Object[]{this.connectionId, Integer.toString(streamId)}));
        }
        return HEADER_SINK;
    }

    private void closeIdleStreams(int newMaxActiveRemoteStreamId) throws Http2Exception {
        for (int i = this.maxActiveRemoteStreamId + 2; i < newMaxActiveRemoteStreamId; i += 2) {
            Stream stream = this.getStream(i, false);
            if (stream == null) continue;
            stream.closeIfIdle();
        }
        this.maxActiveRemoteStreamId = newMaxActiveRemoteStreamId;
    }

    @Override
    public void reprioritise(int streamId, int parentStreamId, boolean exclusive, int weight) throws Http2Exception {
        Stream stream = this.getStream(streamId, false);
        if (stream == null) {
            stream = this.createRemoteStream(streamId);
        }
        stream.checkState(FrameType.PRIORITY);
        AbstractStream parentStream = this.getStream(parentStreamId, false);
        if (parentStream == null) {
            parentStream = this;
        }
        stream.rePrioritise(parentStream, exclusive, weight);
    }

    @Override
    public void headersEnd(int streamId) throws ConnectionException {
        this.setMaxProcessedStream(streamId);
        Stream stream = this.getStream(streamId, this.connectionState.get().isNewStreamAllowed());
        if (stream != null && stream.isActive() && stream.receivedEndOfHeaders()) {
            this.processStreamOnContainerThread(stream);
        }
    }

    private void setMaxProcessedStream(int streamId) {
        if (this.maxProcessedStreamId < streamId) {
            this.maxProcessedStreamId = streamId;
        }
    }

    @Override
    public void reset(int streamId, long errorCode) throws Http2Exception {
        Stream stream = this.getStream(streamId, true);
        stream.checkState(FrameType.RST);
        stream.receiveReset(errorCode);
    }

    @Override
    public void setting(Setting setting, long value) throws ConnectionException {
        if (setting == Setting.INITIAL_WINDOW_SIZE) {
            long oldValue = this.remoteSettings.getInitialWindowSize();
            this.remoteSettings.set(setting, value);
            int diff = (int)(value - oldValue);
            for (Stream stream : this.streams.values()) {
                try {
                    stream.incrementWindowSize(diff);
                }
                catch (Http2Exception h2e) {
                    stream.close(new StreamException(sm.getString("upgradeHandler.windowSizeTooBig", new Object[]{this.connectionId, stream.getIdentifier()}), h2e.getError(), stream.getIdentifier()));
                }
            }
        } else {
            this.remoteSettings.set(setting, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void settingsEnd(boolean ack) throws IOException {
        if (ack) {
            if (!this.localSettings.ack()) {
                log.warn((Object)sm.getString("upgradeHandler.unexpectedAck", new Object[]{this.connectionId, this.getIdentifier()}));
            }
        } else {
            SocketWrapperBase<?> socketWrapperBase = this.socketWrapper;
            synchronized (socketWrapperBase) {
                this.socketWrapper.write(true, SETTINGS_ACK, 0, SETTINGS_ACK.length);
                this.socketWrapper.flush(true);
            }
        }
    }

    @Override
    public void pingReceive(byte[] payload, boolean ack) throws IOException {
        this.pingManager.receivePing(payload, ack);
    }

    @Override
    public void goaway(int lastStreamId, long errorCode, String debugData) {
        if (log.isDebugEnabled()) {
            log.debug((Object)sm.getString("upgradeHandler.goaway.debug", new Object[]{this.connectionId, Integer.toString(lastStreamId), Long.toHexString(errorCode), debugData}));
        }
    }

    @Override
    public void incrementWindowSize(int streamId, int increment) throws Http2Exception {
        if (streamId == 0) {
            this.incrementWindowSize(increment);
        } else {
            Stream stream = this.getStream(streamId, true);
            stream.checkState(FrameType.WINDOW_UPDATE);
            stream.incrementWindowSize(increment);
        }
    }

    @Override
    public void swallowed(int streamId, FrameType frameType, int flags, int size) throws IOException {
    }

    private static enum ConnectionState {
        NEW(true),
        CONNECTED(true),
        PAUSING(true),
        PAUSED(false),
        CLOSED(false);

        private final boolean newStreamsAllowed;

        private ConnectionState(boolean newStreamsAllowed) {
            this.newStreamsAllowed = newStreamsAllowed;
        }

        public boolean isNewStreamAllowed() {
            return this.newStreamsAllowed;
        }
    }

    private static class PingRecord {
        private final int sequence;
        private final long sentNanoTime;

        public PingRecord(int sequence, long sentNanoTime) {
            this.sequence = sequence;
            this.sentNanoTime = sentNanoTime;
        }

        public int getSequence() {
            return this.sequence;
        }

        public long getSentNanoTime() {
            return this.sentNanoTime;
        }
    }

    private class PingManager {
        private final long pingIntervalNano = 10000000000L;
        private int sequence = 0;
        private long lastPingNanoTime = Long.MIN_VALUE;
        private Queue<PingRecord> inflightPings = new ConcurrentLinkedQueue<PingRecord>();
        private Queue<Long> roundTripTimes = new ConcurrentLinkedQueue<Long>();

        private PingManager() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendPing(boolean force) throws IOException {
            long now = System.nanoTime();
            if (force || now - this.lastPingNanoTime > 10000000000L) {
                this.lastPingNanoTime = now;
                byte[] payload = new byte[8];
                SocketWrapperBase socketWrapperBase = Http2UpgradeHandler.this.socketWrapper;
                synchronized (socketWrapperBase) {
                    int sentSequence = ++this.sequence;
                    PingRecord pingRecord = new PingRecord(sentSequence, now);
                    this.inflightPings.add(pingRecord);
                    ByteUtil.set31Bits(payload, 4, sentSequence);
                    Http2UpgradeHandler.this.socketWrapper.write(true, PING, 0, PING.length);
                    Http2UpgradeHandler.this.socketWrapper.write(true, payload, 0, payload.length);
                    Http2UpgradeHandler.this.socketWrapper.flush(true);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receivePing(byte[] payload, boolean ack) throws IOException {
            if (ack) {
                int receivedSequence = ByteUtil.get31Bits(payload, 4);
                PingRecord pingRecord = this.inflightPings.poll();
                while (pingRecord != null && pingRecord.getSequence() < receivedSequence) {
                    pingRecord = this.inflightPings.poll();
                }
                if (pingRecord != null) {
                    long roundTripTime = System.nanoTime() - pingRecord.getSentNanoTime();
                    this.roundTripTimes.add(roundTripTime);
                    while (this.roundTripTimes.size() > 3) {
                        this.roundTripTimes.poll();
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)sm.getString("pingManager.roundTripTime", new Object[]{Http2UpgradeHandler.this.connectionId, roundTripTime}));
                    }
                }
            } else {
                SocketWrapperBase socketWrapperBase = Http2UpgradeHandler.this.socketWrapper;
                synchronized (socketWrapperBase) {
                    Http2UpgradeHandler.this.socketWrapper.write(true, PING_ACK, 0, PING_ACK.length);
                    Http2UpgradeHandler.this.socketWrapper.write(true, payload, 0, payload.length);
                    Http2UpgradeHandler.this.socketWrapper.flush(true);
                }
            }
        }

        public long getRoundTripTimeNano() {
            long sum = 0L;
            long count = 0L;
            for (Long roundTripTime : this.roundTripTimes) {
                sum += roundTripTime.longValue();
                ++count;
            }
            if (count > 0L) {
                return sum / count;
            }
            return 0L;
        }
    }
}

