'''OpenGL extension NV.point_sprite

This module customises the behaviour of the 
OpenGL.raw.GL.NV.point_sprite to provide a more 
Python-friendly API

Overview (from the spec)
	
	Applications such as particle systems usually must use OpenGL quads
	rather than points to render their geometry, since they would like to
	use a custom-drawn texture for each particle, rather than the
	traditional OpenGL round antialiased points, and each fragment in
	a point has the same texture coordinates as every other fragment.
	
	Unfortunately, specifying the geometry for these quads can be quite
	expensive, since it quadruples the amount of geometry required, and
	it may also require the application to do extra processing to compute
	the location of each vertex.
	
	The goal of this extension is to allow such apps to use points rather
	than quads.  When GL_POINT_SPRITE_NV is enabled, the state of point
	antialiasing is ignored.  For each texture unit, the app can then
	specify whether to replace the existing texture coordinates with
	point sprite texture coordinates, which are interpolated across the
	point.  Finally, the app can set a global parameter for the way to
	generate the R coordinate for point sprites; the R coordinate can
	either be zero, the input S coordinate, or the input R coordinate.
	This allows applications to use a 3D texture to represent a point
	sprite that goes through an animation, with filtering between frames,
	for example.

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/point_sprite.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.NV.point_sprite import *
### END AUTOGENERATED SECTION