'''OpenGL extension NV.fragment_program2

This module customises the behaviour of the 
OpenGL.raw.GL.NV.fragment_program2 to provide a more 
Python-friendly API

Overview (from the spec)
	
	This extension, like the NV_fragment_program_option extension, provides
	additional fragment program functionality to extend the standard
	ARB_fragment_program language and execution environment.  ARB programs
	wishing to use this added functionality need only add:
	
	    OPTION NV_fragment_program2;
	
	to the beginning of their fragment programs.
	
	New functionality provided by this extension, above and beyond that
	already provided by the NV_fragment_program_option extension, includes:
	
	
	  * structured branching support, including data-dependent IF tests, loops
	    supporting a fixed number of iterations, and a data-dependent loop
	    exit instruction (BRK),
	
	  * subroutine calls,
	
	  * instructions to perform vector normalization, divide vector components
	    by a scalar, and perform two-component dot products (with or without a
	    scalar add),
	
	  * an instruction to perform a texture lookup with an explicit LOD,
	
	  * a loop index register for indirect access into the texture coordinate
	    attribute array, and
	
	  * a facing attribute that indicates whether the fragment is generated
	    from a front- or back-facing primitive.
	

The official definition of this extension is available here:
http://www.opengl.org/registry/specs/NV/fragment_program2.txt
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions, wrapper
from OpenGL.GL import glget
import ctypes
from OpenGL.raw.GL.NV.fragment_program2 import *
### END AUTOGENERATED SECTION