/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import net.sf.mpxj.DayType;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.asta.AbstractFileFormat;
import net.sf.mpxj.asta.AstaReader;
import net.sf.mpxj.asta.FileFormat10008;
import net.sf.mpxj.asta.FileFormat11004;
import net.sf.mpxj.asta.FileFormat12002;
import net.sf.mpxj.asta.FileFormat12005;
import net.sf.mpxj.asta.FileFormat13004;
import net.sf.mpxj.asta.FileFormat8020;
import net.sf.mpxj.asta.FileFormat9006;
import net.sf.mpxj.asta.MapRow;
import net.sf.mpxj.asta.Row;
import net.sf.mpxj.asta.RowComparator;
import net.sf.mpxj.asta.RowHeader;
import net.sf.mpxj.asta.TableDefinition;
import net.sf.mpxj.asta.TextFileRow;
import net.sf.mpxj.common.ReaderTokenizer;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.reader.AbstractProjectReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AstaTextFileReader
extends AbstractProjectReader {
    private AstaReader m_reader;
    private List<ProjectListener> m_projectListeners;
    private Map<String, List<Row>> m_tables;
    private Map<Integer, TableDefinition> m_tableDefinitions;
    private boolean m_epochDateFormat;
    private static final char DELIMITER = ',';
    private static final RowComparator CALENDAR_COMPARATOR = new RowComparator("CALENDARID");
    private static final RowComparator PERMANENT_RESOURCE_COMPARATOR = new RowComparator("PERMANENT_RESOURCEID");
    private static final RowComparator CONSUMABLE_RESOURCE_COMPARATOR = new RowComparator("CONSUMABLE_RESOURCEID");
    private static final RowComparator BAR_COMPARATOR = new RowComparator("NATURAL_ORDER");
    private static final RowComparator TASK_COMPARATOR = new RowComparator("WBT", "NATURAO_ORDER");
    private static final RowComparator LINK_COMPARATOR = new RowComparator("LINKID");
    private static final RowComparator ALLOCATION_COMPARATOR = new RowComparator("PERMANENT_SCHEDUL_ALLOCATIONID");
    private static final Map<Integer, Class<? extends AbstractFileFormat>> FILE_VERSION_MAP = new HashMap<Integer, Class<? extends AbstractFileFormat>>();

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            this.m_reader = new AstaReader();
            ProjectFile projectFile = this.m_reader.getProject();
            projectFile.getEventManager().addProjectListeners(this.m_projectListeners);
            this.m_tables = new HashMap<String, List<Row>>();
            this.processFile(inputStream);
            this.processProjectProperties();
            this.processCalendars();
            this.processResources();
            this.processTasks();
            this.processPredecessors();
            this.processAssignments();
            this.updateStructure(projectFile);
            ProjectFile projectFile2 = projectFile;
            return projectFile2;
        }
        catch (SQLException sQLException) {
            throw new MPXJException("Error reading file", sQLException);
        }
        finally {
            this.m_reader = null;
        }
    }

    private void processFile(InputStream inputStream) throws MPXJException {
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream, "UTF-8");
            ReaderTokenizer readerTokenizer = new ReaderTokenizer(inputStreamReader){

                protected boolean startQuotedIsValid(StringBuilder stringBuilder) {
                    return stringBuilder.length() == 1 && stringBuilder.charAt(0) == '<';
                }
            };
            readerTokenizer.setDelimiter(',');
            ArrayList<String> arrayList = new ArrayList<String>();
            Object object = null;
            while (readerTokenizer.getType() != -1) {
                Object object2;
                arrayList.clear();
                TableDefinition tableDefinition = null;
                while (readerTokenizer.nextToken() == -3) {
                    object2 = readerTokenizer.getToken();
                    if (arrayList.size() == 0) {
                        if (((String)object2).charAt(0) == '#') {
                            int n = ((String)object2).lastIndexOf(58);
                            if (n != -1) {
                                Object object3;
                                if (((String)object2).endsWith("-") || ((String)object2).endsWith("=")) {
                                    object3 = object2;
                                    object2 = null;
                                } else {
                                    object3 = ((String)object2).substring(0, n);
                                    object2 = ((String)object2).substring(n + 1);
                                }
                                RowHeader rowHeader = new RowHeader((String)object3);
                                tableDefinition = this.m_tableDefinitions.get(rowHeader.getType());
                                arrayList.add(rowHeader.getID());
                            }
                        } else if (((String)object2).charAt(0) == '\u0000') {
                            this.processFileType((String)object2);
                        }
                    }
                    if (tableDefinition == null || object2 == null) continue;
                    if (((String)object2).startsWith("<\"") && !((String)object2).endsWith("\">")) {
                        object = object2;
                        continue;
                    }
                    if (object != null) {
                        object2 = (String)object + ',' + (String)object2;
                        object = null;
                    }
                    arrayList.add((String)object2);
                }
                if (tableDefinition == null || arrayList.size() <= 1) continue;
                object2 = new TextFileRow(tableDefinition, arrayList, this.m_epochDateFormat);
                List<Row> list = this.m_tables.get(tableDefinition.getName());
                if (list == null) {
                    list = new LinkedList<Row>();
                    this.m_tables.put(tableDefinition.getName(), list);
                }
                list.add((Row)object2);
            }
        }
        catch (Exception exception) {
            throw new MPXJException("Error reading file", exception);
        }
    }

    private void processFileType(String string) throws MPXJException {
        String string2 = string.substring(2).split(" ")[0];
        Class<? extends AbstractFileFormat> clazz = FILE_VERSION_MAP.get(Integer.valueOf(string2));
        if (clazz == null) {
            throw new MPXJException("Unsupported PP file format version " + string2);
        }
        try {
            AbstractFileFormat abstractFileFormat = clazz.newInstance();
            this.m_tableDefinitions = abstractFileFormat.tableDefinitions();
            this.m_epochDateFormat = abstractFileFormat.epochDateFormat();
        }
        catch (Exception exception) {
            throw new MPXJException("Failed to configure file format", exception);
        }
    }

    private void processProjectProperties() throws SQLException {
        List<Row> list = this.getTable("PROJECT_SUMMARY");
        if (!list.isEmpty()) {
            this.m_reader.processProjectProperties(list.get(0));
        }
    }

    private void processCalendars() throws SQLException {
        List<Row> list = this.getTable("EXCEPTIONN");
        Map<Integer, DayType> map = this.m_reader.createExceptionTypeMap(list);
        list = this.getTable("WORK_PATTERN");
        Map<Integer, Row> map2 = this.m_reader.createWorkPatternMap(list);
        list = new LinkedList<Row>();
        Map<Integer, List<Row>> map3 = this.m_reader.createWorkPatternAssignmentMap(list);
        list = this.getTable("EXCEPTION_ASSIGNMENT");
        Map<Integer, List<Row>> map4 = this.m_reader.createExceptionAssignmentMap(list);
        list = this.getTable("TIME_ENTRY");
        Map<Integer, List<Row>> map5 = this.m_reader.createTimeEntryMap(list);
        list = this.getTable("CALENDAR");
        Collections.sort(list, CALENDAR_COMPARATOR);
        for (Row row : list) {
            this.m_reader.processCalendar(row, map2, map3, map4, map5, map);
        }
        this.m_reader.getProject().getProjectConfig().updateUniqueCounters();
    }

    private void processResources() throws SQLException {
        List<Row> list = this.getTable("PERMANENT_RESOURCE");
        List<Row> list2 = this.getTable("CONSUMABLE_RESOURCE");
        Collections.sort(list, PERMANENT_RESOURCE_COMPARATOR);
        Collections.sort(list2, CONSUMABLE_RESOURCE_COMPARATOR);
        this.m_reader.processResources(list, list2);
    }

    private void processTasks() throws SQLException {
        List<Row> list = this.getTable("BAR");
        List<Row> list2 = this.getTable("EXPANDED_TASK");
        List<Row> list3 = this.join(list, "EXPANDED_TASK", "EXPANDED_TASK", list2, "EXPANDED_TASKID");
        this.filterNotNull(list3, "STARV");
        Collections.sort(list3, BAR_COMPARATOR);
        List<Row> list4 = this.getTable("TASK");
        Collections.sort(list4, TASK_COMPARATOR);
        List<Row> list5 = this.getTable("MILESTONE");
        this.m_reader.processTasks(list3, list4, list5);
    }

    private void processPredecessors() throws SQLException {
        List<Row> list = this.getTable("LINK");
        Collections.sort(list, LINK_COMPARATOR);
        this.m_reader.processPredecessors(list);
    }

    private void processAssignments() throws SQLException {
        List<Row> list = this.getTable("PERMANENT_SCHEDUL_ALLOCATION");
        List<Row> list2 = this.getTable("PERM_RESOURCE_SKILL");
        List<Row> list3 = this.join(list, "ALLOCATIOP_OF", "PERM_RESOURCE_SKILL", list2, "PERM_RESOURCE_SKILLID");
        Collections.sort(list3, ALLOCATION_COMPARATOR);
        this.m_reader.processAssignments(list3);
    }

    private void updateStructure(ProjectFile projectFile) {
        projectFile.updateStructure();
        for (Task iterator2 : projectFile.getChildTasks()) {
            this.updateBlankNames(null, iterator2);
        }
        LinkedList linkedList = new LinkedList();
        for (Task task : projectFile.getAllTasks()) {
            if (task.getChildTasks().size() != 1 || task.getChildTasks().get(0).getChildTasks().size() != 0 || !task.getWBS().equals("-")) continue;
            linkedList.add(task);
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Task task;
            task = (Task)iterator.next();
            Task task2 = task.getChildTasks().get(0);
            Task task3 = task.getParentTask();
            if (task3 == null) {
                List<Task> list = projectFile.getChildTasks();
                int n = list.indexOf(task);
                if (n == -1) {
                    list.add(task2);
                } else {
                    list.add(n, task2);
                }
            } else {
                task3.addChildTaskBefore(task2, task);
            }
            task.getChildTasks().clear();
            task.remove();
        }
        projectFile.renumberTaskIDs();
        projectFile.updateStructure();
    }

    private void updateBlankNames(Task task, Task task2) {
        if (task != null && (task2.getName() == null || task2.getName().length() == 0)) {
            task2.setName(task.getName());
        }
        for (Task task3 : task2.getChildTasks()) {
            this.updateBlankNames(task2, task3);
        }
    }

    private List<Row> join(List<Row> list, String string, String string2, List<Row> list2, String string3) {
        LinkedList<Row> linkedList = new LinkedList<Row>();
        RowComparator rowComparator = new RowComparator(string);
        RowComparator rowComparator2 = new RowComparator(string3);
        Collections.sort(list, rowComparator);
        Collections.sort(list2, rowComparator2);
        ListIterator<Row> listIterator = list2.listIterator();
        Row row = listIterator.hasNext() ? listIterator.next() : null;
        for (Row row2 : list) {
            Serializable serializable;
            Integer n = row2.getInteger(string);
            boolean bl = false;
            while (row != null) {
                serializable = row.getInteger(string3);
                int n2 = n.compareTo((Integer)serializable);
                if (n2 == 0) {
                    bl = true;
                    break;
                }
                if (n2 < 0) {
                    if (!listIterator.hasPrevious()) break;
                    row = listIterator.previous();
                    break;
                }
                row = listIterator.next();
            }
            if (!bl || row == null) continue;
            serializable = new HashMap<String, Object>(((MapRow)row2).getMap());
            for (Map.Entry<String, Object> entry : ((MapRow)row).getMap().entrySet()) {
                String string4 = entry.getKey();
                if (serializable.containsKey(string4)) {
                    string4 = string2 + "." + string4;
                }
                serializable.put(string4, entry.getValue());
            }
            linkedList.add(new MapRow((Map<String, Object>)((Object)serializable)));
        }
        return linkedList;
    }

    private void filterNotNull(List<Row> list, String string) {
        ListIterator<Row> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            MapRow mapRow = (MapRow)listIterator.next();
            if (mapRow.getObject(string) != null) continue;
            listIterator.remove();
        }
    }

    private List<Row> getTable(String string) {
        List<Row> list = this.m_tables.get(string);
        if (list == null) {
            list = new LinkedList<Row>();
        }
        return list;
    }

    static {
        FILE_VERSION_MAP.put(8020, FileFormat8020.class);
        FILE_VERSION_MAP.put(9006, FileFormat9006.class);
        FILE_VERSION_MAP.put(10008, FileFormat10008.class);
        FILE_VERSION_MAP.put(11004, FileFormat11004.class);
        FILE_VERSION_MAP.put(12002, FileFormat12002.class);
        FILE_VERSION_MAP.put(12005, FileFormat12005.class);
        FILE_VERSION_MAP.put(13004, FileFormat13004.class);
    }
}

