/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.asta;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.asta.AstaDatabaseFileReader;
import net.sf.mpxj.asta.AstaTextFileReader;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.reader.AbstractProjectReader;
import net.sf.mpxj.reader.ProjectReader;

public final class AstaFileReader
extends AbstractProjectReader {
    private List<ProjectListener> m_projectListeners;
    private static final String SQLITE_TEXT = "SQLite format";

    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    public ProjectFile read(InputStream inputStream) throws MPXJException {
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            bufferedInputStream.mark(100);
            byte[] byArray = new byte[SQLITE_TEXT.length()];
            bufferedInputStream.read(byArray);
            bufferedInputStream.reset();
            String string = new String(byArray);
            ProjectFile projectFile = SQLITE_TEXT.equals(string) ? this.readDatabaseFile(bufferedInputStream) : this.readTextFile(bufferedInputStream);
            return projectFile;
        }
        catch (IOException iOException) {
            throw new MPXJException("Failed to read file", iOException);
        }
    }

    private void addListeners(ProjectReader projectReader) {
        if (this.m_projectListeners != null) {
            for (ProjectListener projectListener : this.m_projectListeners) {
                projectReader.addProjectListener(projectListener);
            }
        }
    }

    private ProjectFile readTextFile(InputStream inputStream) throws MPXJException {
        AstaTextFileReader astaTextFileReader = new AstaTextFileReader();
        this.addListeners(astaTextFileReader);
        return astaTextFileReader.read(inputStream);
    }

    private ProjectFile readDatabaseFile(InputStream inputStream) throws MPXJException {
        AstaDatabaseFileReader astaDatabaseFileReader = new AstaDatabaseFileReader();
        this.addListeners(astaDatabaseFileReader);
        return astaDatabaseFileReader.read(inputStream);
    }
}

