/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj;

import java.util.Iterator;
import net.sf.mpxj.Day;
import net.sf.mpxj.DayType;
import net.sf.mpxj.ProjectCalendar;
import net.sf.mpxj.ProjectEntityContainer;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Resource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectCalendarContainer
extends ProjectEntityContainer<ProjectCalendar> {
    public ProjectCalendarContainer(ProjectFile projectFile) {
        super(projectFile);
    }

    @Override
    public void removed(ProjectCalendar projectCalendar) {
        Resource resource = projectCalendar.getResource();
        if (resource != null) {
            resource.setResourceCalendar(null);
        }
        projectCalendar.setParent(null);
    }

    public ProjectCalendar add() {
        ProjectCalendar projectCalendar = new ProjectCalendar(this.m_projectFile);
        this.add(projectCalendar);
        return projectCalendar;
    }

    public ProjectCalendar addDefaultBaseCalendar() {
        ProjectCalendar projectCalendar = this.add();
        projectCalendar.setName("Standard");
        projectCalendar.setWorkingDay(Day.SUNDAY, false);
        projectCalendar.setWorkingDay(Day.MONDAY, true);
        projectCalendar.setWorkingDay(Day.TUESDAY, true);
        projectCalendar.setWorkingDay(Day.WEDNESDAY, true);
        projectCalendar.setWorkingDay(Day.THURSDAY, true);
        projectCalendar.setWorkingDay(Day.FRIDAY, true);
        projectCalendar.setWorkingDay(Day.SATURDAY, false);
        projectCalendar.addDefaultCalendarHours();
        return projectCalendar;
    }

    public ProjectCalendar addDefaultDerivedCalendar() {
        ProjectCalendar projectCalendar = this.add();
        projectCalendar.setWorkingDay(Day.SUNDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.MONDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.TUESDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.WEDNESDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.THURSDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.FRIDAY, DayType.DEFAULT);
        projectCalendar.setWorkingDay(Day.SATURDAY, DayType.DEFAULT);
        return projectCalendar;
    }

    public ProjectCalendar getByName(String string) {
        ProjectCalendar projectCalendar = null;
        if (string != null && string.length() != 0) {
            String string2;
            Iterator iterator = this.iterator();
            while (iterator.hasNext() && ((string2 = (projectCalendar = (ProjectCalendar)iterator.next()).getName()) == null || !string2.equalsIgnoreCase(string))) {
                projectCalendar = null;
            }
        }
        return projectCalendar;
    }
}

