/*
 * Decompiled with CFR 0.152.
 */
package com.projity.print;

import com.projity.pm.task.Project;
import com.projity.print.PrintSettings;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.prefs.Preferences;

public class PrintSettingsManager {
    protected static PrintSettings tmpLocalSettings;

    public static PrintSettings getSettings(Project project) {
        if (project == null) {
            if (tmpLocalSettings == null) {
                byte[] byArray = Preferences.userNodeForPackage(PrintSettings.class).getByteArray("printSettings", null);
                if (byArray != null) {
                    try {
                        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                        tmpLocalSettings = (PrintSettings)objectInputStream.readObject();
                        objectInputStream.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                if (tmpLocalSettings == null) {
                    tmpLocalSettings = new PrintSettings();
                    tmpLocalSettings.setEmpty(true);
                }
            }
            return tmpLocalSettings;
        }
        PrintSettings printSettings = project.getPrintSettings(0);
        if (printSettings == null) {
            printSettings = new PrintSettings();
            printSettings.setEmpty(true);
            project.setTmpSettings(printSettings);
        }
        return printSettings;
    }

    public static void saveSettings(PrintSettings printSettings, Project project, boolean bl) {
        if (project == null) {
            if (printSettings != null) {
                printSettings.spreadsheetWorkspace = null;
                tmpLocalSettings = printSettings;
                if (bl) {
                    try {
                        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                        ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                        objectOutputStream.writeObject(printSettings);
                        objectOutputStream.flush();
                        objectOutputStream.close();
                        Preferences.userNodeForPackage(PrintSettings.class).putByteArray("printSettings", byteArrayOutputStream.toByteArray());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        } else {
            project.setPrintSettings(printSettings);
        }
    }
}

