/*
 * Decompiled with CFR 0.152.
 */
package ddf.minim.signals;

import ddf.minim.AudioSignal;
import ddf.minim.Minim;
import processing.core.PApplet;

class ADSR
implements AudioSignal {
    private int a;
    private int d;
    private int s;
    private int r;
    private float susAmp;
    private int samplesProcessed;
    float[] allAmps;

    public ADSR(float attackLength, float decayLength, float sustainLength, float sustainLevel, float releaseLength, float sampleRate) {
        int asamp = (int)(attackLength * sampleRate);
        int dsamp = (int)(decayLength * sampleRate);
        int ssamp = (int)(sustainLength * sampleRate);
        int rsamp = (int)(releaseLength * sampleRate);
        Minim.debug("Attack: " + asamp + ", Decay: " + dsamp + ", Sustain: " + ssamp + ", Release: " + rsamp);
        this.a = asamp;
        this.d = this.a + dsamp;
        this.s = this.d + ssamp;
        this.r = this.s + rsamp;
        this.susAmp = sustainLevel;
        this.samplesProcessed = 0;
    }

    public void trigger() {
        this.samplesProcessed = 0;
    }

    public boolean done() {
        return this.samplesProcessed > this.r;
    }

    public void generate(float[] signal) {
        this.generate(signal, null);
    }

    public void generate(float[] left, float[] right) {
        int i = 0;
        while (i < left.length) {
            float amp = 0.0f;
            if (this.samplesProcessed <= this.a) {
                amp = PApplet.map((float)this.samplesProcessed, (float)0.0f, (float)this.a, (float)0.0f, (float)1.0f);
            } else if (this.samplesProcessed > this.a && this.samplesProcessed <= this.d) {
                amp = PApplet.map((float)this.samplesProcessed, (float)this.a, (float)this.d, (float)1.0f, (float)this.susAmp);
            } else if (this.samplesProcessed > this.d && this.samplesProcessed <= this.s) {
                amp = this.susAmp;
            } else if (this.samplesProcessed > this.s && this.samplesProcessed <= this.r) {
                amp = PApplet.map((float)this.samplesProcessed, (float)this.s, (float)this.r, (float)this.susAmp, (float)0.0f);
            }
            left[i] = amp;
            if (right != null) {
                right[i] = amp;
            }
            ++this.samplesProcessed;
            ++i;
        }
    }
}

