/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.remote;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.netbeans.modules.cnd.api.remote.CommandProvider;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class RemoteFile
extends File {
    private final ExecutionEnvironment execEnv;
    private final String path;

    public ExecutionEnvironment getExecutionEnvironment() {
        return this.execEnv;
    }

    public static File create(ExecutionEnvironment execEnv, String pathname) {
        if (execEnv.isLocal()) {
            return new File(pathname);
        }
        return new RemoteFile(execEnv, pathname);
    }

    public static Reader createReader(File file) throws FileNotFoundException {
        if (file instanceof RemoteFile) {
            RemoteFile rfile = (RemoteFile)file;
            CommandProvider cmd = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
            if (rfile.exists() && cmd.run(rfile.getExecutionEnvironment(), "cat " + rfile.getPath(), null) == 0) {
                return new StringReader(cmd.getOutput());
            }
            throw new FileNotFoundException(rfile.getPath() + " wasn't found on " + rfile.getExecutionEnvironment());
        }
        return new FileReader(file);
    }

    private RemoteFile(ExecutionEnvironment execEnv, String pathname) {
        super(pathname);
        this.path = pathname;
        assert (execEnv.isRemote());
        this.execEnv = execEnv;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public File getAbsoluteFile() {
        return new RemoteFile(this.execEnv, this.getAbsolutePath());
    }

    @Override
    public String getAbsolutePath() {
        return this.path;
    }

    @Override
    public File getCanonicalFile() throws IOException {
        return new RemoteFile(this.execEnv, this.path);
    }

    @Override
    public String getCanonicalPath() throws IOException {
        return super.getCanonicalPath();
    }

    @Override
    public boolean exists() {
        return HostInfoProvider.fileExists(this.execEnv, this.getPath());
    }

    @Override
    public boolean delete() {
        Future task = CommonTasksSupport.rmDir((ExecutionEnvironment)this.execEnv, (String)this.getPath(), (boolean)true, null);
        try {
            int rc = (Integer)task.get();
            return rc == 0;
        }
        catch (InterruptedException ex) {
            return false;
        }
        catch (ExecutionException ex) {
            return false;
        }
    }

    @Override
    public File[] listFiles() {
        String files;
        CommandProvider provider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
        if (provider.run(this.execEnv, "ls -A1 \"" + this.getPath() + "\"", null) == 0 && (files = provider.getOutput()) != null) {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(files));
            ArrayList<RemoteFile> lines = new ArrayList<RemoteFile>();
            try {
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    lines.add(new RemoteFile(this.execEnv, this.getPath() + "/" + line));
                }
                bufferedReader.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return null;
            }
            return lines.toArray(new File[lines.size()]);
        }
        return null;
    }

    @Override
    public boolean isDirectory() {
        CommandProvider provider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
        return provider.run(this.execEnv, "test -d \"" + this.getPath() + "\"", null) == 0;
    }

    @Override
    public boolean isFile() {
        CommandProvider provider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
        return provider.run(this.execEnv, "test -f \"" + this.getPath() + "\"", null) == 0;
    }

    @Override
    public boolean canRead() {
        CommandProvider provider = (CommandProvider)Lookup.getDefault().lookup(CommandProvider.class);
        return provider.run(this.execEnv, "test -r \"" + this.getPath() + "\"", null) == 0;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RemoteFile other = (RemoteFile)obj;
        return !(this.execEnv == null ? other.execEnv != null : !this.execEnv.equals(other.execEnv));
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.execEnv.hashCode() + 7;
    }
}

