/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;

public class JMethodIdTable {
    private static JMethodIdTable defaultTable;
    private JMethodIdTableEntry[] entries;
    private boolean staticTable = false;
    private int incompleteEntries;
    private int nElements;
    private int size;
    private int threshold;

    JMethodIdTable() {
        this.size = 97;
        this.threshold = this.size * 3 / 4;
        this.nElements = 0;
        this.entries = new JMethodIdTableEntry[this.size];
    }

    JMethodIdTable(int[] methodIds, String[][] methodNamesAndSigs) {
        this.staticTable = true;
        this.size = methodIds.length * 2;
        this.threshold = this.size * 3 / 4;
        this.nElements = 0;
        this.entries = new JMethodIdTableEntry[this.size];
        for (int i = 0; i < methodIds.length; ++i) {
            this.addEntry(methodIds[i], methodNamesAndSigs[0][i], methodNamesAndSigs[1][i], methodNamesAndSigs[2][i]);
        }
    }

    JMethodIdTable(JMethodIdTable otherTable) {
        this.staticTable = true;
        this.threshold = otherTable.nElements + 1;
        this.size = this.threshold * 4 / 3;
        this.nElements = 0;
        this.entries = new JMethodIdTableEntry[this.size];
        for (int i = 0; i < otherTable.entries.length; ++i) {
            JMethodIdTableEntry entry = otherTable.entries[i];
            if (entry == null) continue;
            this.addEntry(entry.methodId, entry.className, entry.methodName, entry.methodSig);
        }
    }

    public static JMethodIdTable getDefault() {
        if (defaultTable == null) {
            defaultTable = new JMethodIdTable();
        }
        return defaultTable;
    }

    public static void reset() {
        defaultTable = null;
    }

    public String debug() {
        if (this.entries == null) {
            return "Entries = null, size = " + this.size + ", nElements = " + this.nElements + ", threshold = " + this.threshold + ", incompleteEntries = " + this.incompleteEntries;
        }
        return "Entries.length = " + this.entries.length + ", size = " + this.size + ", nElements = " + this.nElements + ", threshold = " + this.threshold + ", incompleteEntries = " + this.incompleteEntries;
    }

    public void readFromStream(DataInputStream in) throws IOException {
        this.size = in.readInt();
        this.nElements = in.readInt();
        this.threshold = in.readInt();
        this.entries = new JMethodIdTableEntry[this.size];
        int count = in.readInt();
        for (int i = 0; i < count; ++i) {
            int methodId = in.readInt();
            String className = in.readUTF();
            String methodName = in.readUTF();
            String methodSig = in.readUTF();
            this.addEntry(methodId, className, methodName, methodSig);
        }
    }

    public void writeToStream(DataOutputStream out) throws IOException {
        int i;
        out.writeInt(this.size);
        out.writeInt(this.nElements);
        out.writeInt(this.threshold);
        int count = 0;
        for (i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] == null) continue;
            ++count;
        }
        out.writeInt(count);
        for (i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] == null) continue;
            out.writeInt(this.entries[i].methodId);
            out.writeUTF(this.entries[i].className);
            out.writeUTF(this.entries[i].methodName);
            out.writeUTF(this.entries[i].methodSig);
        }
    }

    JMethodIdTableEntry getEntry(int methodId) {
        int pos = this.hash(methodId) % this.size;
        while (this.entries[pos] != null && this.entries[pos].methodId != methodId) {
            pos = (pos + 1) % this.size;
        }
        return this.entries[pos];
    }

    synchronized void getNamesForMethodIds(ProfilerClient profilerClient) throws ClientUtils.TargetAppOrVMTerminated {
        if (this.staticTable) {
            throw new IllegalStateException("Attempt to update snapshot JMethodIdTable");
        }
        if (this.incompleteEntries == 0) {
            return;
        }
        int[] missingNameMethodIds = new int[this.incompleteEntries];
        int idx = 0;
        for (int i = 0; i < this.entries.length; ++i) {
            if (this.entries[i] == null || this.entries[i].className != null) continue;
            missingNameMethodIds[idx++] = this.entries[i].methodId;
        }
        String[][] methodClassNameAndSig = profilerClient.getMethodNamesForJMethodIds(missingNameMethodIds);
        for (int i = 0; i < missingNameMethodIds.length; ++i) {
            this.completeEntry(missingNameMethodIds[i], methodClassNameAndSig[0][i], methodClassNameAndSig[1][i], methodClassNameAndSig[2][i]);
        }
        this.incompleteEntries = 0;
    }

    void addEntry(int methodId, String className, String methodName, String methodSig) {
        this.checkMethodId(methodId);
        this.completeEntry(methodId, className, methodName, methodSig);
    }

    synchronized void checkMethodId(int methodId) {
        int pos = this.hash(methodId) % this.size;
        while (this.entries[pos] != null) {
            if (this.entries[pos].methodId == methodId) {
                return;
            }
            pos = (pos + 1) % this.size;
        }
        if (this.nElements < this.threshold) {
            this.entries[pos] = new JMethodIdTableEntry(methodId);
            ++this.nElements;
            ++this.incompleteEntries;
            return;
        }
        this.growTable();
        this.checkMethodId(methodId);
    }

    private void completeEntry(int methodId, String className, String methodName, String methodSig) {
        int pos = this.hash(methodId) % this.size;
        while (this.entries[pos].methodId != methodId) {
            pos = (pos + 1) % this.size;
        }
        this.entries[pos].className = className;
        this.entries[pos].methodName = methodName;
        this.entries[pos].methodSig = methodSig;
    }

    private void growTable() {
        JMethodIdTableEntry[] oldEntries = this.entries;
        this.size = this.size * 2 + 1;
        this.threshold = this.size * 3 / 4;
        this.entries = new JMethodIdTableEntry[this.size];
        for (int i = 0; i < oldEntries.length; ++i) {
            if (oldEntries[i] == null) continue;
            int pos = this.hash(oldEntries[i].methodId) % this.size;
            while (this.entries[pos] != null) {
                pos = (pos + 1) % this.size;
            }
            this.entries[pos] = oldEntries[i];
        }
    }

    private int hash(int x) {
        return (x >> 2) * 123457 & 0xFFFFFFF;
    }

    static class JMethodIdTableEntry {
        String className;
        String methodName;
        String methodSig;
        int methodId;

        JMethodIdTableEntry(int methodId) {
            this.methodId = methodId;
        }
    }
}

