/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jersey.api.client;

import com.sun.jersey.api.client.AsyncWebResource;
import com.sun.jersey.api.client.ClientHandler;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.ComponentsClientConfig;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.Filterable;
import com.sun.jersey.client.urlconnection.URLConnectionClientHandler;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.core.spi.component.ComponentInjector;
import com.sun.jersey.core.spi.component.ComponentScope;
import com.sun.jersey.core.spi.component.ProviderFactory;
import com.sun.jersey.core.spi.component.ProviderServices;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessor;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessorFactory;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProcessorFactoryInitializer;
import com.sun.jersey.core.spi.component.ioc.IoCComponentProviderFactory;
import com.sun.jersey.core.spi.component.ioc.IoCProviderFactory;
import com.sun.jersey.core.spi.factory.ContextResolverFactory;
import com.sun.jersey.core.spi.factory.InjectableProviderFactory;
import com.sun.jersey.core.spi.factory.MessageBodyFactory;
import com.sun.jersey.core.util.FeaturesAndProperties;
import com.sun.jersey.spi.MessageBodyWorkers;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.InjectableProvider;
import com.sun.jersey.spi.inject.InjectableProviderContext;
import com.sun.jersey.spi.inject.SingletonTypeInjectableProvider;
import com.sun.jersey.spi.service.ServiceFinder;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Providers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Client
extends Filterable
implements ClientHandler {
    private static final Logger LOGGER = Logger.getLogger(Client.class.getName());
    private final ProviderFactory componentProviderFactory;
    private final Providers providers;
    private boolean destroyed = false;
    private Map<String, Object> properties;

    public Client() {
        this(Client.createDefaultClientHander(), new DefaultClientConfig(), null);
    }

    public Client(ClientHandler root) {
        this(root, new DefaultClientConfig(), null);
    }

    public Client(ClientHandler root, ClientConfig config) {
        this(root, config, null);
    }

    public Client(ClientHandler root, ClientConfig config, IoCComponentProviderFactory provider) {
        super(root);
        Class[] components = ServiceFinder.find((String)"jersey-client-components").toClassArray();
        if (components.length > 0) {
            if (LOGGER.isLoggable(Level.INFO)) {
                StringBuilder b = new StringBuilder();
                b.append("Adding the following classes declared in META-INF/services/jersey-client-components to the client configuration:");
                for (Class c : components) {
                    b.append('\n').append("  ").append(c);
                }
                LOGGER.log(Level.INFO, b.toString());
            }
            config = new ComponentsClientConfig(config, components);
        }
        final InjectableProviderFactory injectableFactory = new InjectableProviderFactory();
        this.getProperties().putAll(config.getProperties());
        if (provider != null && provider instanceof IoCComponentProcessorFactoryInitializer) {
            IoCComponentProcessorFactoryInitializer i = (IoCComponentProcessorFactoryInitializer)provider;
            i.init((IoCComponentProcessorFactory)new ComponentProcessorFactoryImpl(injectableFactory));
        }
        this.componentProviderFactory = provider == null ? new ProviderFactory((InjectableProviderContext)injectableFactory) : new IoCProviderFactory((InjectableProviderContext)injectableFactory, provider);
        ProviderServices providerServices = new ProviderServices(this.componentProviderFactory, config.getClasses(), config.getSingletons());
        injectableFactory.add(new ContextInjectableProvider<ClientConfig>((Type)((Object)FeaturesAndProperties.class), config));
        injectableFactory.add(new ContextInjectableProvider<ClientConfig>((Type)((Object)ClientConfig.class), config));
        injectableFactory.configure(providerServices);
        final ContextResolverFactory crf = new ContextResolverFactory(providerServices, injectableFactory);
        final MessageBodyFactory bodyContext = new MessageBodyFactory(providerServices);
        injectableFactory.add(new ContextInjectableProvider<MessageBodyFactory>((Type)((Object)MessageBodyWorkers.class), bodyContext));
        this.providers = new Providers(){

            public <T> MessageBodyReader<T> getMessageBodyReader(Class<T> c, Type t, Annotation[] as, MediaType m) {
                return bodyContext.getMessageBodyReader(c, t, as, m);
            }

            public <T> MessageBodyWriter<T> getMessageBodyWriter(Class<T> c, Type t, Annotation[] as, MediaType m) {
                return bodyContext.getMessageBodyWriter(c, t, as, m);
            }

            public <T extends Throwable> ExceptionMapper<T> getExceptionMapper(Class<T> c) {
                throw new IllegalArgumentException("This method is not supported on the client side");
            }

            public <T> ContextResolver<T> getContextResolver(Class<T> ct, MediaType m) {
                return crf.resolve(ct, m);
            }
        };
        injectableFactory.add(new ContextInjectableProvider<Providers>((Type)((Object)Providers.class), this.providers));
        injectableFactory.add((InjectableProvider)new InjectableProvider<Context, Type>(){

            public ComponentScope getScope() {
                return ComponentScope.Singleton;
            }

            public Injectable<Injectable> getInjectable(ComponentContext ic, Context a, Type c) {
                ParameterizedType pt;
                if (c instanceof ParameterizedType && (pt = (ParameterizedType)c).getRawType() == Injectable.class && pt.getActualTypeArguments().length == 1) {
                    final Injectable i = injectableFactory.getInjectable(a.annotationType(), ic, (Annotation)a, (Object)pt.getActualTypeArguments()[0], ComponentScope.PERREQUEST_UNDEFINED_SINGLETON);
                    return new Injectable<Injectable>(){

                        public Injectable getValue() {
                            return i;
                        }
                    };
                }
                return null;
            }
        });
        bodyContext.init();
        this.componentProviderFactory.injectOnAllComponents();
        this.componentProviderFactory.injectOnProviderInstances(config.getSingletons());
        this.componentProviderFactory.injectOnProviderInstance((Object)root);
    }

    public void destroy() {
        if (!this.destroyed) {
            this.componentProviderFactory.destroy();
            this.destroyed = true;
        }
    }

    protected void finalize() {
        this.destroy();
    }

    public Providers getProviders() {
        return this.providers;
    }

    public WebResource resource(String u) {
        return this.resource(URI.create(u));
    }

    public WebResource resource(URI u) {
        return new WebResource(this, u);
    }

    public AsyncWebResource asyncResource(String u) {
        return this.asyncResource(URI.create(u));
    }

    public AsyncWebResource asyncResource(URI u) {
        return new AsyncWebResource(this, u);
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, Object>();
        }
        return this.properties;
    }

    public void setFollowRedirects(Boolean redirect) {
        this.getProperties().put("com.sun.jersey.client.property.followRedirects", redirect);
    }

    public void setReadTimeout(Integer interval) {
        this.getProperties().put("com.sun.jersey.client.property.readTimeout", interval);
    }

    public void setConnectTimeout(Integer interval) {
        this.getProperties().put("com.sun.jersey.client.property.connectTimeout", interval);
    }

    public void setChunkedEncodingSize(Integer chunkSize) {
        this.getProperties().put("com.sun.jersey.client.property.chunkedEncodingSize", chunkSize);
    }

    @Override
    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        cr.getProperties().putAll(this.properties);
        return this.getHeadHandler().handle(cr);
    }

    public static Client create() {
        return new Client(Client.createDefaultClientHander());
    }

    public static Client create(ClientConfig cc) {
        return new Client(Client.createDefaultClientHander(), cc);
    }

    public static Client create(ClientConfig cc, IoCComponentProviderFactory provider) {
        return new Client(Client.createDefaultClientHander(), cc, provider);
    }

    private static ClientHandler createDefaultClientHander() {
        return new URLConnectionClientHandler();
    }

    private class ComponentProcessorFactoryImpl
    implements IoCComponentProcessorFactory {
        private final InjectableProviderFactory injectableFactory;

        ComponentProcessorFactoryImpl(InjectableProviderFactory injectableFactory) {
            this.injectableFactory = injectableFactory;
        }

        public ComponentScope getScope(Class c) {
            return ComponentScope.Singleton;
        }

        public IoCComponentProcessor get(Class c, ComponentScope scope) {
            final ComponentInjector ci = new ComponentInjector((InjectableProviderContext)this.injectableFactory, c);
            return new IoCComponentProcessor(){

                public void preConstruct() {
                }

                public void postConstruct(Object o) {
                    ci.inject(o);
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ContextInjectableProvider<T>
    extends SingletonTypeInjectableProvider<Context, T> {
        ContextInjectableProvider(Type type, T instance) {
            super(type, instance);
        }
    }
}

