/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.midp.propertyeditors.api.resource;

import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.AbstractButton;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.midp.actions.GoToSourceSupport;
import org.netbeans.modules.vmd.midp.propertyeditors.CleanUp;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.UserCodeAwareness;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.UserCodeCardPanel;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElement;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementEvent;
import org.netbeans.modules.vmd.midp.propertyeditors.api.resource.element.PropertyEditorResourceElementListener;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

class ResourceEditorPanel
extends JPanel
implements PropertyEditorResourceElementListener,
ListSelectionListener,
ActionListener,
UserCodeAwareness,
CleanUp {
    private static final String ACTION_ADD_RESOURCE = "addResource";
    private static final String ACTION_REMOVE_RESOURCE = "removeResource";
    private static final String COMPONENT_CARD = "componentCard";
    private static final String USER_CODE_CARD = "userCodeCard";
    private static long componentIDCounter = -10000L;
    private PropertyEditorResourceElement element;
    private Map<String, PropertyEditorResourceElement.DesignComponentWrapper> wrappersMap;
    private Set<String> changedComponents;
    private String noneComponentAsText;
    private JList componentsList;
    private JRadioButton radioButton;
    private Icon icon;
    private JPanel ucPanel;
    private CardLayout ucCardLayout;

    ResourceEditorPanel(PropertyEditorResourceElement element, String noneComponentAsText, JRadioButton radioButton) {
        if (noneComponentAsText == null || noneComponentAsText.length() == 0) {
            throw new IllegalArgumentException("Incorrect value of noneComponentAsText: " + noneComponentAsText);
        }
        if (element == null) {
            throw new IllegalArgumentException("PropertyEditorResourceElement shouls not be null");
        }
        if (radioButton == null) {
            throw new IllegalArgumentException("Null radioButton value");
        }
        this.element = element;
        this.noneComponentAsText = noneComponentAsText;
        this.radioButton = radioButton;
        this.changedComponents = new HashSet<String>();
        this.initComponents(element.getJComponent());
    }

    @Override
    public void clean(DesignComponent component) {
        if (this.wrappersMap != null) {
            this.wrappersMap.clear();
        }
        this.element = null;
        this.wrappersMap = null;
        this.changedComponents = null;
        this.componentsList = null;
        this.radioButton = null;
        this.icon = null;
        this.ucCardLayout = null;
        this.ucPanel = null;
        this.removeAll();
    }

    private void initComponents(JComponent component) {
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        this.componentsList = new JList(new DefaultListModel());
        this.componentsList.setSelectionMode(0);
        this.componentsList.setCellRenderer(new ComponentsListRenderer());
        this.componentsList.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ResourceEditorPanel.class, (String)"ASCN_ResourcesList"));
        this.componentsList.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResourceEditorPanel.class, (String)"ASCD_ResourcesList"));
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.componentsList);
        constraints.insets = new Insets(0, 0, 0, 12);
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.weightx = 0.0;
        constraints.weighty = 1.0;
        constraints.gridwidth = 2;
        constraints.fill = 1;
        this.add((Component)scrollPane, constraints);
        JButton addButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)addButton, (String)NbBundle.getMessage(ResourceEditorPanel.class, (String)"LBL_ADD_COMPONENT"));
        addButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ResourceEditorPanel.class, (String)"ACSN_ADD_COMPONENT"));
        addButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResourceEditorPanel.class, (String)"ACSD_ADD_COMPONENT"));
        addButton.setActionCommand(ACTION_ADD_RESOURCE);
        addButton.addActionListener(this);
        constraints.insets = new Insets(6, 0, 0, 12);
        constraints.anchor = 18;
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.gridwidth = 1;
        constraints.fill = 0;
        this.add((Component)addButton, constraints);
        JButton removeButton = new JButton();
        Mnemonics.setLocalizedText((AbstractButton)removeButton, (String)NbBundle.getMessage(ResourceEditorPanel.class, (String)"LBL_REMOVE_COMPONENT"));
        removeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ResourceEditorPanel.class, (String)"ACSN_REMOVE_COMPONENT"));
        removeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ResourceEditorPanel.class, (String)"ACSD_REMOVE_COMPONENT"));
        removeButton.setActionCommand(ACTION_REMOVE_RESOURCE);
        removeButton.addActionListener(this);
        constraints.insets = new Insets(6, 0, 0, 12);
        constraints.anchor = 18;
        constraints.gridx = 1;
        constraints.gridy = 1;
        constraints.weightx = 0.0;
        constraints.weighty = 0.0;
        constraints.fill = 0;
        this.add((Component)removeButton, constraints);
        constraints.insets = new Insets(0, 0, 0, 0);
        constraints.anchor = 18;
        constraints.gridx = 2;
        constraints.gridy = 0;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.fill = 1;
        this.add((Component)this.createUCAwarePanel(component), constraints);
        this.icon = ImageUtilities.loadImageIcon((String)this.element.getIconPath(), (boolean)false);
        this.componentsList.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                ResourceEditorPanel.this.radioButton.setSelected(true);
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent event) {
                ResourceEditorPanel.this.componentsList.removeListSelectionListener(ResourceEditorPanel.this);
                ResourceEditorPanel.this.componentsList.addListSelectionListener(ResourceEditorPanel.this);
            }

            @Override
            public void ancestorRemoved(AncestorEvent event) {
                ResourceEditorPanel.this.componentsList.removeListSelectionListener(ResourceEditorPanel.this);
            }

            @Override
            public void ancestorMoved(AncestorEvent event) {
            }
        });
    }

    private JComponent createUCAwarePanel(JComponent component) {
        UserCodeCardPanel userCodeCardPanel = new UserCodeCardPanel(this);
        this.ucCardLayout = new CardLayout();
        this.ucPanel = new JPanel(this.ucCardLayout);
        this.ucPanel.add((Component)component, COMPONENT_CARD);
        this.ucPanel.add((Component)userCodeCardPanel, USER_CODE_CARD);
        return this.ucPanel;
    }

    private void setUserCode(boolean isUserCode) {
        this.ucCardLayout.show(this.ucPanel, isUserCode ? USER_CODE_CARD : COMPONENT_CARD);
    }

    private boolean isUserCodeInside(PropertyEditorResourceElement.DesignComponentWrapper wrapper) {
        if (wrapper == null) {
            return false;
        }
        final DesignComponent component = wrapper.getComponent();
        if (component == null) {
            return false;
        }
        final List<String> propertyNames = this.element.getPropertyValueNames();
        final boolean[] isUC = new boolean[1];
        component.getDocument().getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                for (String propertyName : propertyNames) {
                    PropertyValue pv = component.readProperty(propertyName);
                    if (!PropertyValue.Kind.USERCODE.equals((Object)pv.getKind())) continue;
                    isUC[0] = true;
                    break;
                }
            }
        });
        return isUC[0];
    }

    void update(Map<String, DesignComponent> componentsMap, String selectedComponentName) {
        this.wrappersMap = new HashMap<String, PropertyEditorResourceElement.DesignComponentWrapper>(componentsMap.size());
        for (String key : componentsMap.keySet()) {
            DesignComponent _component = componentsMap.get(key);
            this.wrappersMap.put(key, new PropertyEditorResourceElement.DesignComponentWrapper(_component));
        }
        this.changedComponents.clear();
        this.sortAndSelect(selectedComponentName);
    }

    private void sortAndSelect(String selectedComponentName) {
        DefaultListModel listModel = (DefaultListModel)this.componentsList.getModel();
        listModel.removeAllElements();
        listModel.addElement(this.noneComponentAsText);
        TreeSet<String> set = new TreeSet<String>();
        for (String componentName : this.wrappersMap.keySet()) {
            set.add(componentName);
        }
        for (String str : set) {
            listModel.addElement(str);
        }
        this.selectComponent(selectedComponentName);
    }

    private void selectComponent(String selectedComponentName) {
        this.componentsList.setSelectedValue(selectedComponentName, false);
        if (this.noneComponentAsText.equals(selectedComponentName)) {
            this.element.setDesignComponentWrapper(null);
        } else {
            this.element.setDesignComponentWrapper(this.wrappersMap.get(selectedComponentName));
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        Object selectedName = this.getSelectedComponentName();
        if (selectedName == null || this.noneComponentAsText.equals(selectedName)) {
            this.element.setDesignComponentWrapper(null);
            this.setUserCode(false);
        } else {
            PropertyEditorResourceElement.DesignComponentWrapper wrapper = this.wrappersMap.get(selectedName);
            this.element.setDesignComponentWrapper(wrapper);
            this.setUserCode(this.isUserCodeInside(wrapper));
        }
        this.element.listSelectionHappened();
    }

    @Override
    public void elementChanged(PropertyEditorResourceElementEvent event) {
        long componentID = event.getComponentID();
        String propertyName = event.getPropertyName();
        PropertyValue propertyValue = event.getPropertyValue();
        PropertyEditorResourceElement.DesignComponentWrapper wrapper = null;
        for (String key : this.wrappersMap.keySet()) {
            wrapper = this.wrappersMap.get(key);
            if (wrapper.getComponentID() != componentID) continue;
            wrapper.setChangeRecord(propertyName, propertyValue);
            this.changedComponents.add(key);
            this.componentsList.invalidate();
            this.componentsList.validate();
            this.componentsList.repaint();
            break;
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object selectedName = this.getSelectedComponentName();
        DefaultListModel model = (DefaultListModel)this.componentsList.getModel();
        if (ACTION_ADD_RESOURCE.equals(e.getActionCommand())) {
            String name = this.getNewComponentName();
            PropertyEditorResourceElement.DesignComponentWrapper virtualComponent = new PropertyEditorResourceElement.DesignComponentWrapper(componentIDCounter++, this.element.getTypeID());
            this.wrappersMap.put(name, virtualComponent);
            model.addElement(name);
            this.sortAndSelect(name);
            this.changedComponents.add(name);
        } else if (ACTION_REMOVE_RESOURCE.equals(e.getActionCommand()) && selectedName != null && !this.noneComponentAsText.equals(selectedName)) {
            this.wrappersMap.get(selectedName).deleteComponent();
            int index = model.indexOf(selectedName);
            model.removeElement(selectedName);
            this.componentsList.setSelectedIndex(index - 1);
        }
    }

    private String getNewComponentName() {
        String name;
        String base = this.element.getResourceNameSuggestion();
        Set<String> existingKeys = this.wrappersMap.keySet();
        HashSet<String> toBeDeleted = new HashSet<String>();
        for (String key : this.wrappersMap.keySet()) {
            if (!this.wrappersMap.get(key).isDeleted()) continue;
            toBeDeleted.add(key);
        }
        for (String key : toBeDeleted) {
            this.wrappersMap.remove(key);
        }
        int i = 1;
        while (existingKeys.contains(name = base + i)) {
            ++i;
        }
        return name;
    }

    private Object getSelectedComponentName() {
        return this.componentsList.getSelectedValue();
    }

    String getTextForPropertyValue() {
        String str = (String)this.componentsList.getSelectedValue();
        return str != null ? str : "";
    }

    boolean wasAnyDesignComponentChanged() {
        for (String key : this.wrappersMap.keySet()) {
            if (!this.wrappersMap.get(key).hasChanges()) continue;
            return true;
        }
        return false;
    }

    Map<String, PropertyEditorResourceElement.DesignComponentWrapper> getWrappersMap() {
        return Collections.unmodifiableMap(this.wrappersMap);
    }

    boolean needsUpdate() {
        return true;
    }

    @Override
    public void goToSource() {
        PropertyEditorResourceElement.DesignComponentWrapper wrapper = this.wrappersMap.get(this.getSelectedComponentName());
        if (wrapper != null && wrapper.getComponent() != null) {
            GoToSourceSupport.goToSourceOfComponent(wrapper.getComponent());
        }
    }

    @Override
    public void resetUserCode() {
        PropertyEditorResourceElement.DesignComponentWrapper wrapper = this.wrappersMap.get(this.getSelectedComponentName());
        if (wrapper != null && wrapper.getComponent() != null) {
            final DesignComponent component = wrapper.getComponent();
            component.getDocument().getTransactionManager().writeAccess(new Runnable(){

                @Override
                public void run() {
                    List<String> propertyNames = ResourceEditorPanel.this.element.getPropertyValueNames();
                    for (String propertyName : propertyNames) {
                        PropertyValue pv = component.readProperty(propertyName);
                        if (!PropertyValue.Kind.USERCODE.equals((Object)pv.getKind())) continue;
                        component.writeProperty(propertyName, component.getComponentDescriptor().getPropertyDescriptor(propertyName).getDefaultValue());
                    }
                }
            });
            this.setUserCode(this.isUserCodeInside(wrapper));
        }
    }

    private class ComponentsListRenderer
    extends DefaultListCellRenderer {
        private Font changedFont;
        private Font defaultFont;

        private ComponentsListRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (this.defaultFont == null) {
                this.defaultFont = renderer.getFont();
                this.changedFont = this.defaultFont.deriveFont(1);
            }
            if (!ResourceEditorPanel.this.noneComponentAsText.equals(value) && ResourceEditorPanel.this.icon != null) {
                renderer.setIcon(ResourceEditorPanel.this.icon);
            }
            renderer.setFont(ResourceEditorPanel.this.changedComponents.contains(value) ? this.changedFont : this.defaultFont);
            return renderer;
        }
    }
}

