/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.api.xml.services.UserCatalog;
import org.netbeans.modules.web.jsf.editor.facelets.DefaultFaceletLibraries;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptorException;
import org.openide.filesystems.FileObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FaceletsLibraryDescriptor
extends LibraryDescriptor {
    static FaceletsLibraryDescriptor create(FileObject definitionFile) throws LibraryDescriptorException {
        return new FaceletsLibraryDescriptor(definitionFile);
    }

    static FaceletsLibraryDescriptor create(InputStream content) throws LibraryDescriptorException {
        return new FaceletsLibraryDescriptor(content);
    }

    private FaceletsLibraryDescriptor(FileObject definitionFile) throws LibraryDescriptorException {
        super(definitionFile);
        this.parseLibrary();
    }

    private FaceletsLibraryDescriptor(InputStream content) throws LibraryDescriptorException {
        super(content);
        this.parseLibrary(content);
    }

    @Override
    public String getDefaultPrefix() {
        return DefaultFaceletLibraries.getLibraryDefaultPrefix(this.getURI());
    }

    @Override
    public String getDisplayName() {
        return DefaultFaceletLibraries.getLibraryDisplayName(this.getURI());
    }

    public static String parseNamespace(InputStream content) {
        return FaceletsLibraryDescriptor.parseNamespace(content, "facelet-taglib", "namespace");
    }

    @Override
    protected void parseLibrary(InputStream content) throws LibraryDescriptorException {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            InputSource is = new InputSource(content);
            docBuilder.setEntityResolver(UserCatalog.getDefault().getEntityResolver());
            Document doc = docBuilder.parse(is);
            Node tagLib = FaceletsLibraryDescriptor.getNodeByName(doc, "facelet-taglib");
            this.uri = FaceletsLibraryDescriptor.getTextContent(tagLib, "namespace");
            if (this.uri == null) {
                throw new IllegalStateException("Missing namespace entry in " + this.getDefinitionFile().getPath() + " library.", null);
            }
            NodeList tagNodes = doc.getElementsByTagName("tag");
            if (tagNodes != null) {
                for (int i = 0; i < tagNodes.getLength(); ++i) {
                    Node tag = tagNodes.item(i);
                    String tagName = FaceletsLibraryDescriptor.getTextContent(tag, "tag-name");
                    String tagDescription = FaceletsLibraryDescriptor.getTextContent(tag, "description");
                    HashMap<String, LibraryDescriptor.Attribute> attrs = new HashMap<String, LibraryDescriptor.Attribute>();
                    for (Node attrNode : FaceletsLibraryDescriptor.getNodesByName(tag, "attribute")) {
                        String aName = FaceletsLibraryDescriptor.getTextContent(attrNode, "name");
                        String aDescription = FaceletsLibraryDescriptor.getTextContent(attrNode, "description");
                        boolean aRequired = Boolean.parseBoolean(FaceletsLibraryDescriptor.getTextContent(attrNode, "required"));
                        attrs.put(aName, new LibraryDescriptor.Attribute(aName, aDescription, aRequired));
                    }
                    this.tags.put(tagName, new LibraryDescriptor.TagImpl(tagName, tagDescription, attrs));
                }
            }
        }
        catch (ParserConfigurationException ex) {
            throw new LibraryDescriptorException("Error parsing facelets library: ", ex);
        }
        catch (SAXException ex) {
            throw new LibraryDescriptorException("Error parsing facelets library: ", ex);
        }
        catch (IOException ex) {
            throw new LibraryDescriptorException("Error parsing facelets library: ", ex);
        }
    }
}

