/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.screen;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.model.AccessController;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.presenters.InfoPresenter;
import org.netbeans.modules.vmd.api.screen.display.ScreenDeviceInfoPresenter;
import org.netbeans.modules.vmd.api.screen.editor.EditedScreenSupport;
import org.netbeans.modules.vmd.screen.MainPanel;
import org.netbeans.modules.vmd.screen.device.DevicePanel;
import org.netbeans.modules.vmd.screen.resource.ResourcePanel;

public final class ScreenAccessController
implements AccessController,
EditedScreenSupport.Listener {
    private final DesignDocument document;
    private JPanel mainPanel;
    private DevicePanel devicePanel;
    private final ResourcePanel resourcePanel;
    private final JComboBox editedScreenCombo;
    private final ActionListener editedScreenComboListener;
    private DesignComponent editedScreen;
    private List<DesignComponent> allEditableScreens = Collections.emptyList();

    public ScreenAccessController(final DesignDocument document) {
        this.document = document;
        this.resourcePanel = new ResourcePanel(this);
        this.editedScreenCombo = new JComboBox();
        this.editedScreenCombo.setRenderer(new EditedComboRenderer());
        this.editedScreenComboListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                document.getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        DesignComponent component = (DesignComponent)ScreenAccessController.this.editedScreenCombo.getSelectedItem();
                        EditedScreenSupport.getSupportForDocument(document).setEditedScreenComponentID(component != null ? component.getComponentID() : -1L);
                    }
                });
            }
        };
        this.editedScreenCombo.addActionListener(this.editedScreenComboListener);
        EditedScreenSupport.getSupportForDocument(document).addListener(this);
    }

    @Override
    public void editedScreenChanged(long editedScreenComponentID) {
        this.editedScreen = this.document.getComponentByUID(EditedScreenSupport.getSupportForDocument(this.document).getEditedScreenComponentID());
        this.editedScreenCombo.removeActionListener(this.editedScreenComboListener);
        this.editedScreenCombo.setSelectedItem(this.editedScreen);
        this.editedScreenCombo.addActionListener(this.editedScreenComboListener);
        this.refreshPanels();
    }

    public void writeAccess(Runnable runnable) {
        runnable.run();
    }

    public void notifyEventFiring(DesignEvent event) {
    }

    public void notifyEventFired(DesignEvent event) {
        if (!this.isDeviceInfoExists()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ScreenAccessController.this.document.getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        ScreenAccessController.this.refreshModel();
                    }
                });
            }
        });
    }

    private void refreshModel() {
        if (this.devicePanel == null) {
            this.devicePanel = new DevicePanel(this);
            this.mainPanel = new MainPanel(this.devicePanel, this.resourcePanel);
        }
        this.allEditableScreens = EditedScreenSupport.getAllEditableScreensInDocument(this.document);
        this.editedScreenCombo.removeActionListener(this.editedScreenComboListener);
        this.editedScreenCombo.setModel(new DefaultComboBoxModel<Object>(this.allEditableScreens.toArray()));
        if (!this.allEditableScreens.contains(this.editedScreen)) {
            this.editedScreen = null;
        }
        this.editedScreenCombo.setSelectedItem(this.editedScreen);
        this.editedScreenCombo.addActionListener(this.editedScreenComboListener);
        if (this.editedScreen == null && this.allEditableScreens.size() > 0) {
            this.editedScreen = this.allEditableScreens.get(0);
            EditedScreenSupport.getSupportForDocument(this.document).setEditedScreenComponentID(this.editedScreen.getComponentID());
            return;
        }
        this.refreshPanels();
    }

    public void refreshPanels() {
        if (this.devicePanel == null) {
            return;
        }
        this.devicePanel.reload();
        this.resourcePanel.reload();
        this.mainPanel.validate();
    }

    public void notifyComponentsCreated(Collection<DesignComponent> createdComponents) {
    }

    void showNotify() {
    }

    void hideNotify() {
    }

    JComponent getMainPanel() {
        return this.mainPanel;
    }

    JComponent getToolBar() {
        return this.editedScreenCombo;
    }

    public DesignDocument getDocument() {
        return this.document;
    }

    public DesignComponent getEditedScreen() {
        assert (SwingUtilities.isEventDispatchThread());
        assert (this.document.getTransactionManager().isAccess());
        return this.editedScreen;
    }

    public void setScreenSize(Dimension deviceScreenSize) {
        if (this.devicePanel != null) {
            this.devicePanel.setScreenSize(deviceScreenSize);
        }
    }

    private boolean isDeviceInfoExists() {
        DesignComponent rootComponent = this.document.getRootComponent();
        if (rootComponent == null) {
            return false;
        }
        ScreenDeviceInfoPresenter presenter = (ScreenDeviceInfoPresenter)rootComponent.getPresenter(ScreenDeviceInfoPresenter.class);
        return presenter != null && presenter.getScreenDeviceInfo() != null;
    }

    private class EditedComboRenderer
    extends DefaultListCellRenderer {
        private EditedComboRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            final Image[] image = new Image[1];
            final String[] label = new String[1];
            if (value != null) {
                final DesignComponent dc = (DesignComponent)value;
                ScreenAccessController.this.document.getTransactionManager().readAccess(new Runnable(){

                    @Override
                    public void run() {
                        InfoPresenter presenter = (InfoPresenter)dc.getPresenter(InfoPresenter.class);
                        label[0] = presenter.getDisplayName(InfoPresenter.NameType.PRIMARY);
                        image[0] = presenter.getIcon(InfoPresenter.IconType.COLOR_16x16);
                    }
                });
            }
            super.getListCellRendererComponent((JList<?>)list, label[0], index, isSelected, cellHasFocus);
            if (image[0] != null) {
                this.setIcon(new ImageIcon(image[0]));
            }
            return this;
        }
    }
}

