/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.verification.rules.entity;

import java.util.ArrayList;
import java.util.Arrays;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.netbeans.modules.j2ee.jpa.model.AccessType;
import org.netbeans.modules.j2ee.jpa.model.JPAAnnotations;
import org.netbeans.modules.j2ee.jpa.model.ModelUtils;
import org.netbeans.modules.j2ee.jpa.verification.JPAClassRule;
import org.netbeans.modules.j2ee.jpa.verification.JPAProblemContext;
import org.netbeans.modules.j2ee.jpa.verification.common.ProblemContext;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class JPAAnnotsOnlyOnAccesor
extends JPAClassRule {
    public JPAAnnotsOnlyOnAccesor() {
        this.setClassContraints(Arrays.asList(JPAClassRule.ClassConstraints.ENTITY, JPAClassRule.ClassConstraints.EMBEDDABLE, JPAClassRule.ClassConstraints.MAPPED_SUPERCLASS));
    }

    @Override
    public ErrorDescription[] apply(TypeElement typeElement, ProblemContext problemContext) {
        if (((JPAProblemContext)problemContext).getAccessType() != AccessType.PROPERTY) {
            return null;
        }
        ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
        block0: for (ExecutableElement executableElement : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (this.isAccessor(executableElement)) continue;
            for (String string : ModelUtils.extractAnnotationNames(executableElement)) {
                if (!JPAAnnotations.MEMBER_LEVEL.contains(string)) continue;
                ErrorDescription errorDescription = JPAAnnotsOnlyOnAccesor.createProblem(executableElement, problemContext, NbBundle.getMessage(JPAAnnotsOnlyOnAccesor.class, (String)"MSG_JPAAnnotsOnlyOnAccesor", (Object)ModelUtils.shortAnnotationName(string)));
                arrayList.add(errorDescription);
                continue block0;
            }
        }
        return arrayList.toArray(new ErrorDescription[arrayList.size()]);
    }

    private boolean isAccessor(ExecutableElement executableElement) {
        if (!executableElement.getParameters().isEmpty()) {
            return false;
        }
        String string = executableElement.getSimpleName().toString();
        if (string.startsWith("get")) {
            return true;
        }
        return this.isBoolean(((Object)executableElement.getReturnType()).toString()) && string.startsWith("is");
    }

    private boolean isBoolean(String string) {
        return "boolean".equals(string) || "java.lang.Boolean".equals(string);
    }
}

