/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.model.RefValues;
import com.sun.perseus.model.Segment;
import com.sun.perseus.model.TransformSegment;

public class TransformRefValues
implements RefValues {
    TransformSegment[] segments;
    float[][] w;
    float length;
    float[] segLength;

    public Segment getSegment(int i) {
        return this.segments[i];
    }

    public int getSegments() {
        return this.segments.length;
    }

    public int getComponents() {
        return 6;
    }

    public Object[] compute(int si, float p) {
        this.segments[si].compute(p, this.w);
        return this.w;
    }

    public void makeDiscrete() {
        TransformSegment[] tmpSegments = new TransformSegment[this.segments.length + 1];
        System.arraycopy(this.segments, 0, tmpSegments, 0, this.segments.length);
        TransformSegment lastSeg = this.segments[this.segments.length - 1];
        TransformSegment newSeg = new TransformSegment();
        newSeg.start = lastSeg.end;
        newSeg.end = lastSeg.end;
        newSeg.type = lastSeg.type;
        tmpSegments[tmpSegments.length - 1] = newSeg;
        this.segments = tmpSegments;
    }

    public float getLength() {
        return this.length;
    }

    public float getLength(int si) {
        return this.segLength[si];
    }

    public void initialize() {
        int si;
        int nc = 6;
        this.w = new float[6][];
        int ns = this.segments.length;
        for (si = 0; si < ns; ++si) {
            this.segments[si].initialize();
        }
        this.length = 0.0f;
        this.segLength = new float[ns];
        for (int ci = 0; ci < 6; ++ci) {
            this.w[ci] = new float[1];
        }
        for (si = 0; si < ns; ++si) {
            this.segLength[si] = this.segments[si].getLength();
            this.length += this.segLength[si];
        }
    }
}

