/*
 * Decompiled with CFR 0.152.
 */
package com.sun.perseus.model;

import com.sun.perseus.j2d.PaintDef;
import com.sun.perseus.j2d.RGB;
import com.sun.perseus.model.DocumentNode;
import com.sun.perseus.model.ElementNode;
import com.sun.perseus.model.FloatTraitAnim;
import com.sun.perseus.model.PaintElement;
import com.sun.perseus.model.TraitAnim;
import org.w3c.dom.DOMException;
import org.w3c.dom.svg.SVGRGBColor;

public class SolidColor
extends PaintElement {
    static final String[] REQUIRED_TRAITS = new String[]{"solid-color"};
    static final RGB DEFAULT_SOLID_COLOR = RGB.black;
    static final float DEFAULT_SOLID_OPACITY = 1.0f;
    RGB solidColor = DEFAULT_SOLID_COLOR;
    float solidOpacity = 1.0f;
    RGB compoundColor = DEFAULT_SOLID_COLOR;

    public SolidColor(DocumentNode ownerDocument) {
        super(ownerDocument);
        this.isObjectBBox = false;
    }

    public String getLocalName() {
        return "solidColor";
    }

    public ElementNode newInstance(DocumentNode doc) {
        return new SolidColor(doc);
    }

    public void setSolidColor(RGB newSolidColor) {
        if (this.solidColor.equals(newSolidColor)) {
            return;
        }
        this.solidColor = newSolidColor;
        this.onPaintChange();
    }

    public void setSolidOpacity(float newSolidOpacity) {
        if (newSolidOpacity == this.solidOpacity) {
            return;
        }
        this.solidOpacity = newSolidOpacity;
        if (this.solidOpacity < 0.0f) {
            this.solidOpacity = 0.0f;
        } else if (this.solidOpacity > 1.0f) {
            this.solidOpacity = 1.0f;
        }
        this.onPaintChange();
    }

    void onPaintChange() {
        this.compoundColor = null;
        this.notifyPaintChange();
    }

    protected PaintDef computePaint() {
        if (this.compoundColor == null) {
            this.compoundColor = new RGB((int)(this.solidOpacity * 255.0f), this.solidColor.getRed(), this.solidColor.getGreen(), this.solidColor.getBlue());
        }
        return this.compoundColor;
    }

    boolean supportsTrait(String traitName) {
        if ("solid-color" == traitName || "solid-opacity" == traitName) {
            return true;
        }
        return super.supportsTrait(traitName);
    }

    public String[] getRequiredTraits() {
        return REQUIRED_TRAITS;
    }

    TraitAnim createTraitAnimImpl(String traitName) {
        if ("solid-opacity" == traitName) {
            return new FloatTraitAnim(this, traitName, "float");
        }
        if ("solid-color" == traitName) {
            return new FloatTraitAnim(this, traitName, "SVGRGBColor");
        }
        return super.createTraitAnimImpl(traitName);
    }

    public String getTraitImpl(String name) throws DOMException {
        if ("solid-color" == name) {
            return this.solidColor.toString();
        }
        if ("solid-opacity" == name) {
            return Float.toString(this.solidOpacity);
        }
        return super.getTraitImpl(name);
    }

    float getFloatTraitImpl(String name) throws DOMException {
        if ("solid-opacity" == name) {
            return this.solidOpacity;
        }
        return super.getFloatTraitImpl(name);
    }

    SVGRGBColor getRGBColorTraitImpl(String name) throws DOMException {
        if ("solid-color".equals(name)) {
            return this.solidColor;
        }
        return super.getRGBColorTraitImpl(name);
    }

    void setFloatArrayTrait(String name, float[][] value) throws DOMException {
        if ("solid-color" == name) {
            this.setSolidColor(new RGB((int)value[0][0], (int)value[0][1], (int)value[0][2]));
        } else if ("solid-opacity" == name) {
            this.setSolidOpacity(value[0][0]);
        } else {
            super.setFloatArrayTrait(name, value);
        }
    }

    public float[][] validateFloatArrayTrait(String traitName, String value, String reqNamespaceURI, String reqLocalName, String reqTraitNamespace, String reqTraitName) throws DOMException {
        if ("solid-color" == traitName) {
            RGB color = DEFAULT_SOLID_COLOR;
            if (!"inherit".equals(value)) {
                color = this.parseColorTrait("color", value);
            }
            if (color == null) {
                throw this.illegalTraitValue(traitName, value);
            }
            return new float[][]{{color.getRed(), color.getGreen(), color.getBlue()}};
        }
        if ("solid-opacity" == traitName) {
            float so = 1.0f;
            if (!"inherit".equals(value)) {
                so = this.parseFloatTrait(traitName, value);
            }
            if (so < 0.0f) {
                so = 0.0f;
            } else if (so > 1.0f) {
                so = 1.0f;
            }
            return new float[][]{{so}};
        }
        return super.validateFloatArrayTrait(traitName, value, reqNamespaceURI, reqLocalName, reqTraitNamespace, reqTraitName);
    }

    public void setTraitImpl(String name, String value) throws DOMException {
        if ("solid-opacity" == name) {
            if ("inherit".equals(value)) {
                this.setSolidOpacity(1.0f);
            } else {
                this.setSolidOpacity(this.parseFloatTrait(name, value));
            }
        } else if ("solid-color" == name) {
            if ("inherit".equals(value)) {
                this.setSolidColor(DEFAULT_SOLID_COLOR);
            } else {
                this.setSolidColor(this.parseColorTrait("solid-color", value));
            }
        } else {
            super.setTraitImpl(name, value);
        }
    }

    public void setFloatTraitImpl(String name, float value) throws DOMException {
        if ("solid-opacity" == name) {
            this.setSolidOpacity(value);
        } else {
            super.setFloatTraitImpl(name, value);
        }
    }

    String toStringTrait(String name, float[][] value) {
        if ("solid-opacity" == name) {
            return Float.toString(value[0][0]);
        }
        if ("solid-color" == name) {
            return this.toRGBString(name, value);
        }
        return super.toStringTrait(name, value);
    }

    void setRGBColorTraitImpl(String name, SVGRGBColor color) throws DOMException {
        try {
            if ("solid-color".equals(name)) {
                this.setSolidColor((RGB)color);
            } else {
                super.setRGBColorTraitImpl(name, color);
            }
        }
        catch (IllegalArgumentException iae) {
            throw new DOMException(15, iae.getMessage());
        }
    }
}

