/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.impl;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.keyring.Keyring;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class MySQLOptions {
    private String adminPassword;
    private static final Logger LOGGER = Logger.getLogger(MySQLOptions.class.getName());
    private static final MySQLOptions DEFAULT = new MySQLOptions();
    public static final String PROP_MYSQL_LOCATION = "location";
    public static final String PROP_HOST = "host";
    public static final String PROP_PORT = "port";
    public static final String PROP_ADMINUSER = "adminuser";
    public static final String PROP_ADMINPWD = "adminpwd";
    public static final String PROP_SAVEPWD = "savepwd";
    public static final String PROP_DBDIR = "dbdir";
    public static final String PROP_CONN_REGISTERED = "conn-registered";
    public static final String PROP_PROVIDER_REGISTERED = "provider-registered";
    public static final String PROP_PROVIDER_REMOVED = "provider-removed";
    public static final String PROP_ADMIN_PATH = "admin-path";
    public static final String PROP_START_PATH = "start-path";
    public static final String PROP_STOP_PATH = "stop-path";
    public static final String PROP_ADMIN_ARGS = "admin-args";
    public static final String PROP_START_ARGS = "start-args";
    public static final String PROP_STOP_ARGS = "stop-args";
    public static final String PROP_CONNECT_TIMEOUT = "connect-timeout";
    public static final String PROP_REFRESH_THREAD_SLEEP_INTERVAL = "refresh-thread-sleep-interval";
    private static final String DRIVER_CLASS = "com.mysql.jdbc.Driver";
    private static final String DEFAULT_PORT = "3306";
    private static final String DEFAULT_HOST = "localhost";
    private static final String DEFAULT_ADMIN_USER = "root";
    private static final String DEFAULT_ADMIN_PASSWORD = "";
    private static final String DEFAULT_CONNECT_TIMEOUT = "5000";
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public static MySQLOptions getDefault() {
        return DEFAULT;
    }

    private MySQLOptions() {
        if (Utils.isEmpty(this.getConnectTimeout())) {
            this.setConnectTimeout(DEFAULT_CONNECT_TIMEOUT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void putProperty(String key, String value) {
        String oldval;
        MySQLOptions mySQLOptions = this;
        synchronized (mySQLOptions) {
            oldval = this.getProperty(key);
            if (value != null) {
                NbPreferences.forModule(MySQLOptions.class).put(key, value);
            } else {
                NbPreferences.forModule(MySQLOptions.class).remove(key);
            }
        }
        this.notifyPropertyChange(key, oldval, value);
    }

    protected final void putProperty(String key, boolean value) {
        boolean oldval = this.getBooleanProperty(key);
        NbPreferences.forModule(MySQLOptions.class).putBoolean(key, value);
        this.notifyPropertyChange(key, oldval, value);
    }

    protected final void putProperty(String key, long value, long def) {
        long oldval = this.getLongProperty(key, def);
        NbPreferences.forModule(MySQLOptions.class).putLong(key, value);
        this.notifyPropertyChange(key, oldval, value);
    }

    protected final void clearProperty(String key) {
        String oldval = this.getProperty(key);
        NbPreferences.forModule(MySQLOptions.class).remove(key);
        this.notifyPropertyChange(key, oldval, null);
    }

    protected final String getProperty(String key) {
        return NbPreferences.forModule(MySQLOptions.class).get(key, DEFAULT_ADMIN_PASSWORD);
    }

    protected final boolean getBooleanProperty(String key) {
        return NbPreferences.forModule(MySQLOptions.class).getBoolean(key, false);
    }

    protected final long getLongProperty(String key, long def) {
        return NbPreferences.forModule(MySQLOptions.class).getLong(key, def);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
    }

    private void notifyPropertyChange(String key, Object oldval, Object newval) {
        PropertyChangeEvent event = new PropertyChangeEvent(this, key, oldval, newval);
        this.pcs.firePropertyChange(event);
    }

    public String getHost() {
        return this.getProperty(PROP_HOST);
    }

    public void setHost(String host) {
        this.putProperty(PROP_HOST, host);
    }

    public String getPort() {
        return this.getProperty(PROP_PORT);
    }

    public void setPort(String port) {
        this.putProperty(PROP_PORT, port);
    }

    public String getAdminUser() {
        return this.getProperty(PROP_ADMINUSER);
    }

    public void setAdminUser(String adminUser) {
        this.putProperty(PROP_ADMINUSER, adminUser);
    }

    public synchronized String getAdminPassword() {
        String pwd = NbPreferences.forModule(MySQLOptions.class).get(PROP_ADMINPWD, null);
        if (pwd != null) {
            Keyring.save((String)MySQLOptions.class.getName(), (char[])pwd.toCharArray(), (String)NbBundle.getMessage(MySQLOptions.class, (String)"MySQLOptions_AdminPassword"));
        }
        if (this.isSavePassword()) {
            LOGGER.log(Level.FINE, "Reading a Admin Password from Keyring.");
            char[] chars = Keyring.read((String)MySQLOptions.class.getName());
            return chars == null ? DEFAULT_ADMIN_PASSWORD : String.copyValueOf(chars);
        }
        return this.adminPassword;
    }

    public synchronized void setAdminPassword(String adminPassword) {
        if (adminPassword == null) {
            adminPassword = DEFAULT_ADMIN_PASSWORD;
        }
        this.adminPassword = adminPassword;
        if (this.isSavePassword()) {
            LOGGER.log(Level.FINE, "Storing a Admin Password to Keyring.");
            Keyring.save((String)MySQLOptions.class.getName(), (char[])adminPassword.toCharArray(), (String)NbBundle.getMessage(MySQLOptions.class, (String)"MySQLOptions_AdminPassword"));
        } else {
            LOGGER.log(Level.FINE, "Removing a Admin Password from Keyring.");
            Keyring.delete((String)MySQLOptions.class.getName());
        }
    }

    public void clearAdminPassword() {
        this.clearProperty(PROP_ADMINPWD);
    }

    public boolean isSavePassword() {
        return this.getBooleanProperty(PROP_SAVEPWD);
    }

    public void setSavePassword(boolean savePassword) {
        this.putProperty(PROP_SAVEPWD, savePassword);
        if (!savePassword) {
            this.clearAdminPassword();
        } else {
            this.putProperty(PROP_ADMINPWD, this.adminPassword);
        }
    }

    public void setConnectionRegistered(boolean registered) {
        this.putProperty(PROP_CONN_REGISTERED, registered);
    }

    public boolean isConnectionRegistered() {
        return this.getBooleanProperty(PROP_CONN_REGISTERED);
    }

    public void setProviderRegistered(boolean registered) {
        if (this.isProviderRegistered() && !registered) {
            this.setProviderRemoved(true);
        } else if (registered) {
            this.setProviderRemoved(false);
        }
        this.putProperty(PROP_PROVIDER_REGISTERED, registered);
    }

    public boolean isProviderRegistered() {
        return this.getBooleanProperty(PROP_PROVIDER_REGISTERED);
    }

    private void setProviderRemoved(boolean removed) {
        this.putProperty(PROP_PROVIDER_REMOVED, removed);
    }

    public boolean isProviderRemoved() {
        return this.getBooleanProperty(PROP_PROVIDER_REMOVED);
    }

    public String getStartPath() {
        return this.getProperty(PROP_START_PATH);
    }

    public void setStartPath(String path) {
        this.putProperty(PROP_START_PATH, path);
    }

    public String getStartArgs() {
        return this.getProperty(PROP_START_ARGS);
    }

    public void setStartArgs(String args) {
        this.putProperty(PROP_START_ARGS, args);
    }

    public String getStopPath() {
        return this.getProperty(PROP_STOP_PATH);
    }

    public void setStopPath(String path) {
        this.putProperty(PROP_STOP_PATH, path);
    }

    public String getStopArgs() {
        return this.getProperty(PROP_STOP_ARGS);
    }

    public void setStopArgs(String args) {
        this.putProperty(PROP_STOP_ARGS, args);
    }

    public String getAdminPath() {
        return this.getProperty(PROP_ADMIN_PATH);
    }

    public void setAdminPath(String path) {
        this.putProperty(PROP_ADMIN_PATH, path);
    }

    public String getAdminArgs() {
        return this.getProperty(PROP_ADMIN_ARGS);
    }

    public void setAdminArgs(String args) {
        this.putProperty(PROP_ADMIN_ARGS, args);
    }

    public String getConnectTimeout() {
        return this.getProperty(PROP_CONNECT_TIMEOUT);
    }

    public void setConnectTimeout(String timeout) {
        this.putProperty(PROP_CONNECT_TIMEOUT, timeout);
    }

    public static String getDriverClass() {
        return DRIVER_CLASS;
    }

    public static String getDefaultPort() {
        return DEFAULT_PORT;
    }

    public static String getDefaultAdminPassword() {
        return DEFAULT_ADMIN_PASSWORD;
    }

    public static String getDefaultAdminUser() {
        return DEFAULT_ADMIN_USER;
    }

    public static String getDefaultHost() {
        return DEFAULT_HOST;
    }
}

