/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.form.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import org.netbeans.modules.form.FormDesigner;
import org.netbeans.modules.form.FormEditor;
import org.netbeans.modules.form.FormModel;
import org.netbeans.modules.form.FormUtils;
import org.netbeans.modules.form.RADComponent;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;

public class SetResizabilityAction
extends NodeAction {
    private JCheckBoxMenuItem[] items;
    private ActionListener menuItemListener;

    protected boolean enable(Node[] nodeArray) {
        List<RADComponent> list = FormUtils.getSelectedLayoutComponents(nodeArray);
        return list != null && list.size() > 0;
    }

    public String getName() {
        return NbBundle.getMessage(SetResizabilityAction.class, (String)"ACT_SetResizability");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected void performAction(Node[] nodeArray) {
    }

    public JMenuItem getMenuPresenter() {
        return this.getPopupPresenter();
    }

    public JMenuItem getPopupPresenter() {
        JMenu jMenu = new JMenu(NbBundle.getMessage(SetResizabilityAction.class, (String)"ACT_SetResizability"));
        jMenu.setEnabled(this.isEnabled());
        HelpCtx.setHelpIDString((JComponent)jMenu, (String)SetResizabilityAction.class.getName());
        jMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent menuEvent) {
                JMenu jMenu = (JMenu)menuEvent.getSource();
                SetResizabilityAction.this.createResizabilitySubmenu(jMenu);
            }

            @Override
            public void menuDeselected(MenuEvent menuEvent) {
            }

            @Override
            public void menuCanceled(MenuEvent menuEvent) {
            }
        });
        return jMenu;
    }

    private void createResizabilitySubmenu(JMenu jMenu) {
        Node[] nodeArray = this.getActivatedNodes();
        List<RADComponent> list = FormUtils.getSelectedLayoutComponents(nodeArray);
        if (list == null || list.size() < 1) {
            return;
        }
        if (jMenu.getMenuComponentCount() <= 0) {
            ResourceBundle resourceBundle = NbBundle.getBundle(SetResizabilityAction.class);
            ResizabilityMenuItem resizabilityMenuItem = new ResizabilityMenuItem(resourceBundle.getString("CTL_ResizabilityH"), list, 0);
            ResizabilityMenuItem resizabilityMenuItem2 = new ResizabilityMenuItem(resourceBundle.getString("CTL_ResizabilityV"), list, 1);
            this.items = new JCheckBoxMenuItem[]{resizabilityMenuItem, resizabilityMenuItem2};
            for (int i = 0; i < 2; ++i) {
                this.items[i].addActionListener(this.getMenuItemListener());
                HelpCtx.setHelpIDString((JComponent)this.items[i], (String)SetResizabilityAction.class.getName());
                jMenu.add(this.items[i]);
            }
        }
        this.updateState(list);
    }

    private void updateState(List list) {
        if (list == null || list.size() < 1) {
            return;
        }
        RADComponent rADComponent = (RADComponent)list.get(0);
        FormDesigner formDesigner = FormEditor.getFormDesigner(rADComponent.getFormModel());
        formDesigner.updateResizabilityActions();
        for (int i = 0; i < 2; ++i) {
            this.items[i].setEnabled(formDesigner.getResizabilityButtons()[i].isEnabled());
            this.items[i].setSelected(formDesigner.getResizabilityButtons()[i].isSelected());
        }
    }

    private ActionListener getMenuItemListener() {
        if (this.menuItemListener == null) {
            this.menuItemListener = new ResizabilityMenuItemListener();
        }
        return this.menuItemListener;
    }

    private static class ResizabilityMenuItemListener
    implements ActionListener {
        private ResizabilityMenuItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (!(object instanceof ResizabilityMenuItem)) {
                return;
            }
            ResizabilityMenuItem resizabilityMenuItem = (ResizabilityMenuItem)object;
            if (!resizabilityMenuItem.isEnabled()) {
                return;
            }
            int n = resizabilityMenuItem.getDirection();
            RADComponent rADComponent = (RADComponent)resizabilityMenuItem.getRADComponents().get(0);
            FormModel formModel = rADComponent.getFormModel();
            FormDesigner formDesigner = FormEditor.getFormDesigner(formModel);
            formDesigner.getResizabilityButtons()[n].setSelected(!formDesigner.getResizabilityButtons()[n].isSelected());
            ((Action)formDesigner.getResizabilityActions().toArray()[n]).actionPerformed(actionEvent);
        }
    }

    private static class ResizabilityMenuItem
    extends JCheckBoxMenuItem {
        private int direction;
        private List components;

        ResizabilityMenuItem(String string, List list, int n) {
            super(string);
            this.components = list;
            this.direction = n;
        }

        int getDirection() {
            return this.direction;
        }

        List getRADComponents() {
            return this.components;
        }
    }
}

