/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.ViewFactory;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.editor.ActionFactory;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.BaseCaret;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseImageTokenID;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.BaseTokenID;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.Formatter;
import org.netbeans.editor.GuardedException;
import org.netbeans.editor.LocalBaseAction;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.MultiKeymap;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.SyntaxSupport;
import org.netbeans.editor.TokenContext;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.hyperlink.HyperlinkOperation;
import org.netbeans.lib.editor.util.ListenerList;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.modules.editor.lib.KitsTracker;
import org.netbeans.modules.editor.lib.NavigationHistory;
import org.netbeans.modules.editor.lib.SettingsConversions;
import org.netbeans.modules.editor.lib2.actions.EditorActionUtilities;
import org.netbeans.modules.editor.lib2.actions.SearchableEditorKit;
import org.netbeans.modules.editor.lib2.highlighting.HighlightingManager;
import org.netbeans.modules.editor.lib2.view.ViewFactoryImpl;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public class BaseKit
extends DefaultEditorKit {
    static ThreadLocal<Boolean> IN_PASTE = new ThreadLocal();
    private static final Logger LOG = Logger.getLogger(BaseKit.class.getName());
    public static final String splitLineAction = "split-line";
    public static final String annotationsCyclingAction = "annotations-cycling";
    public static final String collapseFoldAction = "collapse-fold";
    public static final String expandFoldAction = "expand-fold";
    public static final String collapseAllFoldsAction = "collapse-all-folds";
    public static final String expandAllFoldsAction = "expand-all-folds";
    public static final String selectionPageUpAction = "selection-page-up";
    public static final String selectionPageDownAction = "selection-page-down";
    public static final String removeTabAction = "remove-tab";
    public static final String removeSelectionAction = "remove-selection";
    public static final String abbrevExpandAction = "abbrev-expand";
    public static final String abbrevResetAction = "abbrev-reset";
    public static final String removePreviousWordAction = "remove-word-previous";
    public static final String removeNextWordAction = "remove-word-next";
    public static final String removeLineBeginAction = "remove-line-begin";
    public static final String removeLineAction = "remove-line";
    static final String moveSelectionElseLineUpAction = "move-selection-else-line-up";
    static final String moveSelectionElseLineDownAction = "move-selection-else-line-down";
    static final String copySelectionElseLineUpAction = "copy-selection-else-line-up";
    static final String copySelectionElseLineDownAction = "copy-selection-else-line-down";
    public static final String toggleTypingModeAction = "toggle-typing-mode";
    public static final String toUpperCaseAction = "to-upper-case";
    public static final String toLowerCaseAction = "to-lower-case";
    public static final String switchCaseAction = "switch-case";
    public static final String findNextAction = "find-next";
    public static final String findPreviousAction = "find-previous";
    public static final String toggleHighlightSearchAction = "toggle-highlight-search";
    public static final String findSelectionAction = "find-selection";
    public static final String undoAction = "undo";
    public static final String redoAction = "redo";
    public static final String wordMatchNextAction = "word-match-next";
    public static final String wordMatchPrevAction = "word-match-prev";
    public static final String reindentLineAction = "reindent-line";
    public static final String shiftLineRightAction = "shift-line-right";
    public static final String shiftLineLeftAction = "shift-line-left";
    public static final String adjustWindowCenterAction = "adjust-window-center";
    public static final String adjustWindowTopAction = "adjust-window-top";
    public static final String adjustWindowBottomAction = "adjust-window-bottom";
    public static final String adjustCaretCenterAction = "adjust-caret-center";
    public static final String adjustCaretTopAction = "adjust-caret-top";
    public static final String adjustCaretBottomAction = "adjust-caret-bottom";
    public static final String formatAction = "format";
    public static final String firstNonWhiteAction = "first-non-white";
    public static final String lastNonWhiteAction = "last-non-white";
    public static final String selectionFirstNonWhiteAction = "selection-first-non-white";
    public static final String selectionLastNonWhiteAction = "selection-last-non-white";
    public static final String selectIdentifierAction = "select-identifier";
    public static final String selectNextParameterAction = "select-next-parameter";
    public static final String jumpListNextAction = "jump-list-next";
    public static final String jumpListPrevAction = "jump-list-prev";
    public static final String jumpListNextComponentAction = "jump-list-next-component";
    public static final String jumpListPrevComponentAction = "jump-list-prev-component";
    public static final String scrollUpAction = "scroll-up";
    public static final String scrollDownAction = "scroll-down";
    public static final String macroActionPrefix = "macro-";
    public static final String startMacroRecordingAction = "start-macro-recording";
    public static final String stopMacroRecordingAction = "stop-macro-recording";
    public static final String lineFirstColumnAction = "caret-line-first-column";
    public static final String insertDateTimeAction = "insert-date-time";
    public static final String selectionLineFirstColumnAction = "selection-line-first-column";
    public static final String generateGutterPopupAction = "generate-gutter-popup";
    public static final String toggleLineNumbersAction = "toggle-line-numbers";
    public static final String pasteFormatedAction = "paste-formated";
    public static final String startNewLineAction = "start-new-line";
    public static final String cutToLineBeginAction = "cut-to-line-begin";
    public static final String cutToLineEndAction = "cut-to-line-end";
    public static final String removeTrailingSpacesAction = "remove-trailing-spaces";
    public static final String DOC_REPLACE_SELECTION_PROPERTY = "doc-replace-selection-property";
    private static final int KIT_CNT_PREALLOC = 7;
    static final long serialVersionUID = -8570495408376659348L;
    private static final Map<Class, BaseKit> kits = new HashMap<Class, BaseKit>(7);
    private static final Object KEYMAPS_AND_ACTIONS_LOCK = new String("BaseKit.KEYMAPS_AND_ACTIONS_LOCK");
    private static final Map<MimePath, KeybindingsAndPreferencesTracker> keymapTrackers = new WeakHashMap<MimePath, KeybindingsAndPreferencesTracker>(7);
    private static final Map<MimePath, MultiKeymap> kitKeymaps = new WeakHashMap<MimePath, MultiKeymap>(7);
    private static final Map<MimePath, Action[]> kitActions = new WeakHashMap<MimePath, Action[]>(7);
    private static final Map<MimePath, Map<String, Action>> kitActionMaps = new WeakHashMap<MimePath, Map<String, Action>>(7);
    private static CopyAction copyActionDef = new CopyAction();
    private static CutAction cutActionDef = new CutAction();
    private static PasteAction pasteActionDef = new PasteAction(false);
    private static DeleteCharAction deletePrevCharActionDef = new DeleteCharAction("delete-previous", false);
    private static DeleteCharAction deleteNextCharActionDef = new DeleteCharAction("delete-next", true);
    private static ActionFactory.RemoveSelectionAction removeSelectionActionDef = new ActionFactory.RemoveSelectionAction();
    private static final Action insertTabActionDef = new InsertTabAction();
    private static final Action removeTabActionDef = new ActionFactory.RemoveTabAction();
    private static final Action insertBreakActionDef = new InsertBreakAction();
    private static ActionFactory.UndoAction undoActionDef = new ActionFactory.UndoAction();
    private static ActionFactory.RedoAction redoActionDef = new ActionFactory.RedoAction();
    public static final int MAGIC_POSITION_MAX = 0x7FFFFFFE;
    private final SearchableKit searchableKit;
    static final boolean LINEWRAP_ENABLED;

    private void updateActionSettings(Action[] actions) {
        block2: for (Action a : actions) {
            if (!(a instanceof BaseAction)) continue;
            for (Method m : a.getClass().getDeclaredMethods()) {
                if (!m.getName().equals("settingsChange") || m.getParameterTypes().length != 2 || m.getParameterTypes()[1] != Class.class) continue;
                try {
                    m.setAccessible(true);
                    m.invoke((Object)a, new Object[]{null, this.getClass()});
                }
                catch (Exception e) {
                    LOG.log(Level.FINE, null, e);
                }
                continue block2;
            }
        }
    }

    public static BaseKit getKit(Class kitClass) {
        if (kitClass != null && BaseKit.class.isAssignableFrom(kitClass) && BaseKit.class != kitClass) {
            EditorKit kit;
            String mimeType = KitsTracker.getInstance().findMimeType(kitClass);
            if (mimeType != null && (kit = (EditorKit)MimeLookup.getLookup((MimePath)MimePath.parse((String)mimeType)).lookup(EditorKit.class)) instanceof BaseKit) {
                return (BaseKit)kit;
            }
        } else {
            kitClass = BaseKit.class;
        }
        Map<Class, BaseKit> map = kits;
        synchronized (map) {
            BaseKit kit;
            Class<BaseKit> classToTry = kitClass;
            while ((kit = kits.get(classToTry)) == null) {
                try {
                    kit = (BaseKit)classToTry.newInstance();
                    kits.put(classToTry, kit);
                    return kit;
                }
                catch (IllegalAccessException e) {
                    LOG.log(Level.WARNING, "Can't instantiate editor kit from: " + classToTry, e);
                }
                catch (InstantiationException e) {
                    LOG.log(Level.WARNING, "Can't instantiate editor kit from: " + classToTry, e);
                }
                if (classToTry != BaseKit.class) {
                    classToTry = BaseKit.class;
                    continue;
                }
                throw new IllegalStateException("Can't create editor kit for: " + kitClass);
            }
            return kit;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BaseKit() {
        Map<Class, BaseKit> map = kits;
        synchronized (map) {
            if (kits.get(this.getClass()) == null) {
                kits.put(this.getClass(), this);
            }
        }
        this.searchableKit = new SearchableKit(this);
        EditorActionUtilities.registerSearchableKit((EditorKit)this, (SearchableEditorKit)this.searchableKit);
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    public ViewFactory getViewFactory() {
        return HighlightingManager.LINEWRAP_ENABLED ? ViewFactoryImpl.INSTANCE : null;
    }

    @Override
    public Caret createCaret() {
        return new BaseCaret();
    }

    @Override
    public Document createDefaultDocument() {
        return new BaseDocument(this.getClass(), true);
    }

    public Syntax createSyntax(Document doc) {
        return new DefaultSyntax();
    }

    public Syntax createFormatSyntax(Document doc) {
        return this.createSyntax(doc);
    }

    public SyntaxSupport createSyntaxSupport(BaseDocument doc) {
        return new SyntaxSupport(doc);
    }

    public Formatter createFormatter() {
        return new Formatter(this.getClass());
    }

    protected BaseTextUI createTextUI() {
        return new BaseTextUI();
    }

    protected EditorUI createEditorUI() {
        return new EditorUI();
    }

    protected EditorUI createPrintEditorUI(BaseDocument doc) {
        return new EditorUI(doc);
    }

    protected EditorUI createPrintEditorUI(BaseDocument doc, boolean usePrintColoringMap, boolean lineNumberEnabled) {
        return new EditorUI(doc, usePrintColoringMap, lineNumberEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MultiKeymap getKeymap() {
        Object object = KEYMAPS_AND_ACTIONS_LOCK;
        synchronized (object) {
            MimePath mimePath = MimePath.parse((String)this.getContentType());
            MultiKeymap km = kitKeymaps.get(mimePath);
            if (km == null) {
                km = new MultiKeymap("Keymap for " + mimePath.getPath());
                KeyBindingSettings kbs = (KeyBindingSettings)MimeLookup.getLookup((MimePath)mimePath).lookup(KeyBindingSettings.class);
                List mkbList = kbs.getKeyBindings();
                ArrayList<MultiKeyBinding> editorMkbList = new ArrayList<MultiKeyBinding>();
                for (org.netbeans.api.editor.settings.MultiKeyBinding mkb : mkbList) {
                    List keyStrokes = mkb.getKeyStrokeList();
                    MultiKeyBinding editorMkb = new MultiKeyBinding(keyStrokes.toArray(new KeyStroke[keyStrokes.size()]), mkb.getActionName());
                    editorMkbList.add(editorMkb);
                }
                km.load(editorMkbList.toArray(new JTextComponent.KeyBinding[editorMkbList.size()]), this.getActionMap());
                km.setDefaultAction(this.getActionMap().get("default-typed"));
                kitKeymaps.put(mimePath, km);
            }
            return km;
        }
    }

    @Override
    public void read(Reader in, Document doc, int pos) throws IOException, BadLocationException {
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).read(in, pos);
        } else {
            super.read(in, doc, pos);
        }
    }

    @Override
    public void write(Writer out, Document doc, int pos, int len) throws IOException, BadLocationException {
        if (doc instanceof BaseDocument) {
            ((BaseDocument)doc).write(out, pos, len);
        } else {
            super.write(out, doc, pos, len);
        }
    }

    public static void addActionsToMap(Map<String, Action> map, Action[] actions, String logActionsType) {
        boolean fineLoggable = LOG.isLoggable(Level.FINE);
        if (fineLoggable) {
            LOG.fine(logActionsType + " start --------------------\n");
        }
        for (int i = 0; i < actions.length; ++i) {
            Action a = actions[i];
            if (a == null) {
                LOG.info("actions[] contains null at index " + i + (i > 0 ? ". Preceding action is " + actions[i - 1] : "."));
                continue;
            }
            String name = (String)a.getValue("Name");
            if (name == null) {
                LOG.info("Null Action.NAME property of action " + a);
                continue;
            }
            if (fineLoggable) {
                String overriding = map.containsKey(name) ? " OVERRIDING\n" : "\n";
                LOG.fine("    " + name + ": " + a + overriding);
            }
            map.put(name, a);
        }
        if (fineLoggable) {
            LOG.fine(logActionsType + " end ----------------------\n");
        }
    }

    public static Action[] mapToActions(Map map) {
        Action[] actions = new Action[map.size()];
        int i = 0;
        Iterator iter = map.values().iterator();
        while (iter.hasNext()) {
            actions[i++] = (Action)iter.next();
        }
        return actions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void install(JEditorPane c) {
        MultiKeymap keymap;
        boolean enableIM;
        assert (SwingUtilities.isEventDispatchThread()) : "BaseKit.install() incorrectly called from non-AWT thread.";
        BaseTextUI ui = this.createTextUI();
        c.setUI(ui);
        String propName = "netbeans.editor.noinputmethods";
        String noInputMethods = System.getProperty(propName);
        if (noInputMethods != null) {
            enableIM = !Boolean.getBoolean(propName);
        } else {
            Preferences prefs = (Preferences)MimeLookup.getLookup((String)this.getContentType()).lookup(Preferences.class);
            enableIM = prefs.getBoolean("input-methods-enabled", true);
        }
        c.enableInputMethods(enableIM);
        HyperlinkOperation.ensureRegistered(c, this.getContentType());
        c.putClientProperty("context-api-aware", Boolean.TRUE);
        if (!(this instanceof HelpCtx.Provider)) {
            HelpCtx.setHelpIDString((JComponent)c, (String)this.getContentType().replace('/', '.').replace('+', '.'));
        }
        Object object = KEYMAPS_AND_ACTIONS_LOCK;
        synchronized (object) {
            MimePath mimePath = MimePath.get((String)this.getContentType());
            KeybindingsAndPreferencesTracker tracker = keymapTrackers.get(mimePath);
            if (tracker == null) {
                tracker = new KeybindingsAndPreferencesTracker(mimePath.getPath());
                keymapTrackers.put(mimePath, tracker);
            }
            tracker.addComponent(c);
            keymap = this.getKeymap();
        }
        c.setKeymap(keymap);
        this.executeInstallActions(c);
    }

    protected void executeInstallActions(JEditorPane c) {
        MimePath mimePath = MimePath.parse((String)this.getContentType());
        Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)mimePath).lookup(Preferences.class);
        List actionNamesList = (List)SettingsConversions.callFactory(prefs, mimePath, "kit-install-action-name-list", null);
        List<Action> actionsList = this.translateActionNameList(actionNamesList);
        for (Action a : actionsList) {
            a.actionPerformed(new ActionEvent(c, 1001, ""));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deinstall(JEditorPane c) {
        assert (SwingUtilities.isEventDispatchThread()) : "BaseKit.deinstall() incorrectly called from non-AWT thread.";
        this.executeDeinstallActions(c);
        c.setKeymap(null);
        Object object = KEYMAPS_AND_ACTIONS_LOCK;
        synchronized (object) {
            MimePath mimePath = MimePath.get((String)this.getContentType());
            KeybindingsAndPreferencesTracker tracker = keymapTrackers.get(mimePath);
            if (tracker != null) {
                tracker.removeComponent(c);
            }
        }
        BaseTextUI.uninstallUIWatcher(c);
        c.updateUI();
        if (c.getClientProperty("ancestorOverride") != null) {
            c.putClientProperty("ancestorOverride", Boolean.FALSE);
        }
    }

    protected void executeDeinstallActions(JEditorPane c) {
        MimePath mimePath = MimePath.parse((String)this.getContentType());
        Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)mimePath).lookup(Preferences.class);
        List actionNamesList = (List)SettingsConversions.callFactory(prefs, mimePath, "kit-deinstall-action-name-list", null);
        List<Action> actionsList = this.translateActionNameList(actionNamesList);
        for (Action a : actionsList) {
            a.actionPerformed(new ActionEvent(c, 1001, ""));
        }
    }

    protected void initDocument(BaseDocument doc) {
    }

    protected Action[] createActions() {
        return new Action[]{insertBreakActionDef, insertTabActionDef, deletePrevCharActionDef, deleteNextCharActionDef, cutActionDef, copyActionDef, pasteActionDef, new PasteAction(true), removeTabActionDef, removeSelectionActionDef, undoActionDef, redoActionDef, new NextWordAction("caret-next-word"), new NextWordAction("selection-next-word"), new PreviousWordAction("caret-previous-word"), new PreviousWordAction("selection-previous-word"), new ActionFactory.RemoveWordNextAction(), new ActionFactory.RemoveWordPreviousAction(), new ActionFactory.ToggleHighlightSearchAction()};
    }

    protected Action[] getCustomActions() {
        MimePath mimePath = MimePath.parse((String)this.getContentType());
        Preferences prefs = (Preferences)MimeLookup.getLookup((MimePath)mimePath).lookup(Preferences.class);
        List customActions = (List)SettingsConversions.callFactory(prefs, mimePath, "custom-action-list", null);
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("custom-action-list for '" + this.getContentType() + "' {");
            if (customActions != null) {
                for (Action a : customActions) {
                    LOG.fine("    " + a);
                }
            }
            LOG.fine("} End of custom-action-list for '" + this.getContentType() + "'");
        }
        return customActions == null ? null : customActions.toArray(new Action[customActions.size()]);
    }

    protected Action[] getMacroActions() {
        return new Action[0];
    }

    @Override
    public final Action[] getActions() {
        return (Action[])this.addActionsToMap()[0];
    }

    Map<String, Action> getActionMap() {
        return (Map)this.addActionsToMap()[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object[] addActionsToMap() {
        Object object = KEYMAPS_AND_ACTIONS_LOCK;
        synchronized (object) {
            MimePath mimePath = MimePath.parse((String)this.getContentType());
            Action[] actions = kitActions.get(mimePath);
            Map<String, Action> actionMap = kitActionMaps.get(mimePath);
            if (actions == null || actionMap == null) {
                Action[] customActions;
                actions = this.getDeclaredActions();
                actionMap = new HashMap<String, Action>(actions.length << 1);
                BaseKit.addActionsToMap(actionMap, actions, "Declared actions");
                Action[] createActionsMethodResult = this.createActions();
                if (createActionsMethodResult != null) {
                    BaseKit.addActionsToMap(actionMap, createActionsMethodResult, "Actions from createActions()");
                }
                if ((customActions = this.getCustomActions()) != null) {
                    BaseKit.addActionsToMap(actionMap, customActions, "Custom actions");
                }
                actions = actionMap.values().toArray(new Action[actionMap.values().size()]);
                kitActions.put(mimePath, actions);
                kitActionMaps.put(mimePath, actionMap);
                this.updateActionSettings(actions);
                this.updateActions();
            }
            return new Object[]{actions, actionMap};
        }
    }

    protected Action[] getDeclaredActions() {
        return new Action[0];
    }

    protected void updateActions() {
    }

    public Action getActionByName(String name) {
        return name != null ? this.getActionMap().get(name) : null;
    }

    public List<Action> translateActionNameList(List<String> actionNameList) {
        ArrayList<Action> ret = new ArrayList<Action>();
        if (actionNameList != null) {
            for (String actionName : actionNameList) {
                Action a = this.getActionByName(actionName);
                if (a == null) continue;
                ret.add(a);
            }
        }
        return ret;
    }

    static {
        String value = System.getProperty("org.netbeans.editor.linewrap");
        LINEWRAP_ENABLED = value != null ? value.equalsIgnoreCase("true") : true;
    }

    private static final class SearchableKit
    implements SearchableEditorKit {
        private final BaseKit baseKit;
        private final ListenerList<ChangeListener> actionsListenerList = new ListenerList();

        SearchableKit(BaseKit baseKit) {
            this.baseKit = baseKit;
        }

        public Action getAction(String actionName) {
            return this.baseKit.getActionByName(actionName);
        }

        public void addActionsChangeListener(ChangeListener listener) {
            this.actionsListenerList.add((EventListener)listener);
        }

        public void removeActionsChangeListener(ChangeListener listener) {
            this.actionsListenerList.remove((EventListener)listener);
        }

        void fireActionsChange() {
            ChangeEvent evt = new ChangeEvent(this);
            for (ChangeListener listener : this.actionsListenerList.getListeners()) {
                listener.stateChanged(evt);
            }
        }
    }

    private class KeybindingsAndPreferencesTracker
    implements LookupListener,
    PreferenceChangeListener {
        private final String mimeType;
        private final Lookup.Result<KeyBindingSettings> lookupResult;
        private final Preferences prefs;
        private final Set<JTextComponent> components = new WeakSet();

        public KeybindingsAndPreferencesTracker(String mimeType) {
            this.mimeType = mimeType;
            Lookup lookup = MimeLookup.getLookup((String)mimeType);
            this.lookupResult = lookup.lookupResult(KeyBindingSettings.class);
            this.lookupResult.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.lookupResult));
            this.lookupResult.allInstances();
            this.prefs = (Preferences)lookup.lookup(Preferences.class);
            this.prefs.addPreferenceChangeListener((PreferenceChangeListener)WeakListeners.create(PreferenceChangeListener.class, (EventListener)this, (Object)this.prefs));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addComponent(JTextComponent c) {
            Object object = KEYMAPS_AND_ACTIONS_LOCK;
            synchronized (object) {
                this.components.add(c);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeComponent(JTextComponent c) {
            Object object = KEYMAPS_AND_ACTIONS_LOCK;
            synchronized (object) {
                this.components.remove(c);
            }
        }

        public void resultChanged(LookupEvent ev) {
            this.refreshShortcutsAndActions(false);
        }

        @Override
        public void preferenceChange(PreferenceChangeEvent evt) {
            String settingName;
            String string = settingName = evt == null ? null : evt.getKey();
            if (settingName == null || "custom-action-list".equals(settingName)) {
                this.refreshShortcutsAndActions(true);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void refreshShortcutsAndActions(boolean refreshActions) {
            JTextComponent[] arr;
            MultiKeymap keymap;
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("BaseKit.KeymapTracker('" + this.mimeType + "') refreshing keymap " + (refreshActions ? "and actions" : ""));
            }
            Object object = KEYMAPS_AND_ACTIONS_LOCK;
            synchronized (object) {
                MimePath mimePath = MimePath.parse((String)this.mimeType);
                if (refreshActions) {
                    kitActions.remove(mimePath);
                    kitActionMaps.remove(mimePath);
                }
                kitKeymaps.remove(mimePath);
                keymap = BaseKit.this.getKeymap();
                arr = this.components.toArray(new JTextComponent[this.components.size()]);
            }
            for (JTextComponent c : arr) {
                c.setKeymap(keymap);
            }
            BaseKit.this.searchableKit.fireActionsChange();
        }
    }

    static final class DefaultSyntaxTokenContext
    extends TokenContext {
        public static final int TEXT_ID = 1;
        public static final int EOL_ID = 2;
        public static final BaseTokenID TEXT = new BaseTokenID("text", 1);
        public static final BaseImageTokenID EOL = new BaseImageTokenID("EOL", 2, "\n");
        public static final DefaultSyntaxTokenContext CONTEXT = new DefaultSyntaxTokenContext();

        private DefaultSyntaxTokenContext() {
            super("defaultSyntax-token-");
            try {
                this.addDeclaredTokenIDs();
            }
            catch (Exception e) {
                LOG.log(Level.WARNING, "Can't load token IDs", e);
            }
        }
    }

    static final class DefaultSyntax
    extends Syntax {
        private static final int ISI_TEXT = 0;

        public DefaultSyntax() {
            this.tokenContextPath = DefaultSyntaxTokenContext.CONTEXT.getContextPath();
        }

        @Override
        protected TokenID parseToken() {
            while (this.offset < this.stopOffset) {
                char ch = this.buffer[this.offset];
                switch (this.state) {
                    case -1: {
                        switch (ch) {
                            case '\n': {
                                ++this.offset;
                                return DefaultSyntaxTokenContext.EOL;
                            }
                        }
                        this.state = 0;
                        break;
                    }
                    case 0: {
                        switch (ch) {
                            case '\n': {
                                this.state = -1;
                                return DefaultSyntaxTokenContext.TEXT;
                            }
                        }
                    }
                }
                ++this.offset;
            }
            switch (this.state) {
                case 0: {
                    this.state = -1;
                    return DefaultSyntaxTokenContext.TEXT;
                }
            }
            return null;
        }
    }

    public static class RemoveTrailingSpacesAction
    extends LocalBaseAction {
        @Override
        protected boolean asynchonous() {
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomic(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Element lineRootElem = doc.getDefaultRootElement();
                            int count = lineRootElem.getElementCount();
                            boolean removed = false;
                            for (int x = 0; x < count; ++x) {
                                int index;
                                int end;
                                Element elem = lineRootElem.getElement(x);
                                int start = elem.getStartOffset();
                                CharSequence line = DocumentUtilities.getText((Document)doc, (int)start, (int)((end = elem.getEndOffset()) - start));
                                int endIndex = line.length() - 1;
                                if (endIndex < 0 || line.charAt(endIndex) != '\n' || --endIndex < 0 || line.charAt(endIndex) == '\r') {
                                    // empty if block
                                }
                                for (index = --endIndex; index >= 0 && Character.isWhitespace(line.charAt(index)) && line.charAt(index) != '\n'; --index) {
                                }
                                if (index >= endIndex) continue;
                                doc.remove(start + index + 1, endIndex - index);
                                removed = true;
                            }
                            if (removed) {
                                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(BaseKit.class, (String)"TrailingSpacesWereRemoved_Lbl"));
                            } else {
                                StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(BaseKit.class, (String)"TrailingSpacesWereNotRemoved_Lbl"));
                            }
                        }
                        catch (BadLocationException e) {
                            e.printStackTrace();
                            target.getToolkit().beep();
                        }
                    }
                });
            }
        }
    }

    public static class SelectAllAction
    extends KitCompoundAction {
        static final long serialVersionUID = -3502499718130556524L;

        public SelectAllAction() {
            super(new String[]{"caret-begin", "selection-end"});
        }
    }

    public static class SelectLineAction
    extends LocalBaseAction {
        static final long serialVersionUID = -7407681863035740281L;

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                final Caret caret = target.getCaret();
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                        try {
                            int dotPos = caret.getDot();
                            int bolPos = Utilities.getRowStart(target, dotPos);
                            int eolPos = Utilities.getRowEnd(target, dotPos);
                            eolPos = Math.min(eolPos + 1, doc.getLength());
                            caret.setDot(bolPos);
                            caret.moveDot(eolPos);
                        }
                        catch (BadLocationException e) {
                            target.getToolkit().beep();
                        }
                        finally {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                        }
                    }
                });
            }
        }
    }

    public static class SelectWordAction
    extends KitCompoundAction {
        static final long serialVersionUID = 7678848538073016357L;

        public SelectWordAction() {
            super(new String[]{"caret-begin-word", "selection-end-word"});
        }
    }

    public static class EndWordAction
    extends LocalBaseAction {
        static final long serialVersionUID = 3812523676620144633L;

        public EndWordAction() {
            super(62);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int dot = Utilities.getWordEnd(target, caret.getDot());
                    boolean select = "selection-end-word".equals(this.getValue("Name"));
                    if (select) {
                        caret.moveDot(dot);
                    } else {
                        caret.setDot(dot);
                    }
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class BeginWordAction
    extends LocalBaseAction {
        static final long serialVersionUID = 3991338381212491110L;

        public BeginWordAction() {
            super(62);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int dot = Utilities.getWordStart(target, caret.getDot());
                    boolean select = "selection-begin-word".equals(this.getValue("Name"));
                    if (select) {
                        caret.moveDot(dot);
                    } else {
                        caret.setDot(dot);
                    }
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class PreviousWordAction
    extends LocalBaseAction {
        static final long serialVersionUID = -5465143382669785799L;

        PreviousWordAction(String name) {
            super(name, 62);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int dot = Utilities.getPreviousWord(target, caret.getDot());
                    boolean select = "selection-previous-word".equals(this.getValue("Name"));
                    if (caret instanceof BaseCaret) {
                        BaseCaret bCaret = (BaseCaret)caret;
                        if (select) {
                            bCaret.moveDot(dot);
                        } else {
                            bCaret.setDot(dot, false);
                        }
                    } else if (select) {
                        caret.moveDot(dot);
                    } else {
                        caret.setDot(dot);
                    }
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class NextWordAction
    extends LocalBaseAction {
        static final long serialVersionUID = -5909906947175434032L;

        NextWordAction(String name) {
            super(name, 62);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int dotPos = caret.getDot();
                    dotPos = Utilities.getNextWord(target, dotPos);
                    boolean select = "selection-next-word".equals(this.getValue("Name"));
                    if (caret instanceof BaseCaret) {
                        BaseCaret bCaret = (BaseCaret)caret;
                        if (select) {
                            bCaret.moveDot(dotPos);
                        } else {
                            bCaret.setDot(dotPos, false);
                        }
                    } else if (select) {
                        caret.moveDot(dotPos);
                    } else {
                        caret.setDot(dotPos);
                    }
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class EndAction
    extends LocalBaseAction {
        static final long serialVersionUID = 8547506353130203657L;

        public EndAction() {
            super(190);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Rectangle bounds = target.getBounds();
                bounds.x = 0;
                bounds.y = bounds.height;
                bounds.width = 1;
                bounds.height = 1;
                target.scrollRectToVisible(bounds);
                Caret caret = target.getCaret();
                int dot = target.getDocument().getLength();
                boolean select = "selection-end".equals(this.getValue("Name"));
                if (select) {
                    caret.moveDot(dot);
                } else {
                    caret.setDot(dot);
                }
            }
        }
    }

    public static class BeginAction
    extends LocalBaseAction {
        static final long serialVersionUID = 3463563396210234361L;

        public BeginAction() {
            super(190);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                int dot = 0;
                boolean select = "selection-begin".equals(this.getValue("Name"));
                if (select) {
                    caret.moveDot(dot);
                } else {
                    caret.setDot(dot);
                }
            }
        }
    }

    public static class EndLineAction
    extends LocalBaseAction {
        static final long serialVersionUID = 5216077634055190170L;

        public EndLineAction() {
            super(62);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                try {
                    int dot = Utilities.getRowEnd(target, caret.getDot());
                    boolean select = "selection-end-line".equals(this.getValue("Name"));
                    if (select) {
                        caret.moveDot(dot);
                    } else {
                        caret.setDot(dot);
                    }
                    Rectangle r = target.modelToView(dot);
                    if (r != null) {
                        Point p = new Point(0x7FFFFFFE, r.y);
                        caret.setMagicCaretPosition(p);
                    }
                }
                catch (BadLocationException e) {
                    e.printStackTrace();
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class BeginLineAction
    extends LocalBaseAction {
        boolean homeKeyColumnOne;
        static final long serialVersionUID = 3269462923524077779L;

        public static BeginLineAction create() {
            return new BeginLineAction(false);
        }

        public static BeginLineAction createColumnOne() {
            return new BeginLineAction(true);
        }

        public BeginLineAction(boolean columnOne) {
            super(62);
            this.homeKeyColumnOne = columnOne;
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                Caret caret = target.getCaret();
                BaseDocument doc = (BaseDocument)target.getDocument();
                try {
                    boolean select;
                    int dot = caret.getDot();
                    int lineStartPos = Utilities.getRowStart(target, dot);
                    if (this.homeKeyColumnOne) {
                        dot = lineStartPos;
                    } else {
                        int textStartPos = Utilities.getRowFirstNonWhite(doc, lineStartPos);
                        if (textStartPos < 0) {
                            textStartPos = Utilities.getRowEnd(target, lineStartPos);
                        }
                        dot = dot == lineStartPos ? textStartPos : (dot <= textStartPos ? lineStartPos : textStartPos);
                    }
                    String actionName = (String)this.getValue("Name");
                    boolean bl = select = "selection-begin-line".equals(actionName) || BaseKit.selectionLineFirstColumnAction.equals(actionName);
                    if (select) {
                        caret.moveDot(dot);
                    } else {
                        caret.setDot(dot);
                    }
                }
                catch (BadLocationException e) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class BackwardAction
    extends LocalBaseAction {
        static final long serialVersionUID = -3048379822817847356L;

        public BackwardAction() {
            super(62);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target == null) return;
            Caret caret = target.getCaret();
            try {
                int pos;
                boolean select = "selection-backward".equals(this.getValue("Name"));
                if (!select && Utilities.isSelectionShowing(caret)) {
                    pos = target.getSelectionStart();
                    if (pos == caret.getDot()) {
                        caret.setDot(pos);
                        return;
                    }
                    ++pos;
                } else {
                    pos = caret.getDot();
                }
                int dot = target.getUI().getNextVisualPositionFrom(target, pos, Position.Bias.Backward, 7, null);
                if (select) {
                    caret.moveDot(dot);
                    return;
                }
                caret.setDot(dot);
                return;
            }
            catch (BadLocationException ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class PageDownAction
    extends LocalBaseAction {
        static final long serialVersionUID = 8942534850985048862L;

        public PageDownAction() {
            super(60);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                try {
                    Rectangle newCaretBounds;
                    int newCaretOffset;
                    Rectangle visibleBounds;
                    Caret caret = target.getCaret();
                    int caretOffset = caret.getDot();
                    Rectangle caretBounds = ((BaseTextUI)target.getUI()).modelToView(target, caretOffset);
                    if (caretBounds == null) {
                        return;
                    }
                    Point magicCaretPosition = caret.getMagicCaretPosition();
                    if (magicCaretPosition == null) {
                        magicCaretPosition = new Point(caretBounds.x, caretBounds.y);
                    }
                    if ((visibleBounds = target.getVisibleRect()).contains(caretBounds)) {
                        Rectangle newVisibleBounds = new Rectangle(visibleBounds);
                        int bottomLeftOffset = target.viewToModel(new Point(visibleBounds.x, visibleBounds.y + visibleBounds.height));
                        Rectangle bottomLeftLineBounds = target.modelToView(bottomLeftOffset);
                        newVisibleBounds.y = bottomLeftLineBounds.y;
                        int caretRelY = caretBounds.y - visibleBounds.y;
                        int caretNewY = newVisibleBounds.y + caretRelY;
                        newCaretOffset = target.viewToModel(new Point(magicCaretPosition.x, caretNewY));
                        newCaretBounds = target.modelToView(newCaretOffset);
                        if (newCaretBounds.y > caretNewY) {
                            newCaretOffset = target.viewToModel(new Point(magicCaretPosition.x, newCaretBounds.y - newCaretBounds.height));
                            newCaretBounds = target.modelToView(newCaretOffset);
                        }
                        newVisibleBounds.y = newCaretBounds.y - caretRelY;
                        target.scrollRectToVisible(newVisibleBounds);
                    } else {
                        Point newCaretPoint = new Point(magicCaretPosition.x, caretBounds.y + visibleBounds.height);
                        newCaretOffset = target.viewToModel(newCaretPoint);
                        newCaretBounds = target.modelToView(newCaretOffset);
                    }
                    boolean select = BaseKit.selectionPageDownAction.equals(this.getValue("Name"));
                    if (select) {
                        caret.moveDot(newCaretOffset);
                    } else {
                        caret.setDot(newCaretOffset);
                    }
                    magicCaretPosition.y = newCaretBounds.y;
                    caret.setMagicCaretPosition(magicCaretPosition);
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class ForwardAction
    extends LocalBaseAction {
        static final long serialVersionUID = 8007293230193334414L;

        public ForwardAction() {
            super(62);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target == null) return;
            Caret caret = target.getCaret();
            try {
                int pos;
                boolean select = "selection-forward".equals(this.getValue("Name"));
                if (!select && Utilities.isSelectionShowing(caret)) {
                    pos = target.getSelectionEnd();
                    if (pos == caret.getDot()) {
                        caret.setDot(pos);
                        return;
                    }
                    --pos;
                } else {
                    pos = caret.getDot();
                }
                int dot = target.getUI().getNextVisualPositionFrom(target, pos, Position.Bias.Forward, 3, null);
                if (select) {
                    caret.moveDot(dot);
                    return;
                }
                caret.setDot(dot);
                return;
            }
            catch (BadLocationException ex) {
                target.getToolkit().beep();
            }
        }
    }

    public static class PageUpAction
    extends LocalBaseAction {
        static final long serialVersionUID = -3107382148581661079L;

        public PageUpAction() {
            super(60);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                try {
                    Rectangle newCaretBounds;
                    int newCaretOffset;
                    Rectangle visibleBounds;
                    Caret caret = target.getCaret();
                    BaseDocument doc = (BaseDocument)target.getDocument();
                    int caretOffset = caret.getDot();
                    Rectangle caretBounds = ((BaseTextUI)target.getUI()).modelToView(target, caretOffset);
                    if (caretBounds == null) {
                        return;
                    }
                    Point magicCaretPosition = caret.getMagicCaretPosition();
                    if (magicCaretPosition == null) {
                        magicCaretPosition = new Point(caretBounds.x, caretBounds.y);
                    }
                    if ((visibleBounds = target.getVisibleRect()).contains(caretBounds)) {
                        Rectangle newVisibleBounds = new Rectangle(visibleBounds);
                        int topLeftOffset = target.viewToModel(new Point(visibleBounds.x, visibleBounds.y));
                        Rectangle topLeftLineBounds = target.modelToView(topLeftOffset);
                        if (topLeftLineBounds.y != visibleBounds.y) {
                            newVisibleBounds.y = topLeftLineBounds.y + topLeftLineBounds.height;
                        }
                        newVisibleBounds.y -= visibleBounds.height;
                        int caretRelY = caretBounds.y - visibleBounds.y;
                        int caretNewY = newVisibleBounds.y + caretRelY;
                        newCaretOffset = target.viewToModel(new Point(magicCaretPosition.x, caretNewY));
                        newCaretBounds = target.modelToView(newCaretOffset);
                        if (newCaretBounds.y < caretNewY) {
                            newCaretOffset = target.viewToModel(new Point(magicCaretPosition.x, newCaretBounds.y + newCaretBounds.height));
                            newCaretBounds = target.modelToView(newCaretOffset);
                        }
                        newVisibleBounds.y = newCaretBounds.y - caretRelY;
                        target.scrollRectToVisible(newVisibleBounds);
                    } else {
                        Point newCaretPoint = new Point(magicCaretPosition.x, caretBounds.y - visibleBounds.height);
                        newCaretOffset = target.viewToModel(newCaretPoint);
                        newCaretBounds = target.modelToView(newCaretOffset);
                    }
                    boolean select = BaseKit.selectionPageUpAction.equals(this.getValue("Name"));
                    if (select) {
                        caret.moveDot(newCaretOffset);
                    } else {
                        caret.setDot(newCaretOffset);
                    }
                    magicCaretPosition.y = newCaretBounds.y;
                    caret.setMagicCaretPosition(magicCaretPosition);
                }
                catch (BadLocationException ex) {
                    target.getToolkit().beep();
                }
            }
        }
    }

    public static class DownAction
    extends LocalBaseAction {
        static final long serialVersionUID = -5635702355125266822L;

        public DownAction() {
            super(60);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block9: {
                if (target != null) {
                    try {
                        Caret caret = target.getCaret();
                        int dot = caret.getDot();
                        Point p = caret.getMagicCaretPosition();
                        if (p == null) {
                            Rectangle r = target.modelToView(dot);
                            if (r != null) {
                                p = new Point(r.x, r.y);
                                caret.setMagicCaretPosition(p);
                            } else {
                                return;
                            }
                        }
                        try {
                            dot = Utilities.getPositionBelow(target, dot, p.x);
                            boolean select = "selection-down".equals(this.getValue("Name"));
                            if (select) {
                                caret.moveDot(dot);
                                break block9;
                            }
                            caret.setDot(dot);
                        }
                        catch (BadLocationException e) {}
                    }
                    catch (BadLocationException ex) {
                        target.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class UpAction
    extends LocalBaseAction {
        static final long serialVersionUID = 4621760742646981563L;

        public UpAction() {
            super(60);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            block9: {
                if (target != null) {
                    try {
                        Caret caret = target.getCaret();
                        int dot = caret.getDot();
                        Point p = caret.getMagicCaretPosition();
                        if (p == null) {
                            Rectangle r = target.modelToView(dot);
                            if (r != null) {
                                p = new Point(r.x, r.y);
                                caret.setMagicCaretPosition(p);
                            } else {
                                return;
                            }
                        }
                        try {
                            dot = Utilities.getPositionAbove(target, dot, p.x);
                            boolean select = "selection-up".equals(this.getValue("Name"));
                            if (select) {
                                caret.moveDot(dot);
                                break block9;
                            }
                            caret.setDot(dot);
                        }
                        catch (BadLocationException e) {}
                    }
                    catch (BadLocationException ex) {
                        target.getToolkit().beep();
                    }
                }
            }
        }
    }

    public static class BeepAction
    extends LocalBaseAction {
        static final long serialVersionUID = -4474054576633223968L;

        public BeepAction() {
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                target.getToolkit().beep();
            }
        }
    }

    public static class PasteAction
    extends LocalBaseAction {
        static final long serialVersionUID = 5839791453996432149L;

        public PasteAction(boolean formatted) {
            super(formatted ? BaseKit.pasteFormatedAction : "paste-from-clipboard", 28);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final BaseDocument doc = Utilities.getDocument(target);
                if (doc == null) {
                    return;
                }
                try {
                    NavigationHistory.getEdits().markWaypoint(target, target.getCaret().getDot(), false, true);
                }
                catch (BadLocationException e) {
                    LOG.log(Level.WARNING, "Can't add position to the history of edits.", e);
                }
                final Formatter formatter = doc.getFormatter();
                final boolean formatted = BaseKit.pasteFormatedAction.equals(this.getValue("Name"));
                if (formatted) {
                    formatter.reformatLock();
                }
                try {
                    doc.runAtomicAsUser(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                            try {
                                Caret caret = target.getCaret();
                                int startOffset = target.getSelectionStart();
                                IN_PASTE.set(true);
                                if (target.getSelectedText() != null) {
                                    doc.putProperty(BaseKit.DOC_REPLACE_SELECTION_PROPERTY, true);
                                }
                                try {
                                    target.paste();
                                }
                                finally {
                                    IN_PASTE.set(false);
                                    doc.putProperty(BaseKit.DOC_REPLACE_SELECTION_PROPERTY, null);
                                }
                                int endOffset = caret.getDot();
                                if (formatted) {
                                    formatter.reformat(doc, startOffset, endOffset);
                                }
                            }
                            catch (Exception e) {
                                target.getToolkit().beep();
                            }
                            finally {
                                DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                            }
                        }
                    });
                }
                finally {
                    if (formatted) {
                        formatter.reformatUnlock();
                    }
                }
            }
        }

        public static void indentBlock(BaseDocument doc, int startOffset, int endOffset) throws BadLocationException {
            char[] text = doc.getChars(startOffset, endOffset - startOffset);
            String[] lines = PasteAction.toLines(new String(text));
            doc.remove(startOffset, endOffset - startOffset);
            int offset = startOffset;
            for (int i = 0; i < lines.length - 1; ++i) {
                String indent = PasteAction.getIndentString(doc, offset, lines[i]);
                String fragment = indent + lines[i].trim() + '\n';
                doc.insertString(offset, fragment, null);
                offset += fragment.length();
            }
            doc.insertString(offset, lines[lines.length - 1], null);
        }

        private static String[] toLines(String str) {
            Vector<String> v = new Vector<String>();
            int p0 = 0;
            for (int p = 0; p < str.length(); ++p) {
                if (str.charAt(p) != '\n') continue;
                v.add(str.substring(p0, p + 1));
                p0 = p + 1;
            }
            if (p0 < str.length()) {
                v.add(str.substring(p0, str.length()));
            } else {
                v.add("");
            }
            return v.toArray(new String[0]);
        }

        private static String getIndentString(BaseDocument doc, int startOffset, String str) {
            try {
                int i;
                Formatter f = doc.getFormatter();
                CharArrayWriter cw = new CharArrayWriter();
                Writer w = f.createWriter(doc, startOffset, cw);
                w.write(str, 0, str.length());
                w.close();
                String out = new String(cw.toCharArray());
                for (i = 0; i < out.length() && (out.charAt(i) == ' ' || out.charAt(i) == '\t'); ++i) {
                }
                return out.substring(0, i);
            }
            catch (IOException e) {
                return "";
            }
        }
    }

    public static class CopyAction
    extends LocalBaseAction {
        static final long serialVersionUID = -5119779005431986964L;

        public CopyAction() {
            super("copy-to-clipboard", 28);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                try {
                    if (!Utilities.isSelectionShowing(target)) {
                        Element elem = ((AbstractDocument)target.getDocument()).getParagraphElement(target.getCaretPosition());
                        if (!Utilities.isRowWhite((BaseDocument)target.getDocument(), elem.getStartOffset())) {
                            target.select(elem.getStartOffset(), elem.getEndOffset());
                        }
                    }
                    target.copy();
                }
                catch (BadLocationException ble) {
                    LOG.log(Level.FINE, null, ble);
                }
            }
        }
    }

    public static class CutAction
    extends LocalBaseAction {
        static final long serialVersionUID = 6377157040901778853L;

        public CutAction() {
            super("cut-to-clipboard", 28);
            this.setEnabled(false);
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                try {
                    NavigationHistory.getEdits().markWaypoint(target, target.getCaret().getDot(), false, true);
                }
                catch (BadLocationException e) {
                    LOG.log(Level.WARNING, "Can't add position to the history of edits.", e);
                }
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                        try {
                            int removeNewlineOffset = -1;
                            if (!Utilities.isSelectionShowing(target)) {
                                Element elem = ((AbstractDocument)target.getDocument()).getParagraphElement(target.getCaretPosition());
                                int lineStartOffset = elem.getStartOffset();
                                int lineEndOffset = elem.getEndOffset();
                                if (lineEndOffset == doc.getLength() + 1) {
                                    try {
                                        doc.insertString(lineEndOffset - 1, "\n", null);
                                        if (lineStartOffset > 0) {
                                            removeNewlineOffset = lineStartOffset - 1;
                                        }
                                    }
                                    catch (BadLocationException e) {
                                        // empty catch block
                                    }
                                }
                                target.select(lineStartOffset, lineEndOffset);
                            }
                            target.cut();
                            if (removeNewlineOffset != -1) {
                                try {
                                    doc.remove(removeNewlineOffset, 1);
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                        }
                        finally {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                        }
                    }
                });
            }
        }
    }

    @Deprecated
    public static class WritableAction
    extends LocalBaseAction {
        static final long serialVersionUID = -5982547952800937954L;

        public WritableAction() {
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                target.setEditable(true);
            }
        }
    }

    @Deprecated
    public static class ReadOnlyAction
    extends LocalBaseAction {
        static final long serialVersionUID = 9204335480208463193L;

        public ReadOnlyAction() {
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                target.setEditable(false);
            }
        }
    }

    public static class DeleteCharAction
    extends LocalBaseAction {
        protected boolean nextChar;
        static final long serialVersionUID = -4321971925753148556L;

        public DeleteCharAction(String nm, boolean nextChar) {
            super(nm, 22);
            this.nextChar = nextChar;
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final BaseDocument doc = (BaseDocument)target.getDocument();
                final Caret caret = target.getCaret();
                final int dot = caret.getDot();
                final int mark = caret.getMark();
                doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                        try {
                            if (dot != mark) {
                                doc.remove(Math.min(dot, mark), Math.abs(dot - mark));
                            } else if (DeleteCharAction.this.nextChar) {
                                char ch = doc.getChars(dot, 1)[0];
                                doc.remove(dot, 1);
                                DeleteCharAction.this.charDeleted(doc, dot, caret, ch);
                            } else {
                                char ch = doc.getChars(dot - 1, 1)[0];
                                doc.remove(dot - 1, 1);
                                DeleteCharAction.this.charBackspaced(doc, dot - 1, caret, ch);
                            }
                        }
                        catch (BadLocationException e) {
                            target.getToolkit().beep();
                        }
                        finally {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                        }
                    }
                });
            }
        }

        protected void charBackspaced(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
        }

        protected void charDeleted(BaseDocument doc, int dotPos, Caret caret, char ch) throws BadLocationException {
        }
    }

    public static class InsertStringAction
    extends LocalBaseAction {
        String text;
        static final long serialVersionUID = -2755852016584693328L;

        public InsertStringAction(String nm, String text) {
            super(nm, 22);
            this.text = text;
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                target.replaceSelection(this.text);
            }
        }
    }

    @Deprecated
    public static class InsertContentAction
    extends LocalBaseAction {
        static final long serialVersionUID = 5647751370952797218L;

        public InsertContentAction() {
            super(22);
            this.putValue("no-keybinding", Boolean.TRUE);
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null && evt != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                String content = evt.getActionCommand();
                if (content != null) {
                    target.replaceSelection(content);
                } else {
                    target.getToolkit().beep();
                }
            }
        }
    }

    @Deprecated
    public static class KitCompoundAction
    extends LocalBaseAction {
        private String[] actionNames;
        static final long serialVersionUID = 8415246475764264835L;

        public KitCompoundAction(String[] actionNames) {
            this(0, actionNames);
        }

        public KitCompoundAction(int resetMask, String[] actionNames) {
            super(resetMask);
            this.actionNames = actionNames;
        }

        public KitCompoundAction(String nm, String[] actionNames) {
            this(nm, 0, actionNames);
        }

        public KitCompoundAction(String nm, int resetMask, String[] actionNames) {
            super(nm, resetMask);
            this.actionNames = actionNames;
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            BaseKit kit;
            if (target != null && (kit = Utilities.getKit(target)) != null) {
                for (int i = 0; i < this.actionNames.length; ++i) {
                    Action a = kit.getActionByName(this.actionNames[i]);
                    if (a == null) continue;
                    if (a instanceof BaseAction) {
                        ((BaseAction)a).actionPerformed(evt, target);
                        continue;
                    }
                    a.actionPerformed(evt);
                }
            }
        }
    }

    @Deprecated
    public static class CompoundAction
    extends LocalBaseAction {
        Action[] actions;
        static final long serialVersionUID = 1649688300969753758L;

        public CompoundAction(String nm, Action[] actions) {
            this(nm, 0, actions);
        }

        public CompoundAction(String nm, int resetMask, Action[] actions) {
            super(nm, resetMask);
            this.actions = actions;
        }

        @Override
        public void actionPerformed(ActionEvent evt, JTextComponent target) {
            if (target != null) {
                for (int i = 0; i < this.actions.length; ++i) {
                    Action a = this.actions[i];
                    if (a instanceof BaseAction) {
                        ((BaseAction)a).actionPerformed(evt, target);
                        continue;
                    }
                    a.actionPerformed(evt);
                }
            }
        }
    }

    public static class InsertTabAction
    extends LocalBaseAction {
        static final long serialVersionUID = -3379768531715989243L;

        public InsertTabAction() {
            super("insert-tab", 22);
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final Caret caret = target.getCaret();
                final BaseDocument doc = (BaseDocument)target.getDocument();
                doc.runAtomicAsUser(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block14: {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                            Formatter.pushFormattingContextDocument(doc);
                            try {
                                int caretCol;
                                if (Utilities.isSelectionShowing(caret)) {
                                    try {
                                        doc.getFormatter().changeBlockIndent(doc, target.getSelectionStart(), target.getSelectionEnd(), 1);
                                    }
                                    catch (GuardedException e) {
                                        target.getToolkit().beep();
                                    }
                                    catch (BadLocationException e) {
                                        e.printStackTrace();
                                    }
                                    break block14;
                                }
                                int dotPos = caret.getDot();
                                try {
                                    caretCol = doc.getVisColFromPos(dotPos);
                                }
                                catch (BadLocationException e) {
                                    LOG.log(Level.WARNING, null, e);
                                    caretCol = 0;
                                }
                                try {
                                    int indent;
                                    int upperCol = Utilities.getRowIndent(doc, dotPos, false);
                                    if (upperCol == -1) {
                                        upperCol = 0;
                                    }
                                    if ((indent = Utilities.getRowIndent(doc, dotPos)) == -1) {
                                        indent = upperCol > caretCol ? upperCol : Utilities.getNextTabColumn(doc, dotPos);
                                        int rowStart = Utilities.getRowStart(doc, dotPos);
                                        doc.getFormatter().changeRowIndent(doc, dotPos, indent);
                                        int newDotPos = doc.getOffsetFromVisCol(indent, rowStart);
                                        if (newDotPos >= 0) {
                                            caret.setDot(newDotPos);
                                        }
                                        break block14;
                                    }
                                    doc.getFormatter().insertTabString(doc, dotPos);
                                }
                                catch (BadLocationException badLocationException) {
                                    // empty catch block
                                }
                            }
                            finally {
                                Formatter.popFormattingContextDocument(doc);
                                DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                            }
                        }
                    }
                });
            }
        }
    }

    public static class SplitLineAction
    extends LocalBaseAction {
        static final long serialVersionUID = 7966576342334158659L;

        public SplitLineAction() {
            super(22);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final BaseDocument doc = (BaseDocument)target.getDocument();
                final Caret caret = target.getCaret();
                final Formatter formatter = doc.getFormatter();
                formatter.indentLock();
                try {
                    doc.runAtomicAsUser(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                            try {
                                target.replaceSelection("");
                                int dotPos = caret.getDot();
                                formatter.indentNewLine(doc, dotPos);
                                caret.setDot(dotPos);
                            }
                            finally {
                                DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                            }
                        }
                    });
                }
                finally {
                    formatter.indentUnlock();
                }
            }
        }
    }

    public static class InsertBreakAction
    extends LocalBaseAction {
        static final long serialVersionUID = 7966576342334158659L;

        public InsertBreakAction() {
            super("insert-break", 22);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null) {
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final BaseDocument doc = (BaseDocument)target.getDocument();
                final Formatter formatter = doc.getFormatter();
                formatter.indentLock();
                try {
                    doc.runAtomicAsUser(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                            try {
                                target.replaceSelection("");
                                Caret caret = target.getCaret();
                                Object cookie = InsertBreakAction.this.beforeBreak(target, doc, caret);
                                int dotPos = caret.getDot();
                                int newDotPos = formatter.indentNewLine(doc, dotPos);
                                caret.setDot(newDotPos);
                                InsertBreakAction.this.afterBreak(target, doc, caret, cookie);
                            }
                            finally {
                                DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                            }
                        }
                    });
                }
                finally {
                    formatter.indentUnlock();
                }
            }
        }

        protected Object beforeBreak(JTextComponent target, BaseDocument doc, Caret caret) {
            return null;
        }

        protected void afterBreak(JTextComponent target, BaseDocument doc, Caret caret, Object data) {
        }
    }

    public static class DefaultKeyTypedAction
    extends LocalBaseAction {
        static final long serialVersionUID = 3069164318144463899L;
        private static final boolean isMac = System.getProperty("mrj.version") != null;

        public DefaultKeyTypedAction() {
            super("default-typed", 34);
            this.putValue("no-keybinding", Boolean.TRUE);
            LOG.fine("DefaultKeyTypedAction with enhanced logging, see issue #145306");
        }

        @Override
        public void actionPerformed(ActionEvent evt, final JTextComponent target) {
            if (target != null && evt != null) {
                boolean alt;
                boolean ctrl;
                int mod = evt.getModifiers();
                boolean bl = ctrl = (mod & 2) != 0;
                boolean bl2 = isMac ? (mod & 4) != 0 : (alt = (mod & 8) != 0);
                if (alt || ctrl) {
                    return;
                }
                if (!target.isEditable() || !target.isEnabled()) {
                    target.getToolkit().beep();
                    return;
                }
                final Caret caret = target.getCaret();
                final BaseDocument doc = (BaseDocument)target.getDocument();
                final EditorUI editorUI = Utilities.getEditorUI(target);
                final String cmd = evt.getActionCommand();
                if (cmd != null && cmd.length() == 1) {
                    try {
                        NavigationHistory.getEdits().markWaypoint(target, caret.getDot(), false, true);
                    }
                    catch (BadLocationException e) {
                        LOG.log(Level.WARNING, "Can't add position to the history of edits.", e);
                    }
                    doc.runAtomicAsUser(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            DocumentUtilities.setTypingModification((Document)doc, (boolean)true);
                            try {
                                block12: {
                                    char ch = cmd.charAt(0);
                                    if (ch >= ' ' && ch != '\u007f') {
                                        LOG.fine("Processing command char: " + Integer.toHexString(ch));
                                        editorUI.getWordMatch().clear();
                                        Boolean overwriteMode = (Boolean)editorUI.getProperty("overwriteMode");
                                        try {
                                            boolean doInsert = true;
                                            if (!doInsert) break block12;
                                            if (Utilities.isSelectionShowing(caret)) {
                                                boolean ovr = overwriteMode != null && overwriteMode != false;
                                                try {
                                                    doc.putProperty(BaseKit.DOC_REPLACE_SELECTION_PROPERTY, true);
                                                    DefaultKeyTypedAction.this.replaceSelection(target, caret.getDot(), caret, cmd, ovr);
                                                    break block12;
                                                }
                                                finally {
                                                    doc.putProperty(BaseKit.DOC_REPLACE_SELECTION_PROPERTY, null);
                                                }
                                            }
                                            int dotPos = caret.getDot();
                                            if (overwriteMode != null && overwriteMode.booleanValue() && dotPos < doc.getLength() && doc.getChars(dotPos, 1)[0] != '\n') {
                                                DefaultKeyTypedAction.this.insertString(doc, dotPos, caret, cmd, true);
                                                break block12;
                                            }
                                            DefaultKeyTypedAction.this.insertString(doc, dotPos, caret, cmd, false);
                                        }
                                        catch (BadLocationException e) {
                                            LOG.log(Level.FINE, null, e);
                                            target.getToolkit().beep();
                                        }
                                    } else {
                                        LOG.fine("Invalid command char: " + Integer.toHexString(ch));
                                    }
                                }
                                DefaultKeyTypedAction.this.checkIndent(target, cmd);
                            }
                            finally {
                                DocumentUtilities.setTypingModification((Document)doc, (boolean)false);
                            }
                        }
                    });
                } else if (LOG.isLoggable(Level.FINE)) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i < cmd.length(); ++i) {
                        String hex = Integer.toHexString(cmd.charAt(i));
                        sb.append(hex);
                        if (i + 1 >= cmd.length()) continue;
                        sb.append(" ");
                    }
                    LOG.fine("Invalid command: '" + sb + "'");
                }
            }
        }

        protected void insertString(BaseDocument doc, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
            if (overwrite) {
                doc.remove(dotPos, 1);
            }
            doc.insertString(dotPos, str, null);
        }

        protected void replaceSelection(JTextComponent target, int dotPos, Caret caret, String str, boolean overwrite) throws BadLocationException {
            target.replaceSelection(str);
        }

        protected void checkIndent(JTextComponent target, String typedText) {
        }
    }
}

