/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.source;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.Comment;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.java.source.WorkingCopy;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.java.source.builder.CommentHandlerService;
import org.netbeans.modules.java.source.parsing.SourceFileObject;
import org.netbeans.modules.java.source.query.CommentHandler;
import org.netbeans.modules.java.source.query.CommentSet;

public final class CommentCollector {
    private static CommentCollector instance = null;
    private static Logger log = Logger.getLogger(CommentCollector.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommentCollector getInstance() {
        Class<CommentsCollection> clazz = CommentsCollection.class;
        synchronized (CommentsCollection.class) {
            if (instance == null) {
                instance = new CommentCollector();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private CommentCollector() {
    }

    public void collect(WorkingCopy copy) throws IOException {
        JCTree.JCCompilationUnit unit = (JCTree.JCCompilationUnit)copy.getCompilationUnit();
        TokenSequence seq = ((SourceFileObject)unit.getSourceFile()).getTokenHierarchy().tokenSequence(JavaTokenId.language());
        this.collect((TokenSequence<JavaTokenId>)seq, copy);
    }

    public void collect(TokenSequence<JavaTokenId> ts, CompilationInfo ci) {
        CommentHandlerService ch = CommentHandlerService.instance(ci.impl.getJavacTask().getContext());
        TreeUtilities tu = new TreeUtilities(ci);
        JCTree.JCCompilationUnit cu = (JCTree.JCCompilationUnit)ci.getCompilationUnit();
        EndPosTable endPositions = cu.endPositions;
        List trees = cu.getTypeDecls();
        Tree lastTree = trees.isEmpty() ? ci.getCompilationUnit() : (Tree)trees.get(0);
        CommentsCollection foundComments = null;
        ts.move(0);
        int newlines = 0;
        while (ts.moveNext()) {
            Token t = ts.token();
            if (t.id() == JavaTokenId.WHITESPACE) {
                newlines += this.numberOfNL((Token<JavaTokenId>)t);
                continue;
            }
            if (this.isComment((JavaTokenId)t.id())) {
                if (foundComments != null) {
                    this.attachComments(foundComments, lastTree, ch, (Map<JCTree, Integer>)((Object)endPositions), ts);
                }
                foundComments = this.getCommentsCollection(ts, newlines);
                if (t.id() == JavaTokenId.LINE_COMMENT) {
                    newlines = 1;
                    continue;
                }
                newlines = 0;
                continue;
            }
            this.skipEvil(ts);
            Tree tree = this.getTree(tu, ts);
            if (tree != null && foundComments != null) {
                int[] bounds = foundComments.getBounds();
                double weight = this.belongsTo(bounds[0], bounds[1], ts);
                if (tree.getKind() == Tree.Kind.COMPILATION_UNIT && weight == 0.0) {
                    this.attachComments(foundComments, lastTree, ch, (Map<JCTree, Integer>)((Object)endPositions), ts);
                } else if (weight >= 0.0) {
                    this.attachComments(foundComments, tree, ch, (Map<JCTree, Integer>)((Object)endPositions), ts);
                } else {
                    this.attachComments(foundComments, lastTree, ch, (Map<JCTree, Integer>)((Object)endPositions), ts);
                }
                foundComments = null;
            }
            lastTree = tree;
            newlines = 0;
        }
    }

    private void skipEvil(TokenSequence<JavaTokenId> ts) {
        do {
            JavaTokenId id = (JavaTokenId)ts.token().id();
            switch (id) {
                case PUBLIC: 
                case PRIVATE: 
                case PROTECTED: 
                case ABSTRACT: 
                case FINAL: 
                case STATIC: 
                case VOID: 
                case VOLATILE: 
                case NATIVE: 
                case STRICTFP: 
                case WHITESPACE: 
                case INT: 
                case BOOLEAN: 
                case DOUBLE: 
                case FLOAT: 
                case BYTE: 
                case CHAR: 
                case SHORT: 
                case CONST: 
                case LONG: {
                    break;
                }
                default: {
                    return;
                }
            }
        } while (ts.moveNext());
    }

    private double belongsTo(int startPos, int endPos, TokenSequence<JavaTokenId> ts) {
        int index = ts.index();
        double result = this.getForwardWeight(endPos, ts) - this.getBackwardWeight(startPos, ts);
        ts.moveIndex(index);
        ts.moveNext();
        return result;
    }

    private double getForwardWeight(int endPos, TokenSequence<JavaTokenId> ts) {
        double result = 0.0;
        ts.move(endPos);
        while (ts.moveNext()) {
            if (ts.token().id() == JavaTokenId.WHITESPACE) {
                int nls = this.numberOfNL((Token<JavaTokenId>)ts.token());
                result = nls == 0 ? 1.0 : (double)(1 / nls);
                continue;
            }
            if (!this.isComment((JavaTokenId)ts.token().id())) break;
            if (ts.token().id() == JavaTokenId.LINE_COMMENT) {
                return 1.0;
            }
            result = 0.0;
            break;
        }
        return result;
    }

    private double getBackwardWeight(int startPos, TokenSequence<JavaTokenId> ts) {
        double result = 0.0;
        ts.move(startPos);
        while (ts.movePrevious()) {
            if (ts.token().id() == JavaTokenId.WHITESPACE) {
                int nls = this.numberOfNL((Token<JavaTokenId>)ts.token());
                result = nls == 0 ? 0.0 : (double)(1 / nls);
                continue;
            }
            if (!this.isComment((JavaTokenId)ts.token().id())) break;
            result = 0.0;
            break;
        }
        return result;
    }

    private void attachComments(CommentsCollection foundComments, Tree tree, CommentHandler ch, Map<JCTree, Integer> endPositions, TokenSequence<JavaTokenId> ts) {
        BlockTree bt;
        if (foundComments.isEmpty()) {
            return;
        }
        int[] bounds = this.getBounds((JCTree)tree, endPositions);
        CommentSet.RelativePosition positioning = tree instanceof BlockTree ? ((bt = (BlockTree)tree).getStatements().isEmpty() && bounds[0] >= foundComments.getBounds()[0] && bounds[1] <= foundComments.getBounds()[1] ? CommentSet.RelativePosition.INNER : this.computePositioning(bounds, foundComments, ts)) : this.computePositioning(bounds, foundComments, ts);
        CommentSet set = this.createCommentSet(ch, tree);
        for (Token<JavaTokenId> comment : foundComments) {
            this.attachComment(positioning, set, comment);
        }
    }

    private void attachComment(CommentSet.RelativePosition positioning, CommentSet set, Token<JavaTokenId> comment) {
        Comment c = Comment.create(this.getStyle((JavaTokenId)comment.id()), comment.offset(null), this.getEndPos(comment), -2, this.getText(comment));
        set.addComment(positioning, c);
    }

    private String getText(Token<JavaTokenId> comment) {
        return String.valueOf(comment.text());
    }

    private int getEndPos(Token<JavaTokenId> comment) {
        return comment.offset(null) + comment.length();
    }

    private Comment.Style getStyle(JavaTokenId id) {
        switch (id) {
            case JAVADOC_COMMENT: {
                return Comment.Style.JAVADOC;
            }
            case LINE_COMMENT: {
                return Comment.Style.LINE;
            }
            case BLOCK_COMMENT: {
                return Comment.Style.BLOCK;
            }
        }
        return Comment.Style.WHITESPACE;
    }

    private CommentSet.RelativePosition computePositioning(int[] treeBounds, CommentsCollection cc, TokenSequence<JavaTokenId> ts) {
        int[] commentsBounds = cc.getBounds();
        if (commentsBounds[1] < treeBounds[0]) {
            return CommentSet.RelativePosition.PRECEDING;
        }
        if (commentsBounds[0] > treeBounds[1]) {
            TokenSequence sequence = ts.subSequence(treeBounds[1], commentsBounds[0]);
            sequence.move(0);
            if (!sequence.moveNext()) {
                return CommentSet.RelativePosition.INLINE;
            }
            switch ((JavaTokenId)sequence.token().id()) {
                case WHITESPACE: {
                    if (this.numberOfNL((Token<JavaTokenId>)sequence.token()) > 0) {
                        return CommentSet.RelativePosition.TRAILING;
                    }
                    return CommentSet.RelativePosition.INLINE;
                }
            }
            return CommentSet.RelativePosition.TRAILING;
        }
        if (commentsBounds[0] > treeBounds[0] && commentsBounds[1] < treeBounds[1]) {
            return CommentSet.RelativePosition.INNER;
        }
        return CommentSet.RelativePosition.TRAILING;
    }

    private int[] getBounds(JCTree tree, Map<JCTree, Integer> endPositions) {
        return new int[]{TreeInfo.getStartPos(tree), TreeInfo.getEndPos((JCTree)tree, endPositions)};
    }

    private Tree getTree(TreeUtilities tu, TokenSequence<JavaTokenId> ts) {
        TreePath path;
        int start = ts.offset();
        if (ts.token().length() > 0) {
            ++start;
        }
        if ((path = tu.pathFor(start)) != null) {
            return path.getLeaf();
        }
        return null;
    }

    private int numberOfNL(Token<JavaTokenId> t) {
        int count = 0;
        CharSequence charSequence = t.text();
        for (int i = 0; i < charSequence.length(); ++i) {
            char a = charSequence.charAt(i);
            if ('\n' != a) continue;
            ++count;
        }
        return count;
    }

    private CommentsCollection getCommentsCollection(TokenSequence<JavaTokenId> ts, int maxTension) {
        CommentsCollection result = new CommentsCollection();
        Token t = ts.token();
        result.add((Token<JavaTokenId>)t);
        boolean isLC = t.id() == JavaTokenId.LINE_COMMENT;
        int lastCommentIndex = ts.index();
        int start = ts.offset();
        int end = ts.offset() + ts.token().length();
        while (ts.moveNext()) {
            t = ts.token();
            if (this.isComment((JavaTokenId)t.id())) {
                result.add((Token<JavaTokenId>)t);
                start = Math.min(ts.offset(), start);
                end = Math.max(ts.offset() + t.length(), end);
                isLC = t.id() == JavaTokenId.LINE_COMMENT;
                lastCommentIndex = ts.index();
                continue;
            }
            if (t.id() == JavaTokenId.WHITESPACE && this.numberOfNL((Token<JavaTokenId>)t) + (isLC ? 1 : 0) <= maxTension) continue;
        }
        ts.moveIndex(lastCommentIndex);
        ts.moveNext();
        result.setBounds(new int[]{start, end});
        return result;
    }

    private CommentSet createCommentSet(CommentHandler ch, Tree lastTree) {
        return ch.getComments(lastTree);
    }

    private boolean isComment(JavaTokenId tid) {
        switch (tid) {
            case JAVADOC_COMMENT: 
            case LINE_COMMENT: 
            case BLOCK_COMMENT: {
                return true;
            }
        }
        return false;
    }

    private static class CommentsCollection
    implements Iterable<Token<JavaTokenId>> {
        private final int[] bounds = new int[]{-2, -2};
        private final List<Token<JavaTokenId>> comments = new LinkedList<Token<JavaTokenId>>();

        private CommentsCollection() {
        }

        void add(Token<JavaTokenId> comment) {
            this.comments.add(comment);
        }

        boolean isEmpty() {
            return this.comments.isEmpty();
        }

        @Override
        public Iterator<Token<JavaTokenId>> iterator() {
            return this.comments.iterator();
        }

        void setBounds(int[] bounds) {
            this.bounds[0] = bounds[0];
            this.bounds[1] = bounds[1];
        }

        public int[] getBounds() {
            return (int[])this.bounds.clone();
        }

        public void merge(CommentsCollection cc) {
            this.comments.addAll(cc.comments);
            this.bounds[0] = Math.min(this.bounds[0], cc.bounds[0]);
            this.bounds[1] = Math.max(this.bounds[1], cc.bounds[1]);
        }
    }
}

