/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.models.nodes;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.ModelNode;
import org.netbeans.modules.php.dbgp.SessionId;
import org.netbeans.modules.php.dbgp.SessionManager;
import org.netbeans.modules.php.dbgp.UnsufficientValueException;
import org.netbeans.modules.php.dbgp.models.VariablesModelFilter;
import org.netbeans.modules.php.dbgp.models.nodes.AbstractModelNode;
import org.netbeans.modules.php.dbgp.models.nodes.AbstractVariableNode;
import org.netbeans.modules.php.dbgp.models.nodes.VariableNode;
import org.netbeans.modules.php.dbgp.packets.EvalCommand;
import org.netbeans.modules.php.dbgp.packets.Property;
import org.netbeans.modules.php.project.api.PhpOptions;
import org.netbeans.spi.debugger.ContextProvider;
import org.openide.util.NbBundle;

public class ScriptWatchEvaluating
extends AbstractModelNode
implements ModelNode {
    private static final String WATCH_ICON = "org/netbeans/modules/debugger/resources/watchesView/Watch";
    private Watch myWatch;
    private ContextProvider myProvider;
    private Property myValue;

    protected ScriptWatchEvaluating(ContextProvider provider, Watch watch) {
        super(null, null);
        this.myWatch = watch;
        this.myProvider = provider;
        this.requestValue();
    }

    public synchronized String getExpression() {
        return this.myWatch.getExpression();
    }

    public synchronized void remove() {
        this.myWatch.remove();
    }

    public synchronized void setExpression(String expression) {
        this.myWatch.setExpression(expression);
        this.requestValue();
    }

    @Override
    public String getName() {
        return this.myWatch.getExpression();
    }

    public String getDisplayName() {
        return this.myWatch.getExpression();
    }

    @Override
    public String getShortDescription() {
        return this.myWatch.getExpression();
    }

    @Override
    public String getIconBase() {
        return WATCH_ICON;
    }

    @Override
    public synchronized String getType() {
        if (this.myValue == null) {
            return null;
        }
        return this.myValue.getType();
    }

    @Override
    public synchronized String getValue() throws UnsufficientValueException {
        if (!PhpOptions.getInstance().isDebuggerWatchesAndEval()) {
            return NbBundle.getMessage(ScriptWatchEvaluating.class, (String)"WatchesAndEvalDisabled");
        }
        if (this.myValue == null) {
            return null;
        }
        return this.myValue.getStringValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VariableNode[] getChildren(int from, int to) {
        List<Object> list;
        ScriptWatchEvaluating scriptWatchEvaluating = this;
        synchronized (scriptWatchEvaluating) {
            list = this.getVariables() == null ? new ArrayList() : new ArrayList<AbstractVariableNode>(this.getVariables());
        }
        if (from >= list.size()) {
            return new VariableNode[0];
        }
        int end = Math.min(to, list.size());
        list = list.subList(from, end);
        return list.toArray(new VariableNode[list.size()]);
    }

    @Override
    public boolean isLeaf() {
        return this.getChildrenSize() == 0;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public synchronized int getChildrenSize() {
        return this.getVariables() == null ? 0 : this.getVariables().size();
    }

    protected synchronized void setEvaluated(Property value) {
        this.myValue = value;
        if (value != null) {
            this.initVariables(value.getChildren());
        }
    }

    protected void requestValue() {
        this.setEvaluated(null);
        DebugSession session = this.getSession();
        if (session == null) {
            return;
        }
        String toEvaluation = this.getExpression();
        if (PhpOptions.getInstance().isDebuggerWatchesAndEval()) {
            EvalCommand command = new EvalCommand(session.getTransactionId());
            command.setData(toEvaluation);
            session.sendCommandLater(command);
        }
    }

    @Override
    protected boolean isTypeApplied(Set<VariablesModelFilter.FilterType> set) {
        return true;
    }

    private SessionId getSessionId() {
        if (this.myProvider == null) {
            return null;
        }
        SessionId id = (SessionId)this.myProvider.lookupFirst(null, SessionId.class);
        if (id == null) {
            return null;
        }
        return id;
    }

    private DebugSession getSession() {
        return SessionManager.getInstance().getSession(this.getSessionId());
    }
}

