/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugzilla.query;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import org.eclipse.mylyn.tasks.core.data.TaskData;
import org.eclipse.mylyn.tasks.core.data.TaskDataCollector;
import org.netbeans.modules.bugtracking.issuetable.ColumnDescriptor;
import org.netbeans.modules.bugtracking.spi.Issue;
import org.netbeans.modules.bugtracking.spi.Query;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCache;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugzilla.Bugzilla;
import org.netbeans.modules.bugzilla.BugzillaConfig;
import org.netbeans.modules.bugzilla.BugzillaConnector;
import org.netbeans.modules.bugzilla.commands.GetMultiTaskDataCommand;
import org.netbeans.modules.bugzilla.commands.PerformQueryCommand;
import org.netbeans.modules.bugzilla.issue.BugzillaIssue;
import org.netbeans.modules.bugzilla.kenai.KenaiRepository;
import org.netbeans.modules.bugzilla.query.QueryController;
import org.netbeans.modules.bugzilla.repository.BugzillaRepository;
import org.openide.nodes.Node;

public class BugzillaQuery
extends Query {
    private String name;
    private final BugzillaRepository repository;
    protected QueryController controller;
    private final Set<String> issues = new HashSet<String>();
    private Set<String> archivedIssues = new HashSet<String>();
    protected String urlParameters;
    private boolean initialUrlDef;
    private boolean firstRun = true;
    private ColumnDescriptor[] columnDescriptors;

    public BugzillaQuery(BugzillaRepository repository) {
        this(null, repository, null, false, false, true);
    }

    public BugzillaQuery(String name, BugzillaRepository repository, String urlParameters, boolean saved, boolean urlDef, boolean initControler) {
        boolean autoRefresh;
        this.repository = repository;
        this.saved = saved;
        this.name = name;
        this.urlParameters = urlParameters;
        this.initialUrlDef = urlDef;
        this.setLastRefresh(repository.getIssueCache().getQueryTimestamp(this.getStoredQueryName()));
        if (initControler) {
            this.controller = this.createControler(repository, this, urlParameters);
        }
        if (repository instanceof KenaiRepository && (autoRefresh = BugzillaConfig.getInstance().getQueryAutoRefresh(this.getDisplayName()))) {
            this.getRepository().scheduleForRefresh(this);
        }
    }

    public String getDisplayName() {
        return this.name;
    }

    public String getTooltip() {
        return this.name + " - " + this.repository.getDisplayName();
    }

    public synchronized QueryController getController() {
        if (this.controller == null) {
            this.controller = this.createControler(this.repository, this, this.urlParameters);
        }
        return this.controller;
    }

    public BugzillaRepository getRepository() {
        return this.repository;
    }

    protected QueryController createControler(BugzillaRepository r, BugzillaQuery q, String parameters) {
        return new QueryController(r, q, parameters, this.initialUrlDef);
    }

    public ColumnDescriptor[] getColumnDescriptors() {
        if (this.columnDescriptors == null) {
            this.columnDescriptors = BugzillaIssue.getColumnDescriptors(this.repository);
        }
        return this.columnDescriptors;
    }

    public void refresh() {
        this.refreshIntern(false);
    }

    boolean refreshIntern(final boolean autoRefresh) {
        assert (this.urlParameters != null);
        assert (!SwingUtilities.isEventDispatchThread()) : "Accessing remote host. Do not call in awt";
        final boolean[] ret = new boolean[1];
        this.executeQuery(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                HashSet<String> queryIssues;
                block7: {
                    Bugzilla.LOG.log(Level.FINE, "refresh start - {0} [{1}]", new String[]{BugzillaQuery.this.name, BugzillaQuery.this.urlParameters});
                    try {
                        queryIssues = new HashSet<String>();
                        BugzillaQuery.this.issues.clear();
                        BugzillaQuery.this.archivedIssues.clear();
                        if (BugzillaQuery.this.isSaved()) {
                            if (!BugzillaQuery.this.wasRun() && BugzillaQuery.this.issues.size() != 0) {
                                Bugzilla.LOG.warning("query " + BugzillaQuery.this.getDisplayName() + " supposed to be run for the first time yet already contains issues.");
                                assert (false);
                            }
                            queryIssues.addAll(BugzillaQuery.this.repository.getIssueCache().readQueryIssues(BugzillaQuery.this.getStoredQueryName()));
                            queryIssues.addAll(BugzillaQuery.this.repository.getIssueCache().readArchivedQueryIssues(BugzillaQuery.this.getStoredQueryName()));
                            BugzillaQuery.this.archivedIssues.addAll(queryIssues);
                        }
                        BugzillaQuery.this.firstRun = false;
                        StringBuffer url = new StringBuffer();
                        url.append("/buglist.cgi?query_format=advanced");
                        url.append(BugzillaQuery.this.urlParameters);
                        PerformQueryCommand queryCmd = new PerformQueryCommand(BugzillaQuery.this.repository, url.toString(), new IssuesIdCollector());
                        BugzillaQuery.this.repository.getExecutor().execute(queryCmd, !autoRefresh);
                        ret[0] = queryCmd.hasFailed();
                        if (!ret[0]) break block7;
                        BugzillaQuery.this.logQueryEvent(BugzillaQuery.this.issues.size(), autoRefresh);
                    }
                    catch (Throwable throwable) {
                        BugzillaQuery.this.logQueryEvent(BugzillaQuery.this.issues.size(), autoRefresh);
                        Bugzilla.LOG.log(Level.FINE, "refresh finish - {0} [{1}]", new String[]{BugzillaQuery.this.name, BugzillaQuery.this.urlParameters});
                        throw throwable;
                    }
                    Bugzilla.LOG.log(Level.FINE, "refresh finish - {0} [{1}]", new String[]{BugzillaQuery.this.name, BugzillaQuery.this.urlParameters});
                    return;
                }
                BugzillaQuery.this.archivedIssues.removeAll(BugzillaQuery.this.issues);
                if (BugzillaQuery.this.isSaved()) {
                    BugzillaQuery.this.repository.getIssueCache().storeQueryIssues(BugzillaQuery.this.getStoredQueryName(), BugzillaQuery.this.issues.toArray(new String[BugzillaQuery.this.issues.size()]));
                    BugzillaQuery.this.repository.getIssueCache().storeArchivedQueryIssues(BugzillaQuery.this.getStoredQueryName(), BugzillaQuery.this.archivedIssues.toArray(new String[BugzillaQuery.this.archivedIssues.size()]));
                }
                queryIssues.addAll(BugzillaQuery.this.issues);
                BugzillaQuery.this.getController().switchToDeterminateProgress(queryIssues.size());
                GetMultiTaskDataCommand dataCmd = new GetMultiTaskDataCommand(BugzillaQuery.this.repository, queryIssues, new IssuesCollector());
                BugzillaQuery.this.repository.getExecutor().execute(dataCmd, !autoRefresh);
                ret[0] = dataCmd.hasFailed();
                BugzillaQuery.this.logQueryEvent(BugzillaQuery.this.issues.size(), autoRefresh);
                Bugzilla.LOG.log(Level.FINE, "refresh finish - {0} [{1}]", new String[]{BugzillaQuery.this.name, BugzillaQuery.this.urlParameters});
            }
        });
        return ret[0];
    }

    public String getStoredQueryName() {
        return this.getDisplayName();
    }

    protected void logQueryEvent(int count, boolean autoRefresh) {
        BugtrackingUtil.logQueryEvent((String)BugzillaConnector.getConnectorName(), (String)this.name, (int)count, (boolean)false, (boolean)autoRefresh);
    }

    void refresh(String urlParameters, boolean autoReresh) {
        assert (urlParameters != null);
        this.urlParameters = urlParameters;
        this.refreshIntern(autoReresh);
    }

    void remove() {
        this.repository.removeQuery(this);
        this.fireQueryRemoved();
    }

    public int getIssueStatus(Issue issue) {
        String id = issue.getID();
        return this.getIssueStatus(id);
    }

    public boolean contains(Issue issue) {
        return this.issues.contains(issue.getID());
    }

    public Node[] getSelection() {
        return super.getSelection();
    }

    public int getIssueStatus(String id) {
        return this.repository.getIssueCache().getStatus(id);
    }

    int getSize() {
        return this.issues.size();
    }

    public String getUrlParameters() {
        return this.getController().getUrlParameters();
    }

    public boolean isUrlDefined() {
        return this.getController().isUrlDefined();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setSaved(boolean saved) {
        super.setSaved(saved);
    }

    public void fireQuerySaved() {
        super.fireQuerySaved();
        this.repository.fireQueryListChanged();
    }

    public void fireQueryRemoved() {
        super.fireQueryRemoved();
        this.repository.fireQueryListChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Issue[] getIssues(int includeStatus) {
        if (this.issues == null) {
            return new Issue[0];
        }
        ArrayList<String> ids = new ArrayList<String>();
        Set<String> set = this.issues;
        synchronized (set) {
            ids.addAll(this.issues);
        }
        IssueCache<TaskData> cache = this.repository.getIssueCache();
        ArrayList<Issue> ret = new ArrayList<Issue>();
        for (String id : ids) {
            int status = this.getIssueStatus(id);
            if ((status & includeStatus) == 0) continue;
            ret.add(cache.getIssue(id));
        }
        return ret.toArray(new Issue[ret.size()]);
    }

    boolean wasRun() {
        return !this.firstRun;
    }

    private class IssuesCollector
    extends TaskDataCollector {
        public void accept(TaskData taskData) {
            BugzillaIssue issue;
            String id = BugzillaIssue.getID(taskData);
            BugzillaQuery.this.getController().addProgressUnit(BugzillaIssue.getDisplayName(taskData));
            try {
                IssueCache<TaskData> cache = BugzillaQuery.this.repository.getIssueCache();
                issue = (BugzillaIssue)cache.setIssueData(id, (Object)taskData);
            }
            catch (IOException ex) {
                Bugzilla.LOG.log(Level.SEVERE, null, ex);
                return;
            }
            BugzillaQuery.this.fireNotifyData(issue);
        }
    }

    private class IssuesIdCollector
    extends TaskDataCollector {
        public void accept(TaskData taskData) {
            String id = BugzillaIssue.getID(taskData);
            BugzillaQuery.this.issues.add(id);
        }
    }
}

