/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.wizards.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.hibernate.wizards.support.Table;
import org.netbeans.modules.hibernate.wizards.support.TableProvider;
import org.openide.util.ChangeSupport;

public class TableClosure {
    private final Set<Table> tables;
    private final Set<Table> availableTables = new HashSet<Table>();
    private final Set<Table> wantedTables = new HashSet<Table>();
    private final Set<Table> selectedTables = new HashSet<Table>();
    private final Set<Table> referencedTables = new HashSet<Table>();
    private final Set<Table> unmodifAvailableTables = Collections.unmodifiableSet(this.availableTables);
    private final Set<Table> unmodifWantedTables = Collections.unmodifiableSet(this.wantedTables);
    private final Set<Table> unmodifSelectedTables = Collections.unmodifiableSet(this.selectedTables);
    private final Set<Table> unmodifReferencedTables = Collections.unmodifiableSet(this.referencedTables);
    private boolean closureEnabled = true;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    public TableClosure(TableProvider tableProvider) {
        this.tables = tableProvider.getTables();
        this.availableTables.addAll(this.tables);
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public Set<Table> getAvailableTables() {
        return this.unmodifAvailableTables;
    }

    public Set<Table> getSelectedTables() {
        return this.unmodifSelectedTables;
    }

    public Set<Table> getReferencedTables() {
        return this.unmodifReferencedTables;
    }

    Set<Table> getWantedTables() {
        return this.unmodifWantedTables;
    }

    public void addTables(Set<Table> set) {
        if (!this.canAddAllTables(set)) {
            return;
        }
        if (this.closureEnabled) {
            if (this.wantedTables.addAll(set)) {
                Set<Table> set2 = TableClosure.removeDisabledTables(this.getReferencedTablesTransitively(set));
                HashSet<Table> hashSet = new HashSet<Table>(set);
                hashSet.addAll(set2);
                this.selectedTables.addAll(hashSet);
                this.referencedTables.addAll(set2);
                this.availableTables.removeAll(hashSet);
                Set<Table> set3 = TableClosure.removeDisabledTables(this.getJoinTablesTransitively(hashSet));
                set3.removeAll(this.selectedTables);
                this.selectedTables.addAll(set3);
                this.referencedTables.addAll(set3);
                this.availableTables.removeAll(set3);
                this.changeSupport.fireChange();
            }
        } else {
            this.wantedTables.addAll(set);
            this.selectedTables.addAll(set);
            this.availableTables.removeAll(set);
            this.changeSupport.fireChange();
        }
    }

    public void removeTables(Set<Table> set) {
        if (!this.canRemoveAllTables(set)) {
            return;
        }
        if (this.closureEnabled) {
            if (this.wantedTables.removeAll(set)) {
                this.redoClosure();
                this.changeSupport.fireChange();
            }
        } else {
            this.wantedTables.removeAll(set);
            this.selectedTables.removeAll(set);
            this.availableTables.addAll(set);
            this.changeSupport.fireChange();
        }
    }

    public void addAllTables() {
        this.wantedTables.clear();
        for (Table table : this.tables) {
            if (table.isDisabled()) continue;
            this.wantedTables.add(table);
        }
        if (this.closureEnabled) {
            this.redoClosure();
            this.changeSupport.fireChange();
        } else {
            this.selectedTables.addAll(this.wantedTables);
            this.availableTables.addAll(this.tables);
            this.availableTables.removeAll(this.wantedTables);
            this.changeSupport.fireChange();
        }
    }

    public void removeAllTables() {
        this.wantedTables.clear();
        this.selectedTables.clear();
        this.referencedTables.clear();
        this.availableTables.addAll(this.tables);
        this.changeSupport.fireChange();
    }

    public boolean getClosureEnabled() {
        return this.closureEnabled;
    }

    public void setClosureEnabled(boolean bl) {
        if (this.closureEnabled == bl) {
            return;
        }
        this.closureEnabled = bl;
        if (bl) {
            this.redoClosure();
        } else {
            this.selectedTables.clear();
            this.selectedTables.addAll(this.wantedTables);
            this.referencedTables.clear();
            this.availableTables.addAll(this.tables);
            this.availableTables.removeAll(this.wantedTables);
        }
        this.changeSupport.fireChange();
    }

    public boolean canAddAllTables(Set<Table> set) {
        if (set.size() <= 0) {
            return false;
        }
        for (Table table : set) {
            if (!table.isDisabled()) continue;
            return false;
        }
        return true;
    }

    public boolean canAddSomeTables(Set<Table> set) {
        if (set.size() <= 0) {
            return false;
        }
        for (Table table : set) {
            if (table.isDisabled()) continue;
            return true;
        }
        return false;
    }

    public boolean canRemoveAllTables(Set<Table> set) {
        if (set.size() <= 0) {
            return false;
        }
        if (!this.closureEnabled) {
            return true;
        }
        for (Table table : set) {
            if (!this.referencedTables.contains(table)) continue;
            return false;
        }
        return true;
    }

    private void redoClosure() {
        this.referencedTables.clear();
        this.referencedTables.addAll(TableClosure.removeDisabledTables(this.getReferencedTablesTransitively(this.wantedTables)));
        this.selectedTables.clear();
        this.selectedTables.addAll(this.wantedTables);
        this.selectedTables.addAll(this.referencedTables);
        Set<Table> set = TableClosure.removeDisabledTables(this.getJoinTablesTransitively(this.selectedTables));
        set.removeAll(this.selectedTables);
        this.selectedTables.addAll(set);
        this.referencedTables.addAll(set);
        this.availableTables.clear();
        this.availableTables.addAll(this.tables);
        this.availableTables.removeAll(this.selectedTables);
    }

    private Set<Table> getReferencedTablesTransitively(Set<Table> set) {
        Queue<Table> queue = new Queue<Table>(set);
        HashSet<Table> hashSet = new HashSet<Table>();
        while (!queue.isEmpty()) {
            Table table = queue.poll();
            for (Table table2 : table.getReferencedTables()) {
                if (!table2.equals(table)) {
                    hashSet.add(table2);
                }
                queue.offer(table2);
            }
        }
        return hashSet;
    }

    private Set<Table> getJoinTablesTransitively(Set<Table> set) {
        Queue<Table> queue = new Queue<Table>(set);
        HashSet<Table> hashSet = new HashSet<Table>();
        while (!queue.isEmpty()) {
            Table table = queue.poll();
            for (Table table2 : table.getJoinTables()) {
                if (!this.areReferencedTablesSelected(table2, hashSet)) continue;
                hashSet.add(table2);
                queue.offer(table2);
            }
        }
        return hashSet;
    }

    private boolean areReferencedTablesSelected(Table table, Set<Table> set) {
        for (Table table2 : table.getReferencedTables()) {
            if (this.selectedTables.contains(table2) || set.contains(table2)) continue;
            return false;
        }
        return true;
    }

    private static Set<Table> removeDisabledTables(Set<Table> set) {
        Iterator<Table> iterator = set.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isDisabled()) continue;
            iterator.remove();
        }
        return set;
    }

    static final class Queue<T> {
        private final List<T> queue;
        private final Set<T> contents;
        private int currentIndex;

        public Queue(Set<T> set) {
            assert (!set.contains(null));
            this.queue = new ArrayList<T>(set);
            this.contents = new HashSet<T>(set);
        }

        public void offer(T t) {
            assert (t != null);
            if (!this.contents.contains(t)) {
                this.contents.add(t);
                this.queue.add(t);
            }
        }

        public boolean isEmpty() {
            return this.currentIndex >= this.queue.size();
        }

        public T poll() {
            T t = null;
            if (!this.isEmpty()) {
                t = this.queue.get(this.currentIndex);
                ++this.currentIndex;
            }
            return t;
        }
    }
}

