/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hibernate.completion;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import java.io.IOException;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.hibernate.completion.HibernateCompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.LazyCompletionItem;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.Exceptions;

public class LazyTypeCompletionItem
extends HibernateCompletionItem
implements LazyCompletionItem {
    private ElementHandle<TypeElement> eh;
    private JavaSource javaSource;
    private String name;
    private HibernateCompletionItem delegate;
    private String simpleName;
    private String pkgName;
    private int prefWidth = -1;
    private String sortText;

    public static LazyTypeCompletionItem create(int n, ElementHandle<TypeElement> elementHandle, JavaSource javaSource) {
        return new LazyTypeCompletionItem(n, elementHandle, javaSource);
    }

    private LazyTypeCompletionItem(int n, ElementHandle<TypeElement> elementHandle, JavaSource javaSource) {
        super(n);
        this.eh = elementHandle;
        this.javaSource = javaSource;
        this.name = elementHandle.getQualifiedName();
        int n2 = this.name.lastIndexOf(46);
        this.simpleName = n2 > -1 ? this.name.substring(n2 + 1) : this.name;
        this.pkgName = n2 > -1 ? this.name.substring(0, n2) : "";
        this.sortText = this.simpleName + HibernateCompletionItem.getImportanceLevel(this.pkgName) + "#" + this.pkgName;
    }

    public boolean accept() {
        if (this.eh != null) {
            try {
                this.javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                    public void run(CompilationController compilationController) throws Exception {
                        compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                        TypeElement typeElement = (TypeElement)LazyTypeCompletionItem.this.eh.resolve((CompilationInfo)compilationController);
                        if (typeElement != null && LazyTypeCompletionItem.isAccessibleClass(typeElement)) {
                            LazyTypeCompletionItem.this.delegate = HibernateCompletionItem.createTypeItem(LazyTypeCompletionItem.this.substitutionOffset, typeElement, (ElementHandle<TypeElement>)LazyTypeCompletionItem.this.eh, compilationController.getElements().isDeprecated(typeElement), true);
                        }
                        LazyTypeCompletionItem.this.eh = null;
                    }
                }, true);
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
        }
        return this.delegate != null;
    }

    private static boolean isAccessibleClass(TypeElement typeElement) {
        NestingKind nestingKind = typeElement.getNestingKind();
        return nestingKind == NestingKind.TOP_LEVEL || nestingKind == NestingKind.MEMBER && typeElement.getModifiers().contains((Object)Modifier.STATIC);
    }

    public int getSortPriority() {
        return 200;
    }

    public CharSequence getSortText() {
        return this.sortText;
    }

    public CharSequence getInsertPrefix() {
        return this.simpleName;
    }

    @Override
    public String getDisplayText() {
        return this.simpleName;
    }

    @Override
    public CompletionTask createDocumentationTask() {
        if (this.delegate != null) {
            return this.delegate.createDocumentationTask();
        }
        return null;
    }

    @Override
    public CompletionTask createToolTipTask() {
        if (this.delegate != null) {
            return this.delegate.createToolTipTask();
        }
        return null;
    }

    @Override
    public void defaultAction(JTextComponent jTextComponent) {
        if (this.delegate != null) {
            this.delegate.defaultAction(jTextComponent);
        }
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        if (this.delegate != null) {
            this.delegate.processKeyEvent(keyEvent);
        }
    }

    @Override
    public int getPreferredWidth(Graphics graphics, Font font) {
        if (this.prefWidth < 0) {
            this.prefWidth = CompletionUtilities.getPreferredWidth((String)(this.simpleName + " (" + this.pkgName + ")"), null, (Graphics)graphics, (Font)font);
        }
        return this.prefWidth;
    }

    @Override
    public void render(Graphics graphics, Font font, Color color, Color color2, int n, int n2, boolean bl) {
        if (this.delegate != null) {
            this.delegate.render(graphics, font, color, color2, n, n2, bl);
        }
    }
}

