/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nativeexecution.api.util;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.nativeexecution.api.util.Shell;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.netbeans.modules.nativeexecution.support.ui.ShellValidationStatusPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public final class ShellValidationSupport {
    protected static final ShellValidationStatus NOSHELL = new ShellValidationStatus(null, Arrays.asList("No shell"), null);
    protected static final ShellValidationStatus VALID = new ShellValidationStatus(null, null, null);

    private ShellValidationSupport() {
    }

    public static ShellValidationStatus getValidationStatus(Shell shell) {
        if (shell == null) {
            return NOSHELL;
        }
        if (shell.type == Shell.ShellType.CYGWIN) {
            return ShellValidationSupport.validateCygwinShell(shell);
        }
        return VALID;
    }

    private static ShellValidationStatus validateCygwinShell(Shell shell) {
        assert (shell != null && shell.type == Shell.ShellType.CYGWIN);
        ArrayList<String> validationErrors = new ArrayList<String>();
        ArrayList<String> validationWarnings = new ArrayList<String>();
        try {
            File mount_util = new File(shell.bindir, "mount.exe");
            File cygpath_util = new File(shell.bindir, "cygpath.exe");
            if (!mount_util.exists()) {
                validationErrors.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.fileNotFound", mount_util.getAbsolutePath()));
            }
            if (!cygpath_util.exists()) {
                validationErrors.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.fileNotFound", cygpath_util.getAbsolutePath()));
            }
            ProcessBuilder pb = new ProcessBuilder(mount_util.getAbsolutePath());
            Process p = pb.start();
            List<String> output = ProcessUtils.readProcessOutput(p);
            int res = p.waitFor();
            if (res != 0) {
                validationErrors.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.validationFailed", shell.bindir.getAbsolutePath()));
            }
            Pattern pattern = Pattern.compile("(.*) on (/.*) type .*");
            boolean rootIsMounted = false;
            for (String line : output) {
                Matcher m = pattern.matcher(line);
                if (!m.matches()) continue;
                String winpath = m.group(1);
                File winfile = new File(winpath);
                String cygpath = m.group(2);
                if (cygpath.equals("/")) {
                    rootIsMounted = true;
                }
                if (!winfile.exists()) {
                    validationErrors.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.absentMountPoint", winpath, cygpath));
                    continue;
                }
                if (!cygpath.startsWith("/usr")) continue;
                String p1 = (winfile.getParentFile().getAbsolutePath() + '\\').toLowerCase();
                String p2 = (shell.bindir.getParentFile().getAbsolutePath() + '\\').toLowerCase();
                if (p2.startsWith(p1)) continue;
                validationWarnings.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.wrongMountPoint", winpath, cygpath));
            }
            if (!rootIsMounted) {
                validationErrors.add(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.rootIsNotMounted", new String[0]));
            }
        }
        catch (InterruptedException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new ShellValidationStatus(shell, validationErrors, validationWarnings);
    }

    public static boolean confirm(ShellValidationStatus status) {
        return ShellValidationSupport.confirm(null, null, status);
    }

    public static boolean confirm(String header, String footer, ShellValidationStatus status) {
        if (status == null || status == NOSHELL) {
            if (Boolean.getBoolean("nativeexecution.mode.unittest")) {
                System.err.println(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.NoShell", new String[0]));
            } else {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)ShellValidationSupport.loc("ShellValidationSupport.ValidationError.NoShell", new String[0]), 0));
            }
            return false;
        }
        if (status.isValid() && !status.hasWarnings()) {
            return true;
        }
        String key = status.shell.toString();
        String allowBroken = NbPreferences.forModule(WindowsSupport.class).get(key, "no");
        if ("yes".equals(allowBroken)) {
            return true;
        }
        Object response = null;
        if (Boolean.getBoolean("nativeexecution.mode.unittest")) {
            System.err.println(ShellValidationSupport.loc("ShellValidationSupport.ValidationError.ErrorDialogTitle", "cygwin"));
            System.err.println(header);
            for (String error : status.shell.getValidationStatus().getErrors()) {
                System.err.println(error);
            }
            System.err.println(footer);
            response = DialogDescriptor.YES_OPTION;
        } else {
            final ShellValidationStatusPanel errorPanel = new ShellValidationStatusPanel(header, footer, status.shell);
            final JButton noButton = new JButton("No");
            errorPanel.setActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    noButton.setEnabled(!errorPanel.isRememberDecision());
                }
            });
            DialogDescriptor dd = new DialogDescriptor((Object)errorPanel, ShellValidationSupport.loc("ShellValidationSupport.ValidationError.ErrorDialogTitle", "cygwin"), true, new Object[]{DialogDescriptor.YES_OPTION, noButton}, (Object)noButton, 0, null, null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dd);
            dialog.setVisible(true);
            response = dd.getValue();
            if (response == DialogDescriptor.YES_OPTION && errorPanel.isRememberDecision()) {
                NbPreferences.forModule(WindowsSupport.class).put(key, "yes");
            }
        }
        return response == DialogDescriptor.YES_OPTION;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(ShellValidationSupport.class, (String)key, (Object[])params);
    }

    public static class ShellValidationStatus {
        private final List<String> errors = new ArrayList<String>();
        private final List<String> warnings = new ArrayList<String>();
        private final Shell shell;

        private ShellValidationStatus(Shell shell, List<String> errors, List<String> warnings) {
            if (errors != null) {
                this.errors.addAll(errors);
            }
            if (warnings != null) {
                this.warnings.addAll(warnings);
            }
            this.shell = shell;
        }

        public boolean isValid() {
            return this.errors.isEmpty();
        }

        public List<String> getErrors() {
            return Collections.unmodifiableList(this.errors);
        }

        public List<String> getWarnings() {
            return Collections.unmodifiableList(this.warnings);
        }

        public boolean hasWarnings() {
            return !this.warnings.isEmpty();
        }
    }
}

