/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi.jna;

import com.sun.jna.Native;
import java.nio.channels.ByteChannel;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyModule;
import org.jruby.nb.ext.ffi.FFIProvider;
import org.jruby.nb.ext.ffi.Factory;
import org.jruby.nb.ext.ffi.Platform;
import org.jruby.nb.ext.ffi.jna.FileDescriptorByteChannel;
import org.jruby.nb.ext.ffi.jna.JNABuffer;
import org.jruby.nb.ext.ffi.jna.JNAMemoryPointer;
import org.jruby.nb.ext.ffi.jna.JNAPlatform;
import org.jruby.nb.ext.ffi.jna.JNAProvider;

public class JNAFactory
extends Factory {
    private final JNAPlatform platform = new JNAPlatform();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init(Ruby runtime, RubyModule module) {
        super.init(runtime, module);
        RubyModule rubyModule = module;
        synchronized (rubyModule) {
            if (module.fastGetClass("MemoryPointer") == null) {
                JNAMemoryPointer.createMemoryPointerClass(runtime);
            }
            if (module.fastGetClass("Buffer") == null) {
                JNABuffer.createBufferClass(runtime);
            }
        }
    }

    @Override
    protected FFIProvider newProvider(Ruby runtime) {
        return new JNAProvider(runtime);
    }

    @Override
    public <T> T loadLibrary(String libraryName, Class<T> libraryClass) {
        return libraryClass.cast(Native.loadLibrary((String)libraryName, libraryClass));
    }

    @Override
    public Platform getPlatform() {
        return this.platform;
    }

    @Override
    public ByteChannel newByteChannel(int fd) {
        return new FileDescriptorByteChannel(fd);
    }
}

