/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ext.ffi;

import java.nio.ByteBuffer;
import org.jruby.nb.RubyNumeric;
import org.jruby.nb.RubyString;
import org.jruby.nb.javasupport.JavaObject;
import org.jruby.nb.javasupport.JavaUtil;
import org.jruby.nb.runtime.builtin.IRubyObject;

public final class Util {
    private Util() {
    }

    public static final byte int8Value(IRubyObject parameter) {
        long value = Util.longValue(parameter);
        if (value < -128L || value > 127L) {
            throw parameter.getRuntime().newRangeError("Value " + value + " outside char range");
        }
        return (byte)value;
    }

    public static final short uint8Value(IRubyObject parameter) {
        long value = Util.longValue(parameter);
        if (value < 0L || value > 255L) {
            throw parameter.getRuntime().newRangeError("Value " + value + " outside unsigned char range");
        }
        return (short)value;
    }

    public static final short int16Value(IRubyObject parameter) {
        long value = Util.longValue(parameter);
        if (value < -32768L || value > 32767L) {
            throw parameter.getRuntime().newRangeError("Value " + value + " outside short range");
        }
        return (short)value;
    }

    public static final int uint16Value(IRubyObject parameter) {
        long value = Util.longValue(parameter);
        if (value < 0L || value > 65535L) {
            throw parameter.getRuntime().newRangeError("Value " + value + " outside unsigned short range");
        }
        return (int)value;
    }

    public static final int int32Value(IRubyObject parameter) {
        long value = Util.longValue(parameter);
        if (value < Integer.MIN_VALUE || value > 0xFFFFFFFFL) {
            throw parameter.getRuntime().newRangeError("Value " + value + " outside integer range");
        }
        return (int)value;
    }

    public static final long uint32Value(IRubyObject parameter) {
        long value = Util.longValue(parameter);
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw parameter.getRuntime().newRangeError("Value " + value + " outside unsigned integer range");
        }
        return value;
    }

    public static final long int64Value(IRubyObject parameter) {
        return Util.longValue(parameter);
    }

    public static final long uint64Value(IRubyObject parameter) {
        long value = Util.longValue(parameter);
        if (value < 0L) {
            throw parameter.getRuntime().newRangeError("Value " + value + " outside unsigned long long range");
        }
        return value;
    }

    public static final float floatValue(IRubyObject parameter) {
        double value = RubyNumeric.num2dbl(parameter);
        if (value < (double)1.4E-45f || value > 3.4028234663852886E38) {
            throw parameter.getRuntime().newRangeError("Value " + value + " outside float range");
        }
        return (float)value;
    }

    public static final double doubleValue(IRubyObject parameter) {
        return RubyNumeric.num2dbl(parameter);
    }

    public static final long longValue(IRubyObject parameter) {
        if (parameter instanceof RubyNumeric) {
            return ((RubyNumeric)parameter).getLongValue();
        }
        if (parameter.isNil()) {
            return 0L;
        }
        if (parameter instanceof RubyString) {
            return Util.longValue((RubyString)parameter);
        }
        throw parameter.getRuntime().newRangeError("Value " + parameter + " is not an integer");
    }

    private static final long longValue(RubyString parameter) {
        String cs = parameter.asJavaString();
        if (cs.length() == 1) {
            return cs.charAt(0);
        }
        throw parameter.getRuntime().newRangeError("Value " + parameter + " is not an integer");
    }

    public static final <T> T convertParameter(IRubyObject parameter, Class<T> paramClass) {
        return paramClass.cast(parameter instanceof JavaObject ? ((JavaObject)parameter).getValue() : JavaUtil.convertRubyToJava(parameter, paramClass));
    }

    public static final ByteBuffer slice(ByteBuffer buf, int offset) {
        ByteBuffer tmp = buf.duplicate();
        tmp.position(offset);
        return tmp.slice();
    }
}

