/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.environment;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.util.Map;
import org.jruby.nb.Ruby;
import org.jruby.nb.environment.IOSEnvironmentReader;
import org.jruby.nb.environment.OSEnvironment;
import org.jruby.nb.environment.OSEnvironmentReaderExcepton;

class OSEnvironmentReaderFromFile
implements IOSEnvironmentReader {
    private static final String JRUBY_ENVFILE = "jruby.envfile";
    private final OSEnvironment environmentReader = new OSEnvironment();

    OSEnvironmentReaderFromFile() {
    }

    @Override
    public boolean isAccessible(Ruby runtime) {
        String jrubyEnvFilename = System.getProperty(JRUBY_ENVFILE);
        if (jrubyEnvFilename == null || jrubyEnvFilename.length() < 1) {
            return false;
        }
        File jrubyEnvFile = new File(jrubyEnvFilename);
        return jrubyEnvFile.exists() && !jrubyEnvFile.isDirectory() && jrubyEnvFile.canRead();
    }

    @Override
    public Map getVariables(Ruby runtime) {
        String jrubyEnvFilename = System.getProperty(JRUBY_ENVFILE);
        Map envs = null;
        if (jrubyEnvFilename == null || jrubyEnvFilename.length() < 1) {
            this.environmentReader.handleException(new OSEnvironmentReaderExcepton("Property jruby.envfile not defined."));
        } else {
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(jrubyEnvFilename));
            }
            catch (FileNotFoundException e) {
                envs = null;
                this.environmentReader.handleException(e);
            }
            envs = this.environmentReader.getVariablesFrom(reader);
        }
        return envs;
    }
}

