/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation.graph;

import java.awt.Point;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.modules.web.jsf.navigation.graph.PageFlowSceneData;
import org.netbeans.modules.web.jsf.navigation.graph.XmlScope;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.xml.XMLUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SceneSerializer {
    private static final String SCENE_ELEMENT = "Scene";
    private static final String SCENE_LAST_USED_SCOPE_ATTR = "Scope";
    private static final String SCENE_SCOPE_ATTR = "Scope";
    private static final String SCENE_SCOPE_ELEMENT = "Scope";
    private static final String VERSION_ATTR = "version";
    private static final String NODE_ELEMENT = "Node";
    private static final String NODE_ID_ATTR = "id";
    private static final String NODE_X_ATTR = "x";
    private static final String NODE_Y_ATTR = "y";
    private static final String NODE_ZOOM_ATTR = "zoom";
    private static final String VERSION_VALUE_1 = "1";
    private static final String VERSION_VALUE_2 = "2";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.web.jsf.navigation");

    private SceneSerializer() {
    }

    public static void serialize(PageFlowSceneData sceneData, FileObject file) {
        Node scopeAllElement;
        Node scopeProjectElement;
        if (file == null || !file.isValid()) {
            LOG.warning("Can not serialize locations because file is null.");
            return;
        }
        LOG.entering("SceneSerializer", "serialize");
        Document document = XMLUtil.createDocument((String)SCENE_ELEMENT, null, null, null);
        Node sceneElement = document.getFirstChild();
        SceneSerializer.setAttribute(document, sceneElement, VERSION_ATTR, VERSION_VALUE_2);
        SceneSerializer.setAttribute(document, sceneElement, "Scope", XmlScope.getInstance(sceneData.getCurrentScopeStr()).toString());
        Node scopeFacesElement = SceneSerializer.createScopeElement(document, sceneData, XmlScope.SCOPE_FACES);
        if (scopeFacesElement != null) {
            sceneElement.appendChild(scopeFacesElement);
        }
        if ((scopeProjectElement = SceneSerializer.createScopeElement(document, sceneData, XmlScope.SCOPE_PROJECT)) != null) {
            sceneElement.appendChild(scopeProjectElement);
        }
        if ((scopeAllElement = SceneSerializer.createScopeElement(document, sceneData, XmlScope.SCOPE_ALL)) != null) {
            sceneElement.appendChild(scopeAllElement);
        }
        SceneSerializer.writeToFile(document, file);
        LOG.finest("Serializing to the follwoing file: " + file.toString());
        LOG.exiting("SceneSerializer", "serialize");
    }

    private static final Node createScopeElement(Document document, PageFlowSceneData sceneData, XmlScope scopeXml) {
        Element sceneScopeElement = null;
        Map<String, PageFlowSceneData.PageData> facesConfigScopeMap = sceneData.getScopeData(scopeXml.getScope());
        if (facesConfigScopeMap != null) {
            sceneScopeElement = document.createElement("Scope");
            SceneSerializer.setAttribute(document, sceneScopeElement, "Scope", scopeXml.toString());
            for (String key : facesConfigScopeMap.keySet()) {
                PageFlowSceneData.PageData data = facesConfigScopeMap.get(key);
                if (data == null) continue;
                Element nodeElement = document.createElement(NODE_ELEMENT);
                SceneSerializer.setAttribute(document, nodeElement, NODE_ID_ATTR, key);
                SceneSerializer.setAttribute(document, nodeElement, NODE_X_ATTR, Integer.toString(data.getPoint().x));
                SceneSerializer.setAttribute(document, nodeElement, NODE_Y_ATTR, Integer.toString(data.getPoint().y));
                SceneSerializer.setAttribute(document, nodeElement, NODE_ZOOM_ATTR, Boolean.toString(data.isMinimized()));
                sceneScopeElement.appendChild(nodeElement);
            }
        }
        return sceneScopeElement;
    }

    private static final void writeToFile(final Document document, final FileObject file) {
        try {
            FileSystem fs = file.getFileSystem();
            fs.runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    FileLock lock = file.lock();
                    OutputStream fos = file.getOutputStream(lock);
                    try {
                        XMLUtil.write((Document)document, (OutputStream)fos, (String)"UTF-8");
                        fos.close();
                    }
                    finally {
                        lock.releaseLock();
                    }
                }
            });
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static void deserializeV1(PageFlowSceneData sceneData, FileObject file) {
        LOG.entering("SceneSerializer", "deserializeV1(PageFlowSceneData sceneData, File file)");
        Node sceneElement = SceneSerializer.getRootNode(file);
        HashMap<String, PageFlowSceneData.PageData> sceneInfo = new HashMap<String, PageFlowSceneData.PageData>();
        for (Node element : SceneSerializer.getChildNode(sceneElement)) {
            if (!NODE_ELEMENT.equals(element.getNodeName())) continue;
            String pageId = SceneSerializer.getAttributeValue(element, NODE_ID_ATTR);
            int x = Integer.parseInt(SceneSerializer.getAttributeValue(element, NODE_X_ATTR));
            int y = Integer.parseInt(SceneSerializer.getAttributeValue(element, NODE_Y_ATTR));
        }
        sceneData.setScopeData(XmlScope.SCOPE_PROJECT.getScope(), sceneInfo);
        LOG.exiting("SceneSerializer", "deserialize");
    }

    public static void deserialize(PageFlowSceneData sceneData, FileObject file) {
        LOG.entering("SceneSerializer", "deserialize(PageFlowSceneData sceneData, File file)");
        Node sceneElement = SceneSerializer.getRootNode(file);
        if (VERSION_VALUE_1.equals(SceneSerializer.getAttributeValue(sceneElement, VERSION_ATTR))) {
            SceneSerializer.deserializeV1(sceneData, file);
        } else if (VERSION_VALUE_2.equals(SceneSerializer.getAttributeValue(sceneElement, VERSION_ATTR))) {
            String lastUsedScopeXML = SceneSerializer.getAttributeValue(sceneElement, "Scope");
            XmlScope lastUsedScope = XmlScope.getInstance(lastUsedScopeXML);
            sceneData.setCurrentScope(lastUsedScope.getScope());
            LOG.fine("Last Used Scope: " + lastUsedScope);
            NodeList scopeNodes = sceneElement.getChildNodes();
            for (int i = 0; i < scopeNodes.getLength(); ++i) {
                Node scopeElement = scopeNodes.item(i);
                if (!scopeElement.getNodeName().equals("Scope")) continue;
                String scopeXMLStr = SceneSerializer.getAttributeValue(scopeElement, "Scope");
                NodeList pageNodes = scopeElement.getChildNodes();
                HashMap<String, PageFlowSceneData.PageData> sceneInfo = new HashMap<String, PageFlowSceneData.PageData>();
                for (int j = 0; j < pageNodes.getLength(); ++j) {
                    Node pageNode = pageNodes.item(j);
                    if (!pageNode.getNodeName().equals(NODE_ELEMENT)) continue;
                    String pageDisplayName = SceneSerializer.getAttributeValue(pageNode, NODE_ID_ATTR);
                    int x = Integer.parseInt(SceneSerializer.getAttributeValue(pageNode, NODE_X_ATTR));
                    int y = Integer.parseInt(SceneSerializer.getAttributeValue(pageNode, NODE_Y_ATTR));
                    boolean isMinimized = false;
                    String zoom = SceneSerializer.getAttributeValue(pageNode, NODE_ZOOM_ATTR);
                    if (zoom != null) {
                        isMinimized = Boolean.parseBoolean(zoom);
                    }
                    PageFlowSceneData.PageData data = PageFlowSceneData.createPageData(new Point(x, y), isMinimized);
                    sceneInfo.put(pageDisplayName, data);
                }
                sceneData.setScopeData(XmlScope.getInstance(scopeXMLStr).getScope(), sceneInfo);
            }
        }
        LOG.exiting("SceneSerializer", "deserialize(PageFlowSceneData sceneData, File file)");
    }

    private static void setAttribute(Document xml, Node node, String name, String value) {
        NamedNodeMap map = node.getAttributes();
        Attr attribute = xml.createAttribute(name);
        attribute.setValue(value);
        map.setNamedItem(attribute);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node getRootNode(FileObject file) {
        InputStream is = null;
        try {
            is = file.getInputStream();
            Document doc = XMLUtil.parse((InputSource)new InputSource(is), (boolean)false, (boolean)false, (ErrorHandler)new ErrorHandler(){

                @Override
                public void error(SAXParseException e) throws SAXException {
                    throw new SAXException(e);
                }

                @Override
                public void fatalError(SAXParseException e) throws SAXException {
                    throw new SAXException(e);
                }

                @Override
                public void warning(SAXParseException e) {
                    Exceptions.printStackTrace((Throwable)e);
                }
            }, null);
            Node node = doc.getFirstChild();
            return node;
        }
        catch (Exception e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return null;
    }

    private static String getAttributeValue(Node node, String attr) {
        try {
            Node mynode;
            NamedNodeMap map;
            if (node != null && (map = node.getAttributes()) != null && (mynode = map.getNamedItem(attr)) != null) {
                return mynode.getNodeValue();
            }
        }
        catch (DOMException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    private static Node[] getChildNode(Node node) {
        NodeList childNodes = node.getChildNodes();
        Node[] nodes = new Node[childNodes != null ? childNodes.getLength() : 0];
        for (int i = 0; i < nodes.length; ++i) {
            nodes[i] = childNodes.item(i);
        }
        return nodes;
    }
}

