/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.hibernate.MappingException;
import org.hibernate.cfg.Configuration;
import org.hibernate.cfg.JDBCBinder;
import org.hibernate.cfg.reveng.DefaultReverseEngineeringStrategy;
import org.hibernate.cfg.reveng.ReverseEngineeringStrategy;
import org.hibernate.engine.Mapping;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.type.Type;

public class JDBCMetaDataConfiguration
extends Configuration {
    private static final Log log = LogFactory.getLog((Class)JDBCMetaDataConfiguration.class);
    private ReverseEngineeringStrategy revEngStrategy = new DefaultReverseEngineeringStrategy();
    private boolean ignoreconfigxmlmapppings = true;
    private boolean preferBasicCompositeIds = true;

    protected void secondPassCompileForeignKeys(Table table, Set done) throws MappingException {
        super.secondPassCompileForeignKeys(table, done);
    }

    public void readFromJDBC() {
        JDBCBinder binder = new JDBCBinder(this, this.buildSettings(), this.createMappings(), this.revEngStrategy);
        binder.readFromDatabase(null, null, JDBCMetaDataConfiguration.buildMapping(this));
    }

    private static Mapping buildMapping(final Configuration cfg) {
        return new Mapping(){

            public Type getIdentifierType(String persistentClass) throws MappingException {
                PersistentClass pc = cfg.getClassMapping(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                return pc.getIdentifier().getType();
            }

            public String getIdentifierPropertyName(String persistentClass) throws MappingException {
                PersistentClass pc = cfg.getClassMapping(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                if (!pc.hasIdentifierProperty()) {
                    return null;
                }
                return pc.getIdentifierProperty().getName();
            }

            public Type getReferencedPropertyType(String persistentClass, String propertyName) throws MappingException {
                PersistentClass pc = cfg.getClassMapping(persistentClass);
                if (pc == null) {
                    throw new MappingException("persistent class not known: " + persistentClass);
                }
                Property prop = pc.getProperty(propertyName);
                if (prop == null) {
                    throw new MappingException("property not known: " + persistentClass + '.' + propertyName);
                }
                return prop.getType();
            }
        };
    }

    public boolean preferBasicCompositeIds() {
        return this.preferBasicCompositeIds;
    }

    public void setPreferBasicCompositeIds(boolean flag) {
        this.preferBasicCompositeIds = flag;
    }

    protected void parseMappingElement(Element subelement, String name) {
        if (!this.ignoreconfigxmlmapppings) {
            super.parseMappingElement(subelement, name);
        } else {
            log.info((Object)("Ignoring " + name + " mapping"));
        }
    }

    public void setReverseEngineeringStrategy(ReverseEngineeringStrategy reverseEngineeringStrategy) {
        this.revEngStrategy = reverseEngineeringStrategy;
    }

    public ReverseEngineeringStrategy getReverseEngineeringStrategy() {
        return this.revEngStrategy;
    }
}

