/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ExtendedNodeModel;
import org.netbeans.spi.viewmodel.ExtendedNodeModelFilter;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.NodeActionsProviderFilter;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.datatransfer.PasteType;

public class LabelVarsFilter
implements NodeActionsProviderFilter,
ExtendedNodeModelFilter {
    private final JPDADebuggerImpl debugger;
    private final List<ModelListener> listeners = new ArrayList<ModelListener>();
    private final Action MARK_OBJECT_ACTION = Models.createAction((String)NbBundle.getBundle(LabelVarsFilter.class).getString("CTL_MarkObject_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object object) {
            if (object == null || !(object instanceof ObjectVariable)) {
                return false;
            }
            ObjectVariable objectVariable = (ObjectVariable)object;
            return objectVariable.getUniqueID() != 0L;
        }

        public void perform(Object[] objectArray) {
            ObjectVariable objectVariable = (ObjectVariable)objectArray[0];
            if (objectVariable.getUniqueID() == 0L) {
                return;
            }
            String string = NbBundle.getBundle(LabelVarsFilter.class).getString("CTL_MarkObject_DLG_Title");
            String string2 = NbBundle.getBundle(LabelVarsFilter.class).getString("CTL_MarkObject_DLG_Label");
            NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(string2, string);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine);
            if (NotifyDescriptor.InputLine.OK_OPTION == object) {
                string2 = inputLine.getInputText().trim();
                if (string2.length() == 0) {
                    string2 = null;
                }
                LabelVarsFilter.this.debugger.markObject(objectVariable, string2);
                LabelVarsFilter.this.fireNodeChange(null);
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);

    public LabelVarsFilter(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
    }

    public void performDefaultAction(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        nodeActionsProvider.performDefaultAction(object);
    }

    public Action[] getActions(NodeActionsProvider nodeActionsProvider, Object object) throws UnknownTypeException {
        Action[] actionArray = nodeActionsProvider.getActions(object);
        if (object instanceof ObjectVariable) {
            int n;
            for (n = 0; n < actionArray.length && actionArray[n] != null; ++n) {
            }
            Action[] actionArray2 = new Action[actionArray.length + 1];
            System.arraycopy(actionArray, 0, actionArray2, 0, n);
            actionArray2[n] = this.MARK_OBJECT_ACTION;
            if (n < actionArray.length) {
                System.arraycopy(actionArray, n, actionArray2, n + 1, actionArray.length - n);
            }
            actionArray = actionArray2;
        }
        return actionArray;
    }

    public boolean canRename(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        return extendedNodeModel.canRename(object);
    }

    public boolean canCopy(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        return extendedNodeModel.canCopy(object);
    }

    public boolean canCut(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        return extendedNodeModel.canCut(object);
    }

    public Transferable clipboardCopy(ExtendedNodeModel extendedNodeModel, Object object) throws IOException, UnknownTypeException {
        return extendedNodeModel.clipboardCopy(object);
    }

    public Transferable clipboardCut(ExtendedNodeModel extendedNodeModel, Object object) throws IOException, UnknownTypeException {
        return extendedNodeModel.clipboardCut(object);
    }

    public PasteType[] getPasteTypes(ExtendedNodeModel extendedNodeModel, Object object, Transferable transferable) throws UnknownTypeException {
        return extendedNodeModel.getPasteTypes(object, transferable);
    }

    public void setName(ExtendedNodeModel extendedNodeModel, Object object, String string) throws UnknownTypeException {
        extendedNodeModel.setName(object, string);
    }

    public String getIconBaseWithExtension(ExtendedNodeModel extendedNodeModel, Object object) throws UnknownTypeException {
        return extendedNodeModel.getIconBaseWithExtension(object);
    }

    public String getDisplayName(NodeModel nodeModel, Object object) throws UnknownTypeException {
        String string;
        String string2 = nodeModel.getDisplayName(object);
        if (object instanceof ObjectVariable && (string = this.debugger.getLabel((ObjectVariable)object)) != null) {
            return string2 + " [" + string + "]";
        }
        return string2;
    }

    public String getIconBase(NodeModel nodeModel, Object object) throws UnknownTypeException {
        return nodeModel.getIconBase(object);
    }

    public String getShortDescription(NodeModel nodeModel, Object object) throws UnknownTypeException {
        String string;
        String string2 = nodeModel.getShortDescription(object);
        if (object instanceof ObjectVariable && (string = this.debugger.getLabel((ObjectVariable)object)) != null) {
            return "[" + string + "] " + string2;
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            if (!this.listeners.contains(modelListener)) {
                this.listeners.add(modelListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        List<ModelListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(modelListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireNodeChange(ObjectVariable objectVariable) {
        ModelEvent.NodeChanged nodeChanged = new ModelEvent.NodeChanged((Object)this, (Object)objectVariable, 5);
        ModelListener[] modelListenerArray = this.listeners;
        synchronized (this.listeners) {
            ModelListener[] modelListenerArray2 = this.listeners.toArray(new ModelListener[0]);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            for (ModelListener modelListener : modelListenerArray2) {
                modelListener.modelChanged((ModelEvent)nodeChanged);
            }
            return;
        }
    }
}

