/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.utils;

import java.awt.Dialog;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.api.java.queries.UnitTestForSourceQuery;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.filters.FilterUtils;
import org.netbeans.lib.profiler.common.filters.SimpleFilter;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.heapwalk.HeapDumpWatch;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.modules.profiler.spi.ProjectTypeProfiler;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.ui.stp.Utils;
import org.netbeans.modules.profiler.utils.AppletSupport;
import org.netbeans.modules.profiler.utils.MainClassWarning;
import org.netbeans.spi.java.classpath.PathResourceImplementation;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.MouseUtils;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;
import org.w3c.dom.Element;

@Deprecated
public final class ProjectUtilities {
    private static final Logger LOGGER = Logger.getLogger(ProjectUtilities.class.getName());
    public static final String PROFILER_NAME_SPACE = "http://www.netbeans.org/ns/profiler/1";
    private static final String UNKNOWN_PROJECT_STRING = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_UnknownProjectString");
    private static final String FAILED_CREATE_CLASSES_DIR_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_FailedCreateClassesDirMsg");
    private static final String FAILED_GENERATE_APPLET_FILE_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_FailedGenerateAppletFileMsg");
    private static final String FAILED_COPY_APPLET_FILE_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_FailedCopyAppletFileMsg");
    private static final String FAILED_CREATE_OUTPUT_FOLDER_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_FailedCreateOutputFolderMsg");
    private static final String PROFILE_PROJECT_CLASSES_STRING = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_ProfileProjectClassesString");
    private static final String PROFILE_PROJECT_SUBPROJECT_CLASSES_STRING = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_ProfileProjectSubprojectClassesString");
    private static final String PROFILER_WILL_BE_UNINTEGRATED_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_ProfilerWillBeUnintegratedMsg");
    private static final String PROFILER_ISNT_INTEGRATED_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_ProfilerIsntIntegratedMsg");
    private static final String RENAMING_BUILD_FAILED_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_RenamingBuildFailedMsg");
    private static final String REMOVING_BUILD_FAILED_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_RemovingBuildFailedMsg");
    private static final String REMOVING_DATA_FAILED_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_RemovingDataFailedMsg");
    private static final String UNINTEGRATION_ERRORS_OCCURED_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_UnintegrationErrorsOccuredMsg");
    private static final String UNINTEGRATION_SUCCESSFUL_MSG = NbBundle.getMessage(ProjectUtilities.class, (String)"ProjectUtilities_UnintegrationSuccessfulMsg");
    public static final SimpleFilter FILTER_PROJECT_ONLY = new SimpleFilter(PROFILE_PROJECT_CLASSES_STRING, 2, "{$project.classes.only}");
    public static final SimpleFilter FILTER_PROJECT_SUBPROJECTS_ONLY = new SimpleFilter(PROFILE_PROJECT_SUBPROJECT_CLASSES_STRING, 2, "{$project.subprojects.classes.only}");

    public static Collection<? extends ProjectTypeProfiler> getAllProjectTypeProfilers() {
        Lookup.Template template;
        Lookup lookup = Lookup.getDefault();
        Lookup.Result result = lookup.lookup(template = new Lookup.Template(ProjectTypeProfiler.class));
        if (result == null) {
            return new ArrayList();
        }
        return result.allInstances();
    }

    public static ClientUtils.SourceCodeSelection[] getClassConstructors(FileObject fileObject) {
        return SourceUtils.getClassConstructors((FileObject)fileObject);
    }

    public static ClasspathInfo getClasspathInfo(Project project) {
        return ProjectUtilities.getClasspathInfo(project, true);
    }

    public static ClasspathInfo getClasspathInfo(Project project, boolean bl) {
        return ProjectUtilities.getClasspathInfo(project, bl, true, true);
    }

    public static ClasspathInfo getClasspathInfo(Project project, boolean bl, boolean bl2, boolean bl3) {
        FileObject[] fileObjectArray = ProjectUtilities.getSourceRoots(project, bl);
        HashSet<FileObject> hashSet = new HashSet<FileObject>(fileObjectArray.length);
        ArrayList arrayList = new ArrayList(fileObjectArray.length);
        ArrayList<URL> arrayList2 = new ArrayList<URL>();
        hashSet.addAll(Arrays.asList(fileObjectArray));
        if (!(fileObjectArray != null && fileObjectArray.length != 0 || bl)) {
            fileObjectArray = ProjectUtilities.getSourceRoots(project, true);
        }
        ClassPath classPath = ClassPathSupport.createClassPath((FileObject[])new FileObject[0]);
        if (fileObjectArray.length == 0) {
            return null;
        }
        ClassPath classPath2 = ClassPathSupport.createClassPath((FileObject[])fileObjectArray);
        ClassPath classPath3 = ClassPath.getClassPath((FileObject)fileObjectArray[0], (String)"classpath/compile");
        for (ClassPath.Entry entry : classPath3.entries()) {
            SourceForBinaryQuery.Result result = SourceForBinaryQuery.findSourceRoots((URL)entry.getURL());
            FileObject[] fileObjectArray2 = result.getRoots();
            if (fileObjectArray2 != null && fileObjectArray2.length != 0) continue;
            arrayList2.add(entry.getURL());
        }
        classPath3 = ClassPathSupport.createClassPath((URL[])arrayList2.toArray(new URL[arrayList2.size()]));
        return ClasspathInfo.create((ClassPath)(bl3 ? ClassPath.getClassPath((FileObject)fileObjectArray[0], (String)"classpath/boot") : classPath), (ClassPath)(bl3 ? classPath3 : classPath), (ClassPath)(bl2 ? classPath2 : classPath));
    }

    public static String getDefaultPackageClassNames(Project project) {
        Collection collection = SourceUtils.getDefaultPackageClassNames((Project)project);
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : collection) {
            stringBuffer.append(string).append(" ");
        }
        return stringBuffer.toString();
    }

    public static boolean isJavaProject(Project project) {
        if (project == null) {
            return false;
        }
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        return sourceGroupArray.length > 0;
    }

    public static Project getMainProject() {
        return OpenProjects.getDefault().getMainProject();
    }

    public static Project[] getOpenedProjects() {
        return OpenProjects.getDefault().getOpenProjects();
    }

    public static Project[] getOpenedProjectsForAttach() {
        Project[] projectArray = ProjectUtilities.getOpenedProjects();
        ArrayList<Project> arrayList = new ArrayList<Project>(projectArray.length);
        for (int i = 0; i < projectArray.length; ++i) {
            if (!ProjectUtilities.isProjectTypeSupportedForAttach(projectArray[i])) continue;
            arrayList.add(projectArray[i]);
        }
        return arrayList.toArray(new Project[arrayList.size()]);
    }

    public static FileObject getOrCreateBuildFolder(Project project, String string) {
        FileObject fileObject = FileUtil.toFileObject((File)PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)string));
        if (fileObject == null) {
            try {
                fileObject = FileUtil.createFolder((FileObject)project.getProjectDirectory(), (String)string);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, MessageFormat.format(FAILED_CREATE_OUTPUT_FOLDER_MSG, iOException.getMessage()));
                ErrorManager.getDefault().notify(65536, (Throwable)iOException);
                return null;
            }
        }
        return fileObject;
    }

    public static boolean isProfilerIntegrated(Project project) {
        Element element = ProjectUtils.getAuxiliaryConfiguration((Project)project).getConfigurationFragment("data", PROFILER_NAME_SPACE, false);
        return element != null;
    }

    public static float getProfilingOverhead(ProfilingSettings profilingSettings) {
        float f = 0.0f;
        if (!Utils.isMonitorSettings(profilingSettings)) {
            if (Utils.isCPUSettings(profilingSettings)) {
                if (profilingSettings.getProfilingType() == 8) {
                    f += 0.5f;
                } else if (profilingSettings.getProfilingType() == 16) {
                    f += 0.2f;
                }
                if (FilterUtils.NONE_FILTER.equals(profilingSettings.getSelectedInstrumentationFilter())) {
                    f += 0.5f;
                }
            } else if (Utils.isMemorySettings(profilingSettings)) {
                if (profilingSettings.getProfilingType() == 2) {
                    f += 0.5f;
                } else if (profilingSettings.getProfilingType() == 4) {
                    f += 0.7f;
                }
                if (profilingSettings.getAllocStackTraceLimit() != 0) {
                    f += 0.3f;
                }
            }
        }
        return f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProjectBuildScript(Project project) {
        FileObject fileObject = ProjectUtilities.findBuildFile(project);
        if (fileObject == null) {
            return null;
        }
        RandomAccessFile randomAccessFile = null;
        byte[] byArray = null;
        try {
            randomAccessFile = new RandomAccessFile(FileUtil.toFile((FileObject)fileObject), "r");
            byArray = new byte[(int)fileObject.getSize()];
            randomAccessFile.readFully(byArray);
        }
        catch (FileNotFoundException fileNotFoundException) {
            ProfilerLogger.log((Exception)fileNotFoundException);
            String string = null;
            return string;
        }
        catch (IOException iOException) {
            ProfilerLogger.log((Exception)iOException);
            String string = null;
            return string;
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    ProfilerLogger.log((Exception)iOException);
                }
            }
        }
        try {
            return new String(byArray, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            ErrorManager.getDefault().notify(65536, (Throwable)unsupportedEncodingException);
            return null;
        }
    }

    public static FileObject findBuildFile(Project project) {
        String string;
        FileObject fileObject = null;
        Properties properties = org.netbeans.modules.profiler.projectsupport.utilities.ProjectUtilities.getProjectProperties((Project)project);
        String string2 = string = properties != null ? properties.getProperty("buildfile") : null;
        if (string != null) {
            fileObject = project.getProjectDirectory().getFileObject(string);
        }
        if (fileObject == null) {
            fileObject = project.getProjectDirectory().getFileObject("build.xml");
        }
        return fileObject;
    }

    public static List<SimpleFilter> getProjectDefaultInstrFilters(Project project) {
        ArrayList<SimpleFilter> arrayList = new ArrayList<SimpleFilter>();
        if (ProjectUtils.getSources((Project)project).getSourceGroups("java").length > 0) {
            arrayList.add(FILTER_PROJECT_ONLY);
        }
        if (ProjectUtilities.hasSubprojects(project)) {
            arrayList.add(FILTER_PROJECT_SUBPROJECTS_ONLY);
        }
        return arrayList;
    }

    public static ClientUtils.SourceCodeSelection[] getProjectDefaultRoots(Project project, String[][] stringArray) {
        ProjectUtilities.computeProjectPackages(project, true, stringArray);
        ClientUtils.SourceCodeSelection[] sourceCodeSelectionArray = new ClientUtils.SourceCodeSelection[stringArray[1].length];
        for (int i = 0; i < stringArray[1].length; ++i) {
            sourceCodeSelectionArray[i] = "".equals(stringArray[1][i]) ? new ClientUtils.SourceCodeSelection("", "", "") : new ClientUtils.SourceCodeSelection(stringArray[1][i] + ".", "", "");
        }
        return sourceCodeSelectionArray;
    }

    public static Project getProjectForBuildScript(String string) {
        FileObject fileObject = FileUtil.toFileObject((File)new File(string));
        while (fileObject != null) {
            try {
                if (fileObject.isFolder()) {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Trying: " + fileObject);
                    }
                    Project project = ProjectManager.getDefault().findProject(fileObject);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Got: " + (project != null ? ProjectUtilities.getProjectName(project) : null));
                    }
                    if (project != null) {
                        return project;
                    }
                }
                fileObject = fileObject.getParent();
            }
            catch (IOException iOException) {
                ProfilerLogger.severe((String)("Got: IOException : " + iOException.getMessage()));
            }
        }
        return null;
    }

    public static Icon getProjectIcon(Project project) {
        ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        if (projectInformation == null) {
            return new ImageIcon();
        }
        return projectInformation.getIcon();
    }

    public static String getProjectName(Project project) {
        ProjectInformation projectInformation = (ProjectInformation)project.getLookup().lookup(ProjectInformation.class);
        if (projectInformation == null) {
            return UNKNOWN_PROJECT_STRING;
        }
        return projectInformation.getDisplayName();
    }

    public static String[] getProjectPackages(Project project) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (FileObject fileObject : ProjectUtilities.getSourceRoots(project, true)) {
            ProjectUtilities.addSubpackages(arrayList, "", fileObject);
        }
        return arrayList.toArray(new String[0]);
    }

    public static ProjectTypeProfiler getProjectTypeProfiler(Project project) {
        if (project == null) {
            return ProjectTypeProfiler.DEFAULT;
        }
        Collection<? extends ProjectTypeProfiler> collection = ProjectUtilities.getAllProjectTypeProfilers();
        for (ProjectTypeProfiler projectTypeProfiler : collection) {
            if (!projectTypeProfiler.isProfilingSupported(project)) continue;
            return projectTypeProfiler;
        }
        return ProjectTypeProfiler.DEFAULT;
    }

    public static boolean isProjectTypeSupported(Project project) {
        ProjectTypeProfiler projectTypeProfiler = ProjectUtilities.getProjectTypeProfiler(project);
        if (projectTypeProfiler.isProfilingSupported(project)) {
            return true;
        }
        return ProjectUtilities.hasAction(project, "profile");
    }

    public static boolean isProjectTypeSupportedForAttach(Project project) {
        return ProjectUtilities.getProjectTypeProfiler(project).isAttachSupported(project);
    }

    public static FileObject getRootOf(FileObject[] fileObjectArray, FileObject fileObject) {
        FileObject fileObject2 = null;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!FileUtil.isParentOf((FileObject)fileObjectArray[i], (FileObject)fileObject)) continue;
            fileObject2 = fileObjectArray[i];
            break;
        }
        return fileObject2;
    }

    public static Project[] getSortedProjects(Project[] projectArray) {
        ArrayList<Project> arrayList = new ArrayList<Project>(projectArray.length);
        for (int i = 0; i < projectArray.length; ++i) {
            arrayList.add(projectArray[i]);
        }
        try {
            Collections.sort(arrayList, new Comparator(){

                public int compare(Object object, Object object2) {
                    Project project = (Project)object;
                    Project project2 = (Project)object2;
                    return ProjectUtils.getInformation((Project)project).getDisplayName().toLowerCase().compareTo(ProjectUtils.getInformation((Project)project2).getDisplayName().toLowerCase());
                }
            });
        }
        catch (Exception exception) {
            ErrorManager.getDefault().log(65536, exception.getMessage());
        }
        arrayList.toArray(projectArray);
        return projectArray;
    }

    public static FileObject[] getSourceRoots(Project project) {
        return ProjectUtilities.getSourceRoots(project, true);
    }

    public static FileObject[] getSourceRoots(Project project, boolean bl) {
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        HashSet<Project> hashSet2 = new HashSet<Project>();
        hashSet2.add(project);
        ProjectUtilities.getSourceRoots(project, bl, hashSet2, hashSet);
        return hashSet.toArray(new FileObject[hashSet.size()]);
    }

    public static boolean backupBuildScript(Project project) {
        FileObject fileObject = ProjectUtilities.findBuildFile(project);
        FileObject fileObject2 = project.getProjectDirectory().getFileObject("build-before-profiler.xml");
        if (fileObject != null && fileObject2 != null) {
            try {
                fileObject2.delete();
            }
            catch (IOException iOException) {
                iOException.printStackTrace(System.err);
                return false;
            }
        }
        try {
            fileObject.copy(project.getProjectDirectory(), "build-before-profiler", "xml");
        }
        catch (IOException iOException) {
            ProfilerLogger.log((Exception)iOException);
            return false;
        }
        return true;
    }

    public static SimpleFilter computeProjectOnlyInstrumentationFilter(Project project, SimpleFilter simpleFilter, String[][] stringArray) {
        if (FILTER_PROJECT_ONLY.equals((Object)simpleFilter)) {
            ProjectUtilities.computeProjectPackages(project, false, stringArray);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray[0].length; ++i) {
                stringBuffer.append("".equals(stringArray[0][i]) ? ProjectUtilities.getDefaultPackageClassNames(project) : stringArray[0][i] + ". ");
            }
            return new SimpleFilter(PROFILE_PROJECT_CLASSES_STRING, 2, stringBuffer.toString().trim());
        }
        if (FILTER_PROJECT_SUBPROJECTS_ONLY.equals((Object)simpleFilter)) {
            ProjectUtilities.computeProjectPackages(project, true, stringArray);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray[1].length; ++i) {
                stringBuffer.append("".equals(stringArray[1][i]) ? ProjectUtilities.getDefaultPackageClassNames(project) : stringArray[1][i] + ". ");
            }
            return new SimpleFilter(PROFILE_PROJECT_SUBPROJECT_CLASSES_STRING, 2, stringBuffer.toString().trim());
        }
        return null;
    }

    public static void computeProjectPackages(Project project, boolean bl, String[][] stringArray) {
        FileObject[] fileObjectArray;
        if (stringArray == null || stringArray.length != 2) {
            throw new IllegalArgumentException("Storage must be a non-null String[2][] array");
        }
        if (stringArray[0] == null) {
            fileObjectArray = new ArrayList();
            for (FileObject fileObject : ProjectUtilities.getSourceRoots(project, false)) {
                ProjectUtilities.addSubpackages((ArrayList<String>)fileObjectArray, "", fileObject);
            }
            stringArray[0] = fileObjectArray.toArray(new String[0]);
        }
        if (bl && stringArray[1] == null) {
            fileObjectArray = ProjectUtilities.getSourceRoots(project, true);
            ArrayList arrayList = new ArrayList();
            for (FileObject fileObject : fileObjectArray) {
                ProjectUtilities.addSubpackages(arrayList, "", fileObject);
            }
            stringArray[1] = arrayList.toArray(new String[0]);
        }
    }

    public static URL copyAppletHTML(Project project, PropertyEvaluator propertyEvaluator, FileObject fileObject, String string) {
        try {
            String string2 = propertyEvaluator.getProperty("build.dir");
            FileObject fileObject2 = ProjectUtilities.getOrCreateBuildFolder(project, string2);
            FileObject fileObject3 = null;
            fileObject3 = fileObject.getParent().getFileObject(fileObject.getName(), "html");
            if (fileObject3 == null) {
                fileObject3 = fileObject.getParent().getFileObject(fileObject.getName(), "HTML");
            }
            if (fileObject3 == null) {
                return null;
            }
            FileObject fileObject4 = fileObject2.getFileObject(fileObject3.getName(), fileObject3.getExt());
            if (fileObject4 != null) {
                fileObject4.delete();
            }
            fileObject3.copy(fileObject2, fileObject.getName(), string).getURL();
            if (fileObject3 != null) {
                return fileObject3.getURL();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().annotate((Throwable)iOException, MessageFormat.format(FAILED_COPY_APPLET_FILE_MSG, iOException.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
            return null;
        }
        return null;
    }

    public static void fetchSubprojects(Project project, Set<Project> set) {
        SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (subprojectProvider != null) {
            for (Project project2 : subprojectProvider.getSubprojects()) {
                if (project2 == null || !set.add(project2)) continue;
                ProjectUtilities.fetchSubprojects(project2, set);
            }
        }
    }

    public static FileObject findTestForFile(FileObject fileObject) {
        if (fileObject == null || !fileObject.getExt().equalsIgnoreCase("java")) {
            return null;
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source");
        if (classPath == null) {
            return null;
        }
        FileObject fileObject2 = classPath.findOwnerRoot(fileObject);
        if (fileObject2 == null) {
            return null;
        }
        URL[] uRLArray = UnitTestForSourceQuery.findUnitTests((FileObject)fileObject2);
        FileObject fileObject3 = null;
        for (int i = 0; i < uRLArray.length; ++i) {
            fileObject3 = ProjectUtilities.findUnitTestInTestRoot(classPath, fileObject, uRLArray[i]);
            if (fileObject3 == null) continue;
            return fileObject3;
        }
        return null;
    }

    public static URL generateAppletHTML(Project project, PropertyEvaluator propertyEvaluator, FileObject fileObject) {
        String string = propertyEvaluator.getProperty("build.dir");
        String string2 = propertyEvaluator.getProperty("build.classes.dir");
        String string3 = propertyEvaluator.getProperty("platform.active");
        FileObject fileObject2 = ProjectUtilities.getOrCreateBuildFolder(project, string);
        FileObject fileObject3 = FileUtil.toFileObject((File)PropertyUtils.resolveFile((File)FileUtil.toFile((FileObject)project.getProjectDirectory()), (String)string2));
        if (fileObject3 == null) {
            try {
                fileObject3 = FileUtil.createFolder((FileObject)project.getProjectDirectory(), (String)string2);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().annotate((Throwable)iOException, MessageFormat.format(FAILED_CREATE_CLASSES_DIR_MSG, iOException.getMessage()));
                ErrorManager.getDefault().notify(65536, (Throwable)iOException);
                return null;
            }
        }
        try {
            return AppletSupport.generateHtmlFileURL(fileObject, fileObject2, fileObject3, string3);
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            ErrorManager.getDefault().annotate((Throwable)fileStateInvalidException, MessageFormat.format(FAILED_GENERATE_APPLET_FILE_MSG, fileStateInvalidException.getMessage()));
            ErrorManager.getDefault().notify(65536, (Throwable)fileStateInvalidException);
            return null;
        }
    }

    public static boolean hasAction(Project project, String string) {
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (actionProvider == null) {
            return false;
        }
        String[] stringArray = actionProvider.getSupportedActions();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null || !string.equals(stringArray[i])) continue;
            return true;
        }
        return false;
    }

    public static void invokeAction(Project project, String string) {
        ActionProvider actionProvider = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (actionProvider == null) {
            return;
        }
        Lookup lookup = null;
        if (NetBeansProfiler.getDefaultNB().getProfiledSingleFile() != null) {
            try {
                lookup = new ProxyLookup(new Lookup[]{Lookup.getDefault(), Lookups.fixed((Object[])new Object[]{DataObject.find((FileObject)NetBeansProfiler.getDefaultNB().getProfiledSingleFile())})});
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                lookup = Lookup.getDefault();
            }
        } else {
            lookup = Lookup.getDefault();
        }
        actionProvider.invokeAction(string, lookup);
    }

    public static ExecutorTask runTarget(FileObject fileObject, String string, Properties properties) {
        try {
            String string2 = properties.getProperty("profiler.info.oomeprotection");
            if (string2 != null && string2.equals("yes")) {
                HeapDumpWatch.getDefault().monitor(properties.getProperty("profiler.info.oomeprotection.dumppath"));
            }
            return ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{string}, (Properties)properties);
        }
        catch (IOException iOException) {
            Profiler.getDefault().notifyException(8, (Exception)iOException);
            return null;
        }
    }

    public static String selectMainClass(Project project, String string, String string2, int n) {
        boolean bl;
        String string3;
        final JButton jButton = new JButton(NbBundle.getMessage(MainClassWarning.class, (String)"LBL_MainClassWarning_ChooseMainClass_OK"));
        jButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(MainClassWarning.class, (String)"AD_MainClassWarning_ChooseMainClass_OK"));
        switch (n) {
            case -1: {
                string3 = MessageFormat.format(NbBundle.getMessage(MainClassWarning.class, (String)"LBL_MainClassNotFound"), string2);
                break;
            }
            case -2: {
                string3 = MessageFormat.format(NbBundle.getMessage(MainClassWarning.class, (String)"LBL_MainClassWrong"), string, string2);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        final MainClassWarning mainClassWarning = new MainClassWarning(string3, ProjectUtilities.getSourceRoots(project));
        Object[] objectArray = new Object[]{jButton, DialogDescriptor.CANCEL_OPTION};
        mainClassWarning.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (changeEvent.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)changeEvent.getSource()))) {
                    jButton.doClick();
                } else {
                    jButton.setEnabled(mainClassWarning.getSelectedMainClass() != null);
                }
            }
        });
        jButton.setEnabled(false);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)mainClassWarning, NbBundle.getMessage(MainClassWarning.class, (String)"CTL_MainClassWarning_Title", (Object)ProjectUtils.getInformation((Project)project).getDisplayName()), true, objectArray, objectArray[0], 0, null, null);
        dialogDescriptor.setMessageType(1);
        Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() != objectArray[0]) {
            bl = true;
        } else {
            string = mainClassWarning.getSelectedMainClass();
            bl = false;
        }
        dialog.dispose();
        if (bl) {
            return null;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unintegrateProfiler(Project project) {
        FileObject fileObject;
        FileObject fileObject2;
        String string = ProjectUtils.getInformation((Project)project).getDisplayName();
        if (ProjectUtilities.isProfilerIntegrated(project) ? ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)MessageFormat.format(PROFILER_WILL_BE_UNINTEGRATED_MSG, string), 0)) != NotifyDescriptor.YES_OPTION : ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)MessageFormat.format(PROFILER_ISNT_INTEGRATED_MSG, string), 0)) != NotifyDescriptor.YES_OPTION) {
            return;
        }
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        FileLock fileLock = null;
        Object var5_5 = null;
        try {
            fileObject2 = ProjectUtilities.findBuildFile(project);
            fileObject = project.getProjectDirectory().getFileObject("build-before-profiler.xml");
            if (fileObject2 != null && fileObject != null && fileObject.isValid()) {
                try {
                    fileLock = fileObject.lock();
                    if (fileObject2 != null && fileObject2.isValid()) {
                        fileObject2.delete();
                    }
                    fileObject.rename(fileLock, "build", "xml");
                }
                catch (Exception exception) {
                    bl = true;
                    stringBuilder.append(MessageFormat.format(RENAMING_BUILD_FAILED_MSG, exception.getMessage()));
                    ProfilerLogger.log((Exception)exception);
                }
            }
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        fileObject2 = null;
        try {
            fileObject = project.getProjectDirectory().getFileObject("nbproject").getFileObject("profiler-build-impl.xml");
            try {
                if (fileObject != null && fileObject.isValid()) {
                    fileObject.delete();
                }
            }
            catch (Exception exception) {
                bl = true;
                stringBuilder.append(MessageFormat.format(REMOVING_BUILD_FAILED_MSG, exception.getMessage()));
                ProfilerLogger.log((Exception)exception);
            }
        }
        finally {
            if (fileObject2 != null) {
                fileObject2.releaseLock();
            }
        }
        ProjectUtils.getAuxiliaryConfiguration((Project)project).removeConfigurationFragment("data", PROFILER_NAME_SPACE, false);
        try {
            ProjectManager.getDefault().saveProject(project);
        }
        catch (Exception exception) {
            bl = true;
            stringBuilder.append(MessageFormat.format(REMOVING_DATA_FAILED_MSG, exception.getMessage()));
            ProfilerLogger.log((Exception)exception);
        }
        if (bl) {
            Profiler.getDefault().displayError(MessageFormat.format(UNINTEGRATION_ERRORS_OCCURED_MSG, stringBuilder.toString()));
        } else {
            Profiler.getDefault().displayInfo(MessageFormat.format(UNINTEGRATION_SUCCESSFUL_MSG, string));
        }
    }

    private static void getSourceRoots(Project project, boolean bl, Set<Project> set, Set<FileObject> set2) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SubprojectProvider subprojectProvider = sources.getSourceGroups("java");
        int n = ((SourceGroup[])subprojectProvider).length;
        for (int i = 0; i < n; ++i) {
            SourceGroup sourceGroup = subprojectProvider[i];
            set2.add(sourceGroup.getRootFolder());
        }
        if (bl && (subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class)) != null) {
            for (Project project2 : subprojectProvider.getSubprojects()) {
                if (!set.add(project2)) continue;
                ProjectUtilities.getSourceRoots(project2, bl, set, set2);
            }
        }
    }

    private static String getTestName(ClassPath classPath, FileObject fileObject) {
        String string = classPath.getResourceName(fileObject, '/', false);
        String string2 = null;
        string2 = fileObject.isFolder() ? ProjectUtilities.convertPackage2SuiteName(string) : ProjectUtilities.convertClass2TestName(string);
        return string2;
    }

    private static void addSubpackages(ArrayList<String> arrayList, String string, FileObject fileObject) {
        FileObject fileObject2;
        int n;
        if (!fileObject.isFolder()) {
            return;
        }
        FileObject[] fileObjectArray = fileObject.getChildren();
        if (!arrayList.contains(string)) {
            for (n = 0; n < fileObjectArray.length; ++n) {
                fileObject2 = fileObjectArray[n];
                if (!fileObject2.getExt().equals("java")) continue;
                arrayList.add(string);
                break;
            }
        }
        for (n = 0; n < fileObjectArray.length; ++n) {
            fileObject2 = fileObjectArray[n];
            if (!fileObject2.isFolder()) continue;
            if ("".equals(string)) {
                ProjectUtilities.addSubpackages(arrayList, fileObject2.getName(), fileObject2);
                continue;
            }
            ProjectUtilities.addSubpackages(arrayList, string + "." + fileObject2.getName(), fileObject2);
        }
    }

    private static String convertClass2TestName(String string) {
        if (string == null || "".equals(string)) {
            return "";
        }
        int n = string.lastIndexOf(47);
        String string2 = n > -1 ? string.substring(0, n) : "";
        String string3 = n > -1 ? string.substring(n + 1) : string;
        string3 = string3.substring(0, 1).toUpperCase() + string3.substring(1);
        if (string2.length() > 0) {
            string2 = string2 + "/";
        }
        return string2 + string3 + "Test";
    }

    private static String convertPackage2SuiteName(String string) {
        if (string == null || "".equals(string)) {
            return "";
        }
        int n = string.lastIndexOf(47);
        String string2 = n > -1 ? string.substring(n + 1) : string;
        string2 = string2.substring(0, 1).toUpperCase() + string2.substring(1);
        return string + "/" + string2 + "Test";
    }

    private static FileObject findUnitTestInTestRoot(ClassPath classPath, FileObject fileObject, URL uRL) {
        Object object;
        ClassPath classPath2 = null;
        if (uRL == null) {
            classPath2 = classPath;
        } else {
            try {
                object = new ArrayList<PathResourceImplementation>();
                object.add(ClassPathSupport.createResource((URL)uRL));
                classPath2 = ClassPathSupport.createClassPath((List)object);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                ErrorManager.getDefault().notify(1, (Throwable)illegalArgumentException);
                classPath2 = classPath;
            }
        }
        object = ProjectUtilities.getTestName(classPath, fileObject);
        return classPath2.findResource((String)object + ".java");
    }

    private static boolean hasSubprojects(Project project) {
        SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        if (subprojectProvider == null) {
            return false;
        }
        return subprojectProvider.getSubprojects().size() > 0;
    }
}

