/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.componentssupport.ui.wizard;

import java.awt.BorderLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.JPanel;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryChooser;
import org.netbeans.modules.vmd.componentssupport.ui.wizard.SelectLibraryWizardPanel;
import org.openide.WizardDescriptor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

final class SelectLibraryVisualPanel
extends JPanel {
    private static final long serialVersionUID = -3903508171781536427L;
    private WizardDescriptor mySettings;
    private final LibraryChooser.Panel myInnerPanel;
    private SelectLibraryWizardPanel myPanel;

    public SelectLibraryVisualPanel(SelectLibraryWizardPanel panel) {
        this.myPanel = panel;
        this.getAccessibleContext().setAccessibleName(SelectLibraryVisualPanel.getMessage("ACS_SelectLibraryPanel"));
        this.getAccessibleContext().setAccessibleDescription(SelectLibraryVisualPanel.getMessage("ACS_SelectLibraryPanel"));
        this.myInnerPanel = LibraryChooser.createPanel(null, (LibraryChooser.Filter)new ClassLibraryFilter());
        this.myInnerPanel.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedLibraries".equals(evt.getPropertyName())) {
                    SelectLibraryVisualPanel.this.checkValidity();
                }
            }
        });
        this.setLayout(new BorderLayout());
        this.add(this.myInnerPanel.getVisualComponent(), "Center");
    }

    private void checkValidity() {
        this.mySettings.putProperty("WizardPanel_errorMessage", null);
        if (this.getSelectedLibrary() != null) {
            this.setValid(true);
        } else {
            this.setValid(false);
        }
    }

    private final void setValid(boolean valid) {
        this.myPanel.setValid(valid);
    }

    private Library getSelectedLibrary() {
        Set selection = this.myInnerPanel.getSelectedLibraries();
        return selection.size() == 1 ? (Library)selection.iterator().next() : null;
    }

    void storeData() {
        Library oldLib = (Library)this.mySettings.getProperty("library");
        Library newLib = this.getSelectedLibrary();
        this.mySettings.putProperty("library", (Object)newLib);
        if (!newLib.equals((Object)oldLib)) {
            this.mySettings.putProperty("libName", null);
            this.mySettings.putProperty("displayName", null);
        }
    }

    void readData(WizardDescriptor settings) {
        this.mySettings = settings;
        this.checkValidity();
    }

    protected HelpCtx getHelp() {
        return new HelpCtx(SelectLibraryVisualPanel.class);
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(SelectLibraryVisualPanel.class, (String)key);
    }

    private class ClassLibraryFilter
    implements LibraryChooser.Filter {
        private ClassLibraryFilter() {
        }

        public boolean accept(Library library) {
            return "j2se".equals(library.getType());
        }
    }
}

