/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.maven.api.problem.ProblemReport;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ProblemsPanel
extends JPanel {
    private ProblemReporterImpl reporter;
    private ChangeListener change;
    private JButton button;
    private JButton close;
    private JLabel jLabel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JLabel lblDescription;
    private JList lstProblems;
    private JTextArea taDescription;

    public ProblemsPanel(ProblemReporterImpl report) {
        this.initComponents();
        this.reporter = report;
        this.taDescription.setLineWrap(true);
        this.taDescription.setWrapStyleWord(true);
        this.lstProblems.setCellRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                ProblemReport report = (ProblemReport)value;
                return super.getListCellRendererComponent((JList<?>)list, report.getShortDescription(), index, isSelected, cellHasFocus);
            }
        });
        this.lstProblems.setSelectionMode(0);
        this.lstProblems.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                Object val = ProblemsPanel.this.lstProblems.getSelectedValue();
                if (val != null) {
                    ProblemReport rep = (ProblemReport)val;
                    ProblemsPanel.this.taDescription.setText(rep.getLongDescription());
                    if (rep.getCorrectiveAction() != null) {
                        ProblemsPanel.this.button.setAction(rep.getCorrectiveAction());
                    } else {
                        ProblemsPanel.this.button.setAction(new NoopAction());
                    }
                } else {
                    ProblemsPanel.this.taDescription.setText("");
                    ProblemsPanel.this.button.setAction(new NoopAction());
                }
            }
        });
        this.change = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ProblemsPanel.this.populateUI();
                    }
                });
            }
        };
    }

    public void setActionButton(JButton butt) {
        this.button = butt;
    }

    public void setCloseButton(JButton close) {
        this.close = close;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.populateUI();
        this.reporter.addChangeListener(this.change);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.reporter.removeChangeListener(this.change);
    }

    private void populateUI() {
        Iterator<ProblemReport> it = this.reporter.getReports().iterator();
        DefaultListModel<ProblemReport> model = new DefaultListModel<ProblemReport>();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
        this.lstProblems.setModel(model);
        if (this.lstProblems.getModel().getSize() > 0) {
            this.lstProblems.setSelectedIndex(0);
        } else {
            this.close.doClick();
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.lstProblems = new JList();
        this.lblDescription = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.taDescription = new JTextArea();
        this.jLabel1 = new JLabel();
        this.jScrollPane1.setViewportView(this.lstProblems);
        this.lblDescription.setLabelFor(this.taDescription);
        Mnemonics.setLocalizedText((JLabel)this.lblDescription, (String)NbBundle.getMessage(ProblemsPanel.class, (String)"LBL_Description"));
        this.taDescription.setColumns(20);
        this.taDescription.setRows(5);
        this.jScrollPane2.setViewportView(this.taDescription);
        this.jLabel1.setLabelFor(this.lstProblems);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(ProblemsPanel.class, (String)"LBL_Problems"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 529, Short.MAX_VALUE).add((Component)this.jLabel1).add((Component)this.lblDescription).add((Component)this.jScrollPane1, -1, 529, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 103, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.lblDescription).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 120, Short.MAX_VALUE).addContainerGap()));
    }

    private class NoopAction
    extends AbstractAction {
        public NoopAction() {
            this.setEnabled(false);
            this.putValue("Name", NbBundle.getMessage(ProblemsPanel.class, (String)"BTN_Correct"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

