/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.newproject;

import org.apache.maven.project.MavenProject;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.modules.maven.model.pom.PluginManagement;
import org.netbeans.modules.maven.model.pom.Project;
import org.netbeans.modules.maven.options.MavenVersionSettings;

class AddOSGiParamToNbmPluginConfiguration
implements ModelOperation<POMModel> {
    private static final String GROUPID_MOJO = "org.codehaus.mojo";
    private static final String NBM_PLUGIN = "nbm-maven-plugin";
    private final boolean useOsgi;
    private final MavenProject mp;

    AddOSGiParamToNbmPluginConfiguration(boolean useOsgiDeps, MavenProject mavenProject) {
        this.mp = mavenProject;
        this.useOsgi = useOsgiDeps;
    }

    public void performOperation(POMModel model) {
        Configuration cnf;
        Plugin plg;
        Project p = model.getProject();
        Build bld = p.getBuild();
        if (bld == null) {
            bld = model.getFactory().createBuild();
            p.setBuild(bld);
        }
        if ((plg = bld.findPluginById(GROUPID_MOJO, NBM_PLUGIN)) == null) {
            PluginManagement pm = bld.getPluginManagement();
            if (pm != null) {
                plg = pm.findPluginById(GROUPID_MOJO, NBM_PLUGIN);
            }
            if (plg == null) {
                plg = model.getFactory().createPlugin();
                bld.addPlugin(plg);
                plg.setGroupId(GROUPID_MOJO);
                plg.setArtifactId(NBM_PLUGIN);
                plg.setVersion(MavenVersionSettings.getDefault().getVersion(NBM_PLUGIN));
            }
        }
        if ((cnf = plg.getConfiguration()) == null) {
            cnf = model.getFactory().createConfiguration();
            plg.setConfiguration(cnf);
        }
        cnf.setSimpleParameter("useOSGiDependencies", Boolean.toString(this.useOsgi));
    }
}

