/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jpa.refactoring;

import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CancellableTask;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.j2ee.jpa.refactoring.EntityAnnotationReference;
import org.netbeans.modules.j2ee.jpa.refactoring.RefactoringUtil;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.EntityMappingsMetadata;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.OneToMany;
import org.openide.filesystems.FileObject;
import org.openide.util.Parameters;

public class EntityAssociationResolver {
    static final String ONE_TO_ONE = "javax.persistence.OneToOne";
    static final String ONE_TO_MANY = "javax.persistence.OneToMany";
    static final String MANY_TO_ONE = "javax.persistence.ManyToOne";
    static final String MANY_TO_MANY = "javax.persistence.ManyToMany";
    private static final List<String> ANNOTATIONS = Arrays.asList("javax.persistence.OneToOne", "javax.persistence.OneToMany", "javax.persistence.ManyToOne", "javax.persistence.ManyToMany");
    static final String MAPPED_BY = "mappedBy";
    static final String TARGET_ENTITY = "targetEntity";
    private final MetadataModel<EntityMappingsMetadata> entityMappingsModel;
    private final TreePathHandle refactoringSource;

    public EntityAssociationResolver(TreePathHandle treePathHandle, MetadataModel<EntityMappingsMetadata> metadataModel) {
        Parameters.notNull((CharSequence)"entityMappingsModel", metadataModel);
        Parameters.notNull((CharSequence)"refactoringSource", (Object)treePathHandle);
        this.entityMappingsModel = metadataModel;
        this.refactoringSource = treePathHandle;
    }

    public List<EntityAnnotationReference> resolveReferences() throws IOException {
        final ArrayList<EntityAnnotationReference> arrayList = new ArrayList<EntityAnnotationReference>();
        final List<Reference> list = this.getReferringProperties();
        this.entityMappingsModel.runReadAction((MetadataModelAction)new MetadataModelAction<EntityMappingsMetadata, Void>(){

            public Void run(EntityMappingsMetadata entityMappingsMetadata) throws Exception {
                for (Reference reference : list) {
                    Entity entity = EntityAssociationResolver.this.getByClass(entityMappingsMetadata.getRoot().getEntity(), reference.getClassName());
                    if (entity == null) continue;
                    arrayList.addAll(EntityAssociationResolver.this.getOneToX(entity, reference));
                }
                return null;
            }
        });
        return arrayList;
    }

    private List<EntityAnnotationReference> getOneToX(Entity entity, Reference reference) throws IOException {
        ArrayList<EntityAnnotationReference> arrayList = new ArrayList<EntityAnnotationReference>();
        boolean bl = "FIELD".equals(entity.getAccess());
        TreePathHandle treePathHandle = RefactoringUtil.getTreePathHandle(reference.getPropertyName(), reference.getClassName(), this.refactoringSource.getFileObject());
        for (OneToMany oneToMany : entity.getAttributes().getOneToMany()) {
            if (!this.isMatching(oneToMany.getName(), bl, reference)) continue;
            arrayList.add(new EntityAnnotationReference(reference.getClassName(), ONE_TO_MANY, MAPPED_BY, reference.getSourceProperty(), treePathHandle));
        }
        for (OneToMany oneToMany : entity.getAttributes().getOneToOne()) {
            if (!this.isMatching(oneToMany.getName(), bl, reference)) continue;
            arrayList.add(new EntityAnnotationReference(reference.getClassName(), ONE_TO_ONE, MAPPED_BY, reference.getSourceProperty(), treePathHandle));
        }
        return arrayList;
    }

    private boolean isMatching(String string, boolean bl, Reference reference) {
        if (bl && reference.isField()) {
            return string.equals(reference.getPropertyName());
        }
        if (!bl && !reference.isField()) {
            return string.equals(RefactoringUtil.getPropertyName(reference.getPropertyName()));
        }
        return false;
    }

    private Entity getByClass(Entity[] entityArray, String string) {
        for (Entity entity : entityArray) {
            if (!entity.getClass2().equals(string)) continue;
            return entity;
        }
        return null;
    }

    List<Reference> getReferringProperties() throws IOException {
        final ArrayList<Reference> arrayList = new ArrayList<Reference>();
        JavaSource javaSource = JavaSource.forFileObject((FileObject)this.refactoringSource.getFileObject());
        javaSource.runUserActionTask((Task)new CancellableTask<CompilationController>(){

            public void cancel() {
            }

            private List<IdentifierTree> getTypeArgs(ParameterizedTypeTree parameterizedTypeTree) {
                ArrayList<IdentifierTree> arrayList2 = new ArrayList<IdentifierTree>();
                for (Tree tree : parameterizedTypeTree.getTypeArguments()) {
                    if (Tree.Kind.IDENTIFIER != tree.getKind()) continue;
                    IdentifierTree identifierTree = (IdentifierTree)tree;
                    arrayList2.add(identifierTree);
                }
                return arrayList2;
            }

            private List<IdentifierTree> getIdentifier(Tree tree) {
                if (Tree.Kind.PARAMETERIZED_TYPE == tree.getKind()) {
                    return this.getTypeArgs((ParameterizedTypeTree)tree);
                }
                if (Tree.Kind.IDENTIFIER == tree.getKind()) {
                    return Collections.singletonList((IdentifierTree)tree);
                }
                return Collections.emptyList();
            }

            public void run(CompilationController compilationController) throws Exception {
                compilationController.toPhase(JavaSource.Phase.RESOLVED);
                Element element = EntityAssociationResolver.this.refactoringSource.resolveElement((CompilationInfo)compilationController);
                String string = ((Object)element.getEnclosingElement().asType()).toString();
                String string2 = element.getSimpleName().toString();
                String string3 = ((Object)element.asType()).toString();
                TypeElement typeElement = compilationController.getElements().getTypeElement(string3);
                if (typeElement == null) {
                    return;
                }
                for (Element element2 : typeElement.getEnclosedElements()) {
                    Object object;
                    Tree tree = compilationController.getTrees().getTree(element2);
                    if (tree == null) continue;
                    List<Object> list = new ArrayList();
                    boolean bl = false;
                    if (element2.getKind().equals((Object)ElementKind.FIELD)) {
                        bl = true;
                        if (Tree.Kind.VARIABLE == tree.getKind()) {
                            object = (VariableTree)tree;
                            list = this.getIdentifier(object.getType());
                        }
                    } else if (element2.getKind().equals((Object)ElementKind.METHOD)) {
                        object = (MethodTree)tree;
                        list = this.getIdentifier(object.getReturnType());
                    }
                    for (IdentifierTree identifierTree : list) {
                        TypeMirror typeMirror = compilationController.getTreeUtilities().parseType(identifierTree.getName().toString(), typeElement);
                        if (!string.equals(((Object)typeMirror).toString())) continue;
                        arrayList.add(new Reference(element2.getSimpleName().toString(), string2, string3, bl));
                    }
                }
            }
        }, false);
        return arrayList;
    }

    static class Reference {
        private final String className;
        private final String propertyName;
        private final String sourceProperty;
        private final boolean field;

        public Reference(String string, String string2, String string3, boolean bl) {
            this.propertyName = string;
            this.sourceProperty = string2;
            this.className = string3;
            this.field = bl;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public String getClassName() {
            return this.className;
        }

        public String getSourceProperty() {
            return this.sourceProperty;
        }

        public boolean isField() {
            return this.field;
        }
    }
}

