/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.api.codegeneration;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.project.classpath.ProjectClassPathModifier;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.netbeans.modules.j2ee.common.J2eeProjectCapabilities;
import org.netbeans.modules.j2ee.core.api.support.java.GenerationUtils;
import org.netbeans.modules.j2ee.dd.api.ejb.AssemblyDescriptor;
import org.netbeans.modules.j2ee.dd.api.ejb.ContainerTransaction;
import org.netbeans.modules.j2ee.dd.api.ejb.DDProvider;
import org.netbeans.modules.j2ee.dd.api.ejb.EnterpriseBeans;
import org.netbeans.modules.j2ee.dd.api.ejb.Method;
import org.netbeans.modules.j2ee.dd.api.ejb.Session;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.j2ee.ejbcore.EjbGenerationUtil;
import org.netbeans.modules.j2ee.ejbcore.naming.EJBNameOptions;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public final class SessionGenerator {
    public static final String EJB21_EJBCLASS = "Templates/J2EE/EJB21/SessionEjbClass.java";
    public static final String EJB21_LOCAL = "Templates/J2EE/EJB21/SessionLocal.java";
    public static final String EJB21_LOCALHOME = "Templates/J2EE/EJB21/SessionLocalHome.java";
    public static final String EJB21_REMOTE = "Templates/J2EE/EJB21/SessionRemote.java";
    public static final String EJB21_REMOTEHOME = "Templates/J2EE/EJB21/SessionRemoteHome.java";
    public static final String EJB30_STATELESS_EJBCLASS = "Templates/J2EE/EJB30/StatelessEjbClass.java";
    public static final String EJB30_STATEFUL_EJBCLASS = "Templates/J2EE/EJB30/StatefulEjbClass.java";
    public static final String EJB30_LOCAL = "Templates/J2EE/EJB30/SessionLocal.java";
    public static final String EJB30_REMOTE = "Templates/J2EE/EJB30/SessionRemote.java";
    public static final String EJB31_SINGLETON_EJBCLASS = "Templates/J2EE/EJB31/SingletonEjbClass.java";
    public static final String ANNOTATION_LOCAL_BEAN = "javax.ejb.LocalBean";
    public static final String TEMPLATE_PROPERTY_INTERFACES = "interfaces";
    public static final String TEMPLATE_PROPERTY_LOCAL_BEAN = "annotationLocalBean";
    private final FileObject pkg;
    private FileObject remotePkg;
    private final boolean hasRemote;
    private final boolean hasLocal;
    private final String sessionType;
    private final boolean isSimplified;
    private final boolean isXmlBased;
    private final EJBNameOptions ejbNameOptions;
    private final String ejbName;
    private final String ejbClassName;
    private final String remoteName;
    private final String remoteHomeName;
    private final String localName;
    private final String localHomeName;
    private final String displayName;
    private final String packageName;
    private final String packageNameWithDot;
    private final Map<String, String> templateParameters;
    private Project projectForRemoteInterface;
    private String remoteInterfacePackageName;

    public static SessionGenerator create(String string, FileObject fileObject, boolean bl, boolean bl2, String string2, boolean bl3, boolean bl4, boolean bl5) {
        return new SessionGenerator(string, fileObject, bl, bl2, string2, bl3, bl4, bl5, false);
    }

    protected SessionGenerator(String string, FileObject fileObject, boolean bl, boolean bl2, String string2, boolean bl3, boolean bl4, boolean bl5, boolean bl6) {
        this.pkg = fileObject;
        this.remotePkg = fileObject;
        this.hasRemote = bl;
        this.hasLocal = bl2;
        this.sessionType = string2;
        this.isSimplified = bl3;
        this.isXmlBased = bl5;
        this.ejbNameOptions = new EJBNameOptions();
        this.ejbName = this.ejbNameOptions.getSessionEjbNamePrefix() + string + this.ejbNameOptions.getSessionEjbNameSuffix();
        this.ejbClassName = this.ejbNameOptions.getSessionEjbClassPrefix() + string + this.ejbNameOptions.getSessionEjbClassSuffix();
        this.remoteName = this.ejbNameOptions.getSessionRemotePrefix() + string + this.ejbNameOptions.getSessionRemoteSuffix();
        this.remoteHomeName = this.ejbNameOptions.getSessionRemoteHomePrefix() + string + this.ejbNameOptions.getSessionRemoteHomeSuffix();
        this.localName = this.ejbNameOptions.getSessionLocalPrefix() + string + this.ejbNameOptions.getSessionLocalSuffix();
        this.localHomeName = this.ejbNameOptions.getSessionLocalHomePrefix() + string + this.ejbNameOptions.getSessionLocalHomeSuffix();
        this.displayName = this.ejbNameOptions.getSessionDisplayNamePrefix() + string + this.ejbNameOptions.getSessionDisplayNameSuffix();
        this.packageName = EjbGenerationUtil.getSelectedPackageName(fileObject);
        this.packageNameWithDot = this.packageName + ".";
        this.templateParameters = new HashMap<String, String>();
        this.templateParameters.put("package", this.packageName);
        this.templateParameters.put("localInterface", this.packageNameWithDot + this.localName);
        this.templateParameters.put("remoteInterface", this.packageNameWithDot + this.remoteName);
        if (bl6) {
            this.templateParameters.put("date", "{date}");
            this.templateParameters.put("time", "{time}");
            this.templateParameters.put("user", "{user}");
        }
    }

    public void setRemoteInterfaceDestination(Project project, String string) throws IOException {
        this.projectForRemoteInterface = project;
        this.remoteInterfacePackageName = string;
        assert (ProjectUtils.getSources((Project)project).getSourceGroups("java").length > 0);
        FileObject fileObject = ProjectUtils.getSources((Project)project).getSourceGroups("java")[0].getRootFolder();
        this.remotePkg = FileUtil.createFolder((FileObject)fileObject, (String)string.replace('.', '/'));
        ProjectClassPathModifier.addProjects((Project[])new Project[]{project}, (FileObject)this.pkg, (String)"classpath/compile");
        assert (LibraryManager.getDefault().getLibrary("javaee-api-6.0") != null);
        if (ClassPath.getClassPath((FileObject)this.remotePkg, (String)"classpath/compile").findResource("javax/ejb") == null) {
            ProjectClassPathModifier.addLibraries((Library[])new Library[]{LibraryManager.getDefault().getLibrary("javaee-api-6.0")}, (FileObject)this.remotePkg, (String)"classpath/compile");
        }
    }

    public FileObject generate() throws IOException {
        FileObject fileObject = null;
        if (this.isSimplified) {
            fileObject = this.generateEJB30Classes();
            Project project = FileOwnerQuery.getOwner((FileObject)this.pkg);
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            j2eeModuleProvider.getConfigSupport().ensureConfigurationReady();
            if (this.isXmlBased) {
                this.generateEJB30Xml();
            }
        } else {
            fileObject = this.generateEJB21Classes();
            Project project = FileOwnerQuery.getOwner((FileObject)this.pkg);
            J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
            j2eeModuleProvider.getConfigSupport().ensureConfigurationReady();
            if (this.isXmlBased) {
                this.generateEJB21Xml();
            }
        }
        return fileObject;
    }

    private FileObject generateEJB21Classes() throws IOException {
        FileObject fileObject = GenerationUtils.createClass((String)EJB21_EJBCLASS, (FileObject)this.pkg, (String)this.ejbClassName, null, this.templateParameters);
        if (this.hasRemote) {
            GenerationUtils.createClass((String)EJB21_REMOTE, (FileObject)this.remotePkg, (String)this.remoteName, null, this.templateParameters);
            GenerationUtils.createClass((String)EJB21_REMOTEHOME, (FileObject)this.remotePkg, (String)this.remoteHomeName, null, this.templateParameters);
        }
        if (this.hasLocal) {
            GenerationUtils.createClass((String)EJB21_LOCAL, (FileObject)this.pkg, (String)this.localName, null, this.templateParameters);
            GenerationUtils.createClass((String)EJB21_LOCALHOME, (FileObject)this.pkg, (String)this.localHomeName, null, this.templateParameters);
        }
        return fileObject;
    }

    private FileObject generateEJB30Classes() throws IOException {
        Project project;
        String string = "";
        if (this.sessionType.equals("Stateless")) {
            string = EJB30_STATELESS_EJBCLASS;
        } else if (this.sessionType.equals("Stateful")) {
            string = EJB30_STATEFUL_EJBCLASS;
        } else if (this.sessionType.equals("Singleton")) {
            string = EJB31_SINGLETON_EJBCLASS;
        } else assert (false);
        if (this.hasLocal && this.hasRemote) {
            this.templateParameters.put(TEMPLATE_PROPERTY_INTERFACES, this.remoteName + ", " + this.localName);
        } else if (this.hasLocal) {
            this.templateParameters.put(TEMPLATE_PROPERTY_INTERFACES, this.localName);
        } else if (this.hasRemote) {
            this.templateParameters.put(TEMPLATE_PROPERTY_INTERFACES, this.remoteName);
        } else {
            project = FileOwnerQuery.getOwner((FileObject)this.pkg);
            J2eeProjectCapabilities j2eeProjectCapabilities = J2eeProjectCapabilities.forProject((Project)project);
            if (j2eeProjectCapabilities != null && j2eeProjectCapabilities.isEjb31Supported()) {
                this.templateParameters.put(TEMPLATE_PROPERTY_LOCAL_BEAN, Boolean.TRUE.toString());
            }
        }
        project = GenerationUtils.createClass((String)string, (FileObject)this.pkg, (String)this.ejbClassName, null, this.templateParameters);
        if (this.hasRemote) {
            GenerationUtils.createClass((String)EJB30_REMOTE, (FileObject)this.remotePkg, (String)this.remoteName, null, this.templateParameters);
        }
        if (this.hasLocal) {
            GenerationUtils.createClass((String)EJB30_LOCAL, (FileObject)this.pkg, (String)this.localName, null, this.templateParameters);
        }
        return project;
    }

    private void generateEJB21Xml() throws IOException {
        Object object;
        EjbJar ejbJar = EjbJar.getEjbJar((FileObject)this.pkg);
        FileObject fileObject = ejbJar.getDeploymentDescriptor();
        if (fileObject == null && ejbJar.getMetaInf() != null) {
            object = "org-netbeans-modules-j2ee-ejbjarproject/ejb-jar-2.1.xml";
            fileObject = FileUtil.copyFile((FileObject)FileUtil.getConfigFile((String)object), (FileObject)ejbJar.getMetaInf(), (String)"ejb-jar");
        }
        if ((object = DDProvider.getDefault().getDDRoot(fileObject)) == null) {
            String string = fileObject == null ? null : FileUtil.getFileDisplayName((FileObject)fileObject);
            Logger.getLogger(SessionGenerator.class.getName()).warning("EjbJar not found for " + string);
            return;
        }
        EnterpriseBeans enterpriseBeans = object.getEnterpriseBeans();
        Session session = null;
        if (enterpriseBeans == null) {
            enterpriseBeans = object.newEnterpriseBeans();
            object.setEnterpriseBeans(enterpriseBeans);
        }
        session = enterpriseBeans.newSession();
        session.setEjbName(this.ejbName);
        session.setDisplayName(this.displayName);
        session.setEjbClass(this.packageNameWithDot + this.ejbClassName);
        if (this.hasRemote) {
            session.setRemote(this.packageNameWithDot + this.remoteName);
            session.setHome(this.packageNameWithDot + this.remoteHomeName);
        }
        if (this.hasLocal) {
            session.setLocal(this.packageNameWithDot + this.localName);
            session.setLocalHome(this.packageNameWithDot + this.localHomeName);
        }
        session.setSessionType(this.sessionType);
        session.setTransactionType("Container");
        enterpriseBeans.addSession(session);
        AssemblyDescriptor assemblyDescriptor = object.getSingleAssemblyDescriptor();
        if (assemblyDescriptor == null) {
            assemblyDescriptor = object.newAssemblyDescriptor();
            object.setAssemblyDescriptor(assemblyDescriptor);
        }
        ContainerTransaction containerTransaction = assemblyDescriptor.newContainerTransaction();
        containerTransaction.setTransAttribute("Required");
        Method method = containerTransaction.newMethod();
        method.setEjbName(this.ejbName);
        method.setMethodName("*");
        containerTransaction.addMethod(method);
        assemblyDescriptor.addContainerTransaction(containerTransaction);
        object.write(ejbJar.getDeploymentDescriptor());
    }

    private void generateEJB30Xml() throws IOException {
        throw new UnsupportedOperationException("Method not implemented yet.");
    }
}

