/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.reglib;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Locale;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.reglib.NbBundle;
import org.netbeans.modules.reglib.NbConnectionSupport;
import org.netbeans.modules.reglib.Util;
import org.netbeans.modules.servicetag.RegistrationData;
import org.netbeans.modules.servicetag.Registry;
import org.netbeans.modules.servicetag.ServiceTag;

public class NbServiceTagSupport2 {
    private static final String ST_DIR = "servicetag";
    private static final String ST_FILE = "servicetag";
    private static final String REG_FILE = "registration.xml";
    private static RegistrationData registration;
    private static final Logger LOG;
    private static final String REGISTRATION_HTML_NAME = "register";
    private static final String PRODUCT_KEY = "@@PRODUCT@@";
    private static final String PRODUCT_TITLE_KEY = "@@PRODUCT_TITLE@@";
    private static final String REGISTRATION_URL_KEY = "@@REGISTRATION_URL@@";
    private static final String REGISTRATION_PAYLOAD_KEY = "@@REGISTRATION_PAYLOAD@@";

    public static String getProductName() {
        return NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsdk.name");
    }

    public static ServiceTag createJavaFXSdkServiceTag(String source, String javaVersion, String rootDir) throws IOException {
        LOG.log(Level.FINE, "Creating JavaFX SDK Standalone service tag");
        ServiceTag st = NbServiceTagSupport2.getJavaFXSdkServiceTag(rootDir);
        if (st == null) {
            LOG.log(Level.FINE, "Creating new service tag");
            st = NbServiceTagSupport2.newJavaFXSdkServiceTag(source, javaVersion, rootDir);
            NbServiceTagSupport2.getRegistrationData(rootDir).addServiceTag(st);
            NbServiceTagSupport2.writeRegistrationXml(rootDir);
        }
        if (Registry.isSupported()) {
            LOG.log(Level.FINE, "Add service tag to system registry");
            NbServiceTagSupport2.installSystemServiceTag(st, rootDir);
        } else {
            LOG.log(Level.FINE, "Cannot add service tag to system registry as ST infrastructure is not found");
        }
        return st;
    }

    public static ServiceTag createJavaFXProductionSuiteServiceTag(String source, String javaVersion, String rootDir) throws IOException {
        LOG.log(Level.FINE, "Creating JavaFX Production Suite service tag");
        ServiceTag st = NbServiceTagSupport2.getJavaFXProductionSuiteServiceTag(rootDir);
        if (st == null) {
            LOG.log(Level.FINE, "Creating new service tag");
            st = NbServiceTagSupport2.newJavaFXProductionSuiteServiceTag(source, javaVersion, rootDir);
            NbServiceTagSupport2.getRegistrationData(rootDir).addServiceTag(st);
            NbServiceTagSupport2.writeRegistrationXml(rootDir);
        }
        if (Registry.isSupported()) {
            LOG.log(Level.FINE, "Add service tag to system registry");
            NbServiceTagSupport2.installSystemServiceTag(st, rootDir);
        } else {
            LOG.log(Level.FINE, "Cannot add service tag to system registry as ST infrastructure is not found");
        }
        return st;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRegistrationXml(String rootDir) throws IOException {
        File targetFile = new File(rootDir + File.separator + "servicetag" + File.separator + REG_FILE);
        File targetDir = new File(rootDir + File.separator + "servicetag");
        if (!targetDir.exists()) {
            targetDir.mkdirs();
        }
        try {
            FileOutputStream os = new FileOutputStream(targetFile);
            try {
                BufferedOutputStream out = new BufferedOutputStream(os);
                NbServiceTagSupport2.getRegistrationData(rootDir).storeToXML(out);
                out.close();
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Error: Cannot save registration data to \"" + targetFile + "\":" + ex.getMessage());
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RegistrationData getRegistrationData(String rootDir) throws IOException {
        if (registration != null) {
            return registration;
        }
        File srcFile = new File(rootDir + File.separator + "servicetag" + File.separator + REG_FILE);
        if (!srcFile.exists()) {
            registration = new RegistrationData();
            LOG.log(Level.FINE, "Service tag file not found");
            return registration;
        }
        LOG.log(Level.FINE, "Service tag will be loaded from: " + srcFile);
        try {
            FileInputStream is = new FileInputStream(srcFile);
            try {
                BufferedInputStream in = new BufferedInputStream(is);
                registration = RegistrationData.loadFromXML(in);
                in.close();
            }
            finally {
                ((InputStream)is).close();
            }
        }
        catch (IOException ex) {
            LOG.log(Level.INFO, "Error: Bad registration data \"" + srcFile + "\":" + ex.getMessage());
            throw ex;
        }
        return registration;
    }

    private static ServiceTag newJavaFXSdkServiceTag(String svcTagSource, String javaVersion, String rootDir) throws IOException {
        String productURN = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsdk.urn");
        String productName = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsdk.name");
        String productVersion = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsdk.version");
        String parentURN = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsdk.parent.urn");
        String parentName = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsdk.parent.name");
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), productName, productVersion, productURN, parentName, parentURN, NbServiceTagSupport2.getNbProductDefinedId(javaVersion, productVersion, rootDir), "Sun Microsystems", System.getProperty("os.arch"), NbServiceTagSupport2.getZoneName(), svcTagSource);
    }

    private static ServiceTag newJavaFXProductionSuiteServiceTag(String svcTagSource, String javaVersion, String rootDir) throws IOException {
        String productURN = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsuite.urn");
        String productName = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsuite.name");
        String productVersion = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsuite.version");
        String parentURN = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsuite.parent.urn");
        String parentName = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsuite.parent.name");
        return ServiceTag.newInstance(ServiceTag.generateInstanceURN(), productName, productVersion, productURN, parentName, parentURN, NbServiceTagSupport2.getNbProductDefinedId(javaVersion, productVersion, rootDir), "Sun Microsystems", System.getProperty("os.arch"), NbServiceTagSupport2.getZoneName(), svcTagSource);
    }

    private static ServiceTag getJavaFXSdkServiceTag(String rootDir) throws IOException {
        String productURN = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsdk.urn");
        RegistrationData regData = NbServiceTagSupport2.getRegistrationData(rootDir);
        Set<ServiceTag> svcTags = regData.getServiceTags();
        for (ServiceTag st : svcTags) {
            if (!productURN.equals(st.getProductURN())) continue;
            return st;
        }
        return null;
    }

    private static ServiceTag getJavaFXProductionSuiteServiceTag(String rootDir) throws IOException {
        String productURN = NbBundle.getMessage(NbServiceTagSupport2.class, "servicetag.javafxsuite.urn");
        RegistrationData regData = NbServiceTagSupport2.getRegistrationData(rootDir);
        Set<ServiceTag> svcTags = regData.getServiceTags();
        for (ServiceTag st : svcTags) {
            if (!productURN.equals(st.getProductURN())) continue;
            return st;
        }
        return null;
    }

    private static String getNbProductDefinedId(String javaVersion, String productVersion, String rooDir) {
        StringBuilder definedId = new StringBuilder();
        definedId.append("id=");
        definedId.append(productVersion);
        definedId.append(",java.version=");
        definedId.append(javaVersion);
        String location = ",dir=" + rooDir;
        if (definedId.length() + location.length() < 256) {
            definedId.append(location);
        } else {
            LOG.log(Level.INFO, "Warning: Product defined instance ID exceeds the field limit:");
        }
        return definedId.toString();
    }

    private static String getZoneName() throws IOException {
        String zonename = "global";
        String command = "/usr/bin/zonename";
        File f = new File(command);
        if (f.canExecute()) {
            ProcessBuilder pb = new ProcessBuilder(command);
            Process p = pb.start();
            String output = Util.commandOutput(p);
            if (p.exitValue() == 0) {
                zonename = output.trim();
            }
        }
        return zonename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getInstalledURN(String urn, String rootDir) throws IOException {
        File srcFile = new File(rootDir + File.separator + "servicetag" + File.separator + "servicetag");
        if (srcFile.exists()) {
            FileReader r = new FileReader(srcFile);
            try {
                BufferedReader in = new BufferedReader(r);
                String line = in.readLine();
                while (line != null) {
                    if (urn.equals(line.trim())) {
                        String string = urn;
                        return string;
                    }
                    line = in.readLine();
                }
                in.close();
                String string = "";
                return string;
            }
            finally {
                ((Reader)r).close();
            }
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void installSystemServiceTag(ServiceTag st, String rootDir) throws IOException {
        if (NbServiceTagSupport2.getInstalledURN(st.getInstanceURN(), rootDir).length() > 0) {
            LOG.log(Level.INFO, "ST is already installed ie. we have file servicetag.");
            return;
        }
        File targetFile = new File(rootDir + File.separator + "servicetag" + File.separator + "servicetag");
        if (Registry.isSupported()) {
            if (Registry.getSystemRegistry().getServiceTag(st.getInstanceURN()) != null) {
                LOG.log(Level.FINE, "Service tag: " + st.getInstanceURN() + " is already installed in system registry.");
                return;
            }
            Registry.getSystemRegistry().addServiceTag(st);
            FileWriter w = new FileWriter(targetFile, true);
            try {
                LOG.log(Level.FINE, "Creating file: " + targetFile);
                BufferedWriter out = new BufferedWriter(w);
                out.write(st.getInstanceURN());
                out.newLine();
                out.close();
            }
            finally {
                ((Writer)w).close();
            }
        }
    }

    public static File getRegistrationHtmlPage(String product, String[] productNames, String rootDir) throws IOException {
        File parent = new File(rootDir + File.separator + "servicetag");
        File f = new File(parent, "register.html");
        NbServiceTagSupport2.generateRegisterHtml(parent, product, productNames, rootDir);
        return f;
    }

    public static void deleteRegistrationFiles(String rootDir) {
        File parent = new File(rootDir + File.separator + "servicetag");
        File f = new File(parent, "servicetag");
        if (f.exists()) {
            f.delete();
        }
        if ((f = new File(parent, REG_FILE)).exists()) {
            f.delete();
        }
        if (parent.isDirectory() && parent.listFiles().length == 0) {
            parent.delete();
        }
    }

    private static void deleteRegistrationHtmlPage(String rootDir) {
        String name;
        File parent = new File(rootDir + File.separator + "servicetag");
        File f = new File(parent, (name = REGISTRATION_HTML_NAME) + ".html");
        if (f.exists()) {
            f.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void generateRegisterHtml(File parent, String product, String[] productNames, String rootDir) throws IOException {
        Locale[] locales;
        String[] imgResources;
        RegistrationData regData = NbServiceTagSupport2.getRegistrationData(rootDir);
        String registerURL = NbConnectionSupport.getRegistrationURL(regData.getRegistrationURN(), product).toString();
        String resourcePrefix = "/org/netbeans/modules/reglib/resources/";
        for (String resourceName : imgResources = new String[]{"kz_backg.png", "kz_backh.png", "oracle-white.png", "pg_box_bg_lft_bot.gif", "pg_box_bg_rpt_bot.gif", "pg_box_bg_rt_bot.gif", "pg_box_hder_bg_lft.gif", "pg_box_hder_bg_rpt.gif", "pg_box_hder_bg_rt.gif", "pg_box_side_lft.gif", "pg_box_side_rt.gif", "red-arrow.gif", "red_triangle.gif"}) {
            String resource = resourcePrefix + resourceName;
            File img = new File(rootDir + File.separator + "servicetag", resourceName);
            InputStream in = NbServiceTagSupport2.class.getResourceAsStream(resource);
            if (in == null) {
                LOG.log(Level.FINE, "Missing resource file: " + resource);
                continue;
            }
            try {
                LOG.log(Level.FINE, "Generating " + img + " from " + resource);
                BufferedInputStream bis = null;
                FileOutputStream fos = null;
                try {
                    int c;
                    bis = new BufferedInputStream(in);
                    fos = new FileOutputStream(img);
                    while ((c = bis.read()) != -1) {
                        fos.write(c);
                    }
                }
                finally {
                    IOException exc = null;
                    try {
                        if (bis != null) {
                            bis.close();
                        }
                    }
                    catch (IOException ex) {
                        exc = ex;
                    }
                    if (fos != null) {
                        fos.close();
                    }
                    if (exc == null) continue;
                    throw exc;
                }
            }
            finally {
                in.close();
            }
        }
        String xml = regData.toString();
        String lineSep = System.getProperty("line.separator");
        String payload = xml.replaceAll("\"", "%22").replaceAll(lineSep, " ");
        String name = REGISTRATION_HTML_NAME;
        File f = new File(parent, name + ".html");
        InputStream in = null;
        Locale l = Locale.getDefault();
        for (Locale locale : locales = new Locale[]{new Locale(l.getLanguage(), l.getCountry(), l.getVariant()), new Locale(l.getLanguage(), l.getCountry()), new Locale(l.getLanguage()), new Locale("")}) {
            String resource = "/org/netbeans/modules/reglib/resources/register" + (locale.toString().equals("") ? "" : "_" + locale) + ".html";
            LOG.log(Level.FINE, "Looking for html in: " + resource);
            in = NbServiceTagSupport2.class.getResourceAsStream(resource);
            if (in == null) continue;
            LOG.log(Level.FINE, "Found html in: " + resource);
            break;
        }
        if (in != null) {
            try {
                LOG.log(Level.FINE, "Generating " + f);
                BufferedReader reader = null;
                PrintWriter pw = null;
                try {
                    reader = new BufferedReader(new InputStreamReader(in, "UTF-8"));
                    pw = new PrintWriter(f, "UTF-8");
                    String line = null;
                    String productName = "";
                    String productNameTitle = "";
                    for (int i = 0; i < productNames.length; ++i) {
                        if (i > 0) {
                            productName = productName + " " + NbBundle.getMessage(NbServiceTagSupport2.class, "MSG_junction") + " ";
                            productNameTitle = productNameTitle + " " + NbBundle.getMessage(NbServiceTagSupport2.class, "MSG_junction") + " ";
                        }
                        productName = productName + "<strong>" + productNames[i] + "</strong>";
                        productNameTitle = productNameTitle + productNames[i];
                    }
                    while ((line = reader.readLine()) != null) {
                        String output = line;
                        if (line.contains(PRODUCT_KEY)) {
                            output = line.replace(PRODUCT_KEY, productName);
                        } else if (line.contains(PRODUCT_TITLE_KEY)) {
                            output = line.replace(PRODUCT_TITLE_KEY, productNameTitle);
                        } else if (line.contains(REGISTRATION_URL_KEY)) {
                            output = line.replace(REGISTRATION_URL_KEY, registerURL);
                        } else if (line.contains(REGISTRATION_PAYLOAD_KEY)) {
                            output = line.replace(REGISTRATION_PAYLOAD_KEY, payload);
                        }
                        pw.println(output);
                    }
                }
                finally {
                    if (pw != null) {
                        pw.close();
                    }
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            finally {
                in.close();
            }
        }
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.reglib.NbServiceTagSupport2");
    }
}

