/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.jaxwsmodel.project;

import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntBuildExtender;
import org.netbeans.modules.websvc.api.jaxws.project.JaxWsBuildScriptExtensionProvider;
import org.netbeans.modules.websvc.api.jaxws.project.WSUtils;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.jaxwsmodel.project.TransformerUtils;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;

public class J2seBuildScriptExtensionProvider
implements JaxWsBuildScriptExtensionProvider {
    private static String COMPILE_ON_SAVE_UNSUPPORTED = "compile.on.save.unsupported.jaxws";
    static String JAX_WS_STYLESHEET_RESOURCE = "/org/netbeans/modules/websvc/jaxwsmodel/resources/jaxws-j2se.xsl";
    private Project project;

    public J2seBuildScriptExtensionProvider(Project project) {
        this.project = project;
    }

    @Override
    public void addJaxWsExtension(AntBuildExtender antBuildExtender) throws IOException {
        TransformerUtils.transformClients(this.project.getProjectDirectory(), JAX_WS_STYLESHEET_RESOURCE);
        FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
        assert (fileObject != null);
        AntBuildExtender.Extension extension = antBuildExtender.getExtension("jaxws");
        if (extension == null) {
            extension = antBuildExtender.addExtension("jaxws", fileObject);
            extension.addDependency("-pre-pre-compile", "wsimport-client-generate");
            J2seBuildScriptExtensionProvider.disableCompileOnSave(this.project);
            ProjectManager.getDefault().saveProject(this.project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeJaxWsExtension(final AntBuildExtender antBuildExtender) throws IOException {
        FileLock fileLock;
        FileObject fileObject;
        AntBuildExtender.Extension extension = antBuildExtender.getExtension("jaxws");
        if (extension != null) {
            ProjectManager.mutex().writeAccess(new Runnable(){

                @Override
                public void run() {
                    antBuildExtender.removeExtension("jaxws");
                }
            });
            this.enableCompileOnSave();
            ProjectManager.getDefault().saveProject(this.project);
        }
        if ((fileObject = this.project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml")) != null && (fileLock = fileObject.lock()) != null) {
            try {
                fileObject.delete(fileLock);
            }
            finally {
                fileLock.releaseLock();
            }
        }
    }

    private static void disableCompileOnSave(Project project) throws IOException {
        EditableProperties editableProperties = WSUtils.getEditableProperties(project, "nbproject/project.properties");
        editableProperties.put(COMPILE_ON_SAVE_UNSUPPORTED, "true");
        WSUtils.storeEditableProperties(project, "nbproject/project.properties", editableProperties);
    }

    private void enableCompileOnSave() throws IOException {
        EditableProperties editableProperties = WSUtils.getEditableProperties(this.project, "nbproject/project.properties");
        editableProperties.remove((Object)COMPILE_ON_SAVE_UNSUPPORTED);
        WSUtils.storeEditableProperties(this.project, "nbproject/project.properties", editableProperties);
    }

    @Override
    public void handleJaxWsModelChanges(JaxWsModel jaxWsModel) throws IOException {
        AntBuildExtender antBuildExtender = (AntBuildExtender)this.project.getLookup().lookup(AntBuildExtender.class);
        if (antBuildExtender != null) {
            FileObject fileObject = this.project.getProjectDirectory().getFileObject("nbproject/jaxws-build.xml");
            if (jaxWsModel.getClients().length == 0) {
                this.removeJaxWsExtension(antBuildExtender);
            } else {
                this.addJaxWsExtension(antBuildExtender);
            }
        }
    }
}

