/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.api;

import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.core.stack.api.impl.FunctionMetricAccessor;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionMetricsFactory;
import org.openide.util.NbBundle;

public final class FunctionMetric {
    private final String metricID;
    private final String metricDisplayedName;
    private final Class metricValueClass;
    public static final FunctionMetric CpuTimeInclusiveMetric;
    public static final FunctionMetric CpuTimeExclusiveMetric;

    FunctionMetric(FunctionMetricConfiguration metricConfiguration) {
        this.metricID = metricConfiguration.getMetricID();
        this.metricDisplayedName = metricConfiguration.getMetricDisplayedName();
        this.metricValueClass = metricConfiguration.getMetricValueClass();
    }

    public final String getMetricID() {
        return this.metricID;
    }

    public final String getMetricDisplayedName() {
        return this.metricDisplayedName;
    }

    public final Class getMetricValueClass() {
        return this.metricValueClass;
    }

    public String toString() {
        return this.metricDisplayedName;
    }

    private static final String getMessage(String name) {
        return NbBundle.getMessage(FunctionMetric.class, (String)name);
    }

    static {
        FunctionMetricAccessor.setDefault(new FunctionMetricAccessorImpl());
        CpuTimeInclusiveMetric = FunctionMetricsFactory.getInstance().getFunctionMetric(new FunctionMetricConfiguration("time_incl", FunctionMetric.getMessage("Metric.CpuTimeInclusive"), Time.class));
        CpuTimeExclusiveMetric = FunctionMetricsFactory.getInstance().getFunctionMetric(new FunctionMetricConfiguration("time_excl", FunctionMetric.getMessage("Metric.CpuTimeExclusive"), Time.class));
    }

    private static final class FunctionMetricAccessorImpl
    extends FunctionMetricAccessor {
        private FunctionMetricAccessorImpl() {
        }

        @Override
        public FunctionMetric createNew(FunctionMetricConfiguration functionMetricConfiguration) {
            return new FunctionMetric(functionMetricConfiguration);
        }
    }

    public static final class FunctionMetricConfiguration {
        private final String metricID;
        private final String metricDisplayedName;
        private final Class metricValueClass;

        public FunctionMetricConfiguration(String metricID, String displayedName, Class metricValueClass) {
            this.metricID = metricID;
            this.metricDisplayedName = displayedName;
            this.metricValueClass = metricValueClass;
        }

        final String getMetricID() {
            return this.metricID;
        }

        final String getMetricDisplayedName() {
            return this.metricDisplayedName;
        }

        final Class getMetricValueClass() {
            return this.metricValueClass;
        }

        public int hashCode() {
            int hash = 7;
            hash = 41 * hash + (this.metricID != null ? this.metricID.hashCode() : 0);
            hash = 41 * hash + (this.metricDisplayedName != null ? this.metricDisplayedName.hashCode() : 0);
            hash = 41 * hash + (this.metricValueClass != null ? this.metricValueClass.hashCode() : 0);
            return hash;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            FunctionMetricConfiguration other = (FunctionMetricConfiguration)obj;
            if (this.metricID == null ? other.metricID != null : !this.metricID.equals(other.metricID)) {
                return false;
            }
            if (this.metricDisplayedName == null ? other.metricDisplayedName != null : !this.metricDisplayedName.equals(other.metricDisplayedName)) {
                return false;
            }
            return this.metricValueClass == other.metricValueClass || this.metricValueClass != null && this.metricValueClass.equals(other.metricValueClass);
        }
    }
}

