/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.cdc.project.semc;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageInputStream;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.layout.GroupLayout;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class MBMThumbnailAccessory
extends JPanel
implements PropertyChangeListener {
    private static final int ICON_MAX_WIDTH = 64;
    private Icon[] thumbnails;
    private JLabel[] labels;
    private File file;
    private String tmpDir;
    private JFileChooser fc;
    private String bmconvLocation;
    private int iconCount;
    private JLabel iconNumLabel;
    private JLabel jLabel2;
    private JScrollPane jScrollPane1;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label4;
    private JLabel label5;
    private JLabel label6;
    private JTextArea textArea;

    public MBMThumbnailAccessory(JFileChooser fc, File sdkLocation) {
        this.fc = fc;
        this.initComponents();
        this.labels = new JLabel[6];
        this.labels[0] = this.label1;
        this.labels[1] = this.label2;
        this.labels[2] = this.label3;
        this.labels[3] = this.label4;
        this.labels[4] = this.label5;
        this.labels[5] = this.label6;
        int width = 5;
        Dimension d = new Dimension(64 + width, 64);
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i].setPreferredSize(d);
        }
        this.tmpDir = System.getProperty("java.io.tmpdir");
        this.iconNumLabel.setText(NbBundle.getMessage(MBMThumbnailAccessory.class, (String)"LBL_ThumbnailsInfo", (Object)"0"));
        StringBuffer str = new StringBuffer();
        if (sdkLocation != null && sdkLocation.exists()) {
            str.append(sdkLocation.getAbsolutePath());
            str.append(File.separatorChar);
            str.append("epoc32");
            str.append(File.separatorChar);
            str.append("tools");
            str.append(File.separatorChar);
        }
        str.append("bmconv");
        this.bmconvLocation = str.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadImages() {
        if (this.file == null || this.thumbnails == null || !this.file.getPath().toLowerCase().endsWith(".mbm")) {
            this.thumbnails = null;
            return;
        }
        boolean error = false;
        try {
            ArrayList<String> thumbs = new ArrayList<String>();
            thumbs.add(this.bmconvLocation);
            thumbs.add("/u");
            thumbs.add(this.file.getPath());
            for (int i = 0; i < this.thumbnails.length; ++i) {
                StringBuffer sb = new StringBuffer();
                sb.append(this.tmpDir);
                sb.append(File.separatorChar);
                sb.append(i);
                sb.append(".bmp");
                thumbs.add(sb.toString());
            }
            Process p = Runtime.getRuntime().exec(thumbs.toArray(new String[0]));
            StringBuffer sout = new StringBuffer();
            StringBuffer serr = new StringBuffer();
            IOThread out = new IOThread(p.getInputStream(), sout);
            out.join();
            IOThread err = new IOThread(p.getInputStream(), serr);
            err.join();
            if (p.waitFor() == 0) {
                ImageIcon tmpIcon = null;
                for (int i = 0; i < this.thumbnails.length; ++i) {
                    File bmpFile = new File(this.tmpDir + File.separatorChar + i + ".bmp");
                    bmpFile.deleteOnExit();
                    Iterator<ImageReader> itImageReaders = ImageIO.getImageReadersByFormatName("bmp");
                    ImageReader reader = null;
                    if (itImageReaders.hasNext()) {
                        reader = itImageReaders.next();
                        ImageInputStream iis = ImageIO.createImageInputStream(new BufferedInputStream(new FileInputStream(bmpFile)));
                        reader.setInput(iis);
                        BufferedImage bi = reader.read(0);
                        Iterator<ImageWriter> itImageWriters = ImageIO.getImageWritersByFormatName("png");
                        ImageWriter writer = null;
                        if (itImageWriters.hasNext()) {
                            writer = itImageWriters.next();
                        }
                        ByteArrayOutputStream baos = new ByteArrayOutputStream();
                        writer.setOutput(ImageIO.createImageOutputStream(baos));
                        writer.write(bi);
                        reader.dispose();
                        writer.dispose();
                        iis.close();
                        tmpIcon = new ImageIcon(baos.toByteArray());
                        if (tmpIcon == null) continue;
                        this.thumbnails[i] = tmpIcon.getIconWidth() > 64 ? new ImageIcon(tmpIcon.getImage().getScaledInstance(64, -1, 1)) : tmpIcon;
                        this.labels[i].setText(String.valueOf(i + 1));
                        this.labels[i].setIcon(this.thumbnails[i]);
                        continue;
                    }
                    this.iconNumLabel.setText(NbBundle.getMessage(MBMThumbnailAccessory.class, (String)"ERR_NotAvailable14"));
                }
            } else {
                error = true;
            }
        }
        catch (IOException ex) {
            error = true;
        }
        catch (InterruptedException ex) {
            error = true;
        }
        finally {
            if (error) {
                Color nbErrorForeground = UIManager.getColor("nb.errorForeground");
                if (nbErrorForeground == null) {
                    nbErrorForeground = new Color(255, 0, 0);
                }
                this.textArea.setForeground(nbErrorForeground);
                this.textArea.setText(NbBundle.getMessage(MBMThumbnailAccessory.class, (String)"ERR_BmpconvNotExists"));
                this.textArea.setCaretPosition(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getImageInfo() {
        if (this.file == null || !this.file.getPath().toLowerCase().endsWith(".mbm")) {
            this.thumbnails = null;
            return;
        }
        boolean error = false;
        try {
            Process p = Runtime.getRuntime().exec(new String[]{this.bmconvLocation, "/v", this.file.getPath()});
            StringBuffer sout = new StringBuffer();
            StringBuffer serr = new StringBuffer();
            IOThread out = new IOThread(p.getInputStream(), sout);
            out.join();
            IOThread err = new IOThread(p.getInputStream(), serr);
            err.join();
            p.waitFor();
            int exitValue = p.exitValue();
            if (exitValue == 0) {
                String text = sout.toString();
                int i = text.indexOf("Bitmap");
                if (i > 0) {
                    Color foreground = UIManager.getColor("TextArea.foreground");
                    if (foreground == null) {
                        foreground = Color.BLACK;
                    }
                    this.textArea.setForeground(foreground);
                    this.textArea.setText(text.substring(i).trim());
                    this.textArea.setCaretPosition(0);
                }
                StringTokenizer st = new StringTokenizer(sout.toString(), "\n", false);
                int c = 0;
                while (st.hasMoreTokens()) {
                    String s = st.nextToken();
                    if (!s.startsWith("Bitmap")) continue;
                    ++c;
                }
                this.iconNumLabel.setText(NbBundle.getMessage(MBMThumbnailAccessory.class, (String)"LBL_ThumbnailsInfo", (Object)String.valueOf(c)));
                this.iconCount = c;
                if (c > 0) {
                    if (c > 6) {
                        c = 6;
                    }
                    this.thumbnails = new Icon[c];
                }
            }
        }
        catch (IOException ex) {
            error = true;
        }
        catch (InterruptedException ex) {
            error = true;
        }
        finally {
            if (error) {
                Color nbErrorForeground = UIManager.getColor("nb.errorForeground");
                if (nbErrorForeground == null) {
                    nbErrorForeground = new Color(255, 0, 0);
                }
                this.textArea.setForeground(nbErrorForeground);
                this.textArea.setText(NbBundle.getMessage(MBMThumbnailAccessory.class, (String)"ERR_BmpconvNotExists"));
                this.textArea.setCaretPosition(0);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        boolean update = false;
        String prop = e.getPropertyName();
        if ("directoryChanged".equals(prop)) {
            this.file = null;
            update = true;
        } else if ("SelectedFileChangedProperty".equals(prop)) {
            this.file = (File)e.getNewValue();
            update = true;
        }
        if (update) {
            this.thumbnails = null;
            this.clean();
            if (this.isShowing()) {
                this.getImageInfo();
                this.loadImages();
            }
        }
    }

    private void clean() {
        this.iconCount = 0;
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i].setText(" ");
            this.labels[i].setIcon(null);
        }
        this.iconNumLabel.setText(NbBundle.getMessage(MBMThumbnailAccessory.class, (String)"LBL_ThumbnailsInfo", (Object)"0"));
        this.textArea.setText("");
    }

    @Override
    public void removeNotify() {
        this.fc.removePropertyChangeListener(this);
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.fc.addPropertyChangeListener(this);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MBMThumbnailAccessory.access$002(MBMThumbnailAccessory.this, null);
                MBMThumbnailAccessory.this.file = MBMThumbnailAccessory.this.fc.getSelectedFile();
                MBMThumbnailAccessory.this.clean();
                MBMThumbnailAccessory.this.getImageInfo();
                MBMThumbnailAccessory.this.loadImages();
            }
        });
    }

    public int getIconCount() {
        return this.iconCount;
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.textArea = new JTextArea();
        this.label1 = new JLabel();
        this.label2 = new JLabel();
        this.label3 = new JLabel();
        this.label4 = new JLabel();
        this.label5 = new JLabel();
        this.label6 = new JLabel();
        this.iconNumLabel = new JLabel();
        this.jLabel2 = new JLabel();
        this.setPreferredSize(new Dimension(400, 250));
        this.textArea.setColumns(20);
        this.textArea.setEditable(false);
        this.textArea.setRows(5);
        this.jScrollPane1.setViewportView(this.textArea);
        this.label1.setText(" ");
        this.label2.setText(" ");
        this.label3.setText(" ");
        this.label4.setText(" ");
        this.label5.setText(" ");
        this.label6.setText(" ");
        this.iconNumLabel.setText(" ");
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(MBMThumbnailAccessory.class, (String)"LBL_MBMDetails"));
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jScrollPane1, -1, 382, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel2).addContainerGap(332, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.label1).addPreferredGap(0).add((Component)this.label2).addPreferredGap(0).add((Component)this.label3).addPreferredGap(0).add((Component)this.label4).addPreferredGap(0).add((Component)this.label5).addPreferredGap(0).add((Component)this.label6)).add((Component)this.iconNumLabel)).add(344, 344, 344)))));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.iconNumLabel).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.label1).add((Component)this.label2).add((Component)this.label3).add((Component)this.label4).add((Component)this.label5).add((Component)this.label6)).addPreferredGap(0).add((Component)this.jLabel2).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 190, Short.MAX_VALUE)));
    }

    static /* synthetic */ Icon[] access$002(MBMThumbnailAccessory x0, Icon[] x1) {
        x0.thumbnails = x1;
        return x1;
    }

    static class IOThread
    extends Thread {
        private BufferedInputStream bis;
        private StringBuffer sb;

        IOThread(InputStream is, StringBuffer sb) {
            this.bis = new BufferedInputStream(is, 2048);
            this.sb = sb;
            this.start();
        }

        @Override
        public void run() {
            try {
                int i;
                while ((i = this.bis.read()) != 1 && i != -1) {
                    if (this.sb == null) continue;
                    this.sb.append((char)i);
                }
            }
            catch (IOException ioEx) {
                // empty catch block
            }
            try {
                this.bis.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

