/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class URLWait {
    private static final Logger LOGGER = Logger.getLogger(URLWait.class.getName());

    private URLWait() {
    }

    public static boolean waitForUrlReady(ExecutorService executorService, URL uRL, int n) {
        String string = uRL.getHost();
        try {
            InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return false;
        }
        return URLWait.waitForUrlConnection(executorService, uRL, n, 100);
    }

    private static boolean waitForUrlConnection(ExecutorService executorService, URL uRL, int n, int n2) {
        Connect connect = new Connect(uRL, n2);
        Future<Boolean> future = executorService.submit(connect);
        try {
            return future.get(n, TimeUnit.MILLISECONDS);
        }
        catch (ExecutionException executionException) {
            LOGGER.log(Level.FINE, null, executionException);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        catch (TimeoutException timeoutException) {
            future.cancel(true);
        }
        return false;
    }

    private static class Connect
    implements Callable<Boolean> {
        private final URL url;
        private final int retryTime;
        private final String host;

        public Connect(URL uRL, int n) {
            this.url = uRL;
            this.retryTime = n;
            this.host = uRL.getHost();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Boolean call() throws Exception {
            try {
                InetAddress.getByName(this.host);
            }
            catch (UnknownHostException unknownHostException) {
                return Boolean.FALSE;
            }
            boolean bl = false;
            HttpURLConnection httpURLConnection = null;
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    boolean bl2;
                    httpURLConnection = (HttpURLConnection)this.url.openConnection();
                    int n = httpURLConnection.getResponseCode();
                    boolean bl3 = bl2 = n == -1 || n > 399 && n < 600;
                    if (!bl2) {
                        Boolean bl4 = Boolean.TRUE;
                        return bl4;
                    }
                }
                catch (IOException iOException) {
                    LOGGER.log(Level.FINE, null, iOException);
                }
                finally {
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                }
                try {
                    Thread.sleep(this.retryTime);
                }
                catch (InterruptedException interruptedException) {
                    bl = true;
                    break;
                }
            }
            if (bl) {
                Thread.currentThread().interrupt();
            }
            return Boolean.FALSE;
        }
    }
}

